/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.common.treetable;

import edu.uoregon.tau.common.treetable.AbstractTreeTableModel;
import edu.uoregon.tau.common.treetable.JTreeTable;
import edu.uoregon.tau.common.treetable.SortTableModel;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class TreeTableModelAdapter
extends AbstractTableModel
implements SortTableModel {
    private JTree tree;
    private AbstractTreeTableModel treeTableModel;
    private JTreeTable jTreeTable;

    public TreeTableModelAdapter(AbstractTreeTableModel abstractTreeTableModel, JTreeTable jTreeTable) {
        this.tree = jTreeTable.getTree();
        this.jTreeTable = jTreeTable;
        this.treeTableModel = abstractTreeTableModel;
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        });
        abstractTreeTableModel.addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }
        });
    }

    public int getColumnCount() {
        return this.treeTableModel.getColumnCount();
    }

    public String getColumnName(int n) {
        return this.treeTableModel.getColumnName(n);
    }

    public Class getColumnClass(int n) {
        return this.treeTableModel.getColumnClass(n);
    }

    public int getRowCount() {
        return this.tree.getRowCount();
    }

    protected Object nodeForRow(int n) {
        TreePath treePath = this.tree.getPathForRow(n);
        return treePath.getLastPathComponent();
    }

    public Object getValueAt(int n, int n2) {
        return this.treeTableModel.getValueAt(this.nodeForRow(n), n2);
    }

    public boolean isCellEditable(int n, int n2) {
        return this.treeTableModel.isCellEditable(this.nodeForRow(n), n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        this.treeTableModel.setValueAt(object, this.nodeForRow(n), n2);
    }

    public Vector getExpandedPaths() {
        Enumeration<TreePath> enumeration = this.tree.getExpandedDescendants(this.getRootPath());
        Vector<TreePath> vector = new Vector<TreePath>();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                vector.add(enumeration.nextElement());
            }
        }
        return vector;
    }

    public void restoreExpandedPaths(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            TreePath treePath = (TreePath)enumeration.nextElement();
            this.tree.expandPath(treePath);
        }
    }

    public TreePath getRootPath() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.treeTableModel.getRoot();
        return new TreePath(defaultMutableTreeNode.getPath());
    }

    protected void delayedFireTableDataChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        });
    }

    public void updateTreeTable() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Vector vector = TreeTableModelAdapter.this.getExpandedPaths();
                TreeTableModelAdapter.this.treeTableModel.fireTreeStructureChanged(this, ((DefaultMutableTreeNode)TreeTableModelAdapter.this.treeTableModel.getRoot()).getPath(), null, null);
                TreeTableModelAdapter.this.restoreExpandedPaths(vector);
                TreeTableModelAdapter.this.jTreeTable.getTableHeader().repaint();
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }
        });
    }

    public boolean isSortable(int n) {
        return this.treeTableModel.isSortable(n);
    }

    public void sortColumn(int n, boolean bl) {
        this.treeTableModel.sortColumn(n, bl);
        this.updateTreeTable();
    }
}

