/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.vis;

import com.sun.opengl.util.GLUT;
import edu.uoregon.tau.vis.Shape;
import edu.uoregon.tau.vis.VisRenderer;
import edu.uoregon.tau.vis.VisTools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Observable;
import java.util.StringTokenizer;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorScale
extends Observable
implements Shape {
    private Color textColor = Color.white;
    private int font = 1;
    private GLUT glut = new GLUT();
    private boolean dirty = true;
    private boolean enabled = false;
    private ColorSet colorSet = ColorSet.RAINBOW;
    private String lowString;
    private String highString;
    private String label;
    private double fontScale = 0.12;
    private float leftMargin = 25.0f;
    private float leftTextMargin = 5.0f;
    private int displayList;
    private int width = 25;
    private int height = 300;
    private int topBottomMargin = 60;
    private boolean oldReverseVideo;
    private int oldWidth;
    private int oldHeight;
    private boolean oldAntiAlias;
    JLabel highLabel = new JLabel();
    JLabel lowLabel = new JLabel();
    ColorPan cp;

    public ColorScale() {
    }

    public ColorScale(ColorSet colorSet) {
        this.colorSet = colorSet;
    }

    public void setStrings(String string, String string2, String string3) {
        this.lowString = string;
        this.highString = string2;
        this.label = string3;
        this.dirty = true;
        if (this.highLabel != null) {
            this.highLabel.setText(this.highString);
        }
        this.lowLabel.setText("<html>" + this.lowString + "<br>" + string3 + "</html>");
    }

    public Color getColor(float f) {
        float f2 = f;
        int n = 0;
        int n2 = this.colorSet.colorsR.length - 1;
        n = 0;
        f = f2 * (float)n2;
        for (float f3 = 1.0f / (float)n2; f2 > f3; f3 += 1.0f / (float)n2) {
            ++n;
            f = (f2 - f3) * (float)n2;
        }
        double d = this.colorSet.colorsR[n] + (double)f * (this.colorSet.colorsR[n + 1] - this.colorSet.colorsR[n]);
        double d2 = this.colorSet.colorsG[n] + (double)f * (this.colorSet.colorsG[n + 1] - this.colorSet.colorsG[n]);
        double d3 = this.colorSet.colorsB[n] + (double)f * (this.colorSet.colorsB[n + 1] - this.colorSet.colorsB[n]);
        d = Math.min(d, 1.0);
        d2 = Math.min(d2, 1.0);
        d3 = Math.min(d3, 1.0);
        d = Math.max(d, 0.0);
        d2 = Math.max(d2, 0.0);
        d3 = Math.max(d3, 0.0);
        return new Color((float)d, (float)d2, (float)d3);
    }

    public JPanel getControlPanel(final VisRenderer visRenderer) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 0.2;
        int n = gridBagConstraints.anchor;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        gridBagConstraints.anchor = 25;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        VisTools.addCompItem(jPanel, this.highLabel, gridBagConstraints, 0, 0, 3, 1);
        gridBagConstraints.weighty = 1.0;
        this.cp = new ColorPan();
        jPanel2.add(this.cp);
        gridBagConstraints.anchor = n;
        gridBagConstraints.fill = 3;
        VisTools.addCompItem(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 2;
        VisTools.addCompItem(jPanel, this.lowLabel, gridBagConstraints, 0, 6, 3, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.anchor = n;
        JCheckBox jCheckBox = new JCheckBox("Show ColorScale", false);
        VisTools.addCompItem(jPanel, jCheckBox, gridBagConstraints, 1, 1, 1, 1);
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorScale.this.enabled = ((JCheckBox)actionEvent.getSource()).isSelected();
                ColorScale.this.dirty = true;
                visRenderer.redraw();
            }
        });
        final JSlider jSlider = new JSlider(0, 100, (int)(this.getFontScale() * 100.0));
        jSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                try {
                    ColorScale.this.setFontScale((double)jSlider.getValue() / 100.0);
                    visRenderer.redraw();
                }
                catch (Exception exception) {
                    VisTools.handleException(exception);
                }
            }
        });
        VisTools.addCompItem(jPanel, new JLabel("Font Size"), gridBagConstraints, 1, 2, 1, 1);
        gridBagConstraints.fill = 1;
        VisTools.addCompItem(jPanel, jSlider, gridBagConstraints, 2, 2, 1, 1);
        gridBagConstraints.fill = 0;
        ButtonGroup buttonGroup = new ButtonGroup();
        final HashMap<JRadioButton, ColorSet> hashMap = new HashMap<JRadioButton, ColorSet>();
        int n2 = 1;
        int n3 = 3;
        for (int i = 0; i < ColorSet.VALUES.length; ++i) {
            ColorSet colorSet = ColorSet.VALUES[i];
            JRadioButton jRadioButton = new JRadioButton(colorSet.toString(), this.colorSet == colorSet);
            buttonGroup.add(jRadioButton);
            hashMap.put(jRadioButton, colorSet);
            jRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ColorScale.this.colorSet = (ColorSet)hashMap.get(actionEvent.getSource());
                    ColorScale.this.dirty = true;
                    ColorScale.this.setChanged();
                    ColorScale.this.notifyObservers();
                    visRenderer.redraw();
                    ColorScale.this.cp.initialize();
                    ColorScale.this.cp.repaint();
                }
            });
            VisTools.addCompItem(jPanel, jRadioButton, gridBagConstraints, n2, n3, 1, 1);
            if (n2 == 1) {
                ++n2;
                continue;
            }
            n2 = 1;
            ++n3;
        }
        return jPanel;
    }

    private float getTextWidth(GL gL, String string) {
        if (string == null) {
            return 0.0f;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        float f = 0.0f;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            float f2 = this.glut.glutStrokeLength(this.font, string2);
            f = Math.max(f, f2);
        }
        return (float)((double)f * this.fontScale);
    }

    private void drawText(GL gL, double d, double d2, String string, boolean bl) {
        if (string == null) {
            return;
        }
        gL.glPushMatrix();
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        n = stringTokenizer.countTokens();
        double d3 = 105.0 * this.fontScale;
        double d4 = 34.0 * this.fontScale;
        float f = (float)(139.0 * this.fontScale);
        f = (float)((d3 + d4) * 1.1);
        d2 = bl ? d2 - d3 - 5.0 : d2 + (double)(f * (float)(n - 1)) + d4 + 3.0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            double d5 = d;
            gL.glPushMatrix();
            float f2 = this.glut.glutStrokeLength(this.font, string2);
            gL.glTranslated(d5 -= (double)f2 * this.fontScale / 2.0, d2, 0.0);
            gL.glScaled(this.fontScale, this.fontScale, this.fontScale);
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                this.glut.glutStrokeCharacter(this.font, c);
            }
            gL.glPopMatrix();
            gL.glTranslated(0.0, (double)(-f), 0.0);
        }
        gL.glPopMatrix();
    }

    @Override
    public void render(VisRenderer visRenderer) {
        GLAutoDrawable gLAutoDrawable = visRenderer.getGLAutoDrawable();
        if (this.oldReverseVideo != visRenderer.getReverseVideo()) {
            this.dirty = true;
        }
        this.oldReverseVideo = visRenderer.getReverseVideo();
        if (this.oldAntiAlias != visRenderer.getAntiAliasedLines()) {
            this.dirty = true;
        }
        this.oldAntiAlias = visRenderer.getAntiAliasedLines();
        if (!this.enabled) {
            return;
        }
        int n = gLAutoDrawable.getWidth();
        int n2 = gLAutoDrawable.getHeight();
        if (n != this.oldWidth || n2 != this.oldHeight) {
            this.dirty = true;
            this.oldWidth = n;
            this.oldHeight = n2;
        }
        GL gL = gLAutoDrawable.getGL();
        if (this.dirty || this.displayList == 0) {
            if (this.displayList != 0) {
                gL.glDeleteLists(this.displayList, 1);
            }
            this.displayList = gL.glGenLists(1);
            gL.glNewList(this.displayList, 4864);
            this.privateRender(visRenderer);
            gL.glEndList();
            this.dirty = false;
        }
        gL.glCallList(this.displayList);
    }

    private void privateRender(VisRenderer visRenderer) {
        float f;
        float f2;
        GLAutoDrawable gLAutoDrawable = visRenderer.getGLAutoDrawable();
        GL gL = gLAutoDrawable.getGL();
        if (!this.enabled) {
            return;
        }
        int n = gLAutoDrawable.getWidth();
        int n2 = gLAutoDrawable.getHeight();
        gL.glMatrixMode(5889);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glOrtho(0.0, (double)n, 0.0, (double)n2, -1.0, 1.0);
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glDisable(2896);
        gL.glDisable(2929);
        gL.glLineWidth(1.0f);
        if (visRenderer.getAntiAliasedLines()) {
            gL.glEnable(2848);
            gL.glEnable(3042);
            gL.glBlendFunc(770, 771);
            gL.glHint(3154, 4354);
        } else {
            gL.glDisable(2848);
            gL.glDisable(3042);
        }
        int n3 = Math.min(this.height, this.height - this.topBottomMargin);
        int n4 = this.width;
        gL.glTranslated((double)this.leftMargin, (double)(n2 / 2 - n3 / 2), 0.0);
        gL.glShadeModel(7425);
        gL.glFrontFace(2304);
        gL.glBegin(7);
        int n5 = 10;
        float f3 = (float)n3 / 10.0f;
        for (f2 = 0.0f; f2 < (float)n5; f2 += 1.0f) {
            f = f2 / (float)n5;
            Color color = this.getColor(f);
            float f4 = (f2 + 1.0f) / (float)n5;
            Color color2 = this.getColor(f4);
            VisTools.glSetColor(gL, color);
            gL.glVertex3f((float)n4, f2 * f3, 0.0f);
            gL.glVertex3f(0.0f, f2 * f3, 0.0f);
            VisTools.glSetColor(gL, color2);
            gL.glVertex3f(0.0f, (f2 + 1.0f) * f3, 0.0f);
            gL.glVertex3f((float)n4, (f2 + 1.0f) * f3, 0.0f);
        }
        gL.glEnd();
        if (visRenderer.getReverseVideo()) {
            VisTools.glSetColor(gL, VisTools.invert(this.textColor));
        } else {
            VisTools.glSetColor(gL, this.textColor);
        }
        float f5 = 0.0f;
        f2 = this.getTextWidth(gL, this.highString);
        f = (float)(n4 / 2) - f2 / 2.0f;
        if (f < -this.leftMargin + this.leftTextMargin) {
            f5 = -f - this.leftMargin + this.leftTextMargin;
        }
        this.drawText(gL, f5 + (float)(n4 / 2), n3, this.highString, false);
        f5 = 0.0f;
        f2 = this.getTextWidth(gL, this.lowString);
        f = (float)(n4 / 2) - f2 / 2.0f;
        if (f < -this.leftMargin + this.leftTextMargin) {
            f5 = -f - this.leftMargin + this.leftTextMargin;
        }
        this.drawText(gL, f5 + (float)(n4 / 2), 0.0, this.lowString, true);
        gL.glRotatef(90.0f, 0.0f, 0.0f, 1.0f);
        this.drawText(gL, n3 / 2, -n4, this.label, true);
        gL.glPopMatrix();
        gL.glMatrixMode(5889);
        gL.glPopMatrix();
        gL.glMatrixMode(5888);
        gL.glEnable(2896);
        gL.glEnable(2929);
    }

    public double getFontScale() {
        return this.fontScale;
    }

    public void setFontScale(double d) {
        this.fontScale = d;
        this.dirty = true;
    }

    @Override
    public void resetCanvas() {
        this.dirty = true;
        this.displayList = 0;
    }

    public class ColorPan
    extends JPanel {
        private static final long serialVersionUID = -3355829427807565800L;
        BufferedImage image;

        ColorPan() {
            Dimension dimension = new Dimension();
            dimension.setSize(50, 50);
            this.setSize(dimension);
            this.setPreferredSize(dimension);
            this.setMinimumSize(dimension);
            this.addComponentListener(new ComponentListener(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    ColorPan.this.initialize();
                }

                @Override
                public void componentMoved(ComponentEvent componentEvent) {
                }

                @Override
                public void componentShown(ComponentEvent componentEvent) {
                }

                @Override
                public void componentHidden(ComponentEvent componentEvent) {
                }
            });
        }

        public void initialize() {
            int n = this.getSize().width;
            int n2 = this.getSize().height;
            if (n2 <= 0 || n <= 0) {
                return;
            }
            int[] nArray = new int[n * n2];
            int n3 = n * n2 - 1;
            int n4 = n2;
            for (float f = 0.0f; f < (float)n4; f += 1.0f) {
                Color color = ColorScale.this.getColor(f / (float)n4);
                Color color2 = ColorScale.this.getColor((f + 1.0f) / (float)n4);
                for (int i = 0; i < n2 / n4; ++i) {
                    for (int j = 0; j < n; ++j) {
                        Color color3 = color;
                        if (i % 2 == 0 && j % 2 == 0 || i % 2 != 0 && j % 2 != 0) {
                            color3 = color2;
                        }
                        nArray[n3--] = color3.getRed() << 16 | color3.getGreen() << 8 | color3.getBlue();
                    }
                }
            }
            this.image = new BufferedImage(n, n2, 1);
            this.image.setRGB(0, 0, n, n2, nArray, 0, n);
        }

        @Override
        public void paint(Graphics graphics) {
            if (this.image == null) {
                this.initialize();
            }
            graphics.drawImage(this.image, 0, 0, this);
        }
    }

    public static class ColorSet {
        private final String name;
        public final double[] colorsR;
        public final double[] colorsG;
        public final double[] colorsB;
        public static final ColorSet RAINBOW = new ColorSet("Rainbow", new double[]{0.0, 0.0, 0.0, 1.0, 1.0}, new double[]{0.0, 1.0, 1.0, 1.0, 0.0}, new double[]{1.0, 1.0, 0.0, 0.0, 0.0});
        public static final ColorSet GRAYSCALE = new ColorSet("Grayscale", new double[]{0.0, 1.0}, new double[]{0.0, 1.0}, new double[]{0.0, 1.0});
        public static final ColorSet INVERSE_GRAYSCALE = new ColorSet("Inverse Grayscale", new double[]{1.0, 0.0}, new double[]{1.0, 0.0}, new double[]{1.0, 0.0});
        public static final ColorSet BLUE_RED = new ColorSet("Blue-Red", new double[]{0.0, 1.0}, new double[]{0.0, 0.0}, new double[]{1.0, 0.0});
        public static final ColorSet BLUE_WHITE_RED = new ColorSet("Blue-White-Red", new double[]{0.0, 1.0, 1.0}, new double[]{0.0, 1.0, 0.0}, new double[]{1.0, 1.0, 0.0});
        public static ColorSet[] VALUES = new ColorSet[]{RAINBOW, GRAYSCALE, INVERSE_GRAYSCALE, BLUE_RED, BLUE_WHITE_RED};

        private ColorSet(String string, double[] dArray, double[] dArray2, double[] dArray3) {
            this.name = string;
            this.colorsR = dArray;
            this.colorsG = dArray2;
            this.colorsB = dArray3;
        }

        public String toString() {
            return this.name;
        }
    }
}

