/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.vis;

import edu.uoregon.tau.vis.Vec;

public class Matrix {
    private double[][] matrix = new double[4][4];

    public Matrix() {
        this.setIdentity();
    }

    public void setIdentity() {
        this.matrix[0][0] = 1.0;
        this.matrix[0][1] = 0.0;
        this.matrix[0][2] = 0.0;
        this.matrix[0][3] = 0.0;
        this.matrix[1][0] = 0.0;
        this.matrix[1][1] = 1.0;
        this.matrix[1][2] = 0.0;
        this.matrix[1][3] = 0.0;
        this.matrix[2][0] = 0.0;
        this.matrix[2][1] = 0.0;
        this.matrix[2][2] = 1.0;
        this.matrix[2][3] = 0.0;
        this.matrix[3][0] = 0.0;
        this.matrix[3][1] = 0.0;
        this.matrix[3][2] = 0.0;
        this.matrix[3][3] = 1.0;
    }

    public void setToTranslate(double d, double d2, double d3) {
        this.setIdentity();
        this.matrix[0][3] = d;
        this.matrix[1][3] = d2;
        this.matrix[2][3] = d3;
    }

    public void setOrthRotate(Vec vec, Vec vec2, Vec vec3) {
        this.matrix[0][0] = vec.x();
        this.matrix[0][1] = vec.y();
        this.matrix[0][2] = vec.z();
        this.matrix[0][3] = 0.0;
        this.matrix[1][0] = vec2.x();
        this.matrix[1][1] = vec2.y();
        this.matrix[1][2] = vec2.z();
        this.matrix[1][3] = 0.0;
        this.matrix[2][0] = vec3.x();
        this.matrix[2][1] = vec3.y();
        this.matrix[2][2] = vec3.z();
        this.matrix[2][3] = 0.0;
        this.matrix[3][0] = 0.0;
        this.matrix[3][1] = 0.0;
        this.matrix[3][2] = 0.0;
        this.matrix[3][3] = 1.0;
    }

    public void transpose() {
        int n;
        int n2;
        Matrix matrix = new Matrix();
        for (n2 = 0; n2 < 4; ++n2) {
            for (n = 0; n < 4; ++n) {
                matrix.matrix[n2][n] = this.matrix[n][n2];
            }
        }
        for (n2 = 0; n2 < 4; ++n2) {
            for (n = 0; n < 4; ++n) {
                this.matrix[n2][n] = matrix.matrix[n2][n];
            }
        }
    }

    public Vec transform(Vec vec) {
        Vec vec2 = new Vec(0.0, 0.0, 0.0);
        vec2.setx((double)vec.x() * this.matrix[0][0] + (double)vec.y() * this.matrix[0][1] + (double)vec.z() * this.matrix[0][2] + (double)vec.w() * this.matrix[0][3]);
        vec2.sety((double)vec.x() * this.matrix[1][0] + (double)vec.y() * this.matrix[1][1] + (double)vec.z() * this.matrix[1][2] + (double)vec.w() * this.matrix[1][3]);
        vec2.setz((double)vec.x() * this.matrix[2][0] + (double)vec.y() * this.matrix[2][1] + (double)vec.z() * this.matrix[2][2] + (double)vec.w() * this.matrix[2][3]);
        vec2.setw((double)vec.x() * this.matrix[3][0] + (double)vec.y() * this.matrix[3][1] + (double)vec.z() * this.matrix[3][2] + (double)vec.w() * this.matrix[3][3]);
        return vec2;
    }

    public static Matrix createRotateX(double d) {
        Matrix matrix = new Matrix();
        matrix.setRotateX(d);
        return matrix;
    }

    public static Matrix createRotateY(double d) {
        Matrix matrix = new Matrix();
        matrix.setRotateY(d);
        return matrix;
    }

    public static Matrix createRotateZ(double d) {
        Matrix matrix = new Matrix();
        matrix.setRotateZ(d);
        return matrix;
    }

    public void setRotateX(double d) {
        this.matrix[0][0] = 1.0;
        this.matrix[0][1] = 0.0;
        this.matrix[0][2] = 0.0;
        this.matrix[0][3] = 0.0;
        this.matrix[1][0] = 0.0;
        this.matrix[1][1] = Math.cos(d);
        this.matrix[1][2] = -Math.sin(d);
        this.matrix[1][3] = 0.0;
        this.matrix[2][0] = 0.0;
        this.matrix[2][1] = Math.sin(d);
        this.matrix[2][2] = Math.cos(d);
        this.matrix[2][3] = 0.0;
        this.matrix[3][0] = 0.0;
        this.matrix[3][1] = 0.0;
        this.matrix[3][2] = 0.0;
        this.matrix[3][3] = 1.0;
    }

    public void setRotateY(double d) {
        this.matrix[0][0] = Math.cos(d);
        this.matrix[0][1] = 0.0;
        this.matrix[0][2] = Math.sin(d);
        this.matrix[0][3] = 0.0;
        this.matrix[1][0] = 0.0;
        this.matrix[1][1] = 1.0;
        this.matrix[1][2] = 0.0;
        this.matrix[1][3] = 0.0;
        this.matrix[2][0] = -Math.sin(d);
        this.matrix[2][1] = 0.0;
        this.matrix[2][2] = Math.cos(d);
        this.matrix[2][3] = 0.0;
        this.matrix[3][0] = 0.0;
        this.matrix[3][1] = 0.0;
        this.matrix[3][2] = 0.0;
        this.matrix[3][3] = 1.0;
    }

    public void setRotateZ(double d) {
        this.matrix[0][0] = Math.cos(d);
        this.matrix[0][1] = -Math.sin(d);
        this.matrix[0][2] = 0.0;
        this.matrix[0][3] = 0.0;
        this.matrix[1][0] = Math.sin(d);
        this.matrix[1][1] = Math.cos(d);
        this.matrix[1][2] = 0.0;
        this.matrix[1][3] = 0.0;
        this.matrix[2][0] = 0.0;
        this.matrix[2][1] = 0.0;
        this.matrix[2][2] = 1.0;
        this.matrix[2][3] = 0.0;
        this.matrix[3][0] = 0.0;
        this.matrix[3][1] = 0.0;
        this.matrix[3][2] = 0.0;
        this.matrix[3][3] = 1.0;
    }

    public Matrix multiply(Matrix matrix) {
        Matrix matrix2 = new Matrix();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                matrix2.matrix[i][j] = 0.0;
                for (int k = 0; k < 4; ++k) {
                    double[] dArray = matrix2.matrix[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.matrix[i][k] * matrix.matrix[k][j];
                }
            }
        }
        return matrix2;
    }
}

