/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.vis;

import com.sun.opengl.util.GLUT;
import edu.uoregon.tau.vis.Axes;
import edu.uoregon.tau.vis.ColorScale;
import edu.uoregon.tau.vis.Matrix;
import edu.uoregon.tau.vis.Plot;
import edu.uoregon.tau.vis.Vec;
import edu.uoregon.tau.vis.VisRenderer;
import edu.uoregon.tau.vis.VisTools;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUquadric;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class XmasTree
implements Plot {
    private List<List<Ornament>> levels;
    private int displayList;
    private boolean dirty = true;
    private float sphereSize = 0.4f;
    private int sphereDetail = 8;
    private ColorScale colorScale;
    private GLUT glut = new GLUT();
    private boolean showLabels = true;
    private double verticalSpread = 2.5;
    private double radiusMultiple = 0.5;

    public XmasTree(List<List<Ornament>> list) {
        this.levels = list;
    }

    @Override
    public ColorScale getColorScale() {
        return this.colorScale;
    }

    @Override
    public void setColorScale(ColorScale colorScale) {
        if (this.colorScale != null) {
            this.colorScale.deleteObserver(this);
        }
        this.colorScale = colorScale;
        if (colorScale != null) {
            colorScale.addObserver(this);
        }
    }

    @Override
    public void render(VisRenderer visRenderer) {
        GLAutoDrawable gLAutoDrawable = visRenderer.getGLAutoDrawable();
        GL gL = gLAutoDrawable.getGL();
        if (this.dirty || this.displayList == 0) {
            this.displayList = gL.glGenLists(1);
            gL.glNewList(this.displayList, 4864);
            this.privateRender(visRenderer);
            gL.glEndList();
            this.dirty = false;
        }
        gL.glCallList(this.displayList);
    }

    private double setRingPosition(List<Ornament> list, float f, double d) {
        double d2 = list.size() - 1;
        if ((d2 *= this.radiusMultiple) <= d) {
            d2 = d + 5.0;
        }
        int n = 0;
        for (Ornament ornament : list) {
            Vec vec = new Vec(d2 * 0.5, 0.0, 0.0);
            Matrix matrix = new Matrix();
            matrix.setRotateZ(Math.PI * 2 * (double)((float)n / (float)list.size()));
            vec = matrix.transform(vec);
            vec.z = f;
            ornament.setVec(vec);
            ++n;
        }
        return d2;
    }

    public void privateRender(VisRenderer visRenderer) {
        Object object;
        Vec vec;
        GLAutoDrawable gLAutoDrawable = visRenderer.getGLAutoDrawable();
        GL gL = gLAutoDrawable.getGL();
        float f = 10.0f;
        for (List<Ornament> gLUquadric2 : this.levels) {
            Iterator<List<Ornament>> iterator = new ArrayList<Ornament>();
            List<Ornament> list = new ArrayList<Ornament>();
            for (Ornament ornament : gLUquadric2) {
                if (gLUquadric2.size() > 5) {
                    if (ornament.children.size() > 0) {
                        iterator.add((List<Ornament>)((Object)ornament));
                        continue;
                    }
                    list.add(ornament);
                    continue;
                }
                iterator.add((List<Ornament>)((Object)ornament));
            }
            double d = 0.0;
            d = this.setRingPosition((List<Ornament>)((Object)iterator), f, d);
            f = (float)((double)f - this.verticalSpread / 2.0);
            d = this.setRingPosition(list, f, d);
            f = (float)((double)f - this.verticalSpread);
        }
        gL.glShadeModel(7425);
        GLU gLU = new GLU();
        gL.glEnable(2896);
        gL.glEnable(2929);
        gL.glFrontFace(2305);
        GLUquadric gLUquadric = gLU.gluNewQuadric();
        gL.glEnable(2884);
        gLU.gluQuadricDrawStyle(gLUquadric, 100012);
        gLU.gluQuadricOrientation(gLUquadric, 100020);
        gLU.gluQuadricNormals(gLUquadric, 100000);
        for (List<Ornament> list : this.levels) {
            for (Ornament ornament : list) {
                vec = ornament.getVec();
                gL.glPushMatrix();
                gL.glTranslatef(vec.x, vec.y, vec.z);
                if (ornament.children.size() > 0) {
                    gL.glColor3f(0.09803922f, 0.74509805f, 0.78431374f);
                } else {
                    gL.glColor3f(1.0f, 0.0f, 0.0f);
                }
                object = this.colorScale.getColor(ornament.getColor());
                gL.glColor3f((float)((Color)object).getRed() / 255.0f, (float)((Color)object).getGreen() / 255.0f, (float)((Color)object).getBlue() / 255.0f);
                if (this.sphereSize < 0.1f) {
                    gL.glDisable(2896);
                    gL.glPointSize(2.5f);
                    gL.glBegin(0);
                    gL.glVertex3f(0.0f, 0.0f, 0.0f);
                    gL.glEnd();
                    gL.glEnable(2896);
                } else {
                    gLU.gluSphere(gLUquadric, Math.max((double)ornament.getSize(), 0.1) * (double)this.sphereSize, this.sphereDetail, this.sphereDetail);
                }
                gL.glPopMatrix();
            }
        }
        gL.glDisable(2896);
        gL.glColor3f(0.42352942f, 0.42352942f, 0.42352942f);
        gL.glBegin(1);
        for (List<Ornament> list : this.levels) {
            for (Ornament ornament : list) {
                vec = ornament.getVec();
                for (Ornament ornament2 : ornament.getChildren()) {
                    Vec vec2 = ornament2.getVec();
                    gL.glVertex3f(vec.x, vec.y, vec.z);
                    gL.glVertex3f(vec2.x, vec2.y, vec2.z);
                }
            }
        }
        gL.glEnd();
        if (this.showLabels) {
            gL.glDisable(2929);
            gL.glDisable(2896);
            for (List<Ornament> list : this.levels) {
                for (Ornament ornament : list) {
                    vec = ornament.getVec();
                    gL.glPushMatrix();
                    gL.glTranslatef(vec.x, vec.y, vec.z);
                    object = ornament.getLabel();
                    gL.glColor3f(0.8f, 0.8f, 0.8f);
                    gL.glRasterPos3d(0.0, 0.0, 0.0);
                    this.glut.glutBitmapString(4, (String)object);
                    gL.glPopMatrix();
                }
            }
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable instanceof ColorScale) {
            this.dirty = true;
        }
    }

    @Override
    public JPanel getControlPanel(final VisRenderer visRenderer) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        final JSlider jSlider = new JSlider(0, 100, (int)(this.verticalSpread * 10.0));
        final JSlider jSlider2 = new JSlider(0, 20, (int)(this.sphereSize * 10.0f));
        final JSlider jSlider3 = new JSlider(3, 30, this.sphereDetail);
        final JSlider jSlider4 = new JSlider(0, 10, (int)(this.radiusMultiple * 10.0));
        jSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                try {
                    XmasTree.this.setVerticalSpread((float)jSlider.getValue() / 10.0f);
                    visRenderer.redraw();
                }
                catch (Exception exception) {
                    VisTools.handleException(exception);
                }
            }
        });
        jSlider2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                try {
                    XmasTree.this.setSphereSize((float)jSlider2.getValue() / 10.0f);
                    visRenderer.redraw();
                }
                catch (Exception exception) {
                    VisTools.handleException(exception);
                }
            }
        });
        jSlider3.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                try {
                    XmasTree.this.setSphereDetail(jSlider3.getValue());
                    visRenderer.redraw();
                }
                catch (Exception exception) {
                    VisTools.handleException(exception);
                }
            }
        });
        jSlider4.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                try {
                    XmasTree.this.setRadiusMultiple((float)jSlider4.getValue() / 10.0f);
                    visRenderer.redraw();
                }
                catch (Exception exception) {
                    VisTools.handleException(exception);
                }
            }
        });
        final JCheckBox jCheckBox = new JCheckBox("Show Labels", this.showLabels);
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    XmasTree.this.setShowLabels(jCheckBox.isSelected());
                    visRenderer.redraw();
                }
                catch (Exception exception) {
                    VisTools.handleException(exception);
                }
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        VisTools.addCompItem(jPanel, jCheckBox, gridBagConstraints, 0, 0, 1, 1);
        VisTools.addCompItem(jPanel, new JLabel("Point size"), gridBagConstraints, 0, 1, 1, 1);
        VisTools.addCompItem(jPanel, new JLabel("Vertical spread"), gridBagConstraints, 0, 2, 1, 1);
        VisTools.addCompItem(jPanel, new JLabel("Radius multiple"), gridBagConstraints, 0, 3, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        VisTools.addCompItem(jPanel, jSlider2, gridBagConstraints, 1, 1, 1, 1);
        VisTools.addCompItem(jPanel, jSlider, gridBagConstraints, 1, 2, 1, 1);
        VisTools.addCompItem(jPanel, jSlider4, gridBagConstraints, 1, 3, 1, 1);
        return jPanel;
    }

    public int getSphereDetail() {
        return this.sphereDetail;
    }

    public void setSphereDetail(int n) {
        this.sphereDetail = n;
        this.dirty = true;
    }

    public boolean getShowLabels() {
        return this.showLabels;
    }

    public void setShowLabels(boolean bl) {
        this.showLabels = bl;
        this.dirty = true;
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public Axes getAxes() {
        return null;
    }

    @Override
    public float getDepth() {
        return 0.0f;
    }

    @Override
    public float getHeight() {
        return 0.0f;
    }

    @Override
    public String getName() {
        return "XmasTree";
    }

    @Override
    public int getSelectedCol() {
        return 0;
    }

    @Override
    public int getSelectedRow() {
        return 0;
    }

    @Override
    public float getWidth() {
        return 0.0f;
    }

    @Override
    public void setAxes(Axes axes) {
    }

    @Override
    public void setSelectedCol(int n) {
    }

    @Override
    public void setSelectedRow(int n) {
    }

    @Override
    public void setSize(float f, float f2, float f3) {
    }

    public void setSphereSize(float f) {
        this.sphereSize = f;
        this.dirty = true;
    }

    public void setVerticalSpread(double d) {
        this.verticalSpread = d;
        this.dirty = true;
    }

    public void setRadiusMultiple(double d) {
        this.radiusMultiple = d;
        this.dirty = true;
    }

    @Override
    public void resetCanvas() {
        this.dirty = true;
        this.displayList = 0;
    }

    public static class Ornament {
        private Object userObject;
        private List<Ornament> parents;
        private List<Ornament> children;
        private float size;
        private float color;
        private float position;
        private Vec vec;
        private String label;

        public Ornament(String string) {
            this(string, string);
        }

        public Ornament(String string, Object object) {
            this.label = string;
            this.userObject = object;
            this.children = new ArrayList<Ornament>();
            this.parents = new ArrayList<Ornament>();
        }

        public void addChild(Ornament ornament) {
            this.children.add(ornament);
        }

        public List<Ornament> getChildren() {
            return this.children;
        }

        public String getLabel() {
            return this.label;
        }

        public float getColor() {
            return this.color;
        }

        public void setColor(float f) {
            this.color = f;
        }

        public List<Ornament> getParents() {
            return this.parents;
        }

        public void setParents(List<Ornament> list) {
            this.parents = list;
        }

        public float getPosition() {
            return this.position;
        }

        public void setPosition(float f) {
            this.position = f;
        }

        public float getSize() {
            return this.size;
        }

        public void setSize(float f) {
            this.size = f;
        }

        public Object getUserObject() {
            return this.userObject;
        }

        public void setUserObject(Object object) {
            this.userObject = object;
        }

        public void setChildren(List<Ornament> list) {
            this.children = list;
        }

        public Vec getVec() {
            return this.vec;
        }

        public void setVec(Vec vec) {
            this.vec = vec;
        }
    }
}

