/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyDataDescr;
import org.python.core.PyException;
import org.python.core.PyFrame;
import org.python.core.PyGenerator$gi_frame_descriptor;
import org.python.core.PyGenerator$throw$_exposer;
import org.python.core.PyIterator;
import org.python.core.PyObject;
import org.python.core.PyTraceback;
import org.python.core.PyType;
import org.python.core.ThreadState;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposeAsSuperclass;
import org.python.expose.ExposedType;

@ExposedType(name="generator", base=PyObject.class, isBaseType=false)
public class PyGenerator
extends PyIterator {
    protected PyFrame gi_frame;
    protected boolean gi_running;
    private PyException generatorExit;
    private PyObject closure;

    public PyGenerator(PyFrame frame, PyObject closure) {
        this.gi_frame = frame;
        this.closure = closure;
        this.generatorExit = Py.makeException(Py.GeneratorExit);
    }

    public PyObject send(PyObject value) {
        if (this.gi_frame == null) {
            throw Py.StopIteration("");
        }
        if (this.gi_frame.f_lasti == 0 && value != Py.None) {
            throw Py.TypeError("can't send non-None value to a just-started generator");
        }
        this.gi_frame.setGeneratorInput(value);
        return this.next();
    }

    public PyObject throw$(PyObject type, PyObject value, PyObject tb) {
        if (tb == Py.None) {
            tb = null;
        } else if (tb != null && !(tb instanceof PyTraceback)) {
            throw Py.TypeError("throw() third argument must be a traceback object");
        }
        return this.raiseException(Py.makeException(type, value, tb));
    }

    public PyObject close() {
        try {
            this.raiseException(this.generatorExit);
            throw Py.RuntimeError("generator ignored GeneratorExit");
        }
        catch (PyException e) {
            if (e.type != Py.StopIteration && e.type != Py.GeneratorExit) {
                throw e;
            }
            return Py.None;
        }
    }

    public PyObject next() {
        return super.next();
    }

    public PyObject __iter__() {
        return this;
    }

    private PyObject raiseException(PyException ex) {
        if (this.gi_frame == null || this.gi_frame.f_lasti == 0) {
            throw ex;
        }
        this.gi_frame.setGeneratorInput(ex);
        return this.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        if (this.gi_frame == null || this.gi_frame.f_lasti == -1) {
            return;
        }
        try {
            this.close();
        }
        catch (PyException e) {
            String className = PyException.exceptionClassName(e.type);
            int lastDot = className.lastIndexOf(46);
            if (lastDot != -1) {
                className = className.substring(lastDot + 1);
            }
            String msg = String.format("Exception %s: %s in %s", className, e.value.__repr__().toString(), this.__repr__().toString());
            Py.println(Py.getSystemState().stderr, Py.newString(msg));
        }
        catch (Throwable throwable) {
        }
        finally {
            super.finalize();
        }
    }

    public PyObject __iternext__() {
        return this.__iternext__(Py.getThreadState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PyObject __iternext__(ThreadState state) {
        if (this.gi_running) {
            throw Py.ValueError("generator already executing");
        }
        if (this.gi_frame == null) {
            return null;
        }
        if (this.gi_frame.f_lasti == -1) {
            this.gi_frame = null;
            return null;
        }
        this.gi_running = true;
        PyObject result = null;
        try {
            result = this.gi_frame.f_code.call(state, this.gi_frame, this.closure);
        }
        catch (PyException e) {
            if (e.type != Py.StopIteration && e.type != Py.GeneratorExit) {
                this.gi_frame = null;
                throw e;
            }
            this.stopException = e;
            this.gi_frame = null;
            PyObject pyObject = null;
            return pyObject;
        }
        finally {
            this.gi_running = false;
        }
        if (result == Py.None && this.gi_frame.f_lasti == -1) {
            return null;
        }
        return result;
    }

    static {
        PyType.addBuilder(PyGenerator.class, new PyGenerator$PyExposer());
    }

    public class PyGenerator$send_exposer
    extends PyBuiltinMethodNarrow {
        public PyGenerator$send_exposer(String string) {
            super(string, 2, 2);
            this.doc = "";
        }

        public PyGenerator$send_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyGenerator$send_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyGenerator)this.self).send(pyObject);
        }
    }

    public class PyGenerator$close_exposer
    extends PyBuiltinMethodNarrow {
        public PyGenerator$close_exposer(String string) {
            super(string, 1, 1);
            this.doc = "";
        }

        public PyGenerator$close_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyGenerator$close_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyGenerator)this.self).close();
        }
    }

    public class PyGenerator$next_exposer
    extends PyBuiltinMethodNarrow {
        public PyGenerator$next_exposer(String string) {
            super(string, 1, 1);
            this.doc = "x.next() -> the next value, or raise StopIteration";
        }

        public PyGenerator$next_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.next() -> the next value, or raise StopIteration";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyGenerator$next_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyGenerator)this.self).next();
        }
    }

    public class PyGenerator$__iter___exposer
    extends PyBuiltinMethodNarrow {
        public PyGenerator$__iter___exposer(String string) {
            super(string, 1, 1);
            this.doc = "";
        }

        public PyGenerator$__iter___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyGenerator$__iter___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyGenerator)this.self).__iter__();
        }
    }

    public class PyGenerator$gi_running_descriptor
    extends PyDataDescr
    implements ExposeAsSuperclass {
        public PyGenerator$gi_running_descriptor() {
            super("gi_running", Boolean.class);
        }

        public Object invokeGet(PyObject pyObject) {
            return Py.newBoolean(((PyGenerator)pyObject).gi_running);
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyGenerator$PyExposer
    extends BaseTypeBuilder {
        public PyGenerator$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new PyGenerator$send_exposer("send"), new PyGenerator$throw$_exposer("throw"), new PyGenerator$close_exposer("close"), new PyGenerator$next_exposer("next"), new PyGenerator$__iter___exposer("__iter__")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{new PyGenerator$gi_running_descriptor(), new PyGenerator$gi_frame_descriptor()};
            super("generator", PyGenerator.class, PyObject.class, false, pyBuiltinMethodArray, pyDataDescrArray, null);
        }
    }
}

