/*
 * Decompiled with CFR 0.152.
 */
package org.xeustechnologies.jtar;

import java.io.File;
import java.util.Date;
import org.xeustechnologies.jtar.Octal;
import org.xeustechnologies.jtar.TarHeader;

public class TarEntry {
    protected File file = null;
    protected TarHeader header = new TarHeader();

    private TarEntry() {
    }

    public TarEntry(File file, String string) {
        this();
        this.file = file;
        this.extractTarHeader(string);
    }

    public TarEntry(byte[] byArray) {
        this();
        this.parseTarHeader(byArray);
    }

    public boolean equals(TarEntry tarEntry) {
        return this.header.name.toString().equals(tarEntry.header.name.toString());
    }

    public boolean isDescendent(TarEntry tarEntry) {
        return tarEntry.header.name.toString().startsWith(this.header.name.toString());
    }

    public TarHeader getHeader() {
        return this.header;
    }

    public String getName() {
        return this.header.name.toString();
    }

    public void setName(String string) {
        this.header.name = new StringBuffer(string);
    }

    public int getUserId() {
        return this.header.userId;
    }

    public void setUserId(int n) {
        this.header.userId = n;
    }

    public int getGroupId() {
        return this.header.groupId;
    }

    public void setGroupId(int n) {
        this.header.groupId = n;
    }

    public String getUserName() {
        return this.header.userName.toString();
    }

    public void setUserName(String string) {
        this.header.userName = new StringBuffer(string);
    }

    public String getGroupName() {
        return this.header.groupName.toString();
    }

    public void setGroupName(String string) {
        this.header.groupName = new StringBuffer(string);
    }

    public void setIds(int n, int n2) {
        this.setUserId(n);
        this.setGroupId(n2);
    }

    public void setModTime(long l) {
        this.header.modTime = l / 1000L;
    }

    public void setModTime(Date date) {
        this.header.modTime = date.getTime() / 1000L;
    }

    public Date getModTime() {
        return new Date(this.header.modTime * 1000L);
    }

    public byte getLinkFlag() {
        return this.header.linkFlag;
    }

    public File getFile() {
        return this.file;
    }

    public long getSize() {
        return this.header.size;
    }

    public void setSize(long l) {
        this.header.size = l;
    }

    public boolean isDirectory() {
        if (this.file != null) {
            return this.file.isDirectory();
        }
        if (this.header != null) {
            if (this.header.linkFlag == 53) {
                return true;
            }
            if (this.header.name.toString().endsWith("/")) {
                return true;
            }
        }
        return false;
    }

    public void extractTarHeader(String string) {
        String string2 = string;
        if ((string2 = string2.replace(File.separatorChar, '/')).startsWith("/")) {
            string2 = string2.substring(1);
        }
        this.header.linkName = new StringBuffer("");
        this.header.name = new StringBuffer(string2);
        if (this.file.isDirectory()) {
            this.header.mode = 16877;
            this.header.linkFlag = (byte)53;
            if (this.header.name.charAt(this.header.name.length() - 1) != '/') {
                this.header.name.append("/");
            }
        } else {
            this.header.mode = 33188;
            this.header.linkFlag = (byte)48;
        }
        this.header.size = this.file.length();
        this.header.modTime = this.file.lastModified() / 1000L;
        this.header.checkSum = 0;
        this.header.devMajor = 0;
        this.header.devMinor = 0;
    }

    public long computeCheckSum(byte[] byArray) {
        long l = 0L;
        for (int i = 0; i < byArray.length; ++i) {
            l += (long)(0xFF & byArray[i]);
        }
        return l;
    }

    public void writeEntryHeader(byte[] byArray) {
        int n = 0;
        n = TarHeader.getNameBytes(this.header.name, byArray, n, 100);
        n = Octal.getOctalBytes(this.header.mode, byArray, n, 8);
        n = Octal.getOctalBytes(this.header.userId, byArray, n, 8);
        n = Octal.getOctalBytes(this.header.groupId, byArray, n, 8);
        long l = this.header.size;
        n = Octal.getLongOctalBytes(l, byArray, n, 12);
        int n2 = n = Octal.getLongOctalBytes(this.header.modTime, byArray, n, 12);
        for (int i = 0; i < 8; ++i) {
            byArray[n++] = 32;
        }
        byArray[n++] = this.header.linkFlag;
        n = TarHeader.getNameBytes(this.header.linkName, byArray, n, 100);
        n = TarHeader.getNameBytes(this.header.magic, byArray, n, 8);
        n = TarHeader.getNameBytes(this.header.userName, byArray, n, 32);
        n = TarHeader.getNameBytes(this.header.groupName, byArray, n, 32);
        n = Octal.getOctalBytes(this.header.devMajor, byArray, n, 8);
        n = Octal.getOctalBytes(this.header.devMinor, byArray, n, 8);
        while (n < byArray.length) {
            byArray[n++] = 0;
        }
        long l2 = this.computeCheckSum(byArray);
        Octal.getCheckSumOctalBytes(l2, byArray, n2, 8);
    }

    public void parseTarHeader(byte[] byArray) {
        int n = 0;
        this.header.name = TarHeader.parseName(byArray, n, 100);
        this.header.mode = (int)Octal.parseOctal(byArray, n += 100, 8);
        this.header.userId = (int)Octal.parseOctal(byArray, n += 8, 8);
        this.header.groupId = (int)Octal.parseOctal(byArray, n += 8, 8);
        this.header.size = Octal.parseOctal(byArray, n += 8, 12);
        this.header.modTime = Octal.parseOctal(byArray, n += 12, 12);
        this.header.checkSum = (int)Octal.parseOctal(byArray, n += 12, 8);
        n += 8;
        this.header.linkFlag = byArray[n++];
        this.header.linkName = TarHeader.parseName(byArray, n, 100);
        this.header.magic = TarHeader.parseName(byArray, n += 100, 8);
        this.header.userName = TarHeader.parseName(byArray, n += 8, 32);
        this.header.groupName = TarHeader.parseName(byArray, n += 32, 32);
        this.header.devMajor = (int)Octal.parseOctal(byArray, n += 32, 8);
        this.header.devMinor = (int)Octal.parseOctal(byArray, n += 8, 8);
    }
}

