/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube;

import scalasca.cubex.cube.LocationGroup;
import scalasca.cubex.cube.LocationType;
import scalasca.cubex.cube.NamedVertex;
import scalasca.cubex.cube.errors.BadSyntaxException;

public class Location
extends NamedVertex {
    protected long rank = -1L;
    protected LocationType type = LocationType.CPU_THREAD;

    public Location() {
        super("Location");
    }

    public Location(int n, LocationGroup locationGroup) {
        super(n, "Location", locationGroup);
    }

    public Location(int n, long l, LocationType locationType, LocationGroup locationGroup) {
        super(n, "Location", locationGroup);
        this.rank = l;
        this.type = locationType;
    }

    public Location(int n, long l, String string, LocationType locationType, LocationGroup locationGroup) {
        super(n, string, locationGroup);
        this.rank = l;
        this.type = locationType;
    }

    public void init(long l, String string, LocationType locationType) {
        this.setName(string);
        this.rank = l;
        this.type = locationType;
    }

    public long getRank() {
        return this.rank;
    }

    public String getName() {
        return super.getName() + " " + String.valueOf(this.rank);
    }

    public LocationType getType() {
        return this.type;
    }

    public String getTypeAsString() {
        if (this.type == LocationType.CPU_THREAD) {
            return "thread";
        }
        if (this.type == LocationType.ACCELERATOR_STREAM) {
            return "accelerator stream";
        }
        if (this.type == LocationType.METRIC) {
            return "metric";
        }
        return "not supported";
    }

    public static LocationType getLocationType(String string) throws BadSyntaxException {
        if (string.equals("thread")) {
            return LocationType.CPU_THREAD;
        }
        if (string.equals("gpu") || string.equals("accelerator stream")) {
            return LocationType.ACCELERATOR_STREAM;
        }
        if (string.equals("metric")) {
            return LocationType.METRIC;
        }
        throw new BadSyntaxException("Do not support location type " + string);
    }
}

