/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube.datalayout.data.value;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import scalasca.cubex.cube.datalayout.data.value.CubeDouble;
import scalasca.cubex.cube.datalayout.data.value.Value;
import scalasca.cubex.cube.errors.WrongNumberOfValueParametersException;
import scalasca.cubex.cube.services.transformation.Endianess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CubeComplex
extends Value {
    protected CubeDouble re;
    protected CubeDouble im;

    public CubeComplex() {
        this.re = new CubeDouble();
        this.im = new CubeDouble();
    }

    public CubeComplex(double d, double d2) {
        this.re = new CubeDouble(d);
        this.im = new CubeDouble(d2);
    }

    @Override
    public String getName() {
        return "Complex";
    }

    @Override
    public String toString() {
        return this.re.toString() + " + i" + this.im.toString();
    }

    @Override
    public int size() {
        return -1;
    }

    @Override
    public void correctEndianess(Endianess endianess, DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
        this.re.correctEndianess(endianess, dataInputStream, dataOutputStream);
        this.im.correctEndianess(endianess, dataInputStream, dataOutputStream);
    }

    @Override
    public Value clone() {
        return new CubeComplex();
    }

    @Override
    public Value copy() {
        return new CubeComplex(this.re.getDouble(), this.im.getDouble());
    }

    @Override
    public Value clone(DataInputStream dataInputStream) throws IOException {
        double d = dataInputStream.readDouble();
        double d2 = dataInputStream.readDouble();
        return new CubeComplex(d, d2);
    }

    @Override
    public void setValue(String string) {
    }

    @Override
    public void setValue(byte by) {
    }

    @Override
    public void setValue(short s) {
    }

    @Override
    public void setValue(int n) {
    }

    @Override
    public void setValue(long l) {
    }

    @Override
    public void setValue(double d) {
    }

    @Override
    public double getDouble() {
        return this.re.getDouble();
    }

    public double getRe() {
        return this.re.getDouble();
    }

    public double getIm() {
        return this.im.getDouble();
    }

    @Override
    public void addValue(Value value) {
        CubeComplex cubeComplex = (CubeComplex)value;
        this.re.addValue(cubeComplex.re);
        this.im.addValue(cubeComplex.im);
    }

    @Override
    public void subtractValue(Value value) {
        CubeComplex cubeComplex = (CubeComplex)value;
        this.re.subtractValue(cubeComplex.re);
        this.im.subtractValue(cubeComplex.im);
    }

    @Override
    public void setValueParameters(Vector<Double> vector) throws WrongNumberOfValueParametersException {
    }
}

