/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube.datalayout.index;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import scalasca.cubex.cube.datalayout.index.DenseIndex;
import scalasca.cubex.cube.datalayout.index.Index;
import scalasca.cubex.cube.datalayout.index.IndexType;
import scalasca.cubex.cube.datalayout.index.SparseIndex;
import scalasca.cubex.cube.errors.BadCubeReportLayoutException;
import scalasca.cubex.cube.errors.UnknownIndexTypeException;
import scalasca.cubex.cube.services.transformation.Endianess;
import scalasca.cubex.cube.services.transformation.NOP;
import scalasca.cubex.cube.services.transformation.SwapBytes;

public class IndexHeader {
    private String Marker = "CUBEX.INDEX";
    private int one;
    private short version;
    private IndexType index_type;
    private Endianess endianess;
    private byte[] raw_data;

    public IndexHeader(byte[] byArray) throws BadCubeReportLayoutException {
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            String string = new String(byArray, 0, this.Marker.length());
            if (!string.equalsIgnoreCase(this.Marker)) {
                throw new BadCubeReportLayoutException("Index header doesn't start with correct marker. Expect " + this.Marker + " but it starts with " + string);
            }
            dataInputStream.skip(this.Marker.length());
            this.one = dataInputStream.readInt();
            this.endianess = this.one == 1 ? new NOP() : new SwapBytes();
            this.version = this.endianess.applyOn(dataInputStream.readShort());
            this.index_type = IndexType.getIndexType(dataInputStream.readByte());
            this.raw_data = new byte[byArray.length - this.size()];
            System.arraycopy(byArray, this.size(), this.raw_data, 0, this.raw_data.length);
            dataInputStream.close();
        }
        catch (IOException iOException) {
            throw new BadCubeReportLayoutException("Reading error of index header: " + iOException.getMessage());
        }
    }

    public int size() {
        return this.Marker.length() + 4 + 2 + 1;
    }

    public Endianess getEndianess() {
        return this.endianess;
    }

    public Index getIndex(int n, int n2) throws BadCubeReportLayoutException {
        switch (this.index_type) {
            case SPARSE: {
                return new SparseIndex(n, n2, this.raw_data, this.endianess);
            }
            case DENSE: {
                return new DenseIndex(n, n2, this.endianess);
            }
        }
        throw new UnknownIndexTypeException(this.index_type);
    }

    public void print() {
        System.out.println("======== Header ============");
        System.out.println(" Version: " + this.version);
        System.out.println(" Endianess: " + this.one + " " + (this.one == 1 ? "same" : "different"));
        System.out.println(" IndexType: " + this.index_type.toString());
        System.out.println("============================");
    }
}

