/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.texture.spi.awt;

import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.awt.AWTTextureData;
import com.jogamp.opengl.util.texture.spi.TextureProvider;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import jogamp.opengl.Debug;

public class IIOTextureProvider
implements TextureProvider {
    private static final boolean DEBUG = Debug.debug("TextureIO");

    @Override
    public TextureData newTextureData(GLProfile gLProfile, File file, int n, int n2, boolean bl, String string) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(file);
        if (bufferedImage == null) {
            return null;
        }
        if (DEBUG) {
            System.out.println("TextureIO.newTextureData(): BufferedImage type for " + file + " = " + bufferedImage.getType());
        }
        return new AWTTextureData(gLProfile, n, n2, bl, bufferedImage);
    }

    @Override
    public TextureData newTextureData(GLProfile gLProfile, InputStream inputStream, int n, int n2, boolean bl, String string) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        if (bufferedImage == null) {
            return null;
        }
        if (DEBUG) {
            System.out.println("TextureIO.newTextureData(): BufferedImage type for stream = " + bufferedImage.getType());
        }
        return new AWTTextureData(gLProfile, n, n2, bl, bufferedImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TextureData newTextureData(GLProfile gLProfile, URL uRL, int n, int n2, boolean bl, String string) throws IOException {
        try (InputStream inputStream = uRL.openStream();){
            TextureData textureData = this.newTextureData(gLProfile, inputStream, n, n2, bl, string);
            return textureData;
        }
    }
}

