/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.common.MetaDataMap;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.DBDataSource;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DataSourceExport;
import edu.uoregon.tau.perfdmf.Database;
import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.UtilFncs;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfdmf.taudb.TAUdbDatabaseAPI;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class ExternalController {
    public static final String LISTAPPLICATIONS = "list applications";
    public static final String LISTEXPERIMENTS = "list experiments";
    public static final String LISTTRIALS = "list trials";
    public static final String LOAD = "load";
    public static final String UPLOAD = "upload";
    public static final String EXPORT = "export";

    public static void runController() {
        try {
            System.out.println("Control Mode Active!");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            String string = bufferedReader.readLine();
            while (string != null) {
                System.out.println("got input: " + string);
                if (string.startsWith("control ")) {
                    ExternalController.processCommand(string.substring(8));
                } else {
                    System.out.println("Valid control statements start with the string 'control'");
                }
                string = bufferedReader.readLine();
            }
            ExternalController.exitController();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void exitController() {
        System.out.println("Control Mode Complete!");
        System.exit(0);
    }

    private static List<String> getControlArgs(String string, String string2) {
        String string3 = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.length();
        if (string2.length() > n) {
            string3 = string2.substring(n + 1).trim();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, " ");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    public static void processCommand(String string) throws Exception {
        System.out.println("processing command: " + string);
        if (string.equals("open manager")) {
            ParaProf.paraProfManagerWindow.setVisible(true);
        } else if (string.equals("list databases")) {
            ExternalController.listDatabases();
        } else if (string.startsWith(LISTAPPLICATIONS)) {
            ExternalController.listApplications(ExternalController.getControlArgs(LISTAPPLICATIONS, string));
        } else if (string.startsWith(LISTEXPERIMENTS)) {
            ExternalController.listExperiments(ExternalController.getControlArgs(LISTEXPERIMENTS, string));
        } else if (string.startsWith(LISTTRIALS)) {
            ExternalController.listTrials(ExternalController.getControlArgs(LISTTRIALS, string));
        } else if (string.startsWith(LOAD)) {
            ExternalController.loadDBTrial(ExternalController.getControlArgs(LOAD, string));
        } else if (string.startsWith(UPLOAD)) {
            ExternalController.uploadTauTrial(ExternalController.getControlArgs(UPLOAD, string));
        } else if (string.startsWith(EXPORT)) {
            ExternalController.exportTrialsToPPK(ExternalController.getControlArgs(EXPORT, string));
        } else if (string.equals("exit")) {
            ExternalController.exitController();
        } else {
            System.out.println("Valid control statements are:\nopen manager\nlist databases\nlist applications <database id>\nlist experiments\nlist trials\nload\nupload\nexport\nexit");
        }
    }

    public static void exportTrialsToPPK(List<String> list) throws Exception {
        if (list.size() <= 3) {
            System.out.println("Invalid input. Requires writable output directory, numeric database id and one more more numeric trial ids");
            return;
        }
        String string = list.get(0);
        int n = Integer.parseInt(list.get(1));
        File file = new File(string);
        if (!file.isDirectory() || !file.canWrite()) {
            System.out.println("Invalid input. ppk output location must be a writable directory.");
            return;
        }
        for (int i = 2; i < list.size(); ++i) {
            int n2 = Integer.parseInt(list.get(i));
            ExternalController.exportTrialToPPK(file, n, n2);
        }
    }

    private static void exportTrialToPPK(File file, int n, int n2) throws Exception {
        DatabaseAPI databaseAPI = new DatabaseAPI();
        Database database = (Database)Database.getDatabases().get(n);
        databaseAPI.initialize(database);
        if (databaseAPI.db().getSchemaVersion() > 0) {
            databaseAPI = new TAUdbDatabaseAPI(databaseAPI);
        }
        Trial trial = databaseAPI.setTrial(n2, true);
        DBDataSource dBDataSource = new DBDataSource(databaseAPI);
        dBDataSource.load();
        trial.setDataSource((DataSource)dBDataSource);
        trial.setID(n2);
        databaseAPI.initialize(database);
        DB dB = databaseAPI.db();
        trial.loadXMLMetadata(dB);
        dBDataSource.setMetaData(trial.getMetaData());
        String string = file.getCanonicalPath() + File.separator + trial.getName() + "-" + trial.getID() + ".ppk";
        File file2 = new File(string);
        DataSourceExport.writePacked((DataSource)dBDataSource, (File)file2);
        System.out.println("Wrote " + file2.getCanonicalPath());
    }

    public static void loadDBTrial(List<String> list) throws Exception {
        if (list.size() != 2) {
            System.out.println("Invalid input. Requires numeric database id and numeric trial id");
            return;
        }
        int n = Integer.parseInt(list.get(0));
        int n2 = Integer.parseInt(list.get(1));
        DatabaseAPI databaseAPI = new DatabaseAPI();
        databaseAPI.initialize((Database)Database.getDatabases().get(n));
        if (databaseAPI.db().getSchemaVersion() > 0) {
            databaseAPI = new TAUdbDatabaseAPI(databaseAPI);
        }
        databaseAPI.setTrial(n2, false);
        DBDataSource dBDataSource = new DBDataSource(databaseAPI);
        dBDataSource.load();
        Trial trial = new Trial();
        trial.setDataSource((DataSource)dBDataSource);
        trial.setID(n2);
        ParaProfTrial paraProfTrial = new ParaProfTrial(trial);
        paraProfTrial.finishLoad();
        paraProfTrial.setID(trial.getID());
        paraProfTrial.showMainWindow();
    }

    public static void uploadTauTrial(List<String> list) throws Exception {
        MetaDataMap metaDataMap;
        if (list.size() != 5) {
            System.out.println("Invalid input. Requires path to profile location, numeric database id, application name, experiment name and trial name");
            ExternalController.outputCommand("return -1");
            ExternalController.outputCommand("endreturn");
            return;
        }
        String string = list.get(0);
        int n = Integer.parseInt(list.get(1));
        String string2 = list.get(2);
        String string3 = list.get(3);
        String string4 = list.get(4);
        File file = new File(string);
        File[] fileArray = new File[]{file};
        int n2 = 1;
        if (!file.isDirectory()) {
            n2 = UtilFncs.identifyData((File)file);
        }
        DataSource dataSource = UtilFncs.initializeDataSource((File[])fileArray, (int)n2, (boolean)false);
        dataSource.load();
        Trial trial = new Trial();
        trial.setDataSource(dataSource);
        DatabaseAPI databaseAPI = new DatabaseAPI();
        databaseAPI.initialize((Database)Database.getDatabases().get(n));
        trial.setName(string4);
        if (databaseAPI.db().getSchemaVersion() == 0) {
            metaDataMap = databaseAPI.getExperiment(string2, string3, true);
            trial.setExperimentID(metaDataMap.getID());
        } else {
            metaDataMap = trial.getMetaData();
            MetaDataMap.MetaDataKey metaDataKey = metaDataMap.newKey("Application");
            metaDataMap.put(metaDataKey, (Object)string2);
            metaDataKey = metaDataMap.newKey("Experiment");
            metaDataMap.put(metaDataKey, (Object)string3);
        }
        int n3 = databaseAPI.uploadTrial(trial, false);
        ExternalController.outputCommand("return " + n3);
        ExternalController.outputCommand("endreturn");
    }

    public static void listApplications(List<String> list) throws SQLException {
        if (list.size() != 1) {
            System.out.println("Invalid input. Requires numeric database id");
            ExternalController.outputCommand("return 0 default");
            ExternalController.outputCommand("endreturn");
            return;
        }
        int n = Integer.parseInt(list.get(0));
        List list2 = Database.getDatabases();
        DatabaseAPI databaseAPI = new DatabaseAPI();
        databaseAPI.initialize((Database)list2.get(n));
        if (databaseAPI.db().getSchemaVersion() > 0) {
            System.out.println("This is a TAUdbDatabase which no longer supports applications.");
            ExternalController.outputCommand("return 0 default");
        } else {
            List list3 = databaseAPI.getApplicationList();
            for (Application application : list3) {
                ExternalController.outputCommand("return " + application.getID() + " " + application.getName());
            }
        }
        ExternalController.outputCommand("endreturn");
    }

    public static void listExperiments(List<String> list) throws SQLException {
        if (list.size() != 2) {
            System.out.println("Invalid input. Requires numeric database id and numeric application id");
            ExternalController.outputCommand("return 0 default");
            ExternalController.outputCommand("endreturn");
            return;
        }
        int n = Integer.parseInt(list.get(0));
        int n2 = Integer.parseInt(list.get(1));
        DatabaseAPI databaseAPI = new DatabaseAPI();
        databaseAPI.initialize((Database)Database.getDatabases().get(n));
        databaseAPI.setApplication(n2);
        if (databaseAPI.db().getSchemaVersion() > 0) {
            System.out.println("This is a TAUdbDatabase which no longer supports Experiments.");
            ExternalController.outputCommand("return 0 default");
        } else {
            List list2 = databaseAPI.getExperimentList();
            for (Experiment experiment : list2) {
                ExternalController.outputCommand("return " + experiment.getID() + " " + experiment.getName());
            }
        }
        ExternalController.outputCommand("endreturn");
    }

    public static void listTrials(List<String> list) throws SQLException {
        if (list.size() < 1) {
            System.out.println("Invalid input. Requires numeric database id and, for older databases, experiment id");
            ExternalController.outputCommand("return -1 default");
            ExternalController.outputCommand("endreturn");
            return;
        }
        int n = Integer.parseInt(list.get(0));
        DatabaseAPI databaseAPI = new DatabaseAPI();
        databaseAPI.initialize((Database)Database.getDatabases().get(n));
        int n2 = databaseAPI.db().getSchemaVersion();
        int n3 = -1;
        if (n2 <= 0) {
            if (list.size() != 2) {
                System.out.println("Invalid input. Requires numeric database id and, for older databases, experiment id");
                ExternalController.outputCommand("return -1 default");
                ExternalController.outputCommand("endreturn");
                return;
            }
            n3 = Integer.parseInt(list.get(1));
        }
        if (n2 > 0) {
            databaseAPI = new TAUdbDatabaseAPI(databaseAPI);
        } else {
            databaseAPI.setExperiment(n3);
        }
        List list2 = databaseAPI.getTrialList(false);
        for (Trial trial : list2) {
            ExternalController.outputCommand("return " + trial.getID() + " " + trial.getName());
        }
        ExternalController.outputCommand("endreturn");
    }

    public static void listDatabases() {
        List list = Database.getDatabases();
        int n = 0;
        for (Database database : list) {
            ExternalController.outputCommand("return " + n + " " + database.getName());
            ++n;
        }
        ExternalController.outputCommand("endreturn");
    }

    public static void outputCommand(String string) {
        System.out.println("control " + string);
    }
}

