/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.paraprof.GroupListCellRenderer;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.WindowPlacer;
import edu.uoregon.tau.paraprof.interfaces.ParaProfWindow;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.Group;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GroupChangerWindow
extends JFrame
implements ParaProfWindow,
ActionListener {
    private static final long serialVersionUID = 6095352344200700777L;
    private ParaProfTrial ppTrial;
    private DefaultListModel listModel;
    private JList regionList;
    private DefaultListModel currentGroupListModel = new DefaultListModel();
    private JList currentGroupList;
    private DefaultListModel availableGroupListModel = new DefaultListModel();
    private JList availableGroupList;
    private JTextField filterTextField;

    private GroupChangerWindow(ParaProfTrial paraProfTrial, JFrame jFrame) {
        this.ppTrial = paraProfTrial;
        this.setLocation(WindowPlacer.getNewLocation(this, jFrame));
        ParaProfUtils.setFrameIcon(this);
        this.setSize(new Dimension(800, 400));
        this.setTitle("TAU: ParaProf: Group Changer: " + paraProfTrial);
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        JLabel jLabel = new JLabel("Region");
        gridBagConstraints.weighty = 0.0;
        Utility.addCompItem((Container)container, (Component)jLabel, (GridBagConstraints)gridBagConstraints, (int)0, (int)0, (int)2, (int)1);
        this.filterTextField = new JTextField();
        gridBagConstraints.fill = 2;
        this.filterTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                GroupChangerWindow.this.updateFunctionList();
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }
        });
        Utility.addCompItem((Container)container, (Component)this.filterTextField, (GridBagConstraints)gridBagConstraints, (int)1, (int)1, (int)1, (int)1);
        JLabel jLabel2 = new JLabel("filter:");
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        Utility.addCompItem((Container)container, (Component)jLabel2, (GridBagConstraints)gridBagConstraints, (int)0, (int)1, (int)1, (int)1);
        this.listModel = new DefaultListModel();
        this.updateFunctionList();
        this.regionList = new JList(this.listModel);
        this.regionList.setSelectionMode(2);
        this.regionList.setSize(500, 300);
        this.regionList.addListSelectionListener(new RegionListener());
        JScrollPane jScrollPane = new JScrollPane(this.regionList);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        Utility.addCompItem((Container)container, (Component)jScrollPane, (GridBagConstraints)gridBagConstraints, (int)0, (int)2, (int)2, (int)2);
        JLabel jLabel3 = new JLabel("Current");
        jLabel3.setHorizontalAlignment(0);
        jLabel3.setVerticalAlignment(1);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Utility.addCompItem((Container)container, (Component)jLabel3, (GridBagConstraints)gridBagConstraints, (int)2, (int)0, (int)1, (int)2);
        this.currentGroupList = new JList(this.currentGroupListModel);
        this.currentGroupList.setCellRenderer(new GroupListCellRenderer());
        this.currentGroupList.setSelectionMode(2);
        JScrollPane jScrollPane2 = new JScrollPane(this.currentGroupList);
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.weighty = 0.1;
        Utility.addCompItem((Container)container, (Component)jScrollPane2, (GridBagConstraints)gridBagConstraints, (int)2, (int)2, (int)1, (int)2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        JButton jButton = new JButton("<--");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GroupChangerWindow.this.addGroups();
            }
        });
        Utility.addCompItem((Container)container, (Component)jButton, (GridBagConstraints)gridBagConstraints, (int)3, (int)2, (int)1, (int)1);
        JButton jButton2 = new JButton("-->");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GroupChangerWindow.this.removeGroups();
            }
        });
        Utility.addCompItem((Container)container, (Component)jButton2, (GridBagConstraints)gridBagConstraints, (int)3, (int)3, (int)1, (int)1);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        JLabel jLabel4 = new JLabel("Available");
        jLabel4.setHorizontalAlignment(0);
        gridBagConstraints.weighty = 0.0;
        Utility.addCompItem((Container)container, (Component)jLabel4, (GridBagConstraints)gridBagConstraints, (int)4, (int)0, (int)2, (int)1);
        final JTextField jTextField = new JTextField();
        gridBagConstraints.fill = 2;
        Utility.addCompItem((Container)container, (Component)jTextField, (GridBagConstraints)gridBagConstraints, (int)4, (int)1, (int)1, (int)1);
        JButton jButton3 = new JButton("new group");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GroupChangerWindow.this.ppTrial.getDataSource().addGroup(jTextField.getText());
                GroupChangerWindow.this.updateGroupLists();
            }
        });
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        Utility.addCompItem((Container)container, (Component)jButton3, (GridBagConstraints)gridBagConstraints, (int)5, (int)1, (int)1, (int)1);
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.availableGroupList = new JList(this.availableGroupListModel);
        this.availableGroupList.setCellRenderer(new GroupListCellRenderer());
        this.availableGroupList.setSelectionMode(2);
        JScrollPane jScrollPane3 = new JScrollPane(this.availableGroupList);
        Utility.addCompItem((Container)container, (Component)jScrollPane3, (GridBagConstraints)gridBagConstraints, (int)4, (int)2, (int)2, (int)2);
    }

    private void addGroups() {
        Object[] objectArray = this.availableGroupList.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            GroupListBlob groupListBlob = (GroupListBlob)objectArray[i];
            Group group = groupListBlob.group;
            Object[] objectArray2 = this.regionList.getSelectedValues();
            for (int j = 0; j < objectArray2.length; ++j) {
                Function function = (Function)objectArray2[j];
                function.addGroup(group);
            }
        }
        this.updateGroupLists();
        this.ppTrial.updateRegisteredObjects("dataEvent");
    }

    private void removeGroups() {
        Object[] objectArray = this.currentGroupList.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            GroupListBlob groupListBlob = (GroupListBlob)objectArray[i];
            Group group = groupListBlob.group;
            Object[] objectArray2 = this.regionList.getSelectedValues();
            for (int j = 0; j < objectArray2.length; ++j) {
                Function function = (Function)objectArray2[j];
                function.removeGroup(group);
            }
        }
        this.updateGroupLists();
        this.ppTrial.updateRegisteredObjects("dataEvent");
    }

    private void updateFunctionList() {
        this.listModel.clear();
        int n = 0;
        try {
            String string = this.filterTextField.getText();
            string = string.replaceAll("\\*", ".\\*");
            string = string.replaceAll("\\(", "\\\\(");
            string = string.replaceAll("\\)", "\\\\)");
            string = string + ".*";
            Pattern pattern = Pattern.compile(string);
            Iterator<Function> iterator = this.ppTrial.getFunctions();
            while (iterator.hasNext()) {
                Function function = iterator.next();
                if (this.filterTextField.getText().equals("")) {
                    this.listModel.add(n++, function);
                    continue;
                }
                Matcher matcher = pattern.matcher(function.getName().trim());
                if (!matcher.matches()) continue;
                this.listModel.add(n++, function);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void updateGroupLists() {
        int n;
        HashMap<Group, Integer> hashMap = new HashMap<Group, Integer>();
        Object[] objectArray = this.regionList.getSelectedValues();
        for (n = 0; n < objectArray.length; ++n) {
            Function function = (Function)objectArray[n];
            for (Group group : function.getGroups()) {
                Integer n2 = (Integer)hashMap.get(group);
                if (n2 == null) {
                    hashMap.put(group, new Integer(1));
                    continue;
                }
                hashMap.put(group, new Integer(n2 + 1));
            }
        }
        this.currentGroupListModel.clear();
        this.availableGroupListModel.clear();
        n = 0;
        int n3 = 0;
        for (Group group : hashMap.keySet()) {
            int n4 = (Integer)hashMap.get(group);
            GroupListBlob groupListBlob = new GroupListBlob();
            groupListBlob.group = group;
            if (n4 == objectArray.length) {
                groupListBlob.allMembers = true;
            } else {
                groupListBlob.allMembers = false;
                this.availableGroupListModel.add(n3++, groupListBlob);
            }
            this.currentGroupListModel.add(n++, groupListBlob);
        }
        Iterator<Object> iterator = this.ppTrial.getDataSource().getGroups();
        while (iterator.hasNext()) {
            Group group;
            group = (Group)iterator.next();
            if (hashMap.get(group) != null) continue;
            GroupListBlob groupListBlob = new GroupListBlob();
            groupListBlob.group = group;
            groupListBlob.allMembers = true;
            this.availableGroupListModel.add(n3++, groupListBlob);
        }
    }

    public static GroupChangerWindow createGroupChangerWindow(ParaProfTrial paraProfTrial, JFrame jFrame) {
        GroupChangerWindow groupChangerWindow = new GroupChangerWindow(paraProfTrial, jFrame);
        return groupChangerWindow;
    }

    @Override
    public void closeThisWindow() {
    }

    @Override
    public JFrame getFrame() {
        return null;
    }

    @Override
    public void help(boolean bl) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    private class RegionListener
    implements ListSelectionListener {
        private RegionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            GroupChangerWindow.this.updateGroupLists();
        }
    }

    public static class GroupListBlob {
        public Group group;
        public boolean allMembers;

        public String toString() {
            return this.group.getName();
        }
    }
}

