/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class HelpWindow
extends JFrame
implements ActionListener,
Observer {
    private static final long serialVersionUID = -3689599495979927735L;
    int windowWidth = 750;
    int windowHeight = 500;
    JTextArea helpJTextArea;
    Document helpJTextAreaDocument;
    private JScrollPane scrollPane;

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public HelpWindow() {
        this.setSize(new Dimension(this.windowWidth, this.windowHeight));
        this.setTitle("TAU: ParaProf: Help Window");
        ParaProfUtils.setFrameIcon(this);
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Display General Help");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Close ParaProf Help Window");
        jMenuItem2.addActionListener(this);
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Exit ParaProf!");
        jMenuItem3.addActionListener(this);
        jMenu.add(jMenuItem3);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        this.helpJTextArea = new JTextArea();
        this.helpJTextArea.setLineWrap(true);
        this.helpJTextArea.setWrapStyleWord(true);
        this.helpJTextArea.setMargin(new Insets(3, 3, 3, 3));
        this.helpJTextArea.setSize(new Dimension(this.windowWidth, this.windowHeight));
        this.helpJTextAreaDocument = this.helpJTextArea.getDocument();
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        Border border = BorderFactory.createLoweredBevelBorder();
        this.scrollPane = new JScrollPane(this.helpJTextArea);
        this.scrollPane.setBorder(border);
        this.scrollPane.setPreferredSize(new Dimension(this.windowWidth, this.windowHeight));
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(this.scrollPane, gridBagConstraints, 0, 0, 2, 1);
        this.writeText("Welcome to ParaProf!");
        this.writeText("");
        this.writeText("For general help, please select display general help from the file menu.");
    }

    public void clearText() {
        try {
            this.helpJTextAreaDocument.remove(0, this.helpJTextAreaDocument.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void writeText(String string) {
        this.helpJTextArea.append(string);
        this.helpJTextArea.append("\n");
    }

    @Override
    public void update(Observable observable, Object object) {
        String string = (String)object;
        if (string.equals("subWindowCloseEvent")) {
            this.setVisible(false);
        }
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Display General Help")) {
                    this.clearText();
                    this.writeText("Welcome to ParaProf!");
                    this.writeText("");
                } else if (string.equals("Close ParaProf Help Window")) {
                    this.setVisible(false);
                } else if (string.equals("Exit ParaProf!")) {
                    this.setVisible(false);
                    this.dispose();
                    ParaProf.exitParaProf(0);
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }
}

