/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.common.ImageExport;
import edu.uoregon.tau.common.ImageFormatFileFilter;
import edu.uoregon.tau.common.ImageOptionsPanel;
import edu.uoregon.tau.paraprof.ParaProfException;
import edu.uoregon.tau.paraprof.ThreeDeeImageProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class ParaProfImageOutput {
    private ParaProfImageOutput() {
    }

    public static void saveImage(ImageExport imageExport) throws IOException {
        int n;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Save Image File");
        jFileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        FileFilter[] fileFilterArray = jFileChooser.getChoosableFileFilters();
        for (int i = 0; i < fileFilterArray.length; ++i) {
            jFileChooser.removeChoosableFileFilter(fileFilterArray[i]);
        }
        jFileChooser.addChoosableFileFilter((FileFilter)new ImageFormatFileFilter(ImageFormatFileFilter.JPG));
        jFileChooser.addChoosableFileFilter((FileFilter)new ImageFormatFileFilter(ImageFormatFileFilter.PNG));
        jFileChooser.setFileSelectionMode(0);
        ImageOptionsPanel imageOptionsPanel = new ImageOptionsPanel((Component)imageExport, true, false);
        jFileChooser.setAccessory((JComponent)imageOptionsPanel);
        jFileChooser.addPropertyChangeListener((PropertyChangeListener)imageOptionsPanel);
        int n2 = jFileChooser.showSaveDialog((Component)imageExport);
        if (n2 != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        String string = file.getCanonicalPath();
        ImageFormatFileFilter imageFormatFileFilter = null;
        FileFilter fileFilter = jFileChooser.getFileFilter();
        if (!(fileFilter instanceof ImageFormatFileFilter)) {
            throw new ParaProfException("Unknown format : " + fileFilter);
        }
        imageFormatFileFilter = (ImageFormatFileFilter)fileFilter;
        String string2 = ImageFormatFileFilter.getExtension((File)file);
        if (string2 == null || string2.toUpperCase().compareTo("JPG") != 0 && string2.toUpperCase().compareTo("PNG") != 0) {
            string2 = imageFormatFileFilter.getExtension();
            string = string + "." + string2;
            file = new File(string);
        }
        if (file.exists() && (n = JOptionPane.showConfirmDialog((Component)imageExport, file + " already exists\nOverwrite existing file?", "Confirm Overwrite", 2, 3)) == 2) {
            return;
        }
        ParaProfImageOutput.saveImage(imageExport, file, imageOptionsPanel.isFullScreen(), imageOptionsPanel.isPrependHeader(), imageOptionsPanel.getImageQuality());
    }

    public static void saveImage(ImageExport imageExport, File file) throws IOException {
        ParaProfImageOutput.saveImage(imageExport, file, false, true, 100.0f);
    }

    public static void saveImage(ImageExport imageExport, String string) throws IOException {
        ParaProfImageOutput.saveImage(imageExport, new File(string), false, true, 100.0f);
    }

    public static void saveImage(ImageExport imageExport, File file, boolean bl, boolean bl2, float f) throws IOException {
        String string = ImageFormatFileFilter.getExtension((File)file);
        Dimension dimension = imageExport.getImageSize(bl, bl2);
        dimension.height = Math.max(dimension.height, 1);
        dimension.width = Math.max(dimension.width, 1);
        BufferedImage bufferedImage = new BufferedImage((int)dimension.getWidth(), (int)dimension.getHeight(), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        imageExport.export(graphics2D, false, bl, bl2);
        dimension = imageExport.getImageSize(bl, bl2);
        dimension.height = Math.max(dimension.height, 1);
        dimension.width = Math.max(dimension.width, 1);
        bufferedImage = new BufferedImage((int)dimension.getWidth(), (int)dimension.getHeight(), 1);
        graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, (int)dimension.getWidth(), (int)dimension.getHeight());
        graphics2D.setColor(Color.black);
        imageExport.export(graphics2D, false, bl, bl2);
        ImageWriter imageWriter = null;
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string.toUpperCase());
        if (iterator.hasNext()) {
            imageWriter = iterator.next();
        }
        if (imageWriter == null) {
            JOptionPane.showMessageDialog((Component)imageExport, "Couldn't find Image Writer for extension '." + string.toUpperCase() + "'");
            return;
        }
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(file);
        imageWriter.setOutput(imageOutputStream);
        IIOImage iIOImage = new IIOImage(bufferedImage, null, null);
        if (string.toUpperCase().compareTo("JPG") == 0) {
            ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
            imageWriteParam.setCompressionMode(2);
            imageWriteParam.setCompressionQuality(f);
            imageWriter.write(null, iIOImage, imageWriteParam);
        } else {
            imageWriter.write(iIOImage);
        }
    }

    public static void save3dImage(ThreeDeeImageProvider threeDeeImageProvider) throws IOException {
        int n;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Save Image File");
        jFileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        FileFilter[] fileFilterArray = jFileChooser.getChoosableFileFilters();
        for (int i = 0; i < fileFilterArray.length; ++i) {
            jFileChooser.removeChoosableFileFilter(fileFilterArray[i]);
        }
        jFileChooser.addChoosableFileFilter((FileFilter)new ImageFormatFileFilter(ImageFormatFileFilter.JPG));
        jFileChooser.addChoosableFileFilter((FileFilter)new ImageFormatFileFilter(ImageFormatFileFilter.PNG));
        jFileChooser.setFileSelectionMode(0);
        ImageOptionsPanel imageOptionsPanel = new ImageOptionsPanel(threeDeeImageProvider.getComponent(), false, false);
        jFileChooser.setAccessory((JComponent)imageOptionsPanel);
        jFileChooser.addPropertyChangeListener((PropertyChangeListener)imageOptionsPanel);
        int n2 = jFileChooser.showSaveDialog(threeDeeImageProvider.getComponent());
        if (n2 != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        String string = file.getCanonicalPath();
        ImageFormatFileFilter imageFormatFileFilter = null;
        FileFilter fileFilter = jFileChooser.getFileFilter();
        if (!(fileFilter instanceof ImageFormatFileFilter)) {
            throw new ParaProfException("Unknown format : " + fileFilter);
        }
        imageFormatFileFilter = (ImageFormatFileFilter)fileFilter;
        String string2 = ImageFormatFileFilter.getExtension((File)file);
        if (string2 == null || string2.toUpperCase().compareTo("JPG") != 0 && string2.toUpperCase().compareTo("PNG") != 0) {
            string2 = imageFormatFileFilter.getExtension();
            string = string + "." + string2;
            file = new File(string);
        }
        if (file.exists() && (n = JOptionPane.showConfirmDialog((Component)((Object)threeDeeImageProvider), file + " already exists\nOverwrite existing file?", "Confirm Overwrite", 2, 3)) == 2) {
            return;
        }
        ImageFormatFileFilter imageFormatFileFilter2 = null;
        if (fileFilter instanceof ImageFormatFileFilter) {
            imageFormatFileFilter2 = (ImageFormatFileFilter)fileFilter;
            if (string2 == null) {
                string = string + "." + imageFormatFileFilter2.getExtension();
                file = new File(string);
            } else if (!string2.equals("png") && !string2.equals("jpg")) {
                string = string + "." + imageFormatFileFilter2.getExtension();
                file = new File(string);
            }
            String string3 = imageFormatFileFilter2.getExtension().toUpperCase();
            File file2 = file;
            jFileChooser.setVisible(false);
            BufferedImage bufferedImage = threeDeeImageProvider.getImage();
            ImageWriter imageWriter = null;
            Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string3);
            if (iterator.hasNext()) {
                imageWriter = iterator.next();
            }
            ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(file2);
            imageWriter.setOutput(imageOutputStream);
            IIOImage iIOImage = new IIOImage(bufferedImage, null, null);
            if (string2.toUpperCase().compareTo("JPG") == 0) {
                ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
                imageWriteParam.setCompressionMode(2);
                imageWriteParam.setCompressionQuality(imageOptionsPanel.getImageQuality());
                imageWriter.write(null, iIOImage, imageWriteParam);
            } else {
                imageWriter.write(iIOImage);
            }
        }
    }
}

