/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.barchart;

import edu.uoregon.tau.common.ImageExport;
import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.barchart.AbstractBarChartModel;
import edu.uoregon.tau.paraprof.barchart.BarChart;
import edu.uoregon.tau.paraprof.barchart.BarChartModel;
import edu.uoregon.tau.paraprof.interfaces.ScrollBarController;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class BarChartPanel
extends JScrollPane
implements Printable,
ImageExport,
ScrollBarController {
    private static final long serialVersionUID = 4417813804029452411L;
    BarChart barChart;

    public BarChartPanel(BarChartModel barChartModel) {
        this(barChartModel, null);
    }

    public BarChartPanel(BarChartModel barChartModel, JComponent jComponent) {
        this.barChart = new BarChart(barChartModel, this);
        this.setViewportView(this.barChart);
        this.setColumnHeaderView(jComponent);
        this.getVerticalScrollBar().setUnitIncrement(35);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                BarChartPanel.this.barChart.sizeChanged();
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }
        });
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        try {
            if (n >= 1) {
                return 1;
            }
            Dimension dimension = this.getImageSize(true, true);
            ParaProfUtils.scaleForPrint(graphics, pageFormat, (int)dimension.getWidth(), (int)dimension.getHeight());
            this.getColumnHeader().paintAll(graphics);
            graphics.translate(0, this.getColumnHeader().getHeight());
            this.export((Graphics2D)graphics, false, true, false);
            return 0;
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
            return 1;
        }
    }

    public BarChart getBarChart() {
        return this.barChart;
    }

    public void export(Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) {
        if (bl3) {
            this.getColumnHeader().paintAll(graphics2D);
            graphics2D.translate(0, this.getColumnHeader().getHeight());
        }
        Rectangle rectangle = this.getViewport().getViewRect();
        graphics2D.translate(0.0, -rectangle.getMinY());
        this.barChart.export(graphics2D, false, bl2);
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        if (bl2) {
            Dimension dimension = this.getColumnHeader().getSize();
            Dimension dimension2 = bl ? this.barChart.getSize() : this.getViewport().getExtentSize();
            return new Dimension((int)Math.max(dimension.getWidth(), dimension2.getWidth()), (int)(dimension.getHeight() + dimension2.getHeight()));
        }
        if (bl) {
            return this.barChart.getSize();
        }
        return this.getViewport().getExtentSize();
    }

    @Override
    public void setVerticalScrollBarPosition(int n) {
        JScrollBar jScrollBar = this.getVerticalScrollBar();
        jScrollBar.setValue(n);
    }

    @Override
    public void setHorizontalScrollBarPosition(int n) {
        JScrollBar jScrollBar = this.getHorizontalScrollBar();
        jScrollBar.setValue(n);
    }

    @Override
    public Dimension getThisViewportSize() {
        return this.getViewport().getExtentSize();
    }

    public static void main(String[] stringArray) {
        new ParaProf();
        ParaProf.initialize();
        JFrame jFrame = new JFrame("Bar Chart Test");
        jFrame.setDefaultCloseOperation(3);
        AbstractBarChartModel abstractBarChartModel = new AbstractBarChartModel(){

            @Override
            public int getNumRows() {
                return 5;
            }

            @Override
            public int getSubSize() {
                return 3;
            }

            @Override
            public String getRowLabel(int n) {
                return "row " + n;
            }

            @Override
            public String getValueLabel(int n, int n2) {
                return "xygYpAcol " + n2;
            }

            @Override
            public double getValue(int n, int n2) {
                return (n + 5) * (n2 + 15);
            }

            @Override
            public Color getValueColor(int n, int n2) {
                return Color.orange;
            }

            @Override
            public Color getValueHighlightColor(int n, int n2) {
                return null;
            }

            @Override
            public void fireValueClick(int n, int n2, MouseEvent mouseEvent, JComponent jComponent) {
            }

            @Override
            public void fireRowLabelClick(int n, MouseEvent mouseEvent, JComponent jComponent) {
            }

            @Override
            public String getValueToolTipText(int n, int n2) {
                return null;
            }

            @Override
            public String getRowLabelToolTipText(int n) {
                return null;
            }

            @Override
            public String getOtherToolTopText(int n) {
                return null;
            }

            @Override
            public void reloadData() {
            }

            @Override
            public DataSorter getDataSorter() {
                return null;
            }
        };
        BarChartPanel barChartPanel = new BarChartPanel(abstractBarChartModel, new JTextArea("asdf"));
        barChartPanel.getBarChart().setLeftJustified(true);
        barChartPanel.getBarChart().setSingleLine(false);
        barChartPanel.getBarChart().setBarLength(300);
        jFrame.getContentPane().add(barChartPanel);
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.setLocation(500, 500);
        jFrame.setSize(640, 480);
    }
}

