/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.treetable;

import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.treetable.ContextEventModel;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

public class ContextEventTreeNode
extends DefaultMutableTreeNode
implements Comparable<ContextEventTreeNode> {
    private static final long serialVersionUID = 8704255864552442447L;
    private List<ContextEventTreeNode> children;
    private String displayName;
    private ContextEventModel model;
    private UserEventProfile userEventProfile;
    private String name;
    private static final String SPACE_COLON_SPACE = " : ";
    private static final String ARROW = "=>";
    private static final String SPACE_ARROW_SPACE = " => ";

    public ContextEventTreeNode(String string, ContextEventModel contextEventModel) {
        this(null, contextEventModel, string);
    }

    public ContextEventTreeNode(UserEventProfile userEventProfile, ContextEventModel contextEventModel, String string) {
        this.setUserObject(userEventProfile);
        this.userEventProfile = userEventProfile;
        this.model = contextEventModel;
        if (userEventProfile == null) {
            this.name = string.trim();
            this.displayName = UtilFncs.getRightMost((String)string);
        } else {
            this.name = ParaProfUtils.getUserEventDisplayName(userEventProfile.getUserEvent()).trim();
            this.displayName = this.name.indexOf(SPACE_COLON_SPACE) != -1 ? this.name.substring(0, this.name.lastIndexOf(SPACE_COLON_SPACE)).trim() : this.name;
        }
    }

    public UserEventProfile getUserEventProfile() {
        return this.userEventProfile;
    }

    public List<ContextEventTreeNode> getChildren() {
        this.checkInitChildren();
        return this.children;
    }

    private void checkInitChildren() {
        if (this.children == null) {
            Object object;
            this.children = new ArrayList<ContextEventTreeNode>();
            HashSet<Object> hashSet = new HashSet<Object>();
            Iterator iterator = this.model.getThread().getUserEventProfiles();
            while (iterator.hasNext()) {
                Object object2;
                String string;
                UserEventProfile object3 = (UserEventProfile)iterator.next();
                if (object3 == null || !object3.getUserEvent().isContextEvent() || !(string = ((String)(object = ParaProfUtils.getUserEventDisplayName(object3.getUserEvent()))).substring(((String)object).lastIndexOf(SPACE_COLON_SPACE) + 2).trim()).startsWith(this.name)) continue;
                String string2 = string.substring(this.name.length()).trim();
                if (string2.startsWith(ARROW)) {
                    string2 = string2.substring(2).trim();
                    object2 = this.name + SPACE_ARROW_SPACE + UtilFncs.getLeftSide((String)string2);
                    hashSet.add(object2);
                    continue;
                }
                if (string2.length() != 0) continue;
                object2 = new ContextEventTreeNode(object3, this.model, null);
                this.children.add((ContextEventTreeNode)object2);
            }
            for (String string : hashSet) {
                object = new ContextEventTreeNode(string, this.model);
                this.children.add((ContextEventTreeNode)object);
            }
        }
    }

    public int getNumChildren() {
        this.checkInitChildren();
        return this.children.size();
    }

    public void sortChildren() {
        if (this.children != null) {
            Collections.sort(this.children);
            for (ContextEventTreeNode contextEventTreeNode : this.children) {
                contextEventTreeNode.sortChildren();
            }
        }
    }

    @Override
    public String toString() {
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(ContextEventTreeNode contextEventTreeNode) {
        int n = 0;
        int n2 = this.model.getSortColumn();
        if (n2 == 0) {
            n = this.toString().compareTo(contextEventTreeNode.toString());
        } else {
            Double d = (Double)this.model.getValueAt(contextEventTreeNode, n2);
            Double d2 = (Double)this.model.getValueAt(this, n2);
            if (d == null && d2 != null) {
                return 1;
            }
            if (d != null && d2 == null) {
                return -1;
            }
            n = d == null && d2 == null ? 0 : (int)(d2 - d);
        }
        if (this.model.getSortAscending()) {
            return -n;
        }
        return n;
    }
}

