/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.treetable;

import edu.uoregon.tau.common.ImageExport;
import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.common.treetable.AbstractTreeTableModel;
import edu.uoregon.tau.common.treetable.JTreeTable;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.WindowPlacer;
import edu.uoregon.tau.paraprof.interfaces.ParaProfWindow;
import edu.uoregon.tau.paraprof.treetable.ContextEventModel;
import edu.uoregon.tau.paraprof.treetable.ContextEventTreeNode;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ContextEventWindow
extends JFrame
implements Observer,
ParaProfWindow,
Printable,
ImageExport,
ActionListener {
    private static final long serialVersionUID = 1234017079628001497L;
    private ParaProfTrial ppTrial;
    private Thread thread;
    private ContextEventModel model;
    private JTreeTable treeTable;
    private JScrollPane scrollPane;
    private static String showTot = "Show Total Column";
    JCheckBoxMenuItem showTotalMenuItem;
    String hTitle = "Hide Totals";
    String sTitle = "Show Totals";

    public ContextEventWindow(ParaProfTrial paraProfTrial, Thread thread) {
        this(paraProfTrial, thread, null);
    }

    public ContextEventWindow(ParaProfTrial paraProfTrial, Thread thread, Component component) {
        this.ppTrial = paraProfTrial;
        this.thread = thread;
        paraProfTrial.addObserver(this);
        this.setSize(ParaProfUtils.checkSize(new Dimension(1000, 600)));
        this.setLocation(WindowPlacer.getNewLocation(this, component));
        if (thread.getNodeID() == -1 || thread.getNodeID() == -6) {
            this.setTitle("TAU: ParaProf: Mean Context Events - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        } else if (thread.getNodeID() == -2) {
            this.setTitle("TAU: ParaProf: Total Context Events - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        } else if (thread.getNodeID() == -3 || thread.getNodeID() == -7) {
            this.setTitle("TAU: ParaProf: Std. Dev. Context Events - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        } else {
            this.setTitle("TAU: ParaProf: Context Events for: " + ParaProfUtils.getThreadLabel(thread) + " - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        }
        ParaProfUtils.setFrameIcon(this);
        if (ParaProf.getHelpWindow().isVisible()) {
            this.help(false);
        }
        this.setupMenus();
        this.setupData();
        ParaProf.incrementNumWindows();
    }

    private void setupMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(ParaProfUtils.createFileMenu(this, this, this));
        JMenu jMenu = new JMenu("Options");
        this.showTotalMenuItem = new JCheckBoxMenuItem(showTot);
        this.showTotalMenuItem.setSelected(true);
        this.showTotalMenuItem.addActionListener(this);
        jMenu.add(this.showTotalMenuItem);
        jMenuBar.add(jMenu);
        jMenuBar.add(ParaProfUtils.createWindowsMenu(this.ppTrial, this));
        jMenuBar.add(ParaProfUtils.createHelpMenu(this, this));
        this.setJMenuBar(jMenuBar);
    }

    private void setupData() {
        this.model = new ContextEventModel(this, this.ppTrial, this.thread, false);
        this.model.showTotal(this.showTotalMenuItem.getState());
        this.createTreeTable(this.model);
        this.addComponents();
    }

    private void createTreeTable(AbstractTreeTableModel abstractTreeTableModel) {
        this.treeTable = new JTreeTable(abstractTreeTableModel, true, true);
        final JTree jTree = this.treeTable.getTree();
        FontMetrics fontMetrics = jTree.getFontMetrics(ParaProf.preferences.getFont());
        jTree.setRowHeight(fontMetrics.getHeight());
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                try {
                    TreePath treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (treePath != null) {
                        ContextEventTreeNode contextEventTreeNode = (ContextEventTreeNode)treePath.getLastPathComponent();
                        if (ParaProfUtils.rightClick(mouseEvent)) {
                            if (contextEventTreeNode.getUserEventProfile() != null) {
                                ParaProfUtils.handleUserEventClick(ContextEventWindow.this.ppTrial, contextEventTreeNode.getUserEventProfile().getUserEvent(), ContextEventWindow.this.thread, (JComponent)ContextEventWindow.this.treeTable, mouseEvent);
                            } else {
                                JPopupMenu jPopupMenu = new JPopupMenu();
                                MidNodeActionListener midNodeActionListener = new MidNodeActionListener(contextEventTreeNode);
                                JMenuItem jMenuItem = new JMenuItem(ContextEventWindow.this.sTitle);
                                jMenuItem.addActionListener(midNodeActionListener);
                                jPopupMenu.add(jMenuItem);
                                jMenuItem = new JMenuItem(ContextEventWindow.this.hTitle);
                                jMenuItem.addActionListener(midNodeActionListener);
                                jPopupMenu.add(jMenuItem);
                                jPopupMenu.show((Component)ContextEventWindow.this.treeTable, mouseEvent.getX(), mouseEvent.getY());
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        this.treeTable.addMouseListener((MouseListener)mouseAdapter);
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer(){
            private static final long serialVersionUID = 2780103869814842355L;

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                this.setIcon(null);
                this.setBackgroundNonSelectionColor(null);
                if (n % 2 == 0) {
                    this.setBackgroundNonSelectionColor(new Color(235, 235, 235));
                } else {
                    this.setBackground(jTree.getBackground());
                }
                return this;
            }
        };
        this.treeTable.getTree().setCellRenderer(defaultTreeCellRenderer);
        Font font = ParaProf.preferencesWindow.getFont();
        this.treeTable.setFont(font);
        defaultTreeCellRenderer.setFont(font);
        FontMetrics fontMetrics2 = this.getFontMetrics(font);
        this.treeTable.setRowHeight(fontMetrics2.getMaxAscent() + fontMetrics2.getMaxDescent() + 3);
        this.treeTable.setAutoResizeMode(0);
        this.treeTable.setAutoResizeMode(2);
        TableColumn tableColumn = this.treeTable.getColumnModel().getColumn(0);
        int n = 450;
        tableColumn.setPreferredWidth(n);
    }

    private void addComponents() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new GridBagLayout());
        this.scrollPane = new JScrollPane((Component)this.treeTable);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        Utility.addCompItem((JFrame)this, (Component)this.scrollPane, (GridBagConstraints)gridBagConstraints, (int)0, (int)0, (int)0, (int)0);
        this.validate();
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        try {
            if (n >= 1) {
                return 1;
            }
            ParaProfUtils.scaleForPrint(graphics, pageFormat, (int)this.treeTable.getSize().getWidth(), (int)this.treeTable.getSize().getHeight());
            this.export((Graphics2D)graphics, false, true, false);
            return 0;
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
            return 1;
        }
    }

    public void setUnits(int n) {
    }

    public void export(Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            this.scrollPane.getColumnHeader().paintAll(graphics2D);
            graphics2D.translate(0, this.scrollPane.getColumnHeader().getHeight());
            this.treeTable.paintAll((Graphics)graphics2D);
        } else {
            this.scrollPane.paintAll(graphics2D);
        }
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        if (bl) {
            Dimension dimension = this.treeTable.getSize();
            dimension.setSize(dimension.getWidth(), dimension.getHeight() + (double)this.scrollPane.getColumnHeader().getHeight());
            return dimension;
        }
        return this.scrollPane.getSize();
    }

    public boolean getTreeMode() {
        return true;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (this.thread.getNodeID() >= 0) {
            this.setTitle("TAU: ParaProf: Context Events for: " + ParaProfUtils.getThreadLabel(this.thread) + " - " + this.ppTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        }
        this.setupData();
        this.treeTable.repaint();
    }

    @Override
    public void closeThisWindow() {
        this.setVisible(false);
        this.ppTrial.deleteObserver(this);
        ParaProf.decrementNumWindows();
        this.dispose();
    }

    @Override
    public void help(boolean bl) {
        ParaProf.getHelpWindow().clearText();
        if (bl) {
            ParaProf.getHelpWindow().setVisible(true);
        }
        ParaProf.getHelpWindow().writeText("This is the Context Event Window.\n");
        ParaProf.getHelpWindow().writeText("This window shows context events in a tree-table.)\n");
    }

    @Override
    public JFrame getFrame() {
        return this;
    }

    public void selectEvent(UserEventProfile userEventProfile) {
        JTree jTree = this.treeTable.getTree();
        TreeModel treeModel = jTree.getModel();
        ContextEventTreeNode contextEventTreeNode = (ContextEventTreeNode)treeModel.getRoot();
        String string = userEventProfile.getName().trim().replaceAll(" +", " ");
        string = string.substring(string.indexOf(58) + 1).trim();
        int n = 0;
        if (userEventProfile.getUserEvent().isContextEvent()) {
            n = ContextEventWindow.treeSearch(contextEventTreeNode, userEventProfile, jTree, 0, string);
        } else {
            n = ContextEventWindow.tableSearch(this.model, userEventProfile);
            this.treeTable.getSelectionModel().setSelectionInterval(n, n);
        }
        int n2 = this.treeTable.getRowHeight() + this.treeTable.getRowMargin();
        this.treeTable.scrollRectToVisible(new Rectangle(0, n2 * n, 5, 5));
        this.treeTable.validate();
    }

    private static int tableSearch(ContextEventModel contextEventModel, UserEventProfile userEventProfile) {
        ContextEventTreeNode contextEventTreeNode = (ContextEventTreeNode)contextEventModel.getRoot();
        int n = contextEventModel.getChildCount(contextEventModel.getRoot());
        for (int i = 0; i < n; ++i) {
            UserEventProfile userEventProfile2;
            ContextEventTreeNode contextEventTreeNode2 = (ContextEventTreeNode)contextEventModel.getChild(contextEventTreeNode, i);
            if (contextEventTreeNode2 == null || (userEventProfile2 = (UserEventProfile)contextEventTreeNode2.getUserObject()) == null || !userEventProfile2.equals(userEventProfile)) continue;
            return i;
        }
        return 0;
    }

    private static int treeSearch(ContextEventTreeNode contextEventTreeNode, UserEventProfile userEventProfile, JTree jTree, int n, String string) {
        TreeModel treeModel = jTree.getModel();
        UserEventProfile userEventProfile2 = (UserEventProfile)contextEventTreeNode.getUserObject();
        if (userEventProfile2 != null && userEventProfile.equals(userEventProfile2)) {
            if (n == 0) {
                return 0;
            }
            return n - 1;
        }
        int n2 = treeModel.getChildCount(contextEventTreeNode);
        if (n2 == 0) {
            return 0;
        }
        for (int i = 0; i < n2; ++i) {
            ContextEventTreeNode contextEventTreeNode2 = (ContextEventTreeNode)treeModel.getChild(contextEventTreeNode, i);
            if (contextEventTreeNode2 == null) continue;
            if (string.startsWith(contextEventTreeNode2.getName().trim().replaceAll(" +", " "))) {
                jTree.expandRow(i + n);
                return ContextEventWindow.treeSearch(contextEventTreeNode2, userEventProfile, jTree, i + ++n, string);
            }
            UserEventProfile userEventProfile3 = (UserEventProfile)contextEventTreeNode2.getUserObject();
            if (userEventProfile3 != null) {
                System.out.println(userEventProfile3.getName());
            }
            if (userEventProfile3 == null || !userEventProfile3.equals(userEventProfile)) continue;
            if (userEventProfile.getUserEvent().isContextEvent()) {
                jTree.setSelectionRow(n + i);
            }
            return n + i;
        }
        return 0;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(showTot)) {
            this.model.showTotal(this.showTotalMenuItem.getState());
            this.setupData();
        }
    }

    class MidNodeActionListener
    implements ActionListener {
        ContextEventTreeNode node;

        MidNodeActionListener(ContextEventTreeNode contextEventTreeNode) {
            this.node = contextEventTreeNode;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            boolean bl = true;
            if (string.equals(ContextEventWindow.this.hTitle)) {
                bl = false;
            }
            this.showHideTotals(bl, this.node);
            ContextEventWindow.this.ppTrial.updateRegisteredObjects("colorEvent");
        }

        private void showHideTotals(boolean bl, ContextEventTreeNode contextEventTreeNode) {
            List<ContextEventTreeNode> list = contextEventTreeNode.getChildren();
            for (ContextEventTreeNode contextEventTreeNode2 : list) {
                UserEventProfile userEventProfile = contextEventTreeNode2.getUserEventProfile();
                if (userEventProfile != null) {
                    userEventProfile.getUserEvent().setShowTotal(bl);
                    continue;
                }
                this.showHideTotals(bl, contextEventTreeNode2);
            }
        }
    }
}

