/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import java.text.ChoiceFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class TimeFormat {
    private static final double[] LIMITS = new double[]{Double.NEGATIVE_INFINITY, 0.0, 1.0E-10, 1.0E-7, 1.0E-4, 0.1};
    private static final String[] UNITS = new String[]{"-ve", "ps", "ns", "us", "ms", "s"};
    private static final String PATTERN = "#,##0.00###";
    private DecimalFormat decfmt = (DecimalFormat)NumberFormat.getInstance();
    private ChoiceFormat unitfmt = null;

    public TimeFormat() {
        this.decfmt.applyPattern(PATTERN);
        this.unitfmt = new ChoiceFormat(LIMITS, UNITS);
    }

    public String format(double d) {
        String string = this.unitfmt.format(Math.abs(d));
        if (string.equals("s")) {
            return this.decfmt.format(d) + " sec";
        }
        if (string.equals("ms")) {
            return this.decfmt.format(d * 1000.0) + " msec";
        }
        if (string.equals("us")) {
            return this.decfmt.format(d * 1000000.0) + " usec";
        }
        if (string.equals("ns")) {
            return this.decfmt.format(d * 1.0E9) + " nsec";
        }
        if (string.equals("ps")) {
            return this.decfmt.format(d * 1.0E12) + " psec";
        }
        return this.decfmt.format(d) + " sec";
    }
}

