/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.vis;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.util.gl2.GLUT;
import edu.uoregon.tau.vis.Shape;
import edu.uoregon.tau.vis.VisRenderer;
import edu.uoregon.tau.vis.VisTools;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Axes
implements Shape {
    private GLUT glut = new GLUT();
    private float xSize;
    private float ySize;
    private float zSize;
    private String xlabel;
    private String ylabel;
    private String zlabel;
    private String xOrigLabel;
    private String yOrigLabel;
    private String zOrigLabel;
    private int xTickSkip;
    private int yTickSkip;
    private int zTickSkip;
    private int xLabelSkip;
    private int yLabelSkip;
    private int zLabelSkip;
    private List<String> xStrings;
    private List<String> yStrings;
    private List<String> zStrings;
    private List<String> xOrigStrings;
    private List<String> yOrigStrings;
    private List<String> zOrigStrings;
    private boolean autoSkip = true;
    private boolean onEdge;
    private boolean dirty = true;
    private Orientation orientation = Orientation.NW;
    private int font = 1;
    private float stringSize = 3.0f;
    private float labelSize = 5.0f;
    private float fontScale = 1200.0f;
    private int labelLength = 30;
    private boolean enabled = true;
    private Color highlightColor = new Color(1, 0, 0);
    private int displayList;
    private int selectedRow = -1;
    private int selectedCol = -1;
    private Color textColor = Color.white;
    private Color majorColor = Color.white;
    private Color minorColor = new Color(0.5f, 0.5f, 0.5f);
    private boolean oldReverseVideo;
    private boolean oldAntiAlias;

    public boolean getVisible() {
        return this.enabled;
    }

    public void setVisible(boolean bl) {
        this.enabled = bl;
        this.dirty = true;
    }

    public void setStrings(String string, String string2, String string3, List<String> list, List<String> list2, List<String> list3) {
        this.xOrigLabel = this.xlabel = string;
        this.yOrigLabel = this.ylabel = string2;
        this.zOrigLabel = this.zlabel = string3;
        this.xStrings = list;
        this.xOrigStrings = this.xStrings;
        this.yStrings = list2;
        this.yOrigStrings = this.yStrings;
        this.zStrings = list3;
        this.zOrigStrings = this.zStrings;
        if (this.xStrings == null) {
            this.xStrings = new ArrayList<String>();
        }
        if (this.yStrings == null) {
            this.yStrings = new ArrayList<String>();
        }
        if (this.zStrings == null) {
            this.zStrings = new ArrayList<String>();
        }
        this.setStringLength();
        this.setLabelLength();
        this.setAutoTickSkip();
        this.dirty = true;
    }

    private void setLabelLength() {
        if (this.xlabel.contains("\n")) {
            if (this.xOrigLabel == null) {
                this.xOrigLabel = this.xlabel;
            }
            this.xlabel = this.fixLabelLength(this.xOrigLabel);
        }
        if (this.ylabel.contains("\n")) {
            if (this.yOrigLabel == null) {
                this.yOrigLabel = this.ylabel;
            }
            this.ylabel = this.fixLabelLength(this.yOrigLabel);
        }
        if (this.zlabel.contains("\n")) {
            if (this.zOrigLabel == null) {
                this.zOrigLabel = this.zlabel;
            }
            this.zlabel = this.fixLabelLength(this.zOrigLabel);
        }
    }

    private void setStringLength() {
        if (this.xlabel.equals("Function")) {
            if (this.xOrigStrings == null) {
                this.xOrigStrings = this.yStrings;
            }
            this.xStrings = this.fixStringLength(this.xOrigStrings);
        }
        if (this.ylabel.equals("Function")) {
            if (this.yOrigStrings == null) {
                this.yOrigStrings = this.yStrings;
            }
            this.yStrings = this.fixStringLength(this.yOrigStrings);
        }
        if (this.zlabel.equals("Function")) {
            if (this.zOrigStrings == null) {
                this.zOrigStrings = this.yStrings;
            }
            this.zStrings = this.fixStringLength(this.zOrigStrings);
        }
    }

    private String fixLabelLength(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        String string2 = stringTokenizer.nextToken();
        if (string2 != null && string2.length() > this.labelLength) {
            string2 = string2.substring(0, this.labelLength) + "...";
        }
        string2 = string2 + "\n";
        string2 = string2 + stringTokenizer.nextToken();
        return string2;
    }

    private List<String> fixStringLength(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (string != null && string.length() > this.labelLength) {
                string = string.substring(0, this.labelLength) + "...";
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    public void setOnEdge(boolean bl) {
        this.onEdge = bl;
        this.dirty = true;
    }

    public boolean getOnEdge() {
        return this.onEdge;
    }

    public void setSize(float f, float f2, float f3) {
        this.xSize = f;
        this.ySize = f2;
        this.zSize = f3;
        if (this.autoSkip) {
            this.setAutoTickSkip();
        }
        this.dirty = true;
    }

    public void setHighlightColor(Color color) {
        this.highlightColor = color;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.dirty = true;
    }

    public JPanel getControlPanel(final VisRenderer visRenderer) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        final JCheckBox jCheckBox = new JCheckBox("Show Axes", this.enabled);
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Axes.this.setVisible(jCheckBox.isSelected());
                    visRenderer.redraw();
                }
                catch (Exception exception) {
                    VisTools.handleException(exception);
                }
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string = actionEvent.getActionCommand();
                    if (string.equals("NW")) {
                        Axes.this.setOrientation(Orientation.NW);
                    } else if (string.equals("SW")) {
                        Axes.this.setOrientation(Orientation.SW);
                    } else if (string.equals("SE")) {
                        Axes.this.setOrientation(Orientation.SE);
                    } else if (string.equals("NE")) {
                        Axes.this.setOrientation(Orientation.NE);
                    }
                    visRenderer.redraw();
                }
                catch (Exception exception) {
                    VisTools.handleException(exception);
                }
            }
        };
        final JSlider jSlider = new JSlider(0, 4550, 4600 - (int)this.getFontScale());
        jSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                try {
                    Axes.this.setFontScale(4600.0f - (float)jSlider.getValue());
                    visRenderer.redraw();
                }
                catch (Exception exception) {
                    VisTools.handleException(exception);
                }
            }
        });
        final JSlider jSlider2 = new JSlider(0, 512, this.labelLength);
        jSlider2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                try {
                    Axes.this.setLabelLength(jSlider2.getValue());
                    visRenderer.redraw();
                }
                catch (Exception exception) {
                    VisTools.handleException(exception);
                }
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButton jRadioButton = new JRadioButton("NW", this.orientation == Orientation.NW);
        JRadioButton jRadioButton2 = new JRadioButton("NE", this.orientation == Orientation.NW);
        JRadioButton jRadioButton3 = new JRadioButton("SE", this.orientation == Orientation.SE);
        JRadioButton jRadioButton4 = new JRadioButton("SW", this.orientation == Orientation.SW);
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton4);
        jRadioButton.addActionListener(actionListener);
        jRadioButton2.addActionListener(actionListener);
        jRadioButton4.addActionListener(actionListener);
        jRadioButton3.addActionListener(actionListener);
        jRadioButton.setHorizontalTextPosition(10);
        jRadioButton3.setHorizontalTextPosition(10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 0.2;
        VisTools.addCompItem(jPanel, jCheckBox, gridBagConstraints, 0, 0, 2, 2);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        VisTools.addCompItem(jPanel, new JLabel("Orientation"), gridBagConstraints, 2, 0, 2, 1);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        VisTools.addCompItem(jPanel, jRadioButton, gridBagConstraints, 2, 1, 1, 1);
        VisTools.addCompItem(jPanel, jRadioButton3, gridBagConstraints, 2, 2, 1, 1);
        gridBagConstraints.anchor = 17;
        VisTools.addCompItem(jPanel, jRadioButton2, gridBagConstraints, 3, 1, 1, 1);
        VisTools.addCompItem(jPanel, jRadioButton4, gridBagConstraints, 3, 2, 1, 1);
        gridBagConstraints.anchor = 10;
        VisTools.addCompItem(jPanel, new JLabel("Font Size"), gridBagConstraints, 0, 2, 1, 1);
        gridBagConstraints.fill = 2;
        VisTools.addCompItem(jPanel, jSlider, gridBagConstraints, 0, 3, 1, 1);
        VisTools.addCompItem(jPanel, new JLabel("Label Length"), gridBagConstraints, 0, 4, 1, 1);
        VisTools.addCompItem(jPanel, jSlider2, gridBagConstraints, 0, 5, 1, 1);
        return jPanel;
    }

    public int getSelectedCol() {
        return this.selectedCol;
    }

    public void setSelectedCol(int n) {
        this.selectedCol = n;
        this.dirty = true;
    }

    public int getSelectedRow() {
        return this.selectedRow;
    }

    public void setSelectedRow(int n) {
        this.selectedRow = n;
        this.dirty = true;
    }

    @Override
    public void render(VisRenderer visRenderer) {
        GLAutoDrawable gLAutoDrawable = visRenderer.getGLAutoDrawable();
        if (this.oldReverseVideo != visRenderer.getReverseVideo()) {
            this.dirty = true;
        }
        this.oldReverseVideo = visRenderer.getReverseVideo();
        if (this.oldAntiAlias != visRenderer.getAntiAliasedLines()) {
            this.dirty = true;
        }
        this.oldAntiAlias = visRenderer.getAntiAliasedLines();
        if (!this.enabled) {
            return;
        }
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        if (this.dirty || this.displayList == 0) {
            if (this.displayList == 0) {
                this.displayList = gL2.glGenLists(1);
            }
            gL2.glNewList(this.displayList, 4864);
            this.privateRender(visRenderer);
            gL2.glEndList();
            this.dirty = false;
        }
        gL2.glCallList(this.displayList);
    }

    private void setAutoTickSkip() {
        if (this.xStrings == null) {
            return;
        }
        this.xLabelSkip = (int)((float)this.xStrings.size() / (this.xSize * 2.0f));
        this.yLabelSkip = (int)((float)this.yStrings.size() / (this.ySize * 2.0f));
        this.zLabelSkip = (int)((float)this.zStrings.size() / (this.zSize * 2.0f));
        this.xTickSkip = this.xLabelSkip > 0 ? this.xLabelSkip / 3 : 0;
        this.yTickSkip = this.yLabelSkip > 0 ? this.yLabelSkip / 3 : 0;
        this.zTickSkip = this.zLabelSkip > 0 ? this.zLabelSkip / 3 : 0;
    }

    private void applyMajorColor(VisRenderer visRenderer) {
        VisTools.glApplyInvertableColor(visRenderer, this.majorColor);
    }

    private void applyTextColor(VisRenderer visRenderer) {
        VisTools.glApplyInvertableColor(visRenderer, this.textColor);
    }

    private void applyMinorColor(VisRenderer visRenderer) {
        VisTools.glApplyInvertableColor(visRenderer, this.minorColor);
    }

    private void drawGrid(VisRenderer visRenderer, int n, int n2, float f, float f2, int n3, int n4) {
        float f3;
        int n5;
        GL2 gL2 = visRenderer.getGLAutoDrawable().getGL().getGL2();
        this.applyMinorColor(visRenderer);
        gL2.glBegin(1);
        int n6 = 0;
        int n7 = 0;
        if (this.onEdge) {
            n6 = 1;
            n7 = 1;
        }
        for (n5 = 0; n5 < n; ++n5) {
            if ((n5 - n6) % (n3 + 1) != 0 && n5 != n - 1) continue;
            if (n5 == 0 || n5 == n - 1) {
                this.applyMajorColor(visRenderer);
            }
            f3 = (float)n5 / (float)(n - 1) * f;
            gL2.glVertex3f(f3, 0.0f, 0.0f);
            gL2.glVertex3f(f3, f2, 0.0f);
            if (n5 != 0 && n5 != n - 1) continue;
            this.applyMinorColor(visRenderer);
        }
        for (n5 = 0; n5 < n2; ++n5) {
            if ((n5 - n7) % (n4 + 1) != 0 && n5 != n2 - 1) continue;
            if (n5 == 0 || n5 == n2 - 1) {
                this.applyMajorColor(visRenderer);
            }
            f3 = (float)n5 / (float)(n2 - 1) * f2;
            gL2.glVertex3f(0.0f, f3, 0.0f);
            gL2.glVertex3f(f, f3, 0.0f);
            if (n5 != 0 && n5 != n2 - 1) continue;
            this.applyMinorColor(visRenderer);
        }
        gL2.glEnd();
    }

    private void privateRender(VisRenderer visRenderer) {
        if (!this.enabled) {
            return;
        }
        GL2 gL2 = visRenderer.getGLAutoDrawable().getGL().getGL2();
        if (this.selectedRow < 0 || this.selectedCol < 0) {
            this.selectedRow = -1;
            this.selectedCol = -1;
        }
        int n = this.xStrings.size();
        int n2 = this.yStrings.size();
        int n3 = this.zStrings.size();
        if (this.onEdge) {
            n += 2;
            n2 += 2;
        }
        gL2.glDisable(2896);
        if (visRenderer.getAntiAliasedLines()) {
            gL2.glEnable(2848);
            gL2.glEnable(3042);
            gL2.glBlendFunc(770, 771);
            gL2.glHint(3154, 4354);
        } else {
            gL2.glDisable(2848);
            gL2.glDisable(3042);
        }
        gL2.glLineWidth(1.0f);
        this.drawGrid(visRenderer, n, n2, this.xSize, this.ySize, this.xLabelSkip, this.yLabelSkip);
        gL2.glPushMatrix();
        if (this.orientation == Orientation.NE || this.orientation == Orientation.SE) {
            gL2.glTranslatef(0.0f, this.ySize, 0.0f);
        }
        gL2.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
        this.drawGrid(visRenderer, n, n3, this.xSize, this.zSize, this.xLabelSkip, this.zLabelSkip);
        gL2.glPopMatrix();
        gL2.glPushMatrix();
        if (this.orientation == Orientation.SE || this.orientation == Orientation.SW) {
            gL2.glTranslatef(this.xSize, 0.0f, 0.0f);
        }
        gL2.glRotatef(90.0f, 0.0f, 0.0f, 1.0f);
        gL2.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
        this.drawGrid(visRenderer, n2, n3, this.ySize, this.zSize, this.yLabelSkip, this.zLabelSkip);
        gL2.glPopMatrix();
        this.applyMajorColor(visRenderer);
        float f = this.ySize / (float)(n2 - 1);
        gL2.glPushMatrix();
        if (this.orientation == Orientation.NW) {
            gL2.glTranslatef(this.xSize, 0.0f, 0.0f);
            gL2.glRotatef(180.0f, 0.0f, 0.0f, 1.0f);
            f = -f;
        } else if (this.orientation == Orientation.NE) {
            gL2.glTranslatef(this.xSize, 0.0f, 0.0f);
        } else if (this.orientation != Orientation.SE && this.orientation == Orientation.SW) {
            gL2.glRotatef(180.0f, 0.0f, 0.0f, 1.0f);
            f = -f;
        }
        if (this.onEdge) {
            gL2.glTranslatef(0.0f, f, 0.0f);
        }
        this.drawLabels(visRenderer, this.ylabel, this.yStrings, f, this.yLabelSkip, this.yTickSkip, this.orientation == Orientation.NE || this.orientation == Orientation.SW, this.selectedRow);
        gL2.glPopMatrix();
        gL2.glPushMatrix();
        f = this.xSize / (float)(n - 1);
        if (this.orientation == Orientation.NW) {
            gL2.glTranslatef(0.0f, this.ySize, 0.0f);
            gL2.glRotatef(90.0f, 0.0f, 0.0f, 1.0f);
            f = -f;
        } else if (this.orientation == Orientation.NE) {
            gL2.glRotatef(90.0f, 0.0f, 0.0f, 1.0f);
            f = -f;
        } else if (this.orientation == Orientation.SE) {
            gL2.glRotatef(270.0f, 0.0f, 0.0f, 1.0f);
        } else if (this.orientation == Orientation.SW) {
            gL2.glTranslatef(0.0f, this.ySize, 0.0f);
            gL2.glRotatef(270.0f, 0.0f, 0.0f, 1.0f);
        }
        if (this.onEdge) {
            gL2.glTranslatef(0.0f, f, 0.0f);
        }
        this.drawLabels(visRenderer, this.xlabel, this.xStrings, f, this.xLabelSkip, this.xTickSkip, this.orientation == Orientation.NW || this.orientation == Orientation.SE, this.selectedCol);
        gL2.glPopMatrix();
        gL2.glPushMatrix();
        f = this.zSize / (float)(n3 - 1);
        if (this.orientation == Orientation.NW) {
            gL2.glTranslatef(0.0f, this.ySize, 0.0f);
            gL2.glRotatef(45.0f, 0.0f, 0.0f, 1.0f);
        } else if (this.orientation == Orientation.NE) {
            gL2.glTranslatef(this.xSize, this.ySize, 0.0f);
            gL2.glRotatef(-45.0f, 0.0f, 0.0f, 1.0f);
        } else if (this.orientation == Orientation.SW) {
            gL2.glTranslatef(this.xSize, this.ySize, 0.0f);
            gL2.glRotatef(135.0f, 0.0f, 0.0f, 1.0f);
        } else if (this.orientation == Orientation.SE) {
            gL2.glTranslatef(0.0f, this.ySize, 0.0f);
            gL2.glRotatef(-135.0f, 0.0f, 0.0f, 1.0f);
        }
        gL2.glRotatef(90.0f, 0.0f, 0.0f, 1.0f);
        gL2.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
        this.drawLabels(visRenderer, this.zlabel, this.zStrings, f, this.zLabelSkip, this.zTickSkip, this.orientation == Orientation.NW || this.orientation == Orientation.NE, -1);
        gL2.glPopMatrix();
        gL2.glPushMatrix();
        f = this.zSize / (float)(n3 - 1);
        if (this.orientation == Orientation.NW) {
            gL2.glTranslatef(this.xSize, 0.0f, 0.0f);
            gL2.glRotatef(45.0f, 0.0f, 0.0f, 1.0f);
        } else if (this.orientation == Orientation.NE) {
            gL2.glRotatef(-45.0f, 0.0f, 0.0f, 1.0f);
        } else if (this.orientation == Orientation.SW) {
            gL2.glRotatef(135.0f, 0.0f, 0.0f, 1.0f);
        } else if (this.orientation == Orientation.SE) {
            gL2.glTranslatef(this.xSize, 0.0f, 0.0f);
            gL2.glRotatef(-135.0f, 0.0f, 0.0f, 1.0f);
        }
        gL2.glRotatef(90.0f, 0.0f, 0.0f, 1.0f);
        gL2.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
        this.drawLabels(visRenderer, this.zlabel, this.zStrings, f, this.zLabelSkip, this.zTickSkip, this.orientation == Orientation.SE || this.orientation == Orientation.SW, -1);
        gL2.glPopMatrix();
        gL2.glEnable(2896);
    }

    private void drawLabels(VisRenderer visRenderer, String string, List<String> list, float f, int n, int n2, boolean bl, int n3) {
        char c;
        String string2;
        GL2 gL2 = visRenderer.getGLAutoDrawable().getGL().getGL2();
        double d = 0.0;
        this.applyTextColor(visRenderer);
        for (int i = 0; i < list.size(); ++i) {
            if (i % (n + 1) == 0) {
                if (i == n3) {
                    VisTools.glSetColor(gL2, this.highlightColor);
                }
                string2 = list.get(i);
                double d2 = this.glut.glutStrokeLengthf(this.font, string2);
                gL2.glPushMatrix();
                gL2.glBegin(1);
                if (bl) {
                    gL2.glVertex3f(0.0f, 0.0f, 0.0f);
                    gL2.glVertex3f(1.0f, 0.0f, 0.0f);
                } else {
                    gL2.glVertex3f(0.0f, 0.0f, 0.0f);
                    gL2.glVertex3f(-1.0f, 0.0f, 0.0f);
                }
                gL2.glEnd();
                if (bl) {
                    gL2.glTranslatef(1.5f, 0.0f, 0.0f);
                    gL2.glScalef(this.stringSize / this.fontScale, this.stringSize / this.fontScale, this.stringSize / this.fontScale);
                } else {
                    gL2.glTranslatef(-1.5f, 0.0f, 0.0f);
                    gL2.glScalef(this.stringSize / this.fontScale, this.stringSize / this.fontScale, this.stringSize / this.fontScale);
                    gL2.glTranslated(-d2, 0.0, 0.0);
                }
                d = Math.max(d, d2);
                gL2.glTranslatef(0.0f, -50.0f, 0.0f);
                for (c = '\u0000'; c < string2.length(); ++c) {
                    char c2 = string2.charAt(c);
                    this.glut.glutStrokeCharacter(this.font, c2);
                }
                gL2.glPopMatrix();
            } else if (i % (n2 + 1) == 0) {
                gL2.glBegin(1);
                if (bl) {
                    gL2.glVertex3f(0.0f, 0.0f, 0.0f);
                    gL2.glVertex3f(0.5f, 0.0f, 0.0f);
                } else {
                    gL2.glVertex3f(0.0f, 0.0f, 0.0f);
                    gL2.glVertex3f(-0.5f, 0.0f, 0.0f);
                }
                gL2.glEnd();
            }
            gL2.glTranslatef(0.0f, f, 0.0f);
            if (i != n3) continue;
            this.applyTextColor(visRenderer);
        }
        d = d * (double)0.003f + (double)(2400.0f / this.fontScale);
        gL2.glPushMatrix();
        if (bl) {
            gL2.glTranslated(d + 3.0, (double)(-f * (float)(list.size() + 1) / 2.0f), 0.0);
            gL2.glRotatef(90.0f, 0.0f, 0.0f, 1.0f);
            gL2.glScalef(this.labelSize / this.fontScale, this.labelSize / this.fontScale, this.labelSize / this.fontScale);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                float f2 = this.glut.glutStrokeLength(this.font, string2);
                gL2.glTranslatef(-f2 / 2.0f, 0.0f, 0.0f);
                for (int i = 0; i < string2.length(); ++i) {
                    c = string2.charAt(i);
                    this.glut.glutStrokeCharacter(this.font, c);
                }
                gL2.glTranslatef(-f2 / 2.0f, 0.0f, 0.0f);
                gL2.glTranslated(0.0, -250.0, 0.0);
            }
        } else {
            gL2.glTranslated(-(d + 3.0), (double)(-f * (float)(list.size() + 1) / 2.0f), 0.0);
            gL2.glRotatef(-90.0f, 0.0f, 0.0f, 1.0f);
            gL2.glScalef(this.labelSize / this.fontScale, this.labelSize / this.fontScale, this.labelSize / this.fontScale);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                float f3 = this.glut.glutStrokeLength(this.font, string2);
                gL2.glTranslatef(-f3 / 2.0f, 0.0f, 0.0f);
                for (int i = 0; i < string2.length(); ++i) {
                    c = string2.charAt(i);
                    this.glut.glutStrokeCharacter(this.font, c);
                }
                gL2.glTranslatef(-f3 / 2.0f, 0.0f, 0.0f);
                gL2.glTranslated(0.0, -250.0, 0.0);
            }
        }
        gL2.glPopMatrix();
    }

    public boolean getAutoSkip() {
        return this.autoSkip;
    }

    public void setAutoSkip(boolean bl) {
        this.autoSkip = bl;
    }

    public Color getMajorColor() {
        return this.majorColor;
    }

    public void setMajorColor(Color color) {
        this.majorColor = color;
        this.dirty = true;
    }

    public Color getMinorColor() {
        return this.minorColor;
    }

    public void setMinorColor(Color color) {
        this.minorColor = color;
        this.dirty = true;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
        this.dirty = true;
    }

    public float getFontScale() {
        return this.fontScale;
    }

    public void setFontScale(float f) {
        this.fontScale = f;
        this.dirty = true;
    }

    public void setLabelLength(int n) {
        this.labelLength = n;
        this.setStringLength();
        this.setLabelLength();
        this.dirty = true;
    }

    @Override
    public void resetCanvas() {
        this.dirty = true;
        this.displayList = 0;
    }

    public static class Orientation {
        private final String name;
        public static final Orientation NW = new Orientation("NW");
        public static final Orientation NE = new Orientation("NE");
        public static final Orientation SW = new Orientation("SW");
        public static final Orientation SE = new Orientation("SE");

        private Orientation(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }
}

