/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.common.MetaDataMap;
import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.perfdmf.CallPathUtilFuncs;
import edu.uoregon.tau.perfdmf.Context;
import edu.uoregon.tau.perfdmf.DataSourceException;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Group;
import edu.uoregon.tau.perfdmf.MetaDataParser;
import edu.uoregon.tau.perfdmf.MetaDataParserJSON;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Node;
import edu.uoregon.tau.perfdmf.Snapshot;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class DataSource {
    public static final SimpleDateFormat dateTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    public static final int PPK = 0;
    public static final int TAUPROFILE = 1;
    public static final int SNAP = 2;
    public static final int DYNAPROF = 3;
    public static final int MPIP = 4;
    public static final int HPM = 5;
    public static final int GPROF = 6;
    public static final int PSRUN = 7;
    public static final int PPROF = 8;
    public static final int CUBE = 9;
    public static final int HPCTOOLKIT = 10;
    public static final int OMPP = 11;
    public static final int PERIXML = 12;
    public static final int GPTL = 13;
    public static final int PARAVER = 14;
    public static final int IPM = 15;
    public static final int GOOGLE = 16;
    public static final int CUBE3 = 17;
    public static final int DARSHAN = 18;
    public static final int GYRO = 100;
    public static final int GAMESS = 101;
    public static final String FILE_TYPE_INDEX = "File Type Index";
    public static final String FILE_TYPE_NAME = "File Type Name";
    public static String[] formatTypeStrings = new String[]{"ParaProf Packed Profile", "TAU profiles", "TAU Snapshot", "Dynaprof", "MpiP", "HPMToolkit", "Gprof", "PSRun", "Tau pprof.dat", "Cube", "HPCToolkit", "ompP", "PERI-XML", "General Purpose Timing Library (GPTL)", "Paraver", "IPM", "Google PerfTools", "Cube 3 (Old parser)", "Darshan"};
    protected static boolean meanIncludeNulls = true;
    private boolean userEventsPresent = false;
    private boolean callPathDataPresent = false;
    private boolean groupNamesPresent = false;
    private boolean phasesPresent = false;
    private Function topLevelPhase;
    protected List<Metric> metrics = null;
    protected Thread meanData = null;
    protected Thread totalData = null;
    protected Thread stddevData = null;
    protected Thread meanDataAll = null;
    protected Thread stddevDataAll = null;
    protected Thread meanDataNoNull = null;
    protected Thread stddevDataNoNull = null;
    protected Thread minData = null;
    protected Thread maxData = null;
    private Map<Integer, Node> nodes = new TreeMap<Integer, Node>();
    private Map<String, Function> functions = new TreeMap<String, Function>();
    private Map<String, Group> groups = new TreeMap<String, Group>();
    private Map<String, UserEvent> userEvents = new TreeMap<String, UserEvent>();
    private List<Thread> allThreads;
    private boolean generateIntermediateCallPathData;
    private boolean reverseDataAvailable;
    private int[] maxNCT = null;
    protected volatile boolean reloading;
    protected MetaDataMap metaData = new MetaDataMap();
    protected MetaDataMap uncommonMetaData = new MetaDataMap();
    private File metadataFile;
    private StringBuffer metadataString = new StringBuffer();
    private boolean wellBehavedSnapshots;
    private long avgStartTime;
    protected boolean monitored;
    protected boolean hasThreads = true;
    protected boolean hasContexts = true;
    protected boolean hasMPI = false;
    private int fileType = 1;
    protected boolean derivedProvided = false;
    protected boolean derivedAtomicProvided = false;
    private int threadsPerConext = -1;
    private int conextsPerNode = -1;
    private Set<Integer> selectRanks = null;
    private List<Thread> aggThreads = null;
    private boolean generateTAUdbStatistics;
    public static final int EXEC_TYPE_SINGLE = 0;
    public static final int EXEC_TYPE_MPI = 1;
    public static final int EXEC_TYPE_THREADED = 2;
    public static final int EXEC_TYPE_HYBRID = 3;
    public static final int EXEC_TYPE_OTHER = 4;

    public abstract void load() throws FileNotFoundException, IOException, DataSourceException, SQLException;

    public abstract int getProgress();

    public abstract void cancelLoad();

    public void setSelectedRank(Set<Integer> set) {
        this.selectRanks = set;
    }

    public Set<Integer> getSelectedRanks() {
        return this.selectRanks;
    }

    public boolean isDerivedProvided() {
        return this.derivedProvided;
    }

    public void setDerivedProvided(boolean bl) {
        this.derivedProvided = bl;
    }

    public int getFileType() {
        return this.fileType;
    }

    public void setFileType(int n) {
        this.fileType = n;
    }

    public List<File> getFiles() {
        return new ArrayList<File>();
    }

    public boolean isReloading() {
        return this.reloading;
    }

    public boolean reloadData() throws Exception {
        if (this.reloading) {
            return false;
        }
        this.reloading = true;
        this.cleanData();
        this.load();
        this.reloading = false;
        return true;
    }

    protected void cleanData() {
        for (Thread thread : this.getAllThreads()) {
            Iterator<FunctionProfile> iterator = thread.getFunctionProfileIterator();
            while (iterator.hasNext()) {
                FunctionProfile functionProfile = iterator.next();
                if (functionProfile == null) continue;
                for (int i = 0; i < this.getNumberOfMetrics(); ++i) {
                    functionProfile.setExclusive(i, 0.0);
                    functionProfile.setInclusive(i, 0.0);
                }
                functionProfile.setNumSubr(0.0);
                functionProfile.setNumCalls(0.0);
            }
        }
    }

    public void setMonitored(boolean bl) {
        this.monitored = bl;
    }

    public Thread getMeanData() {
        return this.meanData;
    }

    public Thread getMeanDataAll() {
        return this.meanDataAll;
    }

    public Thread getMeanDataNoNull() {
        return this.meanDataNoNull;
    }

    public Thread getStdDevData() {
        return this.stddevData;
    }

    public Thread getStdDevDataAll() {
        return this.stddevDataAll;
    }

    public Thread getStdDevDataNoNull() {
        return this.stddevDataNoNull;
    }

    public Thread getTotalData() {
        return this.totalData;
    }

    public Thread getMaxData() {
        return this.maxData;
    }

    public Thread getMinData() {
        return this.minData;
    }

    private void setCallPathDataPresent(boolean bl) {
        this.callPathDataPresent = bl;
    }

    public boolean getCallPathDataPresent() {
        return this.callPathDataPresent;
    }

    protected void setGroupNamesPresent(boolean bl) {
        this.groupNamesPresent = bl;
    }

    public boolean getGroupNamesPresent() {
        return this.groupNamesPresent;
    }

    protected void setUserEventsPresent(boolean bl) {
        this.userEventsPresent = bl;
    }

    public boolean getUserEventsPresent() {
        return this.userEventsPresent;
    }

    public Function addFunction(String string) {
        return this.addFunction(string, this.getNumberOfMetrics());
    }

    public Function addFunction(String string, int n) {
        Function function = this.functions.get(string = string.trim());
        if (function != null) {
            return function;
        }
        function = new Function(string, this.functions.size(), n);
        this.functions.put(string, function);
        return function;
    }

    public Function getFunction(String string) {
        Function function = this.functions.get(string.trim());
        if (function != null) {
            return function;
        }
        return this.functions.get(string.trim() + " [THROTTLED]");
    }

    public int getNumFunctions() {
        return this.functions.size();
    }

    public List<Function> getFunctions() {
        return new ArrayList<Function>(this.functions.values());
    }

    public Iterator<Function> getFunctionIterator() {
        return this.functions.values().iterator();
    }

    public Iterator<Function> getFunctionIteratorCopy() {
        HashSet<Function> hashSet = new HashSet<Function>(this.functions.values());
        return hashSet.iterator();
    }

    public UserEvent addUserEvent(String string) {
        String string2 = string.trim();
        UserEvent userEvent = this.userEvents.get(string2 = Utility.removeRuns((String)string2));
        if (userEvent != null) {
            return userEvent;
        }
        UserEvent userEvent2 = new UserEvent(string2, this.userEvents.size() + 1);
        this.userEvents.put(string2, userEvent2);
        this.setUserEventsPresent(true);
        return userEvent2;
    }

    public UserEvent getUserEvent(String string) {
        return this.userEvents.get(string);
    }

    public int getNumUserEvents() {
        return this.userEvents.size();
    }

    public List<UserEvent> getUserEvents() {
        return new ArrayList<UserEvent>(this.userEvents.values());
    }

    public Iterator<UserEvent> getUserEventIterator() {
        return this.userEvents.values().iterator();
    }

    public Group getGroup(String string) {
        return this.groups.get(string);
    }

    public Group addGroup(String string) {
        Group group;
        if ((string = string.trim()) == "TAU_MPI") {
            this.hasMPI = true;
        }
        if ((group = this.groups.get(string)) != null) {
            return group;
        }
        Group group2 = new Group(string, this.groups.size() + 1);
        this.groups.put(string, group2);
        return group2;
    }

    protected void addGroups(String string, Function function) {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2 == null) continue;
            Group group = this.addGroup(string2.trim());
            function.addGroup(group);
        }
        this.setGroupNamesPresent(true);
    }

    public int getNumGroups() {
        return this.groups.size();
    }

    public Iterator<Group> getGroups() {
        return this.groups.values().iterator();
    }

    public int[] getMaxNCTNumbers() {
        if (this.maxNCT == null) {
            this.maxNCT = new int[3];
            Iterator<Node> iterator = this.getNodes();
            while (iterator.hasNext()) {
                Node node = iterator.next();
                this.maxNCT[0] = Math.max(this.maxNCT[0], node.getNodeID());
                Iterator<Context> iterator2 = node.getContexts();
                while (iterator2.hasNext()) {
                    Context context = iterator2.next();
                    this.maxNCT[1] = Math.max(this.maxNCT[1], context.getContextID());
                    Iterator<Thread> iterator3 = context.getThreads();
                    while (iterator3.hasNext()) {
                        Thread thread = iterator3.next();
                        this.maxNCT[2] = Math.max(this.maxNCT[2], thread.getThreadID());
                    }
                }
            }
        }
        return this.maxNCT;
    }

    public int getMaxThreadsPerContext() {
        if (this.threadsPerConext < 0) {
            this.threadsPerConext = 0;
            Iterator<Node> iterator = this.getNodes();
            while (iterator.hasNext()) {
                Node node = iterator.next();
                Iterator<Context> iterator2 = node.getContexts();
                while (iterator2.hasNext()) {
                    Context context = iterator2.next();
                    int n = context.getNumberOfThreads();
                    this.threadsPerConext = this.threadsPerConext < n ? n : this.threadsPerConext;
                }
            }
        }
        return this.threadsPerConext;
    }

    public int getMaxContextPerNode() {
        if (this.conextsPerNode < 0) {
            this.conextsPerNode = 0;
            Iterator<Node> iterator = this.getNodes();
            while (iterator.hasNext()) {
                Node node = iterator.next();
                int n = node.getNumberOfContexts();
                this.conextsPerNode = this.conextsPerNode < n ? n : this.conextsPerNode;
            }
        }
        return this.conextsPerNode;
    }

    public int getMaxNode() {
        return this.nodes.size();
    }

    public int getNumThreads() {
        int n = 0;
        Iterator<Node> iterator = this.getNodes();
        while (iterator.hasNext()) {
            Node node = iterator.next();
            Iterator<Context> iterator2 = node.getContexts();
            while (iterator2.hasNext()) {
                Context context = iterator2.next();
                Iterator<Thread> iterator3 = context.getThreads();
                while (iterator3.hasNext()) {
                    iterator3.next();
                    ++n;
                }
            }
        }
        return n;
    }

    public void setMetrics(List<Metric> list) {
        this.metrics = list;
    }

    public void addMetric(Metric metric) {
        if (this.metrics == null) {
            this.metrics = new ArrayList<Metric>();
        } else {
            for (Thread thread : this.getAllThreads()) {
                thread.addMetric();
            }
            if (this.meanDataNoNull != null) {
                this.meanDataNoNull.addMetric();
            }
            if (this.totalData != null) {
                this.totalData.addMetric();
            }
            if (this.stddevDataNoNull != null) {
                this.stddevDataNoNull.addMetric();
            }
            if (this.minData != null) {
                this.minData.addMetric();
            }
            if (this.maxData != null) {
                this.maxData.addMetric();
            }
            if (this.meanDataAll != null) {
                this.meanDataAll.addMetric();
            }
            if (this.stddevDataAll != null) {
                this.stddevDataAll.addMetric();
            }
        }
        metric.setID(this.getNumberOfMetrics());
        this.metrics.add(metric);
    }

    public Metric addMetric(String string) {
        if (this.metrics != null) {
            for (Metric metric : this.metrics) {
                if (!metric.getName().equals(string)) continue;
                return metric;
            }
        }
        Metric metric = new Metric();
        metric.setName(string);
        this.addMetric(metric);
        return metric;
    }

    public Metric addMetricNoCheck(String string) {
        Metric metric = new Metric();
        metric.setName(string);
        this.addMetric(metric);
        return metric;
    }

    public Metric addMetric(String string, Thread thread) {
        Metric metric = null;
        if (this.metrics == null) {
            this.metrics = new ArrayList<Metric>();
        } else {
            for (Metric metric2 : this.metrics) {
                if (!metric2.getName().equals(string)) continue;
                metric = metric2;
                break;
            }
        }
        if (metric == null) {
            metric = new Metric();
            metric.setName(string);
            metric.setID(this.getNumberOfMetrics());
            this.metrics.add(metric);
        }
        if (thread.getNumMetrics() < this.getNumberOfMetrics()) {
            thread.addMetric();
        }
        return metric;
    }

    public List<Metric> getMetrics() {
        return this.metrics;
    }

    public void clearMetrics() {
        this.metrics = null;
    }

    public Metric getMetric(String string) {
        for (Metric metric : this.metrics) {
            if (!metric.getName().equals(string)) continue;
            return metric;
        }
        return null;
    }

    public Metric getMetric(int n) {
        if (this.metrics != null && n < this.metrics.size()) {
            return this.metrics.get(n);
        }
        return null;
    }

    public String getMetricName(int n) {
        if (this.metrics != null && n < this.metrics.size()) {
            return this.metrics.get(n).getName();
        }
        return null;
    }

    public int getNumberOfMetrics() {
        if (this.metrics != null) {
            return this.metrics.size();
        }
        return 0;
    }

    private void generateBonusCallPathData() {
        Comparable<Function> comparable;
        if (!this.getCallPathDataPresent()) {
            return;
        }
        ArrayList<Function> arrayList = new ArrayList<Function>();
        Iterator<Function> iterator = this.getFunctionIterator();
        while (iterator.hasNext()) {
            comparable = iterator.next();
            arrayList.add((Function)comparable);
        }
        this.initAllThreadsList();
        int n = this.allThreads.size();
        comparable = this.addGroup("TAU_CALLPATH_DERIVED");
        this.reverseDataAvailable = true;
        for (Function function : arrayList) {
            if (!function.isCallPathFunction() || !CallPathUtilFuncs.containsDoublePath(function.getName())) continue;
            String string = function.getName();
            string = string.substring(string.indexOf("=>") + 2);
            while (string.indexOf("=>") != -1) {
                Function function2 = this.getFunction(string);
                if (function2 == null) {
                    function2 = this.addFunction(string);
                    Iterator<Group> iterator2 = function.getGroups().iterator();
                    while (iterator2.hasNext()) {
                        function2.addGroup(iterator2.next());
                    }
                }
                function2.addGroup((Group)comparable);
                string = string.substring(string.indexOf("=>") + 2);
                for (int i = 0; i < n; ++i) {
                    Thread thread = this.allThreads.get(i);
                    FunctionProfile functionProfile = thread.getFunctionProfile(function);
                    if (functionProfile == null) continue;
                    FunctionProfile functionProfile2 = thread.getFunctionProfile(function2);
                    if (functionProfile2 == null) {
                        functionProfile2 = new FunctionProfile(function2, this.getNumberOfMetrics(), thread.getNumSnapshots());
                        thread.addFunctionProfile(functionProfile2);
                    }
                    for (int j = 0; j < this.getNumberOfMetrics(); ++j) {
                        functionProfile2.setExclusive(j, functionProfile2.getExclusive(j) + functionProfile.getExclusive(j));
                        functionProfile2.setInclusive(j, functionProfile2.getInclusive(j) + functionProfile.getInclusive(j));
                    }
                    functionProfile2.setNumCalls(functionProfile2.getNumCalls() + functionProfile.getNumCalls());
                    functionProfile2.setNumSubr(functionProfile2.getNumSubr() + functionProfile.getNumSubr());
                }
            }
        }
    }

    private String sampleNameSummary(String string) {
        String string2 = null;
        int n = -1;
        if ((string.contains("[SAMPLE]") || string.contains("[disabled UNWIND]")) && !string.contains("UNRESOLVED")) {
            n = string.lastIndexOf("} {");
            if (n == -1) {
                return null;
            }
            string2 = string.substring(0, n);
            string2 = string2 + "}]";
            StringBuilder stringBuilder = new StringBuilder(string2);
            int n2 = string2.lastIndexOf("[SAMPLE]");
            if (n2 == -1) {
                n2 = string2.lastIndexOf("[UNWIND]");
            }
            if (n2 == -1) {
                return null;
            }
            stringBuilder.replace(n2, n2 + 8, "[SUMMARY]");
            string2 = stringBuilder.toString();
        } else if ((string.contains("[SAMPLE]") || string.contains("[disabled UNWIND]")) && string.contains("UNRESOLVED") && string.contains("ADDR")) {
            n = string.lastIndexOf(" ADDR ");
            if (n == -1) {
                return null;
            }
            string2 = string.substring(0, n);
            StringBuilder stringBuilder = new StringBuilder(string2);
            int n3 = string2.lastIndexOf("[SAMPLE]");
            if (n3 == -1) {
                n3 = string2.lastIndexOf("[UNWIND]");
            }
            if (n3 == -1) {
                return null;
            }
            stringBuilder.replace(n3, n3 + 8, "[SUMMARY]");
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private void generateAggregateSampleData() {
        Object object;
        int n;
        Object object2;
        Object object3;
        Object object4;
        Comparable<Function> comparable;
        if (!this.getCallPathDataPresent()) {
            return;
        }
        ArrayList<Function> arrayList = new ArrayList<Function>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        Iterator<Function> iterator = this.getFunctionIterator();
        while (iterator.hasNext()) {
            void comparable2;
            comparable = iterator.next();
            object4 = null;
            object4 = this.sampleNameSummary(comparable.getName());
            if (object4 == null) continue;
            arrayList.add((Function)comparable);
            Iterator iterator2 = this.getFunction((String)object4);
            if (iterator2 != null) {
                return;
            }
            Integer n2 = 0;
            if (hashMap.containsKey(object4)) {
                Integer n3 = (Integer)hashMap.get(object4);
            }
            hashMap.put(object4, comparable2.intValue() + 1);
        }
        this.initAllThreadsList();
        int n2 = this.allThreads.size();
        comparable = this.addGroup("TAU_CALLPATH_DERIVED");
        object4 = this.addGroup("TAU_DERIVED");
        for (Function function : arrayList) {
            int n4;
            object3 = null;
            object2 = null;
            object3 = this.sampleNameSummary(function.getName());
            if (object3 == null || (Integer)hashMap.get(object3) < 3) continue;
            object2 = this.getFunction((String)object3);
            if (object2 == null) {
                object2 = this.addFunction((String)object3);
                Iterator<Group> iterator2 = function.getGroups().iterator();
                while (iterator2.hasNext()) {
                    ((Function)object2).addGroup(iterator2.next());
                }
            }
            arrayList2.add(object2);
            ((Function)object2).addGroup((Group)object4);
            n = 0;
            if (this.derivedProvided) {
                n = -7;
            }
            for (n4 = n; n4 < n2; ++n4) {
                int n5;
                object = null;
                if (n4 < 0) {
                    if (n4 == -1) {
                        object = this.meanDataNoNull;
                    } else if (n4 == -2) {
                        object = this.totalData;
                    } else if (n4 == -3) {
                        object = this.stddevDataNoNull;
                    } else if (n4 == -4) {
                        object = this.minData;
                    } else if (n4 == -5) {
                        object = this.maxData;
                    } else if (n4 == -6) {
                        object = this.meanDataAll;
                    } else {
                        if (n4 != -7) continue;
                        object = this.stddevDataAll;
                    }
                } else {
                    object = this.allThreads.get(n4);
                }
                FunctionProfile functionProfile = ((Thread)object).getFunctionProfile(function);
                if (functionProfile == null) continue;
                FunctionProfile functionProfile2 = ((Thread)object).getFunctionProfile((Function)object2);
                if (functionProfile2 == null) {
                    functionProfile2 = new FunctionProfile((Function)object2, this.getNumberOfMetrics(), ((Thread)object).getNumSnapshots());
                    ((Thread)object).addFunctionProfile(functionProfile2);
                    if (object.equals(this.minData)) {
                        for (n5 = 0; n5 < this.getNumberOfMetrics(); ++n5) {
                            functionProfile2.setExclusive(n5, Double.MAX_VALUE);
                            functionProfile2.setInclusive(n5, Double.MAX_VALUE);
                        }
                    }
                }
                for (n5 = 0; n5 < this.getNumberOfMetrics(); ++n5) {
                    if (object.equals(this.minData) || object.equals(this.maxData)) continue;
                    functionProfile2.setExclusive(n5, functionProfile2.getExclusive(n5) + functionProfile.getExclusive(n5));
                    functionProfile2.setInclusive(n5, functionProfile2.getInclusive(n5) + functionProfile.getInclusive(n5));
                }
                functionProfile2.setNumCalls(functionProfile2.getNumCalls() + functionProfile.getNumCalls());
                functionProfile2.setNumSubr(functionProfile2.getNumSubr() + functionProfile.getNumSubr());
            }
            n4 = function.getName().lastIndexOf(" => ");
            if (n4 == -1) continue;
            ((Function)object2).addGroup((Group)comparable);
            object = (String)object3 + function.getName().substring(n4);
            function.setName((String)object);
        }
        for (Function function : arrayList2) {
            if (function == null || this.maxData == null || this.minData == null) continue;
            object3 = this.maxData.getFunctionProfile(function);
            object2 = this.minData.getFunctionProfile(function);
            for (n = 0; n < n2; ++n) {
                Thread thread = this.allThreads.get(n);
                object = thread.getFunctionProfile(function);
                if (object == null || object3 == null) continue;
                for (int i = 0; i < this.getNumberOfMetrics(); ++i) {
                    ((FunctionProfile)object3).setExclusive(i, Math.max(((FunctionProfile)object3).getExclusive(i), ((FunctionProfile)object).getExclusive(i)));
                    ((FunctionProfile)object3).setInclusive(i, Math.max(((FunctionProfile)object3).getInclusive(i), ((FunctionProfile)object).getInclusive(i)));
                    ((FunctionProfile)object2).setExclusive(i, Math.min(((FunctionProfile)object2).getExclusive(i), ((FunctionProfile)object).getExclusive(i)));
                    ((FunctionProfile)object2).setInclusive(i, Math.min(((FunctionProfile)object2).getInclusive(i), ((FunctionProfile)object).getInclusive(i)));
                }
            }
        }
    }

    protected void addDerivedSnapshots(Thread thread, Thread thread2) {
        if (this.wellBehavedSnapshots) {
            thread2.setStartTime(this.avgStartTime);
            for (Snapshot snapshot : thread.getSnapshots()) {
                Snapshot snapshot2 = thread2.addSnapshot(snapshot.getName());
                snapshot2.setTimestamp(snapshot.getTimestamp());
            }
        }
    }

    public void generateDerivedData() {
        this.allThreads = null;
        if (CallPathUtilFuncs.checkCallPathsPresent(this.getFunctionIterator())) {
            this.setCallPathDataPresent(true);
        }
        if (this.generateIntermediateCallPathData) {
            this.generateBonusCallPathData();
        }
        this.generateAggregateSampleData();
        this.checkForPhases();
        List<Thread> list = this.getAllThreads();
        int n = 1;
        if (list != null && !list.isEmpty()) {
            Thread thread = list.get(0);
            n = thread.getNumSnapshots();
        }
        long l = 0L;
        for (Thread thread : list) {
            String string;
            thread.setThreadDataAllMetrics();
            int n2 = thread.getNumSnapshots();
            if (n2 != n) {
                n = -1;
            }
            if ((string = thread.getMetaData().get("Starting Timestamp")) == null) continue;
            l += Long.parseLong(string);
        }
        if (n > 1) {
            this.wellBehavedSnapshots = true;
            this.avgStartTime = (long)((double)l / (double)list.size());
        }
        try {
            this.generateStatistics(0, this.getNumberOfMetrics() - 1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.meanDataNoNull != null) {
            this.meanDataNoNull.setThreadDataAllMetrics();
        }
        if (this.totalData != null) {
            this.totalData.setThreadDataAllMetrics();
        }
        if (this.stddevDataNoNull != null) {
            this.stddevDataNoNull.setThreadDataAllMetrics();
        }
        if (this.maxData != null) {
            this.maxData.setThreadDataAllMetrics();
        }
        if (this.minData != null) {
            this.minData.setThreadDataAllMetrics();
        }
        if (this.meanDataAll != null) {
            this.meanDataAll.setThreadDataAllMetrics();
        }
        if (this.stddevDataAll != null) {
            this.stddevDataAll.setThreadDataAllMetrics();
        }
        this.generateAtomicEventStatistics();
        this.finishPhaseAnalysis();
        this.getMetaData().put(FILE_TYPE_INDEX, Integer.toString(this.fileType));
        this.getMetaData().put(FILE_TYPE_NAME, formatTypeStrings[this.fileType]);
    }

    private double computeStdDev(double d, double d2, int n) {
        double d3 = 0.0;
        if (n > 1) {
            d3 = Math.sqrt(Math.abs(d / (double)n - d2 * d2));
        }
        return d3;
    }

    private void generateAtomicEventStatistics() {
        if (this.derivedAtomicProvided) {
            return;
        }
        this.initAllThreadsList();
        int n = this.allThreads.size();
        int n2 = this.meanData.getNumSnapshots();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < n2; ++i) {
            UserEventProfile userEventProfile;
            UserEventProfile userEventProfile2;
            Object object;
            UserEventProfile userEventProfile3;
            Object object2;
            Comparable<Thread> comparable;
            for (int j = 0; j < n; ++j) {
                comparable = this.allThreads.get(j);
                object2 = ((Thread)comparable).getUserEventProfiles();
                while (object2.hasNext()) {
                    Integer n3;
                    UserEventProfile userEventProfile4;
                    UserEventProfile userEventProfile5;
                    UserEventProfile userEventProfile6;
                    userEventProfile3 = object2.next();
                    object = userEventProfile3.getUserEvent();
                    userEventProfile2 = this.meanDataNoNull.getUserEventProfile((UserEvent)object);
                    if (userEventProfile2 == null) {
                        userEventProfile2 = new UserEventProfile((UserEvent)object, n2);
                        this.meanDataNoNull.addUserEventProfile(userEventProfile2);
                    }
                    if ((userEventProfile = this.meanDataAll.getUserEventProfile((UserEvent)object)) == null) {
                        userEventProfile = new UserEventProfile((UserEvent)object, n2);
                        this.meanDataAll.addUserEventProfile(userEventProfile);
                    }
                    if ((userEventProfile6 = this.totalData.getUserEventProfile((UserEvent)object)) == null) {
                        userEventProfile6 = new UserEventProfile((UserEvent)object, n2);
                        this.totalData.addUserEventProfile(userEventProfile6);
                    }
                    if ((userEventProfile5 = this.stddevDataNoNull.getUserEventProfile((UserEvent)object)) == null) {
                        userEventProfile5 = new UserEventProfile((UserEvent)object, n2);
                        this.stddevDataNoNull.addUserEventProfile(userEventProfile5);
                    }
                    if ((userEventProfile4 = this.stddevDataAll.getUserEventProfile((UserEvent)object)) == null) {
                        userEventProfile4 = new UserEventProfile((UserEvent)object, n2);
                        this.stddevDataAll.addUserEventProfile(userEventProfile4);
                    }
                    if ((n3 = (Integer)hashMap.get(((UserEvent)object).getID())) == null) {
                        n3 = new Integer(1);
                    }
                    Integer n4 = n3;
                    Integer n5 = n3 = Integer.valueOf(n3 + 1);
                    hashMap.put(((UserEvent)object).getID(), n4);
                    userEventProfile6.setNumSamples(userEventProfile6.getNumSamples() + userEventProfile3.getNumSamples(i), i);
                    userEventProfile6.setMaxValue(userEventProfile6.getMaxValue() + userEventProfile3.getMaxValue(i), i);
                    userEventProfile6.setMinValue(userEventProfile6.getMinValue() + userEventProfile3.getMinValue(i), i);
                    userEventProfile6.setMeanValue(userEventProfile6.getMeanValue() + userEventProfile3.getMeanValue(i), i);
                    userEventProfile6.setStdDev(userEventProfile6.getStdDev() + userEventProfile3.getStdDev(i), i);
                    userEventProfile5.setNumSamples(userEventProfile5.getNumSamples() + userEventProfile3.getNumSamples(i) * userEventProfile3.getNumSamples(i), i);
                    userEventProfile5.setMaxValue(userEventProfile5.getMaxValue() + userEventProfile3.getMaxValue(i) * userEventProfile3.getMaxValue(i), i);
                    userEventProfile5.setMinValue(userEventProfile5.getMinValue() + userEventProfile3.getMinValue(i) * userEventProfile3.getMinValue(i), i);
                    userEventProfile5.setMeanValue(userEventProfile5.getMeanValue() + userEventProfile3.getMeanValue(i) * userEventProfile3.getMeanValue(i), i);
                    userEventProfile5.setStdDev(userEventProfile5.getStdDev() + userEventProfile3.getStdDev(i) * userEventProfile3.getStdDev(i), i);
                    userEventProfile4.setNumSamples(userEventProfile4.getNumSamples() + userEventProfile3.getNumSamples(i) * userEventProfile3.getNumSamples(i), i);
                    userEventProfile4.setMaxValue(userEventProfile4.getMaxValue() + userEventProfile3.getMaxValue(i) * userEventProfile3.getMaxValue(i), i);
                    userEventProfile4.setMinValue(userEventProfile4.getMinValue() + userEventProfile3.getMinValue(i) * userEventProfile3.getMinValue(i), i);
                    userEventProfile4.setMeanValue(userEventProfile4.getMeanValue() + userEventProfile3.getMeanValue(i) * userEventProfile3.getMeanValue(i), i);
                    userEventProfile4.setStdDev(userEventProfile4.getStdDev() + userEventProfile3.getStdDev(i) * userEventProfile3.getStdDev(i), i);
                }
            }
            Iterator<UserEvent> iterator = this.getUserEventIterator();
            while (iterator.hasNext()) {
                comparable = iterator.next();
                object2 = this.meanDataNoNull.getUserEventProfile((UserEvent)comparable);
                if (object2 == null) continue;
                userEventProfile3 = this.totalData.getUserEventProfile((UserEvent)comparable);
                object = this.stddevDataNoNull.getUserEventProfile((UserEvent)comparable);
                userEventProfile2 = this.meanDataAll.getUserEventProfile((UserEvent)comparable);
                userEventProfile = this.stddevDataAll.getUserEventProfile((UserEvent)comparable);
                int n6 = (Integer)hashMap.get(((UserEvent)comparable).getID());
                ((UserEventProfile)object2).setNumSamples(userEventProfile3.getNumSamples() / (double)n6, i);
                ((UserEventProfile)object2).setMaxValue(userEventProfile3.getMaxValue(i) / (double)n6, i);
                ((UserEventProfile)object2).setMinValue(userEventProfile3.getMinValue(i) / (double)n6, i);
                ((UserEventProfile)object2).setMeanValue(userEventProfile3.getMeanValue(i) / (double)n6, i);
                ((UserEventProfile)object2).setStdDev(userEventProfile3.getStdDev(i) / (double)n6, i);
                userEventProfile2.setNumSamples(userEventProfile3.getNumSamples() / (double)n, i);
                userEventProfile2.setMaxValue(userEventProfile3.getMaxValue(i) / (double)n, i);
                userEventProfile2.setMinValue(userEventProfile3.getMinValue(i) / (double)n, i);
                userEventProfile2.setMeanValue(userEventProfile3.getMeanValue(i) / (double)n, i);
                userEventProfile2.setStdDev(userEventProfile3.getStdDev(i) / (double)n, i);
                ((UserEventProfile)object).setNumSamples(this.computeStdDev(((UserEventProfile)object).getNumSamples(i), ((UserEventProfile)object2).getNumSamples(i), n6), i);
                ((UserEventProfile)object).setMaxValue(this.computeStdDev(((UserEventProfile)object).getMaxValue(i), ((UserEventProfile)object2).getMaxValue(i), n6), i);
                ((UserEventProfile)object).setMinValue(this.computeStdDev(((UserEventProfile)object).getMinValue(i), ((UserEventProfile)object2).getMinValue(i), n6), i);
                ((UserEventProfile)object).setMeanValue(this.computeStdDev(((UserEventProfile)object).getMeanValue(i), ((UserEventProfile)object2).getMeanValue(i), n6), i);
                ((UserEventProfile)object).setStdDev(this.computeStdDev(((UserEventProfile)object).getStdDev(i), ((UserEventProfile)object2).getStdDev(i), n6), i);
                userEventProfile.setNumSamples(this.computeStdDev(userEventProfile.getNumSamples(i), userEventProfile2.getNumSamples(i), n), i);
                userEventProfile.setMaxValue(this.computeStdDev(userEventProfile.getMaxValue(i), userEventProfile2.getMaxValue(i), n), i);
                userEventProfile.setMinValue(this.computeStdDev(userEventProfile.getMinValue(i), userEventProfile2.getMinValue(i), n), i);
                userEventProfile.setMeanValue(this.computeStdDev(userEventProfile.getMeanValue(i), userEventProfile2.getMeanValue(i), n), i);
                userEventProfile.setStdDev(this.computeStdDev(userEventProfile.getStdDev(i), userEventProfile2.getStdDev(i), n), i);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void generateStatistics(int n, int n2) {
        int n3 = this.getNumberOfMetrics();
        Thread thread = null;
        List<Thread> list = this.getAllThreads();
        if (list != null && !list.isEmpty()) {
            thread = list.get(0);
        }
        if (this.meanDataNoNull == null) {
            this.meanDataNoNull = new Thread(-1, -1, -1, n3, this);
            this.addDerivedSnapshots(thread, this.meanDataNoNull);
        }
        if (this.totalData == null) {
            this.totalData = new Thread(-2, -2, -2, n3, this);
            this.addDerivedSnapshots(thread, this.totalData);
        }
        if (this.stddevDataNoNull == null) {
            this.stddevDataNoNull = new Thread(-3, -3, -3, n3, this);
            this.addDerivedSnapshots(thread, this.stddevDataNoNull);
        }
        if (this.minData == null) {
            this.minData = new Thread(-4, -4, -4, n3, this);
            this.addDerivedSnapshots(thread, this.minData);
        }
        if (this.maxData == null) {
            this.maxData = new Thread(-5, -5, -5, n3, this);
            this.addDerivedSnapshots(thread, this.maxData);
        }
        if (this.meanDataAll == null) {
            this.meanDataAll = new Thread(-6, -6, -6, n3, this);
            this.addDerivedSnapshots(thread, this.meanDataAll);
        }
        if (this.stddevDataAll == null) {
            this.stddevDataAll = new Thread(-7, -7, -7, n3, this);
            this.addDerivedSnapshots(thread, this.stddevDataAll);
        }
        if (meanIncludeNulls) {
            this.meanData = this.meanDataAll;
            this.stddevData = this.stddevDataAll;
        } else {
            this.meanData = this.meanDataNoNull;
            this.stddevData = this.stddevDataNoNull;
        }
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n3];
        double[] dArray4 = new double[n3];
        double[] dArray5 = new double[n3];
        double[] dArray6 = new double[n3];
        double[] dArray7 = new double[n3];
        double[] dArray8 = new double[n3];
        this.initAllThreadsList();
        for (int i = 0; i < this.meanData.getNumSnapshots(); ++i) {
            FunctionProfile functionProfile;
            Object object2;
            Object object3;
            for (int j = n; j <= n2; ++j) {
                object3 = new double[n3];
                if (this.derivedProvided) {
                    object3[j] = 0.0;
                    object2 = this.getFunctionIterator();
                    while (object2.hasNext()) {
                        Function function = (Function)object2.next();
                        functionProfile = this.totalData.getFunctionProfile(function);
                        if (functionProfile == null) continue;
                        object3[j] = Math.max((double)object3[j], functionProfile.getInclusive(j));
                    }
                } else {
                    for (Thread thread2 : list) {
                        if (this.wellBehavedSnapshots) {
                            Object object = object3;
                            int n4 = j;
                            object[n4] = object[n4] + thread2.getMaxInclusive(j, i);
                            continue;
                        }
                        Object object = object3;
                        int n5 = j;
                        object[n5] = object[n5] + thread2.getMaxInclusive(j, thread2.getNumSnapshots() - 1);
                    }
                }
                if (this.totalData != null) {
                    this.totalData.setPercentDivider(j, i, (double)(object3[j] / 100.0));
                }
                if (this.meanDataNoNull != null) {
                    this.meanDataNoNull.setPercentDivider(j, i, (double)(object3[j] / 100.0));
                }
                if (this.stddevDataNoNull != null) {
                    this.stddevDataNoNull.setPercentDivider(j, i, (double)(object3[j] / 100.0));
                }
                if (this.minData != null) {
                    this.minData.setPercentDivider(j, i, (double)(object3[j] / 100.0));
                }
                if (this.maxData != null) {
                    this.maxData.setPercentDivider(j, i, (double)(object3[j] / 100.0));
                }
                if (this.meanDataAll != null) {
                    this.meanDataAll.setPercentDivider(j, i, (double)(object3[j] / 100.0));
                }
                if (this.stddevDataAll == null) continue;
                this.stddevDataAll.setPercentDivider(j, i, (double)(object3[j] / 100.0));
            }
            Iterator<Function> iterator = this.getFunctionIterator();
            while (iterator.hasNext()) {
                int n6;
                int n7;
                void var18_25;
                object3 = iterator.next();
                object2 = this.meanDataNoNull.getFunctionProfile((Function)object3);
                if (object2 == null) {
                    object2 = new FunctionProfile((Function)object3, n3, this.meanDataNoNull.getNumSnapshots());
                    this.meanDataNoNull.addFunctionProfile((FunctionProfile)object2);
                }
                ((Function)object3).setMeanProfile((FunctionProfile)object2);
                FunctionProfile functionProfile2 = this.totalData.getFunctionProfile((Function)object3);
                if (functionProfile2 == null) {
                    FunctionProfile functionProfile3 = new FunctionProfile((Function)object3, n3, this.meanDataNoNull.getNumSnapshots());
                    this.totalData.addFunctionProfile(functionProfile3);
                }
                ((Function)object3).setTotalProfile((FunctionProfile)var18_25);
                functionProfile = this.stddevDataNoNull.getFunctionProfile((Function)object3);
                if (functionProfile == null) {
                    functionProfile = new FunctionProfile((Function)object3, n3, this.meanDataNoNull.getNumSnapshots());
                    this.stddevDataNoNull.addFunctionProfile(functionProfile);
                }
                ((Function)object3).setStddevProfile(functionProfile);
                FunctionProfile functionProfile4 = null;
                FunctionProfile functionProfile5 = null;
                FunctionProfile functionProfile6 = null;
                FunctionProfile functionProfile7 = null;
                if (this.minData != null) {
                    functionProfile4 = this.minData.getFunctionProfile((Function)object3);
                    if (functionProfile4 == null) {
                        functionProfile4 = new FunctionProfile((Function)object3, n3, this.meanDataNoNull.getNumSnapshots());
                        this.minData.addFunctionProfile(functionProfile4);
                    }
                    ((Function)object3).setMinProfile(functionProfile4);
                }
                if (this.maxData != null) {
                    functionProfile5 = this.maxData.getFunctionProfile((Function)object3);
                    if (functionProfile5 == null) {
                        functionProfile5 = new FunctionProfile((Function)object3, n3, this.meanDataNoNull.getNumSnapshots());
                        this.maxData.addFunctionProfile(functionProfile5);
                    }
                    ((Function)object3).setMaxProfile(functionProfile5);
                }
                if (this.stddevDataAll != null) {
                    functionProfile7 = this.stddevDataAll.getFunctionProfile((Function)object3);
                    if (functionProfile7 == null) {
                        functionProfile7 = new FunctionProfile((Function)object3, n3, this.meanDataNoNull.getNumSnapshots());
                        this.stddevDataAll.addFunctionProfile(functionProfile7);
                    }
                    ((Function)object3).setStddevAllProfile(functionProfile7);
                }
                if (this.meanDataAll != null) {
                    functionProfile6 = this.meanDataAll.getFunctionProfile((Function)object3);
                    if (functionProfile6 == null) {
                        functionProfile6 = new FunctionProfile((Function)object3, n3, this.meanDataNoNull.getNumSnapshots());
                        this.meanDataAll.addFunctionProfile(functionProfile6);
                    }
                    ((Function)object3).setMeanAllProfile(functionProfile6);
                }
                if (this.derivedProvided && !this.generateTAUdbStatistics) continue;
                int n8 = 0;
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = Double.MAX_VALUE;
                double d6 = Double.MAX_VALUE;
                double d7 = 0.0;
                double d8 = 0.0;
                for (n7 = 0; n7 < n3; ++n7) {
                    dArray[n7] = 0.0;
                    dArray2[n7] = 0.0;
                    dArray3[n7] = 0.0;
                    dArray4[n7] = 0.0;
                    dArray5[n7] = Double.MAX_VALUE;
                    dArray6[n7] = Double.MAX_VALUE;
                    dArray7[n7] = 0.0;
                    dArray8[n7] = 0.0;
                }
                n7 = list.size();
                for (n6 = 0; n6 < n7; ++n6) {
                    int n9;
                    Thread thread3 = list.get(n6);
                    FunctionProfile functionProfile8 = thread3.getFunctionProfile((Function)object3);
                    int n10 = i;
                    if (!this.wellBehavedSnapshots) {
                        n10 = thread3.getNumSnapshots() - 1;
                    }
                    if (functionProfile8 != null) {
                        ++n8;
                        for (n9 = n; n9 <= n2; ++n9) {
                            int n11 = n9;
                            dArray[n11] = dArray[n11] + functionProfile8.getExclusive(n10, n9);
                            int n12 = n9;
                            dArray2[n12] = dArray2[n12] + functionProfile8.getInclusive(n10, n9);
                            int n13 = n9;
                            dArray3[n13] = dArray3[n13] + functionProfile8.getExclusive(n10, n9) * functionProfile8.getExclusive(n10, n9);
                            int n14 = n9;
                            dArray4[n14] = dArray4[n14] + functionProfile8.getInclusive(n10, n9) * functionProfile8.getInclusive(n10, n9);
                            dArray5[n9] = functionProfile8.getExclusive(n10, n9) < dArray5[n9] ? functionProfile8.getExclusive(n10, n9) : dArray5[n9];
                            dArray6[n9] = functionProfile8.getInclusive(n10, n9) < dArray6[n9] ? functionProfile8.getInclusive(n10, n9) : dArray6[n9];
                            dArray7[n9] = functionProfile8.getExclusive(n10, n9) > dArray7[n9] ? functionProfile8.getExclusive(n10, n9) : dArray7[n9];
                            double d9 = dArray8[n9] = functionProfile8.getInclusive(n10, n9) > dArray8[n9] ? functionProfile8.getInclusive(n10, n9) : dArray8[n9];
                            if (n9 != 0) continue;
                            d += functionProfile8.getNumCalls(n10);
                            d2 += functionProfile8.getNumSubr(n10);
                            d3 += functionProfile8.getNumCalls(n10) * functionProfile8.getNumCalls(n10);
                            d4 += functionProfile8.getNumSubr(n10) * functionProfile8.getNumSubr(n10);
                            d5 = functionProfile8.getNumCalls(n10) < d5 ? functionProfile8.getNumCalls(n10) : d5;
                            d6 = functionProfile8.getNumSubr(n10) < d6 ? functionProfile8.getNumSubr(n10) : d6;
                            d7 = functionProfile8.getNumCalls(n10) > d7 ? functionProfile8.getNumCalls(n10) : d7;
                            d8 = functionProfile8.getNumSubr(n10) > d8 ? functionProfile8.getNumSubr(n10) : d8;
                        }
                        continue;
                    }
                    if (n6 != n7 - 1) continue;
                    for (n9 = n; n9 <= n2; ++n9) {
                        if (dArray5[n9] == Double.MAX_VALUE) {
                            dArray5[n9] = 0.0;
                        }
                        if (dArray6[n9] == Double.MAX_VALUE) {
                            dArray6[n9] = 0.0;
                        }
                        if (n9 != 0) continue;
                        if (d5 == Double.MAX_VALUE) {
                            d5 = 0.0;
                        }
                        if (d6 != Double.MAX_VALUE) continue;
                        d6 = 0.0;
                    }
                }
                n6 = n8;
                double d10 = 0.0;
                if (n7 != 0) {
                    d10 = 1.0 / (double)n7;
                }
                double d11 = 0.0;
                if (n8 != 0) {
                    d11 = 1.0 / (double)n8;
                }
                if (n == 0) {
                    var18_25.setNumCalls(i, d);
                    var18_25.setNumSubr(i, d2);
                    ((FunctionProfile)object2).setNumCalls(i, d * d11);
                    functionProfile6.setNumCalls(i, d * d10);
                    ((FunctionProfile)object2).setNumSubr(i, d2 * d11);
                    functionProfile6.setNumSubr(i, d2 * d10);
                    double d12 = 0.0;
                    if (n6 > 1) {
                        d12 = Math.sqrt(Math.abs(d3 * d11 - ((FunctionProfile)object2).getNumCalls(i) * ((FunctionProfile)object2).getNumCalls(i)));
                        functionProfile.setNumCalls(i, d12);
                        d12 = Math.sqrt(Math.abs(d4 * d11 - ((FunctionProfile)object2).getNumSubr(i) * ((FunctionProfile)object2).getNumSubr(i)));
                        functionProfile.setNumSubr(i, d12);
                    } else {
                        functionProfile.setNumCalls(i, 0.0);
                        functionProfile.setNumSubr(i, 0.0);
                    }
                    functionProfile6.setNumCalls(i, d * d10);
                    functionProfile6.setNumSubr(i, d2 * d10);
                    d12 = Math.sqrt(Math.abs(d3 * d10 - functionProfile6.getNumCalls(i) * functionProfile6.getNumCalls(i)));
                    functionProfile7.setNumCalls(i, d12);
                    d12 = Math.sqrt(Math.abs(d4 * d10 - functionProfile6.getNumSubr(i) * functionProfile6.getNumSubr(i)));
                    functionProfile7.setNumSubr(i, d12);
                    functionProfile4.setNumCalls(i, d5);
                    functionProfile5.setNumCalls(i, d7);
                    functionProfile4.setNumSubr(i, d6);
                    functionProfile5.setNumSubr(i, d8);
                }
                for (int j = n; j <= n2; ++j) {
                    var18_25.setExclusive(i, j, dArray[j]);
                    var18_25.setInclusive(i, j, dArray2[j]);
                    ((FunctionProfile)object2).setExclusive(i, j, dArray[j] * d11);
                    ((FunctionProfile)object2).setInclusive(i, j, dArray2[j] * d11);
                    double d13 = 0.0;
                    if (n6 > 1) {
                        d13 = Math.sqrt(Math.abs(dArray3[j] * d11 - ((FunctionProfile)object2).getExclusive(i, j) * ((FunctionProfile)object2).getExclusive(i, j)));
                        functionProfile.setExclusive(i, j, d13);
                        d13 = Math.sqrt(Math.abs(dArray4[j] * d11 - ((FunctionProfile)object2).getInclusive(i, j) * ((FunctionProfile)object2).getInclusive(i, j)));
                        functionProfile.setInclusive(i, j, d13);
                    } else {
                        functionProfile.setExclusive(i, j, 0.0);
                        functionProfile.setInclusive(i, j, 0.0);
                    }
                    functionProfile6.setExclusive(i, j, dArray[j] * d10);
                    functionProfile6.setInclusive(i, j, dArray2[j] * d10);
                    d13 = Math.sqrt(Math.abs(dArray3[j] * d10 - functionProfile6.getExclusive(i, j) * functionProfile6.getExclusive(i, j)));
                    functionProfile7.setExclusive(i, j, d13);
                    d13 = Math.sqrt(Math.abs(dArray4[j] * d10 - functionProfile6.getInclusive(i, j) * functionProfile6.getInclusive(i, j)));
                    functionProfile7.setInclusive(i, j, d13);
                    functionProfile4.setExclusive(i, j, dArray5[j]);
                    functionProfile4.setInclusive(i, j, dArray6[j]);
                    functionProfile5.setExclusive(i, j, dArray7[j]);
                    functionProfile5.setInclusive(i, j, dArray8[j]);
                }
            }
        }
        int[] nArray = this.getMaxNCTNumbers();
        this.hasContexts = nArray[1] > 0;
        this.hasThreads = nArray[2] > 0;
    }

    public Node addNode(int n) {
        Node node = this.nodes.get(new Integer(n));
        if (node != null) {
            return node;
        }
        Node node2 = new Node(n, this);
        this.nodes.put(new Integer(n), node2);
        return node2;
    }

    public Thread addThread(int n, int n2, int n3) {
        Node node = this.addNode(n);
        Context context = node.addContext(n2);
        Thread thread = context.addThread(n3, this.getNumberOfMetrics());
        this.allThreads = null;
        return thread;
    }

    public Node getNode(int n) {
        return this.nodes.get(new Integer(n));
    }

    public int getNumberOfNodes() {
        return this.nodes.size();
    }

    public Iterator<Node> getNodes() {
        return this.nodes.values().iterator();
    }

    public Map<Integer, Node> getNodeMap() {
        return this.nodes;
    }

    public int getTotalNumberOfContexts() {
        int n = -1;
        Iterator<Node> iterator = this.getNodes();
        while (iterator.hasNext()) {
            Node node = iterator.next();
            n += node.getNumberOfContexts();
        }
        return n;
    }

    public int getNumberOfContexts(int n) {
        return this.getNode(n).getNumberOfContexts();
    }

    public Iterator<Context> getContexts(int n) {
        Node node = this.getNode(n);
        if (node != null) {
            return node.getContexts();
        }
        return null;
    }

    public Context getContext(int n, int n2) {
        Node node = this.getNode(n);
        if (node != null) {
            return node.getContext(n2);
        }
        return null;
    }

    public int getTotalNumberOfThreads() {
        int n = 0;
        Iterator<Node> iterator = this.getNodes();
        while (iterator.hasNext()) {
            Node node = iterator.next();
            Iterator<Context> iterator2 = node.getContexts();
            while (iterator2.hasNext()) {
                Context context = iterator2.next();
                n += context.getNumberOfThreads();
            }
        }
        return n;
    }

    public int getNumberOfThreads(int n, int n2) {
        return this.getContext(n, n2).getNumberOfThreads();
    }

    public List<Thread> getThreads() {
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        Iterator<Node> iterator = this.getNodes();
        while (iterator.hasNext()) {
            Node node = iterator.next();
            Iterator<Context> iterator2 = node.getContexts();
            while (iterator2.hasNext()) {
                Context context = iterator2.next();
                Iterator<Thread> iterator3 = context.getThreads();
                while (iterator3.hasNext()) {
                    Thread thread = iterator3.next();
                    arrayList.add(thread);
                }
            }
        }
        return arrayList;
    }

    public Thread getThread(int n, int n2, int n3) {
        if (n == -1) {
            return this.getMeanData();
        }
        if (n == -3) {
            return this.getStdDevData();
        }
        Context context = this.getContext(n, n2);
        Thread thread = null;
        if (context != null) {
            thread = context.getThread(n3);
        }
        return thread;
    }

    private void initAllThreadsList() {
        this.allThreads = new ArrayList<Thread>();
        Iterator<Node> iterator = this.getNodes();
        while (iterator.hasNext()) {
            Node node = iterator.next();
            Iterator<Context> iterator2 = node.getContexts();
            while (iterator2.hasNext()) {
                Context context = iterator2.next();
                Iterator<Thread> iterator3 = context.getThreads();
                while (iterator3.hasNext()) {
                    Thread thread = iterator3.next();
                    this.allThreads.add(thread);
                }
            }
        }
    }

    private void initAggThreadsList() {
        this.aggThreads = new ArrayList<Thread>();
        this.aggThreads.add(this.meanDataNoNull);
        this.aggThreads.add(this.stddevDataNoNull);
        this.aggThreads.add(this.totalData);
        if (this.maxData != null) {
            this.aggThreads.add(this.maxData);
        }
        if (this.minData != null) {
            this.aggThreads.add(this.minData);
        }
        if (this.meanDataAll != null) {
            this.aggThreads.add(this.meanDataAll);
        }
        if (this.stddevDataAll != null) {
            this.aggThreads.add(this.stddevDataAll);
        }
    }

    public List<Thread> getAggThreads() {
        if (this.aggThreads == null) {
            this.initAggThreadsList();
        }
        return this.aggThreads;
    }

    public List<Thread> getAllThreads() {
        if (this.allThreads == null) {
            this.initAllThreadsList();
        }
        return this.allThreads;
    }

    public static void setMeanIncludeNulls(boolean bl) {
        meanIncludeNulls = bl;
    }

    protected void checkForPhases() {
        Group group = this.getGroup("TAU_PHASE");
        if (group != null) {
            Function function;
            this.phasesPresent = true;
            Iterator<Function> iterator = this.getFunctionIterator();
            while (iterator.hasNext()) {
                function = iterator.next();
                if (!function.isGroupMember(group)) continue;
                function.setPhase(true);
                function.setActualPhase(function);
            }
            iterator = this.getFunctionIterator();
            while (iterator.hasNext()) {
                function = iterator.next();
                int n = function.getName().indexOf("=>");
                if (n <= 0) continue;
                String string = UtilFncs.getLeftSide(function.getName());
                String string2 = UtilFncs.getRightSide(function.getName());
                Function function2 = this.getFunction(string2);
                if (function2 != null && function2.isPhase()) {
                    function.setPhase(true);
                    function.setActualPhase(function2);
                }
                function.setParentPhase(this.getFunction(string));
            }
        }
    }

    protected void finishPhaseAnalysis() {
        if (this.phasesPresent) {
            Group group = this.getGroup("TAU_PHASE");
            ArrayList<Function> arrayList = new ArrayList<Function>();
            Iterator<Function> iterator = this.getFunctionIterator();
            while (iterator.hasNext()) {
                Function function = iterator.next();
                if (!function.isGroupMember(group)) continue;
                arrayList.add(function);
            }
            if (arrayList.size() == 0) {
                throw new RuntimeException("Error: TAU_PHASE found, but no phases!");
            }
            this.topLevelPhase = (Function)arrayList.get(0);
            for (Function function : arrayList) {
                if (!(function.getMeanInclusive(0) > this.topLevelPhase.getMeanInclusive(0))) continue;
                this.topLevelPhase = function;
            }
        }
    }

    public boolean getPhasesPresent() {
        return this.phasesPresent;
    }

    public Function getTopLevelPhase() {
        return this.topLevelPhase;
    }

    public boolean getGenerateIntermediateCallPathData() {
        return this.generateIntermediateCallPathData;
    }

    public void setGenerateIntermediateCallPathData(boolean bl) {
        this.generateIntermediateCallPathData = bl;
    }

    public boolean getReverseDataAvailable() {
        return this.reverseDataAvailable;
    }

    public MetaDataMap getMetaData() {
        return this.metaData;
    }

    public void setMetaData(MetaDataMap metaDataMap) {
        this.metaData = metaDataMap;
    }

    public void buildXMLMetaData() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            Object object;
            org.w3c.dom.Node node;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("tau:metadata");
            element.setAttribute("xmlns:tau", "http://www.cs.uoregon.edu/research/tau");
            document.appendChild(element);
            Element element2 = null;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<Boolean> arrayList2 = new ArrayList<Boolean>();
            if (this.metaData.size() > 0) {
                element2 = document.createElement("tau:CommonProfileAttributes");
                element.appendChild(element2);
                object6 = this.metaData.keySet().iterator();
                while (object6.hasNext()) {
                    object5 = ((MetaDataMap.MetaDataKey)object6.next()).name;
                    object4 = this.metaData.get((String)object5);
                    Element element3 = document.createElement("tau:attribute");
                    element2.appendChild(element3);
                    object3 = document.createElement("tau:name");
                    element3.appendChild((org.w3c.dom.Node)object3);
                    object3.appendChild(document.createTextNode((String)object5));
                    object2 = document.createElement("tau:value");
                    element3.appendChild((org.w3c.dom.Node)object2);
                    object2.appendChild(document.createTextNode((String)object4));
                }
            }
            object6 = this.getAllThreads().iterator();
            while (object6.hasNext()) {
                object5 = object6.next();
                object4 = document.createElement("tau:ProfileAttributes");
                object4.setAttribute("node", Integer.toString(((Thread)object5).getNodeID()));
                object4.setAttribute("context", Integer.toString(((Thread)object5).getContextID()));
                object4.setAttribute("thread", Integer.toString(((Thread)object5).getThreadID()));
                boolean bl = false;
                object3 = ((Thread)object5).getMetaData().keySet().iterator();
                while (object3.hasNext()) {
                    object2 = ((MetaDataMap.MetaDataKey)object3.next()).name;
                    String string = ((Thread)object5).getMetaData().get((String)object2);
                    if (this.metaData.containsKey((String)object2)) continue;
                    node = document.createElement("tau:attribute");
                    object4.appendChild(node);
                    object = document.createElement("tau:name");
                    node.appendChild((org.w3c.dom.Node)object);
                    object.appendChild(document.createTextNode((String)object2));
                    Element element4 = document.createElement("tau:value");
                    node.appendChild(element4);
                    element4.appendChild(document.createTextNode(string));
                    bl = true;
                }
                arrayList.add(object4);
                if (bl) {
                    element.appendChild((org.w3c.dom.Node)object4);
                    arrayList2.add(new Boolean(true));
                    continue;
                }
                arrayList2.add(new Boolean(false));
            }
            if (this.metadataFile != null && !MetaDataParserJSON.isJSON((String)(object6 = DataSource.readFileAsString(this.metadataFile)))) {
                MetaDataParser.parse(this.getMetaData(), (String)object6, null);
                object5 = documentBuilder.parse(this.metadataFile);
                object4 = object5.getDocumentElement();
                org.w3c.dom.Node node2 = document.importNode((org.w3c.dom.Node)object4, true);
                if (element2 != null && node2.getNodeType() == 1 && node2.getNodeName().equals("tau:metadata")) {
                    object3 = node2.getChildNodes();
                    int n = 0;
                    for (int i = 0; i < object3.getLength(); ++i) {
                        node = object3.item(i);
                        if (node.getNodeType() == 1 && node.getNodeName().equals("tau:CommonProfileAttributes")) {
                            object = node.getChildNodes();
                            for (int j = 0; j < object.getLength(); ++j) {
                                org.w3c.dom.Node node3 = object.item(j);
                                if (node3.getNodeType() != 1 || !node3.getNodeName().equals("tau:attribute")) continue;
                                element2.appendChild(node3);
                            }
                            continue;
                        }
                        if (node.getNodeType() != 1 || !node.getNodeName().equals("tau:ProfileAttributes")) continue;
                        object = (Element)arrayList.get(n);
                        if (((Boolean)arrayList2.get(n)).booleanValue()) {
                            NodeList nodeList = node.getChildNodes();
                            for (int j = 0; j < nodeList.getLength(); ++j) {
                                org.w3c.dom.Node node4 = nodeList.item(j);
                                if (node4.getNodeType() != 1 || !node4.getNodeName().equals("tau:attribute")) continue;
                                object.appendChild(node4);
                            }
                        } else {
                            element.appendChild(node);
                        }
                        ++n;
                    }
                } else {
                    element.appendChild(node2);
                }
            }
            document.getDocumentElement().normalize();
            object6 = TransformerFactory.newInstance();
            object5 = ((TransformerFactory)object6).newTransformer();
            object4 = new DOMSource(document);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            object3 = new StreamResult(byteArrayOutputStream);
            ((Transformer)object5).transform((Source)object4, (Result)object3);
            if (element.hasChildNodes()) {
                this.metadataString.append(byteArrayOutputStream.toString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String readFileAsString(File file) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(1000);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        char[] cArray = new char[1024];
        int n = 0;
        while ((n = bufferedReader.read(cArray)) != -1) {
            String string = String.valueOf(cArray, 0, n);
            stringBuffer.append(string);
            cArray = new char[1024];
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }

    public void aggregateMetaData() {
        if (this.getAllThreads() == null || this.getAllThreads().isEmpty()) {
            return;
        }
        Thread thread = this.getAllThreads().get(0);
        if (thread == null) {
            return;
        }
        for (MetaDataMap.MetaDataKey object : thread.getMetaData().keySet()) {
            MetaDataMap.MetaDataValue metaDataValue = thread.getMetaData().get(object);
            this.metaData.put(object, metaDataValue);
        }
        for (Thread thread2 : this.getAllThreads()) {
            for (MetaDataMap.MetaDataKey metaDataKey : thread2.getMetaData().keySet()) {
                MetaDataMap.MetaDataValue metaDataValue = thread2.getMetaData().get(metaDataKey);
                MetaDataMap.MetaDataValue metaDataValue2 = this.metaData.get(metaDataKey);
                if (metaDataValue2 != null && metaDataValue.equals((Object)metaDataValue2) && metaDataKey.timer_context == null) continue;
                this.metaData.remove(metaDataKey);
                this.uncommonMetaData.put(metaDataKey, metaDataValue);
            }
        }
        for (Thread thread3 : this.getAllThreads()) {
            for (MetaDataMap.MetaDataKey metaDataKey : this.metaData.keySet()) {
                thread3.getMetaData().remove(metaDataKey);
            }
        }
    }

    public void setMetadataFile(String string) throws IOException {
        this.metadataFile = new File(string);
        if (!this.metadataFile.exists()) {
            throw new FileNotFoundException("The file " + string + " does not exist.");
        }
        if (!this.metadataFile.canRead()) {
            throw new IOException("The file " + string + " does not have read permission.");
        }
        if (!this.metadataFile.isFile()) {
            throw new FileNotFoundException(string + " is not a valid file.");
        }
    }

    public String getMetadataString() {
        return this.metadataString.toString();
    }

    public boolean getWellBehavedSnapshots() {
        return this.wellBehavedSnapshots;
    }

    public MetaDataMap getUncommonMetaData() {
        return this.uncommonMetaData;
    }

    public boolean getHasThreads() {
        return this.hasThreads;
    }

    public boolean getHasContexts() {
        return this.hasContexts;
    }

    public int getExecutionType() {
        if (this.getAllThreads().size() == 1) {
            if (this.hasMPI) {
                return 1;
            }
            return 0;
        }
        if (!this.getHasContexts() && !this.getHasThreads()) {
            return 1;
        }
        if (!this.getHasContexts()) {
            return 3;
        }
        return 4;
    }

    private static void renameInternalFunction(Function function, String string, String string2) {
        String string3 = function.getName();
        CharSequence[] charSequenceArray = string3.split("=>");
        for (int i = 0; i < charSequenceArray.length; ++i) {
            charSequenceArray[i] = ((String)charSequenceArray[i]).trim();
            if (!((String)charSequenceArray[i]).equals(string)) continue;
            charSequenceArray[i] = string2;
        }
        function.setName(Utility.join((CharSequence)" => ", (CharSequence[])charSequenceArray));
    }

    public void renameFunction(Function function, String string) {
        string = string.trim();
        Group group = this.getGroup("TAU_CALLPATH");
        for (String string2 : this.functions.keySet()) {
            Function function2 = this.functions.get(string2);
            if (!function2.isGroupMember(group)) continue;
            DataSource.renameInternalFunction(function2, function.getName(), string);
        }
        function.setName(string);
    }

    public File getMetadataFile() {
        return this.metadataFile;
    }

    public void setGenerateTAUdbStatistics(boolean bl) {
        this.generateTAUdbStatistics = bl;
    }

    public void reduceTrial(double d, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Function function = this.addFunction("other");
        function.addGroup(this.getGroup("TAU_USER"));
        for (int i = 0; i < this.meanData.getNumSnapshots(); ++i) {
            for (Thread thread : this.getAllThreads()) {
                ReductionStats reductionStats = this.reduceTrialThread(d, n, function, i, thread);
                n2 += reductionStats.reducedTimers;
                n3 += reductionStats.totalTimers;
                n4 += reductionStats.remainingTimers;
            }
        }
        System.out.println("Removed " + n2 + " of " + n3 + " timers from all threads, leaving " + n4);
        if (meanIncludeNulls) {
            function.setMeanAllProfile(this.meanDataAll.getFunctionProfile(function));
            function.setStddevAllProfile(this.stddevDataAll.getFunctionProfile(function));
        } else {
            function.setMeanProfile(this.meanDataNoNull.getFunctionProfile(function));
            function.setStddevProfile(this.stddevDataNoNull.getFunctionProfile(function));
        }
        function.setTotalProfile(this.totalData.getFunctionProfile(function));
        function.setMinProfile(this.minData.getFunctionProfile(function));
        function.setMaxProfile(this.maxData.getFunctionProfile(function));
    }

    private ReductionStats reduceTrialThread(double d, int n, Function function, int n2, Thread thread) {
        double d2 = 0.0;
        d2 = this.wellBehavedSnapshots ? thread.getMaxInclusive(n, n2) : thread.getMaxInclusive(n, thread.getNumSnapshots() - 1);
        double d3 = d2 * (d / 100.0);
        FunctionProfile functionProfile = thread.getFunctionProfile(function);
        if (functionProfile == null) {
            functionProfile = new FunctionProfile(function, this.getNumberOfMetrics(), thread.getNumSnapshots());
            thread.addFunctionProfile(functionProfile);
        }
        int n3 = 0;
        int n4 = 0;
        for (FunctionProfile functionProfile2 : thread.getFunctionProfiles()) {
            if (functionProfile2 == null || functionProfile2.getFunction() == function) continue;
            ++n3;
            if (!(functionProfile2.getInclusive(n) < d3)) continue;
            ++n4;
            functionProfile.setNumCalls(functionProfile.getNumCalls() + functionProfile2.getNumCalls());
            functionProfile.setNumSubr(functionProfile.getNumSubr() + functionProfile2.getNumSubr());
            for (int i = 0; i <= this.getNumberOfMetrics(); ++i) {
                functionProfile.setExclusive(n2, i, functionProfile.getInclusive(n2, i) + functionProfile2.getExclusive(n2, i));
                functionProfile.setInclusive(n2, i, functionProfile.getExclusive(n2, i));
            }
            thread.deleteFunctionProfile(functionProfile2);
        }
        ReductionStats reductionStats = new ReductionStats(n3, n4);
        return reductionStats;
    }

    public void reduceTrial(double d) {
        int n = 0;
        for (Metric metric : this.getMetrics()) {
            if (metric.isTimeMetric()) {
                System.out.println("Using metric: " + metric.getName());
                this.reduceTrial(d, n);
                return;
            }
            ++n;
        }
        this.reduceTrial(d, 0);
    }

    public void reduceTrial() {
        this.reduceTrial(1.0);
    }

    class ReductionStats {
        public int totalTimers = 0;
        public int reducedTimers = 0;
        public int remainingTimers = 0;

        public ReductionStats(int n, int n2) {
            this.totalTimers = n;
            this.reducedTimers = n2;
            this.remainingTimers = n - n2;
        }
    }
}

