/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.Context;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Group;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Node;
import edu.uoregon.tau.perfdmf.Thread;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class GyroDataSource
extends DataSource {
    private List<File[]> initializeObject;
    private int metric = 0;
    private Function function = null;
    private FunctionProfile functionProfile = null;
    private Node node = null;
    private Context context = null;
    private Thread thread = null;
    private int nodeID = -1;
    private int contextID = -1;
    private int threadID = -1;
    private String inputString = null;
    private List<File[]> v = null;
    private File[] files = null;
    private BufferedReader br = null;
    private Hashtable<String, Integer> methodIndexes = null;
    private Vector<String> methodNames = null;
    private double[] wallTime = null;
    private String eventName = null;
    private double runningTotal = 0.0;
    private double runningTotal2 = 0.0;
    private int phaseCounter = 0;
    private Hashtable<String, double[]> phaseValues = null;
    private int numThreads = 1;

    public GyroDataSource(List<File[]> list) {
        this.setMetrics(new Vector<Metric>());
        this.initializeObject = list;
    }

    @Override
    public void cancelLoad() {
    }

    @Override
    public int getProgress() {
        return 0;
    }

    @Override
    public void load() throws FileNotFoundException, IOException {
        this.v = this.initializeObject;
        System.out.println(this.v.size() + " files");
        for (int i = 0; i < this.v.size(); ++i) {
            this.files = this.v.get(i);
            for (int j = 0; j < this.files.length; ++j) {
                System.out.println("Processing data file, please wait ......");
                long l = System.currentTimeMillis();
                this.methodIndexes = new Hashtable();
                this.methodNames = new Vector();
                this.wallTime = new double[20];
                this.phaseValues = new Hashtable();
                this.parseThreadsFromFilename(this.files[j].getName());
                FileInputStream fileInputStream = new FileInputStream(this.files[j]);
                InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
                this.br = new BufferedReader(inputStreamReader);
                ++this.nodeID;
                boolean bl = false;
                while ((this.inputString = this.br.readLine()) != null) {
                    if (this.inputString.trim().length() == 0) continue;
                    if (this.inputString.trim().toUpperCase().startsWith("NL")) {
                        this.processHeader(this.inputString);
                        continue;
                    }
                    if (this.inputString.trim().startsWith("---------") || this.inputString.trim().startsWith("0.000E+00 0.000E+00")) continue;
                    if (bl) {
                        this.processTimers(this.inputString);
                    }
                    bl = !bl;
                }
                this.br.close();
                this.saveMappings();
                l = System.currentTimeMillis() - l;
                System.out.println("Done processing data file!");
                System.out.println("Time to process file (in milliseconds): " + l);
            }
        }
        this.generateDerivedData();
    }

    private void initializeThread() {
        this.function = this.addFunction(this.eventName, 1);
        this.nodeID = this.nodeID == -1 ? 0 : this.nodeID;
        this.contextID = this.contextID == -1 ? 0 : this.contextID;
        this.threadID = this.threadID == -1 ? 0 : this.threadID;
        this.node = this.getNode(this.nodeID);
        if (this.node == null) {
            this.node = this.addNode(this.nodeID);
        }
        this.context = this.node.getContext(this.contextID);
        if (this.context == null) {
            this.context = this.node.addContext(this.contextID);
        }
        this.thread = this.context.getThread(this.threadID);
        if (this.thread == null) {
            this.thread = this.context.addThread(this.threadID);
        }
        this.functionProfile = this.thread.getFunctionProfile(this.function);
        if (this.functionProfile == null) {
            this.functionProfile = new FunctionProfile(this.function);
            this.thread.addFunctionProfile(this.functionProfile);
        }
    }

    private void parseThreadsFromFilename(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            String string2 = new String();
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                try {
                    this.numThreads = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (Exception exception) {
            System.out.println("An error occurred while parsing the header!");
            exception.printStackTrace();
        }
    }

    private void processHeader(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            String string2 = new String();
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                this.methodIndexes.put(string2, new Integer(n));
                this.methodNames.add(string2);
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("An error occurred while parsing the header!");
            exception.printStackTrace();
        }
    }

    private void processTimers(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            String string2 = new String();
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                double d = 0.0;
                String string3 = "Iteration " + this.phaseCounter;
                try {
                    double d2 = Double.parseDouble(string2);
                    if (n == 10) {
                        this.wallTime[n] = d2;
                    } else {
                        int n2 = n;
                        this.wallTime[n2] = this.wallTime[n2] + d2;
                    }
                    double[] dArray = new double[2];
                    if (n < 8) {
                        this.runningTotal += d2;
                        d += d2;
                        dArray[0] = d2;
                        dArray[1] = d2;
                        String string4 = this.methodNames.elementAt(n);
                        this.phaseValues.put(new String(string3 + " => " + string4), dArray);
                    }
                    if (n == 8) {
                        this.runningTotal2 += d2;
                        dArray[0] = d2;
                        double d3 = d2 - d;
                        dArray[1] = d3 < 0.0 ? 0.0 : d3;
                        this.phaseValues.put(new String("RUNTIME => " + string3), dArray);
                        this.phaseValues.put(string3, dArray);
                        ++this.phaseCounter;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("An error occurred while parsing the header!");
            exception.printStackTrace();
        }
    }

    private void saveMappings() {
        try {
            Enumeration<String> enumeration = this.methodIndexes.keys();
            while (enumeration.hasMoreElements()) {
                this.eventName = enumeration.nextElement();
                if (this.saveMappingsInner(false)) continue;
            }
            enumeration = this.phaseValues.keys();
            while (enumeration.hasMoreElements()) {
                this.eventName = enumeration.nextElement();
                if (this.saveMappingsInner(true)) continue;
            }
        }
        catch (Exception exception) {
            System.out.println("An error occurred while parsing the callsite data!");
            exception.printStackTrace();
        }
    }

    private boolean saveMappingsInner(boolean bl) throws Exception {
        Integer n = null;
        if (!bl) {
            n = this.methodIndexes.get(this.eventName);
        }
        boolean bl2 = true;
        if (this.eventName.toUpperCase().equals("STEP")) {
            return false;
        }
        if (this.eventName.toUpperCase().equals("ELAPSED")) {
            return false;
        }
        if (this.eventName.toUpperCase().equals("RUNTIME")) {
            bl2 = false;
        }
        for (int i = 0; i < this.numThreads; ++i) {
            this.threadID = i;
            this.initializeThread();
            if (!bl) {
                if (bl2) {
                    this.saveMappingData("Time", this.wallTime[n], this.wallTime[n]);
                } else {
                    double d = this.wallTime[n] - this.runningTotal;
                    d = d < 0.0 ? 0.0 : d;
                    this.saveMappingData("Time", this.wallTime[n], d);
                }
            } else {
                double[] dArray = this.phaseValues.get(this.eventName);
                this.saveMappingData("Time", dArray[0], dArray[1]);
            }
            this.functionProfile.setNumCalls(1.0);
            if (!this.eventName.toUpperCase().equals("RUNTIME")) {
                this.functionProfile.setNumSubr(0.0);
            } else {
                this.functionProfile.setNumSubr(8.0);
                this.function.addGroup(this.addGroup("TAU_PHASE"));
            }
            if (bl) {
                if (this.eventName.indexOf("=>") == -1) {
                    this.function.addGroup(this.addGroup("TAU_PHASE"));
                    continue;
                }
                this.function.addGroup(this.addGroup("TAU_CALLPATH"));
                continue;
            }
            Group group = null;
            group = this.eventName.toUpperCase().endsWith("_TR") ? this.addGroup("TRANSPOSE") : this.addGroup("CALCULATION");
            this.function.addGroup(group);
        }
        return true;
    }

    private void saveMappingData(String string, double d, double d2) {
        this.metric = this.getNumberOfMetrics();
        Metric metric = this.addMetric(string);
        this.metric = metric.getID();
        this.functionProfile.setExclusive(this.metric, d2 * 1000000.0);
        this.functionProfile.setInclusive(this.metric, d * 1000000.0);
    }
}

