/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.database.DB;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;

public class IntervalLocationProfile {
    private int node;
    private int context;
    private int thread;
    private int eventID;
    private double[] doubleList;
    private double numCalls;
    private double numSubroutines;
    private static int fieldCount = 5;

    public IntervalLocationProfile() {
        this.doubleList = new double[fieldCount];
    }

    public IntervalLocationProfile(int n) {
        int n2 = n * fieldCount;
        this.doubleList = new double[n2];
    }

    public int getNode() {
        return this.node;
    }

    public int getContext() {
        return this.context;
    }

    public int getThread() {
        return this.thread;
    }

    public int getIntervalEventID() {
        return this.eventID;
    }

    public double getInclusivePercentage(int n) {
        return this.getDouble(n, 0);
    }

    public double getInclusivePercentage() {
        return this.getDouble(0, 0);
    }

    public double getInclusive(int n) {
        return this.getDouble(n, 1);
    }

    public double getInclusive() {
        return this.getDouble(0, 1);
    }

    public double getExclusivePercentage(int n) {
        return this.getDouble(n, 2);
    }

    public double getExclusivePercentage() {
        return this.getDouble(0, 2);
    }

    public double getExclusive(int n) {
        return this.getDouble(n, 3);
    }

    public double getExclusive() {
        return this.getDouble(0, 3);
    }

    public double getInclusivePerCall(int n) {
        return this.getDouble(n, 4);
    }

    public double getInclusivePerCall() {
        return this.getDouble(0, 4);
    }

    public double getNumCalls() {
        return this.numCalls;
    }

    public double getNumSubroutines() {
        return this.numSubroutines;
    }

    private void incrementStorage() {
        int n = this.doubleList.length;
        double[] dArray = new double[n + fieldCount];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.doubleList[i];
        }
        this.doubleList = dArray;
    }

    private void insertDouble(int n, int n2, double d) {
        int n3 = n * fieldCount + n2;
        if (n3 >= this.doubleList.length) {
            this.incrementStorage();
        }
        try {
            this.doubleList[n3] = d;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private double getDouble(int n, int n2) {
        int n3 = n * fieldCount + n2;
        try {
            return this.doubleList[n3];
        }
        catch (Exception exception) {
            return -1.0;
        }
    }

    public void setNode(int n) {
        this.node = n;
    }

    public void setContext(int n) {
        this.context = n;
    }

    public void setThread(int n) {
        this.thread = n;
    }

    public void setIntervalEventID(int n) {
        this.eventID = n;
    }

    public void setInclusivePercentage(int n, double d) {
        this.insertDouble(n, 0, d);
    }

    public void setInclusive(int n, double d) {
        this.insertDouble(n, 1, d);
    }

    public void setExclusivePercentage(int n, double d) {
        this.insertDouble(n, 2, d);
    }

    public void setExclusive(int n, double d) {
        this.insertDouble(n, 3, d);
    }

    public void setInclusivePerCall(int n, double d) {
        this.insertDouble(n, 4, d);
    }

    public void setNumCalls(double d) {
        this.numCalls = d;
    }

    public void setNumSubroutines(double d) {
        this.numSubroutines = d;
    }

    public void saveMeanSummary(DB dB, int n, Hashtable<Integer, Integer> hashtable, int n2) throws SQLException {
        int n3 = 0;
        Integer n4 = hashtable.get(new Integer(n3));
        while (n4 != null) {
            if (n2 < 0 || n3 == n2) {
                PreparedStatement preparedStatement = null;
                preparedStatement = dB.getDBType().compareTo("oracle") == 0 ? dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "interval_mean_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, excl, call, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)") : (dB.getDBType().compareTo("derby") == 0 ? dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "interval_mean_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, num_calls, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)") : (dB.getDBType().compareTo("mysql") == 0 ? dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "interval_mean_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, `call`, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)") : dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "interval_mean_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, call, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)")));
                preparedStatement.setInt(1, n);
                preparedStatement.setInt(2, n4);
                preparedStatement.setDouble(3, this.getInclusivePercentage(n3));
                preparedStatement.setDouble(4, this.getInclusive(n3));
                preparedStatement.setDouble(5, this.getExclusivePercentage(n3));
                preparedStatement.setDouble(6, this.getExclusive(n3));
                preparedStatement.setDouble(7, this.getNumCalls());
                preparedStatement.setDouble(8, this.getNumSubroutines());
                preparedStatement.setDouble(9, this.getInclusivePerCall(n3));
                preparedStatement.executeUpdate();
                preparedStatement.close();
            }
            n4 = hashtable.get(new Integer(++n3));
        }
    }

    public void saveTotalSummary(DB dB, int n, Hashtable<Integer, Integer> hashtable, int n2) throws SQLException {
        int n3 = 0;
        Integer n4 = hashtable.get(new Integer(n3));
        while (n4 != null) {
            if (n2 < 0 || n3 == n2) {
                PreparedStatement preparedStatement = null;
                preparedStatement = dB.getDBType().compareTo("oracle") == 0 ? dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "interval_total_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, excl, call, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)") : (dB.getDBType().compareTo("derby") == 0 ? dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "interval_total_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, num_calls, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)") : (dB.getDBType().compareTo("mysql") == 0 ? dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "interval_total_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, `call`, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)") : dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "interval_total_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, call, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)")));
                preparedStatement.setInt(1, n);
                preparedStatement.setInt(2, n4);
                preparedStatement.setDouble(3, this.getInclusivePercentage(n3));
                preparedStatement.setDouble(4, this.getInclusive(n3));
                preparedStatement.setDouble(5, this.getExclusivePercentage(n3));
                preparedStatement.setDouble(6, this.getExclusive(n3));
                preparedStatement.setDouble(7, this.getNumCalls());
                preparedStatement.setDouble(8, this.getNumSubroutines());
                preparedStatement.setDouble(9, this.getInclusivePerCall(n3));
                preparedStatement.executeUpdate();
                preparedStatement.close();
            }
            n4 = hashtable.get(new Integer(++n3));
        }
    }

    public static FunctionProfile getIntervalEventDetail(DB dB, Function function, String string) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        if (dB.getSchemaVersion() > 0) {
            stringBuffer.append("select tcd.timer_callpath, ");
            stringBuffer.append("tv.inclusive_percent, tv.inclusive_value, ");
            stringBuffer.append("tv.exclusive_percent, tv.exclusive_value, ");
            stringBuffer.append("tcd.calls, tcd.subroutines, ");
            stringBuffer.append("tv.metric from ");
            stringBuffer.append(dB.getSchemaPrefix() + "timer_value tv left outer join ");
            stringBuffer.append(dB.getSchemaPrefix() + "timer_call_data tcd on tv.timer_call_data = tcd.id ");
            stringBuffer.append("left outer join " + dB.getSchemaPrefix() + "thread h on tcd.thread = h.id ");
            stringBuffer.append(string);
            if (string.length() > 3) {
                stringBuffer.append(" and h.thread_index = -1 ");
            } else {
                stringBuffer.append(" where h.thread_index = -1 ");
            }
            stringBuffer.append(" order by tcd.timer_callpath, tv.metric");
        } else {
            stringBuffer.append("select ms.interval_event, ");
            stringBuffer.append("ms.inclusive_percentage, ms.inclusive, ");
            if (dB.getDBType().compareTo("oracle") == 0) {
                stringBuffer.append("ms.exclusive_percentage, ms.excl, ");
            } else {
                stringBuffer.append("ms.exclusive_percentage, ms.exclusive, ");
            }
            if (dB.getDBType().compareTo("derby") == 0) {
                stringBuffer.append("ms.num_calls, ");
            } else if (dB.getDBType().compareTo("mysql") == 0) {
                stringBuffer.append("ms.`call`, ");
            } else {
                stringBuffer.append("ms.call, ");
            }
            stringBuffer.append("ms.subroutines, ms.inclusive_per_call, ");
            stringBuffer.append("ms.metric ");
            stringBuffer.append("from " + dB.getSchemaPrefix() + "interval_mean_summary ms ");
            stringBuffer.append(string);
            stringBuffer.append(" order by ms.interval_event, ms.metric");
        }
        ResultSet resultSet = dB.executeQuery(stringBuffer.toString());
        int n = 0;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        double d = 0.0;
        double d2 = 0.0;
        while (resultSet.next()) {
            arrayList.add(resultSet.getDouble(3));
            arrayList2.add(resultSet.getDouble(5));
            d = resultSet.getDouble(6);
            d2 = resultSet.getDouble(7);
            ++n;
        }
        resultSet.close();
        FunctionProfile functionProfile = new FunctionProfile(function, n);
        functionProfile.setNumCalls(d);
        functionProfile.setNumSubr(d2);
        for (int i = 0; i < n; ++i) {
            functionProfile.setInclusive(i, (Double)arrayList.get(i));
            functionProfile.setExclusive(i, (Double)arrayList2.get(i));
        }
        return functionProfile;
    }
}

