/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.PeriXMLDataSource;
import edu.uoregon.tau.perfdmf.Thread;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PeriXMLHandler
extends DefaultHandler {
    private StringBuffer accumulator = new StringBuffer();
    private PeriXMLDataSource periXMLDataSource;
    private String procedure;
    private String type;
    private String module;
    private String name;
    private int id;
    private Thread thread;
    private FunctionProfile functionProfile;
    private Map<Integer, Function> functionMap = new HashMap<Integer, Function>();
    private Map<Integer, Metric> metricMap = new HashMap<Integer, Metric>();

    public PeriXMLHandler(PeriXMLDataSource periXMLDataSource) {
        this.periXMLDataSource = periXMLDataSource;
    }

    public int getProgress() {
        return 0;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    private int getId(Attributes attributes) {
        return Integer.parseInt(this.getInsensitiveValue(attributes, "id"));
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.accumulator.setLength(0);
        if (string2.equalsIgnoreCase("eventDef")) {
            this.id = this.getId(attributes);
        } else if (string2.equalsIgnoreCase("metric")) {
            this.id = this.getId(attributes);
        } else if (string2.equalsIgnoreCase("process")) {
            this.id = this.getId(attributes);
            this.thread = this.periXMLDataSource.addThread(this.id, 0, 0);
        } else if (string2.equalsIgnoreCase("eventInstance")) {
            this.id = this.getId(attributes);
            Function function = this.functionMap.get(new Integer(this.id));
            this.functionProfile = new FunctionProfile(function);
            this.thread.addFunctionProfile(this.functionProfile);
        } else if (string2.equalsIgnoreCase("metricDef")) {
            this.id = this.getId(attributes);
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.accumulator.append(cArray, n, n2);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string2.equalsIgnoreCase("name")) {
            this.name = this.accumulator.toString();
        } else if (string2.equalsIgnoreCase("metric")) {
            double d = Double.parseDouble(this.accumulator.toString());
            Metric metric = this.metricMap.get(new Integer(this.id));
            this.functionProfile.setExclusive(metric.getID(), d *= 1000000.0);
            this.functionProfile.setInclusive(metric.getID(), d);
        } else if (string2.equalsIgnoreCase("description")) {
            this.name = this.accumulator.toString();
        } else if (string2.equalsIgnoreCase("procedure")) {
            this.procedure = this.accumulator.toString();
        } else if (string2.equalsIgnoreCase("type")) {
            this.type = this.accumulator.toString();
        } else if (string2.equalsIgnoreCase("startline")) {
            if (!this.accumulator.toString().equals("")) {
                Integer.parseInt(this.accumulator.toString());
            }
        } else if (string2.equalsIgnoreCase("module")) {
            this.module = this.accumulator.toString();
        } else if (string2.equalsIgnoreCase("metricDef")) {
            Metric metric = this.periXMLDataSource.addMetric(this.name);
            this.metricMap.put(new Integer(this.id), metric);
        } else if (string2.equalsIgnoreCase("eventDef")) {
            String string4 = this.procedure + " (" + this.type + ") " + this.module;
            Function function = this.periXMLDataSource.addFunction(string4);
            this.functionMap.put(new Integer(this.id), function);
        }
    }

    private String getInsensitiveValue(Attributes attributes, String string) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!attributes.getLocalName(i).equalsIgnoreCase(string)) continue;
            return attributes.getValue(i);
        }
        return null;
    }
}

