/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.Context;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.LineData;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Node;
import edu.uoregon.tau.perfdmf.Thread;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class SPPMDataSource
extends DataSource {
    private int metric = 0;
    private Function function = null;
    private FunctionProfile functionProfile = null;
    private Node node = null;
    private Context context = null;
    private Thread thread = null;
    private int nodeID = -1;
    private int contextID = -1;
    private int threadID = -1;
    private String inputString = null;
    private Vector<File[]> v = null;
    private File[] files = null;
    private BufferedReader br = null;
    private int deltaCount = 0;
    private int timestepCount = 0;
    private Hashtable<String, Integer> methodIndexes = null;
    private double[] cpuTime = null;
    private double[] wallTime = null;
    private int[] calls = null;
    private int[] subroutines = null;
    private String eventName = null;
    private LineData lineData = new LineData();
    private Vector<File[]> initializeObject;

    public SPPMDataSource(Vector<File[]> vector) {
        this.setMetrics(new Vector<Metric>());
        this.initializeObject = vector;
    }

    @Override
    public void cancelLoad() {
    }

    @Override
    public int getProgress() {
        return 0;
    }

    @Override
    public void load() throws FileNotFoundException, IOException {
        this.v = this.initializeObject;
        System.out.println(this.v.size() + " files");
        Enumeration<File[]> enumeration = this.v.elements();
        while (enumeration.hasMoreElements()) {
            this.files = enumeration.nextElement();
            for (int i = 0; i < this.files.length; ++i) {
                System.out.println("Processing data file, please wait ......");
                long l = System.currentTimeMillis();
                this.methodIndexes = new Hashtable();
                this.cpuTime = new double[20];
                this.wallTime = new double[20];
                this.calls = new int[20];
                this.subroutines = new int[20];
                this.deltaCount = 0;
                this.timestepCount = 0;
                FileInputStream fileInputStream = new FileInputStream(this.files[i]);
                InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
                this.br = new BufferedReader(inputStreamReader);
                ++this.nodeID;
                this.inputString = this.br.readLine();
                if (this.inputString == null) {
                    return;
                }
                while ((this.inputString = this.br.readLine()) != null) {
                    if (this.inputString.length() == 0) continue;
                    if (this.inputString.trim().startsWith("==================> Begin Double Timestep")) {
                        this.processTimestepHeader(this.inputString);
                        continue;
                    }
                    if (this.inputString.trim().indexOf("threads update a") >= 0) {
                        this.processThreadCount(this.inputString);
                        continue;
                    }
                    if (this.inputString.trim().startsWith("DELTA-HYD cpu, wall, ratio:")) {
                        this.processEvent(this.inputString, 0);
                        ++this.deltaCount;
                        continue;
                    }
                    if (this.inputString.trim().startsWith("TSTEP-HYD cpu, wall, ratio:")) {
                        this.processEvent(this.inputString, this.deltaCount);
                        ++this.timestepCount;
                        this.deltaCount = 0;
                        continue;
                    }
                    if (!this.inputString.trim().startsWith("TOTAL-HYD cpu, wall, ratio:") || this.inputString.trim().indexOf("Finished Calculation") < 0) continue;
                    this.processEvent(this.inputString, this.timestepCount);
                }
                this.br.close();
                this.saveFunctions();
                l = System.currentTimeMillis() - l;
            }
        }
        this.generateDerivedData();
    }

    private void initializeThread() {
        this.function = this.addFunction(this.eventName, 1);
        this.nodeID = this.nodeID == -1 ? 0 : this.nodeID;
        this.contextID = this.contextID == -1 ? 0 : this.contextID;
        this.threadID = this.threadID == -1 ? 0 : this.threadID;
        this.node = this.getNode(this.nodeID);
        if (this.node == null) {
            this.node = this.addNode(this.nodeID);
        }
        this.context = this.node.getContext(this.contextID);
        if (this.context == null) {
            this.context = this.node.addContext(this.contextID);
        }
        this.thread = this.context.getThread(this.threadID);
        if (this.thread == null) {
            this.thread = this.context.addThread(this.threadID);
        }
        this.functionProfile = this.thread.getFunctionProfile(this.function);
        if (this.functionProfile == null) {
            this.functionProfile = new FunctionProfile(this.function);
            this.thread.addFunctionProfile(this.functionProfile);
        }
    }

    private void processTimestepHeader(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            string = stringTokenizer.nextToken();
            string = stringTokenizer.nextToken();
            string = stringTokenizer.nextToken();
            string = stringTokenizer.nextToken();
            this.lineData.i0 = Integer.parseInt(stringTokenizer.nextToken().trim());
        }
        catch (Exception exception) {
            System.out.println("An error occurred while parsing the header!");
            exception.printStackTrace();
        }
    }

    private void processThreadCount(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            this.lineData.i1 = Integer.parseInt(stringTokenizer.nextToken().trim());
        }
        catch (Exception exception) {
            System.out.println("An error occurred while parsing the header!");
            exception.printStackTrace();
        }
    }

    private void processEvent(String string, int n) {
        try {
            Object object;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            this.lineData.s0 = stringTokenizer.nextToken().trim();
            this.lineData.s1 = stringTokenizer.nextToken().trim();
            this.lineData.s1 = this.lineData.s1.replaceAll(",", "");
            this.lineData.s2 = stringTokenizer.nextToken().trim();
            this.lineData.s2 = this.lineData.s2.replaceAll(",", "");
            this.lineData.s3 = stringTokenizer.nextToken().trim();
            this.lineData.s3 = this.lineData.s3.replaceAll(":", "");
            this.lineData.d0 = Double.parseDouble(stringTokenizer.nextToken().trim());
            this.lineData.d0 /= (double)this.lineData.i1;
            this.lineData.d1 = Double.parseDouble(stringTokenizer.nextToken().trim());
            this.lineData.d2 = Double.parseDouble(stringTokenizer.nextToken().trim());
            while (stringTokenizer.hasMoreTokens() && !((String)(object = stringTokenizer.nextToken().trim())).equals("@")) {
                this.lineData.s0 = this.lineData.s0 + " " + (String)object;
            }
            object = this.methodIndexes.get(this.lineData.s0);
            if (object == null) {
                object = new Integer(this.methodIndexes.size());
                this.methodIndexes.put(this.lineData.s0, (Integer)object);
                this.cpuTime[((Integer)object).intValue()] = this.lineData.d0;
                this.wallTime[((Integer)object).intValue()] = this.lineData.d1;
                this.calls[((Integer)object).intValue()] = 1;
                this.subroutines[((Integer)object).intValue()] = n;
            } else {
                int n2 = (Integer)object;
                this.cpuTime[n2] = this.cpuTime[n2] + this.lineData.d0;
                int n3 = (Integer)object;
                this.wallTime[n3] = this.wallTime[n3] + this.lineData.d1;
                int n4 = (Integer)object;
                this.calls[n4] = this.calls[n4] + 1;
                this.subroutines[((Integer)object).intValue()] = n;
            }
        }
        catch (Exception exception) {
            System.out.println("An error occurred while parsing the callsite data!");
            exception.printStackTrace();
        }
    }

    private void saveFunctions() {
        try {
            Enumeration<String> enumeration = this.methodIndexes.keys();
            while (enumeration.hasMoreElements()) {
                this.eventName = enumeration.nextElement();
                Integer n = this.methodIndexes.get(this.eventName);
                boolean bl = false;
                if (this.subroutines[n] == 0) {
                    bl = true;
                }
                int n2 = 0;
                while (n2 < this.lineData.i1) {
                    this.threadID = n2++;
                    this.initializeThread();
                    this.saveFunctionData("cpu", this.cpuTime[n], bl);
                    this.thread.addMetric();
                    this.functionProfile.addMetric();
                    this.saveFunctionData("wall", this.wallTime[n], bl);
                    this.functionProfile.setNumCalls(this.calls[n]);
                    this.functionProfile.setNumSubr(this.subroutines[n]);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("An error occurred while parsing the callsite data!");
            exception.printStackTrace();
        }
    }

    private void saveFunctionData(String string, double d, boolean bl) {
        this.metric = this.getNumberOfMetrics();
        Metric metric = this.addMetric(string);
        this.metric = metric.getID();
        if (bl) {
            this.functionProfile.setExclusive(this.metric, d);
        } else {
            this.functionProfile.setExclusive(this.metric, 0.0);
        }
        this.functionProfile.setInclusive(this.metric, d);
    }
}

