/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf.taudb;

import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfdmf.taudb.TAUdbSession;
import edu.uoregon.tau.perfdmf.taudb.TAUdbTimer;
import edu.uoregon.tau.perfdmf.taudb.TAUdbTrial;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TAUdbTimerCallpath {
    private int id = 0;
    private TAUdbTimer timer = null;
    private TAUdbTimerCallpath parent = null;
    private List<TAUdbTimerCallpath> children = null;
    private String name = null;

    public TAUdbTimerCallpath(TAUdbSession tAUdbSession, int n, TAUdbTimer tAUdbTimer, TAUdbTimerCallpath tAUdbTimerCallpath, String string) {
        this.id = n;
        this.timer = tAUdbTimer;
        this.parent = tAUdbTimerCallpath;
        this.name = string;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public TAUdbTimer getTimer() {
        return this.timer;
    }

    public void setTimer(TAUdbTimer tAUdbTimer) {
        this.timer = tAUdbTimer;
    }

    public TAUdbTimerCallpath getParent() {
        return this.parent;
    }

    public void setParent(TAUdbTimerCallpath tAUdbTimerCallpath) {
        this.parent = tAUdbTimerCallpath;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public List<TAUdbTimerCallpath> getChildren() {
        return this.children;
    }

    public void addChild(TAUdbTimerCallpath tAUdbTimerCallpath) {
        if (this.children == null) {
            this.children = new ArrayList<TAUdbTimerCallpath>();
        }
        this.children.add(tAUdbTimerCallpath);
    }

    public String toString() {
        return this.name;
    }

    public static Map<Integer, TAUdbTimerCallpath> getTimerCallpaths(TAUdbSession tAUdbSession, TAUdbTrial tAUdbTrial) {
        if (tAUdbTrial.getTimerCallpaths() != null && tAUdbTrial.getTimerCallpaths().size() > 0) {
            return tAUdbTrial.getTimerCallpaths();
        }
        HashMap<Integer, TAUdbTimerCallpath> hashMap = new HashMap<Integer, TAUdbTimerCallpath>();
        Map<Integer, TAUdbTimer> map = tAUdbTrial.getTimers();
        DB dB = tAUdbSession.getDB();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("with recursive cp (id, parent, timer, name) as ( SELECT tc.id, tc.parent, tc.timer, t.name FROM " + dB.getSchemaPrefix() + "timer_callpath tc inner join " + dB.getSchemaPrefix() + "timer t on tc.timer = t.id where " + "t.trial = " + tAUdbTrial.getID() + " and tc.parent is null " + "UNION ALL " + "SELECT d.id, d.parent, d.timer, ");
        if (dB.getDBType().compareTo("h2") == 0) {
            stringBuilder.append("concat (cp.name, ' => ', dt.name) FROM ");
        } else {
            stringBuilder.append("cp.name || ' => ' || dt.name FROM ");
        }
        stringBuilder.append(dB.getSchemaPrefix() + "timer_callpath AS d JOIN cp ON (d.parent = cp.id) join " + dB.getSchemaPrefix() + "timer dt on d.timer = dt.id where dt.trial = " + tAUdbTrial.getID() + " ) " + "SELECT distinct cp.id, cp.parent, cp.timer, cp.name FROM cp order by parent ");
        try {
            PreparedStatement preparedStatement = tAUdbSession.getDB().prepareStatement(stringBuilder.toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Integer n = resultSet.getInt(1);
                Integer n2 = resultSet.getInt(2);
                Integer n3 = resultSet.getInt(3);
                String string = resultSet.getString(4);
                TAUdbTimer tAUdbTimer = map.get(n3);
                TAUdbTimerCallpath tAUdbTimerCallpath = (TAUdbTimerCallpath)hashMap.get(n2);
                TAUdbTimerCallpath tAUdbTimerCallpath2 = new TAUdbTimerCallpath(tAUdbSession, n, tAUdbTimer, tAUdbTimerCallpath, string);
                if (tAUdbTimerCallpath != null) {
                    tAUdbTimerCallpath.addChild(tAUdbTimerCallpath2);
                }
                hashMap.put(n, tAUdbTimerCallpath2);
            }
            resultSet.close();
            preparedStatement.close();
            tAUdbTrial.setTimerCallpaths(hashMap);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return hashMap;
    }

    public static void main(String[] stringArray) {
        TAUdbSession tAUdbSession = new TAUdbSession("callpath", false);
        TAUdbTrial tAUdbTrial = TAUdbTrial.getTrial(tAUdbSession, 1, true);
        Map<Integer, TAUdbTimerCallpath> map = TAUdbTimerCallpath.getTimerCallpaths(tAUdbSession, tAUdbTrial);
        for (Integer n : map.keySet()) {
            System.out.println(map.get(n).toString());
        }
        tAUdbSession.close();
    }
}

