/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf.taudb;

import edu.uoregon.tau.perfdmf.taudb.TAUdbMetric;
import edu.uoregon.tau.perfdmf.taudb.TAUdbSession;
import edu.uoregon.tau.perfdmf.taudb.TAUdbTimerCall;
import edu.uoregon.tau.perfdmf.taudb.TAUdbTrial;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class TAUdbTimerValue {
    private TAUdbSession session = null;
    private TAUdbTrial trial = null;
    private TAUdbTimerCall timerCall = null;
    private TAUdbMetric metric = null;
    private double inclusive = 0.0;
    private double exclusive = 0.0;
    private double inclusivePercent = 0.0;
    private double exclusivePercent = 0.0;
    private double sumExclusiveSquared = 0.0;

    public TAUdbTimerValue(TAUdbSession tAUdbSession, TAUdbTrial tAUdbTrial, TAUdbTimerCall tAUdbTimerCall, TAUdbMetric tAUdbMetric, double d, double d2, double d3, double d4, double d5) {
        this.session = tAUdbSession;
        this.trial = tAUdbTrial;
        this.timerCall = tAUdbTimerCall;
        this.metric = tAUdbMetric;
        this.inclusive = d;
        this.inclusivePercent = d3;
        this.exclusive = d2;
        this.exclusivePercent = d4;
        this.sumExclusiveSquared = d5;
    }

    public TAUdbSession getSession() {
        return this.session;
    }

    public void setSession(TAUdbSession tAUdbSession) {
        this.session = tAUdbSession;
    }

    public TAUdbTrial getTrial() {
        return this.trial;
    }

    public void setTrial(TAUdbTrial tAUdbTrial) {
        this.trial = tAUdbTrial;
    }

    public TAUdbTimerCall getTimerCall() {
        return this.timerCall;
    }

    public void setTimerCall(TAUdbTimerCall tAUdbTimerCall) {
        this.timerCall = tAUdbTimerCall;
    }

    public TAUdbMetric getMetric() {
        return this.metric;
    }

    public void setMetric(TAUdbMetric tAUdbMetric) {
        this.metric = tAUdbMetric;
    }

    public double getInclusive() {
        return this.inclusive;
    }

    public void setInclusive(double d) {
        this.inclusive = d;
    }

    public double getExclusive() {
        return this.exclusive;
    }

    public void setExclusive(double d) {
        this.exclusive = d;
    }

    public double getInclusivePercent() {
        return this.inclusivePercent;
    }

    public void setInclusivePercent(double d) {
        this.inclusivePercent = d;
    }

    public double getExclusivePercent() {
        return this.exclusivePercent;
    }

    public void setExclusivePercent(double d) {
        this.exclusivePercent = d;
    }

    public double getSumExclusiveSquared() {
        return this.sumExclusiveSquared;
    }

    public void setSumExclusiveSquared(double d) {
        this.sumExclusiveSquared = d;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Callpath: " + this.timerCall + " ");
        stringBuilder.append(this.metric.getName() + ": " + this.inclusive + ", " + this.exclusive);
        return stringBuilder.toString();
    }

    public static List<TAUdbTimerValue> getTimerValues(TAUdbSession tAUdbSession, TAUdbTrial tAUdbTrial) {
        if (tAUdbTrial.getTimerValues() != null && tAUdbTrial.getTimerValues().size() > 0) {
            return tAUdbTrial.getTimerValues();
        }
        ArrayList<TAUdbTimerValue> arrayList = new ArrayList<TAUdbTimerValue>();
        String string = "select v.timer_call_data, v.metric, v.inclusive_value, v.exclusive_value, v.inclusive_percent, v.exclusive_percent, v.sum_exclusive_squared from timer_value v join timer_call_data td on v.timer_call_data = td.id join thread t on td.thread = t.id where t.trial = ?";
        try {
            PreparedStatement preparedStatement = tAUdbSession.getDB().prepareStatement(string);
            preparedStatement.setInt(1, tAUdbTrial.getID());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Integer n = resultSet.getInt(1);
                Integer n2 = resultSet.getInt(2);
                double d = resultSet.getDouble(3);
                double d2 = resultSet.getDouble(4);
                double d3 = resultSet.getDouble(5);
                double d4 = resultSet.getDouble(6);
                double d5 = resultSet.getDouble(7);
                TAUdbTimerCall tAUdbTimerCall = tAUdbTrial.getTimerCalls().get(n);
                TAUdbMetric tAUdbMetric = tAUdbTrial.getTAUdbMetrics().get(n2);
                TAUdbTimerValue tAUdbTimerValue = new TAUdbTimerValue(tAUdbSession, tAUdbTrial, tAUdbTimerCall, tAUdbMetric, d, d2, d3, d4, d5);
                arrayList.add(tAUdbTimerValue);
            }
            resultSet.close();
            preparedStatement.close();
            tAUdbTrial.setTimerValues(arrayList);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        TAUdbSession tAUdbSession = new TAUdbSession("callpath", false);
        TAUdbTrial tAUdbTrial = TAUdbTrial.getTrial(tAUdbSession, 1, true);
        List<TAUdbTimerValue> list = TAUdbTimerValue.getTimerValues(tAUdbSession, tAUdbTrial);
        for (TAUdbTimerValue tAUdbTimerValue : list) {
            System.out.println(tAUdbTimerValue.toString());
        }
        tAUdbSession.close();
    }
}

