/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.client;

import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.DatabaseException;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerClient;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerJTree;
import edu.uoregon.tau.perfexplorer.server.PerfExplorerServer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class LoadTrialProgressWindow
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 4116870609160780629L;
    private JProgressBar progressBar = null;
    private DataSource dataSource = null;
    private Trial ppTrial = null;
    private boolean aborted = false;
    private JLabel label;
    private boolean dbUpload = false;
    private Timer jTimer;

    public LoadTrialProgressWindow(PerfExplorerClient perfExplorerClient, DataSource dataSource, Trial trial, boolean bl) {
        this.dataSource = dataSource;
        this.ppTrial = trial;
        int n = 300;
        int n2 = 120;
        Point point = perfExplorerClient.getLocationOnScreen();
        Dimension dimension = perfExplorerClient.getSize();
        int n3 = dimension.width;
        int n4 = dimension.height;
        int n5 = (n3 - n) / 2;
        int n6 = (n4 - n2) / 2;
        n5 = (int)point.getX() + n5;
        n6 = (int)point.getY() + n6;
        this.setLocation(n5, n6);
        this.setSize(new Dimension(n, n2));
        this.setTitle("TAU: ParaProf: Loading...");
        URL uRL = Utility.getResource((String)"tau32x32.gif");
        if (uRL != null) {
            this.setIconImage(Toolkit.getDefaultToolkit().getImage(uRL));
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                LoadTrialProgressWindow.this.thisWindowClosing(windowEvent);
            }
        });
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.label = new JLabel("Loading Profile Data...");
        this.addCompItem(this.label, gridBagConstraints, 0, 0, 1, 1);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setPreferredSize(new Dimension(200, 14));
        gridBagConstraints.fill = 2;
        this.addCompItem(this.progressBar, gridBagConstraints, 0, 1, 1, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(this);
        this.addCompItem(jButton, gridBagConstraints, 0, 3, 1, 1);
        this.jTimer = new Timer(200, this);
        this.jTimer.start();
        this.execute(bl);
    }

    private synchronized void setDBUpload(boolean bl) {
        this.dbUpload = bl;
    }

    private synchronized boolean getDBUpload() {
        return this.dbUpload;
    }

    private void upload() throws DatabaseException {
        this.label.setText("Uploading Trial");
        this.progressBar.setValue(0);
        this.setDBUpload(true);
        DatabaseAPI databaseAPI = PerfExplorerServer.getServer().getSession();
        if (databaseAPI != null) {
            this.ppTrial.setID(databaseAPI.uploadTrial(this.ppTrial));
            PerfExplorerJTree.getTree().expandLast(true);
        }
    }

    public synchronized void waitForLoad() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void finishLoad() {
        this.notifyAll();
    }

    private synchronized void execute(final boolean bl) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    if (bl) {
                        LoadTrialProgressWindow.this.upload();
                        LoadTrialProgressWindow.this.jTimer.stop();
                        LoadTrialProgressWindow.this.finishLoad();
                        LoadTrialProgressWindow.this.dispose();
                    } else {
                        LoadTrialProgressWindow.this.dataSource.load();
                        if (!LoadTrialProgressWindow.this.aborted) {
                            LoadTrialProgressWindow.this.upload();
                        }
                        LoadTrialProgressWindow.this.ppTrial = null;
                        LoadTrialProgressWindow.this.jTimer.stop();
                        LoadTrialProgressWindow.this.dispose();
                    }
                }
                catch (Exception exception) {
                    LoadTrialProgressWindow.this.dispose();
                    System.err.print(exception.getMessage());
                    exception.printStackTrace(System.err);
                }
            }
        });
        thread.start();
    }

    public void updateProgress() {
        if (this.getDBUpload()) {
            DatabaseAPI databaseAPI = PerfExplorerServer.getServer().getSession();
            if (databaseAPI != null) {
                int n = databaseAPI.getProgress();
                this.progressBar.setValue(n);
            }
        } else {
            int n = this.dataSource.getProgress();
            if (n > 100) {
                n = 100;
            }
            this.progressBar.setValue(n);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof Timer) {
                this.updateProgress();
            } else {
                String string = actionEvent.getActionCommand();
                if (string.equals("Cancel")) {
                    this.aborted = true;
                    if (this.dbUpload) {
                        DatabaseAPI databaseAPI = PerfExplorerServer.getServer().getSession();
                        databaseAPI.cancelUpload();
                    } else {
                        this.dataSource.cancelLoad();
                    }
                }
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void finishDatabase(boolean bl) {
        if (bl && !this.aborted) {
            this.progressBar.setValue(100);
        }
        this.jTimer.stop();
        this.dispose();
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    private void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    void closeThisWindow() {
        try {
            this.aborted = true;
            if (this.dbUpload) {
                DatabaseAPI databaseAPI = PerfExplorerServer.getServer().getSession();
                databaseAPI.cancelUpload();
            } else {
                this.dataSource.cancelLoad();
            }
            this.jTimer.stop();
            this.setVisible(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dispose();
    }
}

