/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.client;

import edu.uoregon.tau.common.ImageExport;
import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.common.VectorExport;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerActionListener;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerChartJMenuBar;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerClient;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;

public class PerfExplorerChartWindow
extends JFrame
implements ActionListener,
ImageExport {
    private static final long serialVersionUID = -5011632640191017358L;
    public static final String ABOUT = "About PerfExplorer";
    public static final String SEARCH = "Search For Help On...";
    public static final String SAVE = "Save As Vector Image";
    public static final String CLOSE = "Close Window";
    private ChartPanel panel = null;

    public PerfExplorerChartWindow(JFreeChart jFreeChart, String string) {
        super("TAU/PerfExplorer: " + string);
        this.panel = new ChartPanel(jFreeChart);
        this.panel.setDisplayToolTips(true);
        this.getContentPane().add((Component)this.panel);
        PerfExplorerChartWindow perfExplorerChartWindow = this;
        this.setJMenuBar(new PerfExplorerChartJMenuBar(perfExplorerChartWindow));
        URL uRL = Utility.getResource((String)"tau32x32.gif");
        if (uRL != null) {
            this.setIconImage(Toolkit.getDefaultToolkit().getImage(uRL));
        }
        PerfExplorerChartWindow.centerFrame(this);
        this.pack();
        this.setVisible(true);
    }

    public static void centerFrame(JFrame jFrame) {
        int n = 700;
        int n2 = 450;
        int n3 = 0;
        int n4 = 0;
        try {
            Point point = PerfExplorerClient.getMainFrame().getLocationOnScreen();
            Dimension dimension = PerfExplorerClient.getMainFrame().getSize();
            int n5 = dimension.width;
            int n6 = dimension.height;
            n3 = (n5 - n) / 2;
            n4 = (n6 - n2) / 2;
            n3 = (int)point.getX() + n3;
            n4 = (int)point.getY() + n4;
        }
        catch (NullPointerException nullPointerException) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension dimension = toolkit.getScreenSize();
            int n7 = dimension.height;
            int n8 = dimension.width;
            n3 = (n8 - n) / 2;
            n4 = (n7 - n2) / 2;
        }
        jFrame.setLocation(n3, n4);
        jFrame.setSize(new Dimension(n, n2));
    }

    public void saveThyself() {
        try {
            VectorExport.promptForVectorExport((ImageExport)this, (String)"PerfExplorer");
        }
        catch (Exception exception) {
            System.out.println("File Export Failed!");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals(ABOUT)) {
                    this.createAboutWindow();
                } else if (string.equals(SEARCH)) {
                    this.createHelpWindow();
                } else if (string.equals(SAVE)) {
                    this.saveThyself();
                } else if (string.equals(CLOSE)) {
                    this.dispose();
                } else {
                    System.out.println("unknown event! " + string);
                }
            }
        }
        catch (Exception exception) {
            System.err.println("actionPerformed Exception: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void createAboutWindow() {
        long l = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L;
        String string = new String("PerfExplorer 1.0\n" + PerfExplorerActionListener.getVersionString() + "\nJVM Heap Size: " + l + "kb\n");
        JOptionPane.showMessageDialog(this, string, ABOUT, -1);
    }

    public void createHelpWindow() {
        JOptionPane.showMessageDialog(this, "Help not implemented.\nFor the most up-to-date documentation, please see\n<html><a href='http://www.cs.uoregon.edu/research/tau/'>http://www.cs.uoregon.edu/research/tau/</a></html>", "PerfExplorer Help", -1);
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        return this.panel.getSize();
    }

    public void export(Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) {
        this.panel.setDoubleBuffered(false);
        this.panel.paintAll((Graphics)graphics2D);
        this.panel.setDoubleBuffered(true);
    }
}

