/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.client;

import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.View;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerClient;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerModel;
import edu.uoregon.tau.perfexplorer.common.ChartDataType;
import edu.uoregon.tau.perfexplorer.common.RMIChartData;
import edu.uoregon.tau.perfexplorer.common.RMICubeData;
import edu.uoregon.tau.perfexplorer.common.RMIGeneralChartData;
import edu.uoregon.tau.perfexplorer.common.RMIPerfExplorer;
import edu.uoregon.tau.perfexplorer.common.RMIPerfExplorerModel;
import edu.uoregon.tau.perfexplorer.common.RMIPerformanceResults;
import edu.uoregon.tau.perfexplorer.common.RMISortableIntervalEvent;
import edu.uoregon.tau.perfexplorer.common.RMIVarianceData;
import edu.uoregon.tau.perfexplorer.server.PerfExplorerServer;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerfExplorerConnection {
    private static PerfExplorerConnection theConnection = null;
    private RMIPerfExplorer server = null;
    private static boolean standalone = true;
    private static String configFile = null;
    private static String tauHome = null;
    private static String tauArch = null;
    private int connectionIndex = 0;
    private static List<Integer> schemaVersion = null;

    private PerfExplorerConnection() {
        this.makeConnection();
    }

    private void makeConnection() {
        if (standalone) {
            this.server = PerfExplorerServer.getServer(configFile, tauHome, tauArch);
        } else {
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new RMISecurityManager());
            }
            try {
                String string = System.getProperty("java.rmi.server.hostname");
                String string2 = "PerfExplorerServer";
                System.out.println("Connecting to rmi://" + string + "/" + string2);
                this.server = (RMIPerfExplorer)Naming.lookup("//" + string + "/" + string2);
                System.out.println("Bound to " + string2);
            }
            catch (Exception exception) {
                System.err.println("createServer Exception: " + exception.getMessage());
                exception.printStackTrace();
                this.server = null;
            }
        }
    }

    public static void setStandalone(boolean bl) {
        standalone = bl;
    }

    public static void setConfigFile(String string) {
        configFile = string;
    }

    public static void setTauHome(String string) {
        tauHome = string;
    }

    public static void setTauArch(String string) {
        tauArch = string;
    }

    public static PerfExplorerConnection getConnection() {
        if (theConnection == null) {
            theConnection = new PerfExplorerConnection();
        }
        if (PerfExplorerConnection.theConnection.server == null) {
            return null;
        }
        return theConnection;
    }

    private void handleError(RemoteException remoteException, String string) {
        System.out.println("PerfExplorerConnection." + string + " Exception: ");
        System.out.println(remoteException.getMessage());
        remoteException.printStackTrace();
        JOptionPane.showMessageDialog(PerfExplorerClient.getMainFrame(), "An error occurred communicating with the server.", "Server Error", 0);
        this.server = null;
        this.makeConnection();
        if (this.server == null) {
            JOptionPane.showMessageDialog(PerfExplorerClient.getMainFrame(), "The connection could not be restored.\nPlease check to make sure the server is running.", "Server Error", 0);
        } else {
            JOptionPane.showMessageDialog(PerfExplorerClient.getMainFrame(), "Connection restored - please try your request again.", "Connection Restored", 1);
        }
    }

    public String sayHello() {
        String string = null;
        try {
            string = this.server.sayHello();
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "sayHello()");
        }
        return string;
    }

    public ListIterator<Application> getApplicationList() {
        ListIterator<Application> listIterator = null;
        try {
            listIterator = this.server.getApplicationList().listIterator();
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getApplicationList()");
        }
        return listIterator;
    }

    public ListIterator<Experiment> getExperimentList(int n) {
        ListIterator<Experiment> listIterator = null;
        try {
            listIterator = this.server.getExperimentList(n).listIterator();
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getExperimentList(" + n + ")");
        }
        return listIterator;
    }

    public ListIterator<Trial> getTrialList(int n, boolean bl) {
        ListIterator<Trial> listIterator = null;
        try {
            listIterator = this.server.getTrialList(n, bl).listIterator();
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getTrialList(" + n + ")");
        }
        return listIterator;
    }

    public String requestAnalysis(RMIPerfExplorerModel rMIPerfExplorerModel, boolean bl) {
        String string = null;
        try {
            string = this.server.requestAnalysis(rMIPerfExplorerModel, bl);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "requestAnalysis(" + rMIPerfExplorerModel.toString() + ")");
        }
        return string;
    }

    public RMIPerformanceResults getPerformanceResults(PerfExplorerModel perfExplorerModel) {
        RMIPerformanceResults rMIPerformanceResults = null;
        try {
            rMIPerformanceResults = this.server.getPerformanceResults(perfExplorerModel);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getPerformanceResults(" + perfExplorerModel.toString() + ")");
        }
        return rMIPerformanceResults;
    }

    public RMIPerformanceResults getCorrelationResults(PerfExplorerModel perfExplorerModel) {
        RMIPerformanceResults rMIPerformanceResults = null;
        try {
            rMIPerformanceResults = this.server.getCorrelationResults(perfExplorerModel);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getCorrelationResults(" + perfExplorerModel.toString() + ")");
        }
        return rMIPerformanceResults;
    }

    public void stopServer() {
        try {
            this.server.stopServer();
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "stopServer()");
        }
    }

    public RMIChartData requestChartData(PerfExplorerModel perfExplorerModel, ChartDataType chartDataType) {
        RMIChartData rMIChartData = null;
        try {
            rMIChartData = this.server.requestChartData(perfExplorerModel, chartDataType);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "requestChartData(" + perfExplorerModel.toString() + ")");
        }
        return rMIChartData;
    }

    public RMIGeneralChartData requestGeneralChartData(PerfExplorerModel perfExplorerModel, ChartDataType chartDataType) {
        RMIGeneralChartData rMIGeneralChartData = null;
        try {
            rMIGeneralChartData = this.server.requestGeneralChartData(perfExplorerModel, chartDataType);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "requestGeneralChartData(" + perfExplorerModel.toString() + ")");
        }
        return rMIGeneralChartData;
    }

    public List<String> getPotentialGroups(PerfExplorerModel perfExplorerModel) {
        List<String> list = null;
        try {
            list = this.server.getPotentialGroups(perfExplorerModel);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getPotentialGroups(" + perfExplorerModel.toString() + ")");
        }
        return list;
    }

    public List<String> getPotentialMetrics(PerfExplorerModel perfExplorerModel) {
        List<String> list = null;
        try {
            list = this.server.getPotentialMetrics(perfExplorerModel);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getPotentialGroups(" + perfExplorerModel.toString() + ")");
        }
        return list;
    }

    public List<String> getPotentialEvents(PerfExplorerModel perfExplorerModel) {
        List<String> list = null;
        try {
            list = this.server.getPotentialEvents(perfExplorerModel);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getPotentialEvents(" + perfExplorerModel.toString() + ")");
        }
        return list;
    }

    public List<String> getPotentialCallPathEvents(PerfExplorerModel perfExplorerModel) {
        List<String> list = null;
        try {
            list = this.server.getPotentialCallPathEvents(perfExplorerModel);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getPotentialCallPathEvents(" + perfExplorerModel.toString() + ")");
        }
        return list;
    }

    public String[] getMetaData(String string) {
        String[] stringArray = null;
        try {
            stringArray = this.server.getMetaData(string);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getMetaData(" + string + ")");
        }
        return stringArray;
    }

    public List<String> getPossibleValues(String string, String string2) {
        List<String> list = null;
        try {
            list = this.server.getPossibleValues(string, string2);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getPossibleValues(" + string + ", " + string2 + ")");
        }
        return list;
    }

    public int createNewView(String string, int n, String string2, String string3, String string4, String string5) {
        int n2 = 0;
        try {
            n2 = this.server.createNewView(string, n, string2, string3, string4, string5);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "createNewView(" + string2 + ", " + string3 + ", " + string5 + ")");
        }
        return n2;
    }

    public void deleteView(String string) {
        try {
            this.server.deleteView(string);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "deleteView(" + string + ")");
        }
    }

    public List<View> getViews(int n) {
        List<View> list = null;
        try {
            list = this.server.getViews(n);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getViews(" + n + ")");
        }
        return list;
    }

    public ListIterator<Trial> getTrialsForView(List<View> list, boolean bl) {
        ListIterator<Trial> listIterator = null;
        try {
            listIterator = this.server.getTrialsForView(list, bl).listIterator();
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getTrialsForView(" + list + ")");
        }
        return listIterator;
    }

    public RMIVarianceData requestVariationAnalysis(PerfExplorerModel perfExplorerModel) {
        RMIVarianceData rMIVarianceData = null;
        try {
            rMIVarianceData = this.server.getVariationAnalysis(perfExplorerModel);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getVariationAnalysis(" + perfExplorerModel.toString() + ")");
        }
        return rMIVarianceData;
    }

    public RMICubeData requestCubeData(PerfExplorerModel perfExplorerModel, int n) {
        RMICubeData rMICubeData = null;
        try {
            rMICubeData = this.server.getCubeData(perfExplorerModel, n);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getCubeData(" + perfExplorerModel.toString() + ")");
        }
        return rMICubeData;
    }

    public String getConnectionString() {
        String string = null;
        try {
            string = this.server.getConnectionString();
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getConnectionString()");
        }
        return string;
    }

    public List<String> getConnectionStrings() {
        List<String> list = null;
        try {
            list = this.server.getConnectionStrings();
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getConnectionStrings()");
        }
        return list;
    }

    public List<String> getConfigNames() {
        List<String> list = null;
        try {
            list = this.server.getConfigNames();
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getConfigNames()");
        }
        return list;
    }

    public ListIterator<RMISortableIntervalEvent> getEventList(int n, int n2) {
        ListIterator<RMISortableIntervalEvent> listIterator = null;
        try {
            listIterator = this.server.getEventList(n, n2).listIterator();
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getEventList(" + n + ")");
        }
        return listIterator;
    }

    public List<Trial> getTrialList(String string, boolean bl) {
        List<Trial> list = null;
        try {
            list = this.server.getTrialList(string, bl);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getTrialList(" + string + ")");
        }
        return list;
    }

    public List<String> getChartFieldNames() {
        List<String> list = null;
        try {
            list = this.server.getChartFieldNames();
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getChartFieldNames()");
        }
        return list;
    }

    public List<String> getXMLFields(PerfExplorerModel perfExplorerModel) {
        List<String> list = null;
        try {
            list = this.server.getXMLFields(perfExplorerModel);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getXMLFields(" + perfExplorerModel.toString() + ")");
        }
        return list;
    }

    public int getConnectionIndex() {
        return this.connectionIndex;
    }

    public void setConnectionIndex(int n) {
        this.connectionIndex = n;
        try {
            this.server.setConnectionIndex(n);
            PerfExplorerModel.getModel().setConnectionIndex(n);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "setConnectionIndex(" + n + ")");
        }
    }

    public void resetServer() {
        try {
            this.server.resetServer();
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "setConnectionIndex(" + this.connectionIndex + ")");
        }
    }

    public List<String> getPotentialAtomicEvents(PerfExplorerModel perfExplorerModel) {
        List<String> list = null;
        try {
            list = this.server.getPotentialAtomicEvents(perfExplorerModel);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getPotentialEvents(" + perfExplorerModel.toString() + ")");
        }
        return list;
    }

    public Map<String, Integer> checkScalabilityChartData(RMIPerfExplorerModel rMIPerfExplorerModel) {
        Map<String, Integer> map = null;
        try {
            map = this.server.checkScalabilityChartData(rMIPerfExplorerModel);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "checkScalabilityChartData(" + rMIPerfExplorerModel.toString() + ")");
        }
        return map;
    }

    public Map<String, double[][]> getUserEventData(RMIPerfExplorerModel rMIPerfExplorerModel) {
        Map<String, double[][]> map = null;
        try {
            map = this.server.getUserEventData(rMIPerfExplorerModel);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getUserEventData(" + rMIPerfExplorerModel.toString() + ")");
        }
        return map;
    }

    public int getSchemaVersion(int n) {
        int n2 = 0;
        try {
            n2 = this.server.getSchemaVersion(n);
        }
        catch (RemoteException remoteException) {
            this.handleError(remoteException, "getSchemaVersion(" + n + ")");
        }
        return n2;
    }
}

