/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.client;

import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.View;
import edu.uoregon.tau.perfexplorer.client.ConnectionNodeObject;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerConnection;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerModel;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerTreeCellRenderer;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerTreeExpansionListener;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerTreeMouseListener;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerTreeNode;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerTreeSelectionListener;
import edu.uoregon.tau.perfexplorer.common.RMISortableIntervalEvent;
import edu.uoregon.tau.perfexplorer.server.PerfExplorerServer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PerfExplorerJTree
extends JTree {
    private static final long serialVersionUID = -7184526063985636881L;
    private static PerfExplorerJTree theTree = null;
    private static List<DefaultMutableTreeNode> leafViews = null;
    private static DefaultMutableTreeNode root = null;
    private static DefaultTreeModel theModel = null;

    private PerfExplorerJTree(DefaultTreeModel defaultTreeModel) {
        super(defaultTreeModel);
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.setShowsRootHandles(true);
        PerfExplorerTreeCellRenderer perfExplorerTreeCellRenderer = new PerfExplorerTreeCellRenderer();
        this.setCellRenderer(perfExplorerTreeCellRenderer);
        this.addTreeSelectionListener(new PerfExplorerTreeSelectionListener(this));
        this.addTreeWillExpandListener(new PerfExplorerTreeExpansionListener(this));
        this.addMouseListener(new PerfExplorerTreeMouseListener(this));
    }

    public static PerfExplorerJTree getTree() {
        if (theTree == null) {
            DefaultTreeModel defaultTreeModel = new DefaultTreeModel(PerfExplorerJTree.createNodes()){
                private static final long serialVersionUID = 1L;

                public void valueForPathChanged(TreePath treePath, Object object) {
                    MutableTreeNode mutableTreeNode = (MutableTreeNode)treePath.getLastPathComponent();
                    PerfExplorerJTree.handleRename((DefaultMutableTreeNode)mutableTreeNode, object);
                    PerfExplorerJTree.nodeChanged((DefaultMutableTreeNode)mutableTreeNode);
                }
            };
            defaultTreeModel.setAsksAllowsChildren(true);
            theTree = new PerfExplorerJTree(defaultTreeModel);
            theModel = defaultTreeModel;
            theTree.setEditable(true);
        }
        return theTree;
    }

    protected static void handleRename(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
        if (object instanceof String) {
            String string = (String)object;
            if (defaultMutableTreeNode.getUserObject() instanceof Application) {
                Application application = (Application)defaultMutableTreeNode.getUserObject();
                application.setName(string);
                DatabaseAPI databaseAPI = PerfExplorerServer.getServer().getSession(application.getDatabase());
                if (databaseAPI != null) {
                    databaseAPI.saveApplication(application);
                }
            } else if (defaultMutableTreeNode.getUserObject() instanceof Experiment) {
                Experiment experiment = (Experiment)defaultMutableTreeNode.getUserObject();
                experiment.setName(string);
                DatabaseAPI databaseAPI = PerfExplorerServer.getServer().getSession(experiment.getDatabase());
                if (databaseAPI != null) {
                    databaseAPI.saveExperiment(experiment);
                }
            } else if (defaultMutableTreeNode.getUserObject() instanceof Trial) {
                Trial trial = (Trial)defaultMutableTreeNode.getUserObject();
                DatabaseAPI databaseAPI = PerfExplorerServer.getServer().getSession(trial.getDatabase());
                trial.rename(databaseAPI.db(), string);
            } else if (defaultMutableTreeNode.getUserObject() instanceof View) {
                View view = (View)defaultMutableTreeNode.getUserObject();
                DatabaseAPI databaseAPI = PerfExplorerServer.getServer().getSession(view.getDatabase());
                view.rename(databaseAPI.db(), string);
            }
        }
    }

    public static void nodeChanged(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (theModel != null && theTree != null) {
            theTree.setVisible(false);
            theModel.nodeChanged(defaultMutableTreeNode);
            theModel.reload(defaultMutableTreeNode);
            theTree.repaint();
            theTree.setVisible(true);
        }
    }

    public static void refreshDatabases() {
        DefaultMutableTreeNode defaultMutableTreeNode = root;
        defaultMutableTreeNode.removeAllChildren();
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        perfExplorerConnection.resetServer();
        List<String> list = perfExplorerConnection.getConnectionStrings();
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            PerfExplorerTreeNode perfExplorerTreeNode = new PerfExplorerTreeNode(new ConnectionNodeObject(string, i));
            defaultMutableTreeNode.add(perfExplorerTreeNode);
        }
        theModel.nodeStructureChanged(defaultMutableTreeNode);
        theTree.setVisible(false);
        theTree.validate();
        theModel.reload();
        theTree.setVisible(true);
    }

    private static DefaultMutableTreeNode createNodes() {
        PerfExplorerTreeNode perfExplorerTreeNode = new PerfExplorerTreeNode("Performance Data");
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        List<String> list = perfExplorerConnection.getConnectionStrings();
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            PerfExplorerTreeNode perfExplorerTreeNode2 = new PerfExplorerTreeNode(new ConnectionNodeObject(string, i));
            perfExplorerTreeNode.add(perfExplorerTreeNode2);
        }
        root = perfExplorerTreeNode;
        return perfExplorerTreeNode;
    }

    public void addViewNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        PerfExplorerTreeNode perfExplorerTreeNode = new PerfExplorerTreeNode("Views");
        leafViews = new ArrayList<DefaultMutableTreeNode>();
        defaultMutableTreeNode.add(perfExplorerTreeNode);
    }

    public static void addViewNodes(DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        PerfExplorerTreeNode perfExplorerTreeNode;
        PerfExplorerJTree.setConnectionIndex(defaultMutableTreeNode);
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        List<View> list = perfExplorerConnection.getViews(n);
        for (View view : list) {
            perfExplorerTreeNode = new PerfExplorerTreeNode(view);
            defaultMutableTreeNode.add(perfExplorerTreeNode);
        }
        leafViews.add(defaultMutableTreeNode);
        if (list.size() == 0) {
            PerfExplorerJTree.addTrialsForView(defaultMutableTreeNode);
        } else {
            View view;
            view = (View)defaultMutableTreeNode.getUserObject();
            perfExplorerTreeNode = View.VirtualView((View)view);
            PerfExplorerTreeNode perfExplorerTreeNode2 = new PerfExplorerTreeNode(perfExplorerTreeNode);
            defaultMutableTreeNode.add(perfExplorerTreeNode2);
        }
    }

    public static void addApplicationNodes(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
        ListIterator<Application> listIterator;
        PerfExplorerJTree.setConnectionIndex(defaultMutableTreeNode);
        PerfExplorerTreeNode perfExplorerTreeNode = null;
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        if (perfExplorerConnection != null && (listIterator = perfExplorerConnection.getApplicationList()) != null) {
            Application application = null;
            while (listIterator.hasNext()) {
                application = listIterator.next();
                perfExplorerTreeNode = new PerfExplorerTreeNode(application);
                defaultMutableTreeNode.add(perfExplorerTreeNode);
            }
        }
    }

    public static void addExperimentNodes(DefaultMutableTreeNode defaultMutableTreeNode, Application application, boolean bl) {
        PerfExplorerJTree.setConnectionIndex(defaultMutableTreeNode);
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        ListIterator<Experiment> listIterator = perfExplorerConnection.getExperimentList(application.getID());
        Experiment experiment = null;
        PerfExplorerTreeNode perfExplorerTreeNode = null;
        while (listIterator.hasNext()) {
            experiment = listIterator.next();
            perfExplorerTreeNode = new PerfExplorerTreeNode(experiment);
            defaultMutableTreeNode.add(perfExplorerTreeNode);
        }
    }

    public static void addTrialNodes(DefaultMutableTreeNode defaultMutableTreeNode, Experiment experiment) {
        PerfExplorerJTree.setConnectionIndex(defaultMutableTreeNode);
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        ListIterator<Trial> listIterator = perfExplorerConnection.getTrialList(experiment.getID(), false);
        Trial trial = null;
        PerfExplorerTreeNode perfExplorerTreeNode = null;
        while (listIterator.hasNext()) {
            trial = listIterator.next();
            perfExplorerTreeNode = new PerfExplorerTreeNode(trial);
            defaultMutableTreeNode.add(perfExplorerTreeNode);
        }
    }

    public static void addTAUdbViewNodes(DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        PerfExplorerJTree.setConnectionIndex(defaultMutableTreeNode);
        if (defaultMutableTreeNode.getUserObject() instanceof ConnectionNodeObject) {
            leafViews = new ArrayList<DefaultMutableTreeNode>();
        }
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        List<View> list = perfExplorerConnection.getViews(n);
        for (View view : list) {
            PerfExplorerTreeNode perfExplorerTreeNode = new PerfExplorerTreeNode(view);
            defaultMutableTreeNode.add(perfExplorerTreeNode);
        }
    }

    public static void addTrialsForViews() {
        for (PerfExplorerTreeNode perfExplorerTreeNode : leafViews) {
            PerfExplorerJTree.addTrialsForView(perfExplorerTreeNode);
        }
    }

    public static void addTrialsForView(DefaultMutableTreeNode defaultMutableTreeNode) {
        PerfExplorerJTree.setConnectionIndex(defaultMutableTreeNode);
        Object[] objectArray = defaultMutableTreeNode.getUserObjectPath();
        ArrayList<View> arrayList = new ArrayList<View>();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof View)) continue;
            arrayList.add((View)objectArray[i]);
        }
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        if (arrayList.size() > 0) {
            ListIterator<Trial> listIterator = perfExplorerConnection.getTrialsForView(arrayList, false);
            Trial trial = null;
            PerfExplorerTreeNode perfExplorerTreeNode = null;
            while (listIterator.hasNext()) {
                trial = listIterator.next();
                perfExplorerTreeNode = new PerfExplorerTreeNode(trial);
                defaultMutableTreeNode.add(perfExplorerTreeNode);
                perfExplorerTreeNode.getParent();
            }
        }
    }

    public static void addMetricNodes(DefaultMutableTreeNode defaultMutableTreeNode, Trial trial) {
        PerfExplorerJTree.setConnectionIndex(defaultMutableTreeNode);
        List list = trial.getMetrics();
        if (list == null) {
            trial.getTrialMetrics(PerfExplorerServer.getServer().getDB());
            list = trial.getMetrics();
        }
        boolean bl = false;
        if (list != null) {
            ListIterator listIterator = list.listIterator();
            Metric metric = null;
            PerfExplorerTreeNode perfExplorerTreeNode = null;
            while (listIterator.hasNext()) {
                metric = (Metric)listIterator.next();
                perfExplorerTreeNode = new PerfExplorerTreeNode(metric, true);
                defaultMutableTreeNode.add(perfExplorerTreeNode);
            }
        }
    }

    public static void addEventNodes(DefaultMutableTreeNode defaultMutableTreeNode, Trial trial, int n) {
        PerfExplorerJTree.setConnectionIndex(defaultMutableTreeNode);
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        ListIterator<RMISortableIntervalEvent> listIterator = perfExplorerConnection.getEventList(trial.getID(), n);
        RMISortableIntervalEvent rMISortableIntervalEvent = null;
        PerfExplorerTreeNode perfExplorerTreeNode = null;
        while (listIterator.hasNext()) {
            rMISortableIntervalEvent = listIterator.next();
            perfExplorerTreeNode = new PerfExplorerTreeNode(rMISortableIntervalEvent, false);
            defaultMutableTreeNode.add(perfExplorerTreeNode);
        }
    }

    public static int getConnectionIndex(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode;
        Object object = defaultMutableTreeNode2.getUserObject();
        while (defaultMutableTreeNode2 != null && !(object instanceof ConnectionNodeObject)) {
            if ((defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent()) == null) continue;
            object = defaultMutableTreeNode2.getUserObject();
        }
        if (object != null && object instanceof ConnectionNodeObject) {
            ConnectionNodeObject connectionNodeObject = (ConnectionNodeObject)object;
            return connectionNodeObject.index;
        }
        return -1;
    }

    public static void setConnectionIndex(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = PerfExplorerJTree.getConnectionIndex(defaultMutableTreeNode);
        PerfExplorerModel.getModel().setConnectionIndex(n);
        PerfExplorerConnection.getConnection().setConnectionIndex(n);
    }

    public void expandAll(boolean bl) {
        TreeNode treeNode = (TreeNode)PerfExplorerJTree.getTree().getModel().getRoot();
        this.expandAll(new TreePath(treeNode), bl);
    }

    public void expandToMetricsAll(TreePath treePath) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        if (((PerfExplorerTreeNode)treeNode).getUserObject() instanceof Metric) {
            return;
        }
        if (((PerfExplorerTreeNode)treeNode).getUserObject() instanceof Experiment) {
            this.collapsePath(treePath);
        }
        this.expandPath(treePath);
        if (treeNode.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode2 = enumeration.nextElement();
                TreePath treePath2 = treePath.pathByAddingChild(treeNode2);
                this.expandToMetricsAll(treePath2);
            }
        }
    }

    public void expandAll(TreePath treePath, boolean bl) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        if (bl) {
            this.expandPath(treePath);
        }
        if (treeNode.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode2 = enumeration.nextElement();
                TreePath treePath2 = treePath.pathByAddingChild(treeNode2);
                this.expandAll(treePath2, bl);
            }
        }
        if (!bl) {
            this.collapsePath(treePath);
        }
    }

    public void expandLast(boolean bl) {
        TreeNode treeNode = (TreeNode)PerfExplorerJTree.getTree().getModel().getRoot();
        this.expandLastAdded(new TreePath(treeNode), bl);
    }

    public void expandLastAdded(TreePath treePath, boolean bl) {
        Object object;
        Object object2;
        PerfExplorerTreeNode perfExplorerTreeNode = (PerfExplorerTreeNode)treePath.getLastPathComponent();
        Object object3 = perfExplorerTreeNode.getUserObject();
        if (object3 instanceof ConnectionNodeObject) {
            object2 = PerfExplorerConnection.getConnection().getConnectionString();
            if (object2 == null || !((String)object2).equals(object3.toString())) {
                return;
            }
        } else if (object3 instanceof Application) {
            object2 = PerfExplorerModel.getModel().getApplication();
            object = (Application)object3;
            if (object2 == null || object2.getID() != object.getID()) {
                return;
            }
        } else if (object3 instanceof Experiment) {
            object2 = PerfExplorerModel.getModel().getExperiment();
            object = (Experiment)object3;
            if (object2 == null || object2.getID() != object.getID()) {
                return;
            }
        } else if (object3 instanceof Trial) {
            object2 = PerfExplorerModel.getModel().getTrial();
            object = (Trial)object3;
            if (object2 == null || object2.getID() != object.getID()) {
                return;
            }
        } else {
            if (object3 instanceof View) {
                return;
            }
            if (object3 instanceof Metric) {
                return;
            }
        }
        if (bl) {
            this.expandPath(treePath);
        }
        if (perfExplorerTreeNode.getChildCount() >= 0) {
            object2 = perfExplorerTreeNode.children();
            while (object2.hasMoreElements()) {
                object = (TreeNode)object2.nextElement();
                TreePath treePath2 = treePath.pathByAddingChild(object);
                this.expandLastAdded(treePath2, bl);
            }
        }
        if (!bl) {
            this.collapsePath(treePath);
        }
    }
}

