/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.client;

import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.IntervalEvent;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.View;
import edu.uoregon.tau.perfexplorer.client.ConnectionNodeObject;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerConnection;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerJTree;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class PerfExplorerTreeExpansionListener
implements TreeExpansionListener,
TreeWillExpandListener {
    private JTree tree;

    public PerfExplorerTreeExpansionListener(JTree jTree) {
        this.tree = jTree;
    }

    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
        DefaultTreeModel defaultTreeModel;
        Object object;
        TreePath treePath = treeExpansionEvent.getPath();
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (!defaultMutableTreeNode.isRoot()) {
            defaultMutableTreeNode.removeAllChildren();
            object = this.tree.getModel();
            if (object instanceof DefaultTreeModel) {
                defaultTreeModel = (DefaultTreeModel)object;
                defaultTreeModel.reload(defaultMutableTreeNode);
            }
        }
        object = defaultMutableTreeNode.getUserObject();
        if (defaultMutableTreeNode.isRoot()) {
            PerfExplorerJTree.refreshDatabases();
        } else if (defaultMutableTreeNode.toString() != null && defaultMutableTreeNode.toString().startsWith("jdbc:")) {
            int n = PerfExplorerJTree.getConnectionIndex(defaultMutableTreeNode);
            int n2 = PerfExplorerConnection.getConnection().getSchemaVersion(n);
            if (object instanceof ConnectionNodeObject) {
                ConnectionNodeObject connectionNodeObject = (ConnectionNodeObject)object;
                connectionNodeObject.setString(PerfExplorerConnection.getConnection().getConnectionStrings().get(n));
                PerfExplorerJTree.nodeChanged(defaultMutableTreeNode);
            }
            if (n2 < 1) {
                PerfExplorerJTree.addApplicationNodes(defaultMutableTreeNode, false);
                PerfExplorerJTree.getTree().addViewNode(defaultMutableTreeNode);
            } else {
                PerfExplorerJTree.addTAUdbViewNodes(defaultMutableTreeNode, 0);
            }
        } else if (defaultMutableTreeNode.toString() != null && defaultMutableTreeNode.toString().equals("Views")) {
            PerfExplorerJTree.addViewNodes(defaultMutableTreeNode, 0);
        } else if (object instanceof Application) {
            defaultTreeModel = (Application)object;
            PerfExplorerJTree.addExperimentNodes(defaultMutableTreeNode, (Application)defaultTreeModel, true);
        } else if (object instanceof Experiment) {
            defaultTreeModel = (Experiment)object;
            PerfExplorerJTree.addTrialNodes(defaultMutableTreeNode, (Experiment)defaultTreeModel);
        } else if (object instanceof Trial) {
            defaultTreeModel = (Trial)object;
            PerfExplorerJTree.addMetricNodes(defaultMutableTreeNode, (Trial)defaultTreeModel);
        } else if (object instanceof Metric) {
            defaultTreeModel = (Metric)object;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            object = defaultMutableTreeNode2.getUserObject();
            Trial trial = (Trial)object;
            List list = trial.getMetrics();
            for (int i = 0; i < list.size(); ++i) {
                Metric metric = (Metric)list.get(i);
                if (metric.getID() != defaultTreeModel.getID()) continue;
                PerfExplorerJTree.addEventNodes(defaultMutableTreeNode, trial, i);
                break;
            }
        } else if (!(object instanceof IntervalEvent)) {
            if (object instanceof View) {
                defaultTreeModel = (View)object;
                PerfExplorerJTree.addViewNodes(defaultMutableTreeNode, defaultTreeModel.getID());
            } else {
                System.out.println("unknown!");
            }
        }
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
    }

    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }
}

