/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.clustering.weka;

import edu.uoregon.tau.perfexplorer.clustering.ClusterDescription;
import edu.uoregon.tau.perfexplorer.clustering.ClusterException;
import edu.uoregon.tau.perfexplorer.clustering.ClusterInterface;
import edu.uoregon.tau.perfexplorer.clustering.DBScanClusterInterface;
import edu.uoregon.tau.perfexplorer.clustering.PrincipalComponentsAnalysisInterface;
import edu.uoregon.tau.perfexplorer.clustering.RawDataInterface;
import edu.uoregon.tau.perfexplorer.clustering.weka.AnalysisFactory;
import edu.uoregon.tau.perfexplorer.clustering.weka.WekaRawData;
import edu.uoregon.tau.perfexplorer.common.RMICubeData;
import java.util.ArrayList;
import weka.attributeSelection.PrincipalComponents;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

public class WekaPrincipalComponents
implements PrincipalComponentsAnalysisInterface {
    private RawDataInterface inputData = null;
    private Instances instances = null;
    private Instances components = null;
    private PrincipalComponents pca = null;
    private int numAttributes = 0;
    private double[][] correlationCoefficients = null;
    private RMICubeData cubeData = null;
    private RawDataInterface rawData = null;
    private ClusterInterface clusterer = null;
    private RawDataInterface[] clusters = null;
    private RawDataInterface transformed = null;
    private int maxComponents = 2;

    WekaPrincipalComponents(RMICubeData rMICubeData) {
        this.cubeData = rMICubeData;
    }

    WekaPrincipalComponents(RawDataInterface rawDataInterface) {
        this.rawData = rawDataInterface;
    }

    public void doPCA() throws ClusterException {
        if (this.rawData != null) {
            try {
                this.pca = new PrincipalComponents();
                if (this.maxComponents > 0) {
                    this.pca.setMaximumAttributeNames(this.maxComponents);
                }
                this.pca.setNormalize(false);
                this.pca.setTransformBackToOriginal(false);
                Instances instances = (Instances)this.rawData.getData();
                this.pca.buildEvaluator(instances);
                System.out.println("variance covered: " + this.pca.getVarianceCovered());
                for (int i = 0; i < ((Instances)this.rawData.getData()).numAttributes(); ++i) {
                    System.out.println("merit[" + i + "]: " + this.pca.evaluateAttribute(i));
                }
                this.components = this.pca.transformedData(instances);
                this.transformed = new WekaRawData(this.components);
            }
            catch (Exception exception) {
                System.err.println("Error performing PCA on dataset");
                exception.printStackTrace(System.err);
            }
        } else {
            int n;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (n = 0; n < this.maxComponents; ++n) {
                arrayList.add(this.cubeData.getNames()[n]);
            }
            this.transformed = AnalysisFactory.createRawData("Scatterplot Data", arrayList, 2, this.inputData.numVectors(), null);
            for (n = 0; n < this.inputData.numVectors(); ++n) {
                float[] fArray = this.cubeData.getValues(n);
                for (int i = 0; i < this.maxComponents; ++i) {
                    this.transformed.addValue(i, n, fArray[i]);
                }
            }
        }
    }

    public ClusterDescription getComponentDescription(int n) throws ClusterException {
        return null;
    }

    public void setInputData(RawDataInterface rawDataInterface) {
        this.inputData = rawDataInterface;
        this.instances = (Instances)rawDataInterface.getData();
    }

    public double[][] getCorrelationCoefficients() {
        if (this.correlationCoefficients == null) {
            this.numAttributes = this.instances.numAttributes();
            this.correlationCoefficients = new double[this.numAttributes][this.numAttributes];
            for (int i = 0; i < this.numAttributes; ++i) {
                double[] dArray = this.instances.attributeToDoubleArray(i);
                for (int j = 0; j < i; ++j) {
                    double[] dArray2 = this.instances.attributeToDoubleArray(j);
                    this.correlationCoefficients[i][j] = Utils.correlation((double[])dArray, (double[])dArray2, (int)this.numAttributes);
                }
            }
        }
        return this.correlationCoefficients;
    }

    public RawDataInterface getResults() {
        return this.transformed;
    }

    public void reset() {
    }

    public RawDataInterface[] getClusters() {
        if (this.clusterer != null) {
            int n;
            int[] nArray = this.clusterer.getClusterSizes();
            int n2 = this.clusterer.getClusterSizes().length;
            if (n2 == 0) {
                this.clusters = null;
                return this.clusters;
            }
            if (this.clusterer instanceof DBScanClusterInterface) {
                ++n2;
            }
            this.clusters = new RawDataInterface[n2];
            Instances[] instancesArray = new Instances[n2];
            int[] nArray2 = new int[n2];
            for (n = 0; n < n2; ++n) {
                instancesArray[n] = n >= nArray.length ? new Instances((Instances)this.transformed.getData(), 0) : new Instances((Instances)this.transformed.getData(), nArray[n]);
                nArray2[n] = 0;
            }
            for (n = 0; n < this.inputData.numVectors(); ++n) {
                double[] dArray = new double[2];
                int n3 = this.clusterer.clusterInstance(n);
                if (n3 < 0) {
                    n3 = instancesArray.length - 1;
                }
                dArray[0] = this.transformed.getValue(0, n);
                dArray[1] = this.transformed.getValue(1, n);
                instancesArray[n3].add(new Instance(1.0, dArray));
                int n4 = n3;
                nArray2[n4] = nArray2[n4] + 1;
            }
            for (n = 0; n < n2; ++n) {
                this.clusters[n] = new WekaRawData(instancesArray[n]);
            }
        }
        return this.clusters;
    }

    public void setClusterer(ClusterInterface clusterInterface) {
        this.clusterer = clusterInterface;
    }

    public int getMaxComponents() {
        return this.maxComponents;
    }

    public void setMaxComponents(int n) {
        this.maxComponents = n;
    }
}

