/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.common;

import edu.uoregon.tau.perfexplorer.common.Equation;
import edu.uoregon.tau.perfexplorer.common.EquationParseException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslateScript {
    private static String spaces = "";

    public static String translate(String string) throws EquationParseException {
        try {
            FileReader fileReader = new FileReader(string);
            String string2 = "";
            int n = fileReader.read();
            while (n != -1) {
                char c = (char)n;
                if (c == '%') {
                    if (string2.charAt(string2.length() - 1) == '#') {
                        spaces = TranslateScript.findSpaces(string2);
                        string2 = string2.substring(0, string2.length() - 1);
                        string2 = string2 + TranslateScript.translateEquation(fileReader);
                    } else {
                        string2 = string2 + c;
                    }
                } else {
                    string2 = string2 + c;
                }
                n = fileReader.read();
            }
            return string2;
        }
        catch (IOException iOException) {
            System.err.println("\n\n *** ERROR: Unknown file  ***\n\n");
            return "";
        }
    }

    private static String translateEquation(InputStreamReader inputStreamReader) throws IOException, EquationParseException {
        Equation equation = TranslateScript.parseEquation(inputStreamReader);
        return TranslateScript.writeCode(equation);
    }

    private static Equation parseEquation(InputStreamReader inputStreamReader) throws IOException, EquationParseException {
        char c = (char)inputStreamReader.read();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        while (c != ',') {
            if (c == '\uffff' || TranslateScript.EOL(c) || c == '=') {
                throw new EquationParseException("\n\n *** ERROR: Invaild Equation  ***\n\n");
            }
            string2 = string2 + c;
            c = (char)inputStreamReader.read();
        }
        c = (char)inputStreamReader.read();
        while (c != '=') {
            if (c == '\uffff' || TranslateScript.EOL(c)) {
                throw new EquationParseException("\n\n *** ERROR: Invaild Equation  ***\n\n");
            }
            string3 = string3 + c;
            c = (char)inputStreamReader.read();
        }
        c = (char)inputStreamReader.read();
        while (!TranslateScript.EOL(c)) {
            if (c == '\uffff') {
                throw new EquationParseException("\n\n *** ERROR: Invaild Equation  ***\n\n");
            }
            string = string + c;
            c = (char)inputStreamReader.read();
        }
        if ((string3 = string3.trim()).indexOf("\"") != -1) {
            string4 = string3;
        }
        return new Equation(string4.trim(), string2.trim(), string.trim(), string3.trim());
    }

    private static boolean EOL(char c) {
        return c == '\n' || c == '\r' || c == '\u0085' || c == '\u2028' || c == '\u2029';
    }

    private static String addName(ArrayList<String> arrayList, String string) {
        block2: {
            try {
                Double.valueOf(string);
                arrayList.add("\"" + string + "\"");
            }
            catch (NumberFormatException numberFormatException) {
                if (string.trim().equals("")) break block2;
                arrayList.add(string);
            }
        }
        return "";
    }

    private static String writeCode(Equation equation) {
        String string = "TAU_DONTUSE = DeriveMetricEquation(" + equation.getPerfResult() + ",";
        if (!equation.hasNewName()) {
            string = string + TranslateScript.formatEquation(equation.getStatement()) + ")\n";
            string = string + spaces + equation.getPerfResult() + " = TAU_DONTUSE.processData().get(0)\n";
            string = string + spaces + equation.getNameVar() + " = TAU_DONTUSE.getNewName()\n";
            return string;
        }
        string = string + TranslateScript.formatEquation(equation.getStatement()) + "," + equation.getNewName() + ")\n";
        string = string + spaces + equation.getPerfResult() + " = TAU_DONTUSE.processData().get(0)\n";
        return string;
    }

    private static String formatEquation(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "";
        char[] cArray = string.toCharArray();
        for (char c : cArray) {
            if (TranslateScript.isOperation(c + "") || c == ')' || c == '(') {
                string2 = TranslateScript.addName(arrayList, string2);
                arrayList.add("\"" + c + "\"");
                continue;
            }
            string2 = string2 + c;
        }
        string2 = TranslateScript.addName(arrayList, string2);
        Object object = "";
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (String)object + arrayList.get(i) + "+";
        }
        object = ((String)object).substring(0, ((String)object).length() - 1);
        return object;
    }

    private static boolean isOperation(String string) {
        char c = string.charAt(0);
        return c == '+' || c == '-' || c == '*' || c == '/';
    }

    private static String findSpaces(String string) {
        String string2 = "";
        int n = string.lastIndexOf(35);
        char c = string.charAt(n - 1);
        int n2 = n - 2;
        while (!TranslateScript.EOL(c)) {
            string2 = c + string2;
            c = string.charAt(n2);
            --n2;
        }
        return string2;
    }
}

