/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import edu.uoregon.tau.perfdmf.UtilFncs;
import edu.uoregon.tau.perfexplorer.glue.AbstractResult;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceResult
extends AbstractResult {
    private static final long serialVersionUID = -1446658362802536887L;
    public static final int PPK = 0;
    public static final int TAUPROFILE = 1;
    public static final int DYNAPROF = 3;
    public static final int MPIP = 4;
    public static final int HPM = 5;
    public static final int GPROF = 6;
    public static final int PSRUN = 7;
    public static final int PPROF = 8;
    public static final int CUBE = 9;
    public static final int HPCTOOLKIT = 10;
    public static final int SNAP = 2;
    public static final int OMPP = 11;
    public static final int PERIXML = 12;
    public static final int GPTL = 13;
    public static final int PARAVER = 14;
    public static final int IPM = 15;
    public static final int GOOGLE = 16;
    public static final int GYRO = 100;
    public static final int GAMESS = 101;
    private DataSource source = null;
    private List<Thread> threadList = null;
    private Map<String, Integer> metricMap = new HashMap<String, Integer>();
    protected Map<Integer, String> eventMap = new HashMap<Integer, String>();

    public DataSourceResult(int n, String[] stringArray, boolean bl) {
        Object object;
        int n2;
        File[] fileArray = new File[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            fileArray[i] = new File(stringArray[i]);
            this.name = fileArray[i].getName();
        }
        this.source = UtilFncs.initializeDataSource((File[])fileArray, (int)n, (boolean)bl);
        try {
            long l = System.currentTimeMillis();
            this.trial = new Trial();
            this.trial.setDataSource(this.source);
            this.dataSource = this.source;
            this.source.load();
            this.trial.setMetaData(this.source.getMetaData());
            this.trial.setUncommonMetaData(this.source.getUncommonMetaData());
            this.trial.setName(this.name);
            long l2 = System.currentTimeMillis() - l;
            float f = (float)l2 / 1000.0f;
            System.out.println("Total time to read data from disk: " + f + " seconds");
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace(System.err);
            return;
        }
        this.threadList = this.source.getThreads();
        for (n2 = 0; n2 < this.threadList.size(); ++n2) {
            this.threads.add(new Integer(n2));
        }
        for (n2 = 0; n2 < this.source.getNumberOfMetrics(); ++n2) {
            object = this.source.getMetric(n2).getName();
            this.metricMap.put((String)object, n2);
            this.metrics.add(object);
        }
        Iterator iterator = this.source.getFunctionIterator();
        while (iterator.hasNext()) {
            object = (Function)iterator.next();
            String string = object.getName();
            this.events.add(string);
        }
        object = this.source.getUserEventIterator();
        while (object.hasNext()) {
            UserEvent userEvent = (UserEvent)object.next();
            String string = userEvent.getName();
            this.userEvents.add(string);
        }
    }

    @Override
    public double getCalls(Integer n, String string) {
        Thread thread = this.threadList.get(n);
        Function function = this.source.getFunction(string);
        try {
            FunctionProfile functionProfile = thread.getFunctionProfile(function);
            return functionProfile.getNumCalls();
        }
        catch (NullPointerException nullPointerException) {
            if (!this.ignoreWarnings) {
                System.err.println("*** Warning - null numCalls value for thread: " + n + ", event: " + string + " ***");
            }
            return 0.0;
        }
    }

    @Override
    public double getExclusive(Integer n, String string, String string2) {
        Thread thread = this.threadList.get(n);
        Function function = this.source.getFunction(string);
        try {
            FunctionProfile functionProfile = thread.getFunctionProfile(function);
            return functionProfile.getExclusive(this.metricMap.get(string2).intValue());
        }
        catch (NullPointerException nullPointerException) {
            if (!this.ignoreWarnings) {
                System.err.println("*** Warning - null exclusive value for thread: " + n + ", event: " + string + ", metric: " + string2 + " ***");
            }
            return 0.0;
        }
    }

    @Override
    public double getInclusive(Integer n, String string, String string2) {
        Thread thread = this.threadList.get(n);
        Function function = this.source.getFunction(string);
        try {
            FunctionProfile functionProfile = thread.getFunctionProfile(function);
            return functionProfile.getInclusive(this.metricMap.get(string2).intValue());
        }
        catch (NullPointerException nullPointerException) {
            if (!this.ignoreWarnings) {
                System.err.println("*** Warning - null inclusive value for thread: " + n + ", event: " + string + ", metric: " + string2 + " ***");
            }
            return 0.0;
        }
    }

    @Override
    public String getMainEvent() {
        if (this.mainEvent == null) {
            for (Thread thread : this.threadList) {
                int n = 0;
                this.mainMetric = this.source.getMetric(n).getName();
                Iterator iterator = this.source.getFunctionIterator();
                while (iterator.hasNext()) {
                    Function function = (Function)iterator.next();
                    String string = function.getName();
                    FunctionProfile functionProfile = thread.getFunctionProfile(function);
                    if (functionProfile == null || !(this.mainInclusive < functionProfile.getInclusive(n))) continue;
                    this.mainInclusive = functionProfile.getInclusive(n);
                    this.mainEvent = string;
                }
            }
        }
        return this.mainEvent;
    }

    @Override
    public Set<String> getUserEvents(Integer n) {
        TreeSet<String> treeSet = new TreeSet<String>();
        Thread thread = this.threadList.get(n);
        Iterator iterator = thread.getUserEventProfiles();
        while (iterator.hasNext()) {
            UserEventProfile userEventProfile = (UserEventProfile)iterator.next();
            treeSet.add(userEventProfile.getUserEvent().getName());
        }
        return treeSet;
    }

    @Override
    public Integer getOriginalThreads() {
        return this.threadList.size();
    }

    @Override
    public double getSubroutines(Integer n, String string) {
        Thread thread = this.threadList.get(n);
        Function function = this.source.getFunction(string);
        try {
            FunctionProfile functionProfile = thread.getFunctionProfile(function);
            return functionProfile.getNumSubr();
        }
        catch (NullPointerException nullPointerException) {
            if (!this.ignoreWarnings) {
                System.err.println("*** Warning - null subroutines value for thread: " + n + ", event: " + string + " ***");
            }
            return 0.0;
        }
    }

    @Override
    public Trial getTrial() {
        return this.trial;
    }

    @Override
    public Integer getTrialID() {
        return new Integer(0);
    }

    @Override
    public double getUsereventMax(Integer n, String string) {
        UserEvent userEvent;
        Thread thread = this.threadList.get(n);
        UserEventProfile userEventProfile = thread.getUserEventProfile(userEvent = this.source.getUserEvent(string));
        if (userEventProfile != null) {
            return userEventProfile.getMaxValue();
        }
        return 0.0;
    }

    @Override
    public double getUsereventMean(Integer n, String string) {
        UserEvent userEvent;
        Thread thread = this.threadList.get(n);
        UserEventProfile userEventProfile = thread.getUserEventProfile(userEvent = this.source.getUserEvent(string));
        if (userEventProfile != null) {
            return userEventProfile.getMeanValue();
        }
        return 0.0;
    }

    @Override
    public double getUsereventMin(Integer n, String string) {
        UserEvent userEvent;
        Thread thread = this.threadList.get(n);
        UserEventProfile userEventProfile = thread.getUserEventProfile(userEvent = this.source.getUserEvent(string));
        if (userEventProfile != null) {
            return userEventProfile.getMinValue();
        }
        return 0.0;
    }

    @Override
    public double getUsereventNumevents(Integer n, String string) {
        UserEvent userEvent;
        Thread thread = this.threadList.get(n);
        UserEventProfile userEventProfile = thread.getUserEventProfile(userEvent = this.source.getUserEvent(string));
        if (userEventProfile != null) {
            return userEventProfile.getNumSamples();
        }
        return 0.0;
    }

    @Override
    public double getUsereventSumsqr(Integer n, String string) {
        UserEvent userEvent;
        Thread thread = this.threadList.get(n);
        UserEventProfile userEventProfile = thread.getUserEventProfile(userEvent = this.source.getUserEvent(string));
        if (userEventProfile != null) {
            return userEventProfile.getSumSquared();
        }
        return 0.0;
    }

    @Override
    public void putCalls(Integer n, String string, double d) {
        System.err.println("*** putCalls not implemented for DataSourceResult ***");
    }

    @Override
    public void putDataPoint(Integer n, String string, String string2, int n2, double d) {
        System.err.println("*** putDataPoint not implemented for DataSourceResult ***");
    }

    @Override
    public void putExclusive(Integer n, String string, String string2, double d) {
        System.err.println("*** putExclusive not implemented for DataSourceResult ***");
    }

    @Override
    public void putInclusive(Integer n, String string, String string2, double d) {
        System.err.println("*** putInclusive not implemented for DataSourceResult ***");
    }

    @Override
    public void putSubroutines(Integer n, String string, double d) {
        System.err.println("*** putSubroutines not implemented for DataSourceResult ***");
    }

    @Override
    public void putUsereventMax(Integer n, String string, double d) {
        System.err.println("*** putUsereventMax not implemented for DataSourceResult ***");
    }

    @Override
    public void putUsereventMean(Integer n, String string, double d) {
        System.err.println("*** putUsereventMean not implemented for DataSourceResult ***");
    }

    @Override
    public void putUsereventMin(Integer n, String string, double d) {
        System.err.println("*** putUsereventMin not implemented for DataSourceResult ***");
    }

    @Override
    public void putUsereventNumevents(Integer n, String string, double d) {
        System.err.println("*** putUsereventNumevents not implemented for DataSourceResult ***");
    }

    @Override
    public void putUsereventSumsqr(Integer n, String string, double d) {
        System.err.println("*** putUsereventsSumsqr not implemented for DataSourceResult ***");
    }
}

