/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.glue.AbstractPerformanceOperation;
import edu.uoregon.tau.perfexplorer.glue.DefaultResult;
import edu.uoregon.tau.perfexplorer.glue.MaxResult;
import edu.uoregon.tau.perfexplorer.glue.MinResult;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NormalizeOperation
extends AbstractPerformanceOperation {
    private static final long serialVersionUID = -1383799654279373763L;

    public NormalizeOperation(PerformanceResult performanceResult) {
        super(performanceResult);
    }

    public NormalizeOperation(Trial trial) {
        super(trial);
    }

    public NormalizeOperation(List<PerformanceResult> list) {
        super(list);
    }

    @Override
    public List<PerformanceResult> processData() {
        for (PerformanceResult performanceResult : this.inputs) {
            DefaultResult defaultResult = new DefaultResult(performanceResult, false);
            MinResult minResult = new MinResult(performanceResult, false);
            MaxResult maxResult = new MaxResult(performanceResult, false);
            minResult.setIgnoreWarnings(true);
            maxResult.setIgnoreWarnings(true);
            double d = 0.0;
            for (Integer n : performanceResult.getThreads()) {
                for (String string : performanceResult.getEvents()) {
                    d = performanceResult.getCalls(n, string);
                    if (!(d > 0.0)) continue;
                    for (String string2 : performanceResult.getMetrics()) {
                        minResult.putDataPoint(0, string, string2, 1, performanceResult.getExclusive(n, string, string2));
                        maxResult.putDataPoint(0, string, string2, 1, performanceResult.getExclusive(n, string, string2));
                        minResult.putDataPoint(0, string, string2, 0, performanceResult.getInclusive(n, string, string2));
                        maxResult.putDataPoint(0, string, string2, 0, performanceResult.getInclusive(n, string, string2));
                    }
                    minResult.putDataPoint(0, string, null, 2, d);
                    maxResult.putDataPoint(0, string, null, 2, d);
                    minResult.putDataPoint(0, string, null, 3, performanceResult.getSubroutines(n, string));
                    maxResult.putDataPoint(0, string, null, 3, performanceResult.getSubroutines(n, string));
                }
            }
            for (Integer n : performanceResult.getThreads()) {
                for (String string : performanceResult.getEvents()) {
                    if (!(performanceResult.getCalls(n, string) > 0.0)) continue;
                    for (String string2 : performanceResult.getMetrics()) {
                        defaultResult.putExclusive(n, string, string2, (performanceResult.getExclusive(n, string, string2) - minResult.getExclusive(0, string, string2)) / (maxResult.getExclusive(0, string, string2) - minResult.getExclusive(0, string, string2)));
                        defaultResult.putInclusive(n, string, string2, (performanceResult.getInclusive(n, string, string2) - minResult.getInclusive(0, string, string2)) / (maxResult.getInclusive(0, string, string2) - minResult.getInclusive(0, string, string2)));
                    }
                    defaultResult.putCalls(n, string, (performanceResult.getCalls(n, string) - minResult.getCalls(0, string)) / (maxResult.getCalls(0, string) - minResult.getCalls(0, string)));
                    defaultResult.putSubroutines(n, string, (performanceResult.getSubroutines(n, string) - minResult.getSubroutines(0, string)) / (maxResult.getSubroutines(0, string) - minResult.getSubroutines(0, string)));
                }
            }
            this.outputs.add(defaultResult);
        }
        return this.outputs;
    }
}

