/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfexplorer.glue.AbstractResult;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import edu.uoregon.tau.perfexplorer.glue.TrialResult;
import edu.uoregon.tau.perfexplorer.server.PerfExplorerServer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrialMeanResult
extends AbstractResult {
    private static final long serialVersionUID = -3739854995183107332L;
    private Integer originalThreads = 0;
    private boolean callPath = true;

    public TrialMeanResult() {
    }

    public TrialMeanResult(TrialMeanResult trialMeanResult) {
        super(trialMeanResult);
    }

    public TrialMeanResult(Trial trial) {
        this.trialID = trial.getID();
        this.trial = trial;
        this.name = this.trial.getName();
        this.buildTrialMeanResult(trial, null, null);
    }

    public TrialMeanResult(Trial trial, List<String> list, List<String> list2, boolean bl) {
        this.trialID = trial.getID();
        this.callPath = bl;
        this.trial = trial;
        this.name = this.trial.getName();
        this.buildTrialMeanResult(trial, list, list2);
    }

    public TrialMeanResult(Trial trial, List<String> list, List<String> list2, List<String> list3, boolean bl) {
        this.trialID = trial.getID();
        this.callPath = bl;
        this.trial = trial;
        this.name = this.trial.getName();
        TrialResult trialResult = new TrialResult(trial, list, list2, list3, bl);
        this.buildTrialMeanResult(trialResult);
    }

    public TrialMeanResult(PerformanceResult performanceResult, boolean bl) {
        this.trial = performanceResult.getTrial();
        this.trialID = performanceResult.getTrialID();
        this.callPath = bl;
        this.name = this.trial.getName();
        this.buildTrialMeanResult(performanceResult);
    }

    private void buildTrialMeanResult(PerformanceResult performanceResult) {
        this.setEventMap(performanceResult.getEventMap());
        boolean bl = false;
        for (String string : performanceResult.getMetrics()) {
            for (String string2 : performanceResult.getEvents()) {
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = performanceResult.getThreads().size();
                for (Integer n : performanceResult.getThreads()) {
                    double d6 = performanceResult.getCalls(n, string2);
                    if (d6 == 0.0) continue;
                    d += performanceResult.getExclusive(n, string2, string);
                    d2 += performanceResult.getInclusive(n, string2, string);
                    if (bl) continue;
                    d3 += d6;
                    d4 += performanceResult.getSubroutines(n, string2);
                }
                this.putExclusive(0, string2, string, d / d5);
                this.putInclusive(0, string2, string, d2 / d5);
                if (bl) continue;
                this.putCalls(0, string2, d3 / d5);
                this.putSubroutines(0, string2, d4 / d5);
            }
            bl = true;
        }
    }

    private void buildTrialMeanResult(Trial trial, List<String> list, List<String> list2) {
        DB dB = PerfExplorerServer.getServer().getDB();
        if (dB.getSchemaVersion() > 0) {
            this.buildTrialResultFromTAUdb(trial, list, list2);
            return;
        }
        try {
            int n;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("select e.name, ");
            stringBuilder.append("m.name, ");
            if (dB.getDBType().compareTo("oracle") == 0) {
                stringBuilder.append("p.excl, ");
            } else {
                stringBuilder.append("p.exclusive, ");
            }
            stringBuilder.append("p.inclusive, ");
            if (dB.getDBType().compareTo("derby") == 0) {
                stringBuilder.append("p.num_calls, ");
            } else {
                stringBuilder.append("p.call, ");
            }
            stringBuilder.append("p.subroutines, e.id ");
            stringBuilder.append("from interval_event e ");
            stringBuilder.append("left outer join interval_mean_summary p ");
            stringBuilder.append("on e.id = p.interval_event ");
            stringBuilder.append("left outer join metric m on m.trial = e.trial ");
            stringBuilder.append("and m.id = p.metric ");
            stringBuilder.append("where e.trial = ? ");
            if (list != null) {
                stringBuilder.append(" and m.name in (");
                n = 0;
                for (String string : list) {
                    if (n > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("'" + string + "'");
                    ++n;
                }
                stringBuilder.append(") ");
            }
            if (list2 != null) {
                stringBuilder.append(" and e.name in (");
                n = 0;
                for (String string : list2) {
                    if (n > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("'" + string + "'");
                    ++n;
                }
                stringBuilder.append(") ");
            }
            if (!this.callPath) {
                stringBuilder.append(" and (e.group_name is null or e.group_name not like '%TAU_CALLPATH%') ");
            }
            stringBuilder.append(" order by 2,1 ");
            PreparedStatement preparedStatement = dB.prepareStatement(stringBuilder.toString());
            preparedStatement.setInt(1, trial.getID());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string;
                string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                this.putExclusive(0, string, string2, resultSet.getDouble(3));
                this.putInclusive(0, string, string2, resultSet.getDouble(4));
                this.putCalls(0, string, resultSet.getDouble(5));
                this.putSubroutines(0, string, resultSet.getDouble(6));
                Integer n2 = resultSet.getInt(7);
                this.eventMap.put(n2, string);
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException.getMessage());
            sQLException.printStackTrace();
        }
    }

    private void buildTrialResultFromTAUdb(Trial trial, List<String> list, List<String> list2) {
        DB dB = PerfExplorerServer.getServer().getDB();
        StringBuilder stringBuilder = null;
        PreparedStatement preparedStatement = null;
        try {
            String string;
            int n;
            stringBuilder = new StringBuilder();
            if (!this.callPath) {
                stringBuilder.append(" select t.name, m.name, tv.exclusive_value, ");
                stringBuilder.append(" tv.inclusive_value, tcd.calls, tcd.subroutines, cp.id from timer t ");
                stringBuilder.append(" left outer join timer_callpath cp on t.trial = " + trial.getID());
                stringBuilder.append(" and t.id = cp.timer ");
                stringBuilder.append(" left outer join timer_call_data tcd on tcd.timer_callpath = cp.id ");
                stringBuilder.append(" left outer join timer_value tv on tv.timer_call_data = tcd.id ");
                stringBuilder.append(" left outer join metric m on m.trial = " + trial.getID() + " and tv.metric = m.id ");
                stringBuilder.append(" left outer join thread h on h.trial = " + trial.getID() + " and tcd.thread = h.id ");
            } else {
                stringBuilder.append(" with recursive cp (id, parent, timer, name) as (  ");
                stringBuilder.append(" SELECT tc.id, tc.parent, tc.timer, timer.name  ");
                stringBuilder.append(" FROM  timer_callpath tc inner join timer on tc.timer = timer.id ");
                stringBuilder.append(" where timer.trial = " + trial.getID() + " and tc.parent is null ");
                stringBuilder.append(" UNION ALL ");
                stringBuilder.append(" SELECT d.id, d.parent, d.timer, ");
                if (dB.getDBType().compareTo("h2") == 0) {
                    stringBuilder.append("concat (cp.name, ' => ', dt.name) ");
                } else {
                    stringBuilder.append("cp.name || ' => ' || dt.name ");
                }
                stringBuilder.append(" FROM timer_callpath AS d JOIN cp ON (d.parent = cp.id) ");
                stringBuilder.append(" join timer dt on d.timer = dt.id where dt.trial = " + trial.getID() + " ) ");
                stringBuilder.append(" select cp.name, m.name, h.thread_index, tv.exclusive_value, ");
                stringBuilder.append(" tv.inclusive_value, tcd.calls, tcd.subroutines, cp.id from cp ");
                stringBuilder.append(" left outer join timer_call_data tcd on tcd.timer_callpath = cp.id ");
                stringBuilder.append(" left outer join timer_value tv on tv.timer_call_data = tcd.id ");
                stringBuilder.append(" left outer join metric m on m.trial = " + trial.getID() + " and tv.metric = m.id ");
                stringBuilder.append(" left outer join thread h on h.trial = " + trial.getID() + " and tcd.thread = h.id ");
            }
            stringBuilder.append("where m.trial = " + trial.getID());
            if (list != null) {
                stringBuilder.append(" and m.name in (");
                n = 0;
                for (String object2 : list) {
                    if (n > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("'" + object2 + "'");
                    ++n;
                }
                stringBuilder.append(") ");
            }
            if (list2 != null) {
                stringBuilder.append(" and t.name in (");
                n = 0;
                for (String string2 : list2) {
                    if (n > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("'" + string2 + "'");
                    ++n;
                }
                stringBuilder.append(") ");
            }
            stringBuilder.append(" and h.thread_index = -1 ");
            stringBuilder.append(" order by 3,2,1 ");
            preparedStatement = dB.prepareStatement(stringBuilder.toString());
            long l = System.currentTimeMillis();
            ResultSet resultSet = preparedStatement.executeQuery();
            long l2 = System.currentTimeMillis() - l;
            float f = (float)l2 / 1000.0f;
            System.out.println("Time to query interval data: " + f + " seconds");
            while (resultSet.next()) {
                string = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                this.putExclusive(0, string, string3, resultSet.getDouble(3));
                this.putInclusive(0, string, string3, resultSet.getDouble(4));
                this.putCalls(0, string, resultSet.getDouble(5));
                this.putSubroutines(0, string, resultSet.getDouble(6));
                Integer n2 = resultSet.getInt(7);
                this.eventMap.put(n2, string);
            }
            resultSet.close();
            preparedStatement.close();
            stringBuilder = new StringBuilder();
            stringBuilder.append("select c.name, ");
            stringBuilder.append("cv.sample_count, ");
            stringBuilder.append("cv.maximum_value, ");
            stringBuilder.append("cv.minimum_value, ");
            stringBuilder.append("cv.mean_value, ");
            stringBuilder.append("cv.standard_deviation ");
            stringBuilder.append("from counter c ");
            stringBuilder.append("left outer join counter_value cv ");
            stringBuilder.append("on c.id = cv.counter and c.trial = " + trial.getID());
            stringBuilder.append(" left outer join thread h ");
            stringBuilder.append("on h.id = cv.thread and h.trial = " + trial.getID());
            stringBuilder.append(" where c.trial = " + trial.getID());
            stringBuilder.append(" and h.thread_index = -1 ");
            stringBuilder.append(" order by 2,1 ");
            preparedStatement = dB.prepareStatement(stringBuilder.toString());
            l = System.currentTimeMillis();
            ResultSet resultSet2 = preparedStatement.executeQuery();
            l2 = System.currentTimeMillis() - l;
            f = (float)l2 / 1000.0f;
            System.out.println("Time to query counter data: " + f + " seconds");
            while (resultSet2.next()) {
                string = resultSet2.getString(1);
                this.putUsereventNumevents(0, string, resultSet2.getDouble(2));
                this.putUsereventMax(0, string, resultSet2.getDouble(3));
                this.putUsereventMin(0, string, resultSet2.getDouble(4));
                this.putUsereventMean(0, string, resultSet2.getDouble(5));
                this.putUsereventSumsqr(0, string, resultSet2.getDouble(6));
            }
            resultSet2.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException.getMessage());
            sQLException.printStackTrace();
            if (preparedStatement != null) {
                System.err.println(preparedStatement);
            }
            System.err.println(stringBuilder);
        }
    }

    @Override
    public Integer getTrialID() {
        return this.trialID;
    }

    @Override
    public void setTrialID(Integer n) {
        this.trialID = n;
    }

    @Override
    public Integer getOriginalThreads() {
        if (this.originalThreads == 0) {
            this.originalThreads = super.getOriginalThreads();
        }
        return this.originalThreads;
    }

    @Override
    public void setOriginalThreads(Integer n) {
        this.originalThreads = n;
    }
}

