/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.server;

import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfexplorer.clustering.RawDataInterface;
import edu.uoregon.tau.perfexplorer.clustering.weka.AnalysisFactory;
import edu.uoregon.tau.perfexplorer.common.PerfExplorerException;
import edu.uoregon.tau.perfexplorer.common.PerfExplorerOutput;
import edu.uoregon.tau.perfexplorer.common.RMIPerfExplorerModel;
import edu.uoregon.tau.perfexplorer.common.TransformationType;
import edu.uoregon.tau.perfexplorer.server.PerfExplorerServer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class DataUtils {
    public static RawDataInterface getRawData(DatabaseAPI databaseAPI, RMIPerfExplorerModel rMIPerfExplorerModel) throws PerfExplorerException {
        Object object;
        PerfExplorerServer.getServer();
        PerfExplorerOutput.print("Getting raw data...");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        RawDataInterface rawDataInterface = null;
        double d = 0.0;
        ArrayList<String> arrayList = null;
        String string = rMIPerfExplorerModel.getClusterValueType();
        PerfExplorerOutput.print("Getting constants...");
        try {
            ResultSet resultSet;
            object = databaseAPI.db();
            if (string.compareTo("inclusive") != 0) {
                string = object.getDBType().compareTo("oracle") == 0 ? "excl" : "exclusive";
            }
            PreparedStatement preparedStatement = null;
            StringBuilder stringBuilder = new StringBuilder();
            if (object.getDBType().compareTo("oracle") == 0) {
                stringBuilder.append("select count(p.excl) ");
            } else {
                stringBuilder.append("select count(p.inclusive) ");
            }
            stringBuilder.append("from interval_event e ");
            stringBuilder.append("left outer join interval_location_profile p ");
            stringBuilder.append("on e.id = p.interval_event ");
            if (rMIPerfExplorerModel.getDimensionReduction().equals(TransformationType.OVER_X_PERCENT)) {
                stringBuilder.append("inner join interval_mean_summary s ");
                stringBuilder.append("on e.id = s.interval_event and s.metric = p.metric ");
                stringBuilder.append("and s.exclusive_percentage > ");
                stringBuilder.append("" + rMIPerfExplorerModel.getXPercent() + "");
            }
            stringBuilder.append("where e.trial = ?");
            stringBuilder.append(" and (e.group_name is null or e.group_name not like '%TAU_CALLPATH%') ");
            if (rMIPerfExplorerModel.getCurrentSelection() instanceof Metric) {
                stringBuilder.append(" and p.metric = ?");
            }
            preparedStatement = object.prepareStatement(stringBuilder.toString());
            preparedStatement.setInt(1, rMIPerfExplorerModel.getTrial().getID());
            if (rMIPerfExplorerModel.getCurrentSelection() instanceof Metric) {
                preparedStatement.setInt(2, ((Metric)rMIPerfExplorerModel.getCurrentSelection()).getID());
            }
            if ((resultSet = preparedStatement.executeQuery()).next()) {
                // empty if block
            }
            resultSet.close();
            preparedStatement.close();
            if (rMIPerfExplorerModel.getCurrentSelection() instanceof Metric) {
                stringBuilder = new StringBuilder();
                stringBuilder.append("select e.id, e.name from interval_event e ");
                if (rMIPerfExplorerModel.getDimensionReduction().equals(TransformationType.OVER_X_PERCENT)) {
                    stringBuilder.append("inner join interval_mean_summary s on ");
                    stringBuilder.append("e.id = s.interval_event ");
                    stringBuilder.append("and s.exclusive_percentage > ");
                    stringBuilder.append("" + rMIPerfExplorerModel.getXPercent() + "");
                    stringBuilder.append(" where e.trial = ? ");
                    if (rMIPerfExplorerModel.getCurrentSelection() instanceof Metric) {
                        stringBuilder.append(" and s.metric = ? ");
                    }
                } else {
                    stringBuilder.append("where e.trial = ?");
                }
                stringBuilder.append(" and (e.group_name is null or e.group_name not like '%TAU_CALLPATH%') ");
                stringBuilder.append(" order by 1");
                preparedStatement = object.prepareStatement(stringBuilder.toString());
                preparedStatement.setInt(1, rMIPerfExplorerModel.getTrial().getID());
                if (rMIPerfExplorerModel.getDimensionReduction().equals(TransformationType.OVER_X_PERCENT) && rMIPerfExplorerModel.getCurrentSelection() instanceof Metric) {
                    preparedStatement.setInt(2, ((Metric)rMIPerfExplorerModel.getCurrentSelection()).getID());
                }
                resultSet = preparedStatement.executeQuery();
                n2 = 0;
                arrayList = new ArrayList();
                while (resultSet.next()) {
                    ++n2;
                    arrayList.add(DataUtils.shortName(resultSet.getString(2)));
                }
                resultSet.close();
                preparedStatement.close();
            } else {
                stringBuilder = new StringBuilder();
                stringBuilder.append("select m.id, m.name from metric m ");
                stringBuilder.append("where m.trial = ?");
                stringBuilder.append(" order by 1");
                preparedStatement = object.prepareStatement(stringBuilder.toString());
                preparedStatement.setInt(1, rMIPerfExplorerModel.getTrial().getID());
                resultSet = preparedStatement.executeQuery();
                n2 = 0;
                arrayList = new ArrayList<String>();
                while (resultSet.next()) {
                    ++n2;
                    arrayList.add(resultSet.getString(2));
                }
                resultSet.close();
                preparedStatement.close();
            }
            stringBuilder = new StringBuilder();
            stringBuilder.append("select max(node), max(context), max(thread) ");
            stringBuilder.append("from interval_location_profile ");
            stringBuilder.append("inner join interval_event ");
            stringBuilder.append("on interval_event.id = interval_event where trial = ? ");
            if (rMIPerfExplorerModel.getCurrentSelection() instanceof Metric) {
                stringBuilder.append(" and metric = ? ");
            }
            preparedStatement = object.prepareStatement(stringBuilder.toString());
            preparedStatement.setInt(1, rMIPerfExplorerModel.getTrial().getID());
            if (rMIPerfExplorerModel.getCurrentSelection() instanceof Metric) {
                preparedStatement.setInt(2, ((Metric)rMIPerfExplorerModel.getCurrentSelection()).getID());
            }
            if ((resultSet = preparedStatement.executeQuery()).next()) {
                n3 = resultSet.getInt(1) + 1;
                n4 = resultSet.getInt(2) + 1;
                n5 = resultSet.getInt(3) + 1;
                n = n3 * n4 * n5;
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            String string2 = "ERROR: Couldn't the constant settings from the database!";
            System.err.println(string2);
            System.err.println(sQLException.getMessage());
            sQLException.printStackTrace();
            throw new PerfExplorerException(string2, sQLException);
        }
        rawDataInterface = AnalysisFactory.createRawData("Cluster Test", arrayList, n, n2, null);
        object = null;
        int n6 = 0;
        int n7 = -1;
        int n8 = 0;
        int n9 = 0;
        d = 0.0;
        try {
            int n10;
            DB dB = databaseAPI.db();
            PreparedStatement preparedStatement = null;
            StringBuilder stringBuilder = new StringBuilder();
            if (rMIPerfExplorerModel.getDimensionReduction().equals(TransformationType.OVER_X_PERCENT)) {
                stringBuilder.append("select e.id, (p.node*");
                stringBuilder.append(n4 * n5);
                stringBuilder.append(") + (p.context*");
                stringBuilder.append(n5);
                stringBuilder.append(") + p.thread as thread, p.metric as metric, p." + string + "/1000000, ");
                stringBuilder.append("p.inclusive/1000000, s.inclusive_percentage, s.exclusive_percentage ");
                stringBuilder.append("from interval_event e ");
                stringBuilder.append("inner join interval_mean_summary s ");
                stringBuilder.append("on e.id = s.interval_event and (s.exclusive_percentage > ");
                stringBuilder.append(rMIPerfExplorerModel.getXPercent());
                stringBuilder.append("or s.inclusive_percentage = 100.0) ");
                stringBuilder.append(" left outer join interval_location_profile p ");
                stringBuilder.append("on e.id = p.interval_event ");
                stringBuilder.append("and p.metric = s.metric where e.trial = ? ");
            } else {
                stringBuilder.append("select e.id, (p.node*" + n4 * n5 + "");
                stringBuilder.append(") + (p.context*" + n5 + "");
                stringBuilder.append(") + p.thread as thread, p.metric as metric, p." + string + ", ");
                stringBuilder.append("p.inclusive/1000000, p.inclusive_percentage ");
                stringBuilder.append("from interval_event e ");
                stringBuilder.append("left outer join interval_location_profile p ");
                stringBuilder.append("on e.id = p.interval_event where e.trial = ? ");
            }
            if (rMIPerfExplorerModel.getCurrentSelection() instanceof Metric) {
                stringBuilder.append(" and p.metric = ? ");
            }
            stringBuilder.append(" and (e.group_name is null or e.group_name not like '%TAU_CALLPATH%') ");
            stringBuilder.append(" order by 3,1,2 ");
            preparedStatement = dB.prepareStatement(stringBuilder.toString());
            preparedStatement.setInt(1, rMIPerfExplorerModel.getTrial().getID());
            if (rMIPerfExplorerModel.getCurrentSelection() instanceof Metric) {
                preparedStatement.setInt(2, ((Metric)rMIPerfExplorerModel.getCurrentSelection()).getID());
            }
            object = preparedStatement.executeQuery();
            int n11 = n10 = rMIPerfExplorerModel.getCurrentSelection() instanceof Metric ? 1 : 3;
            while (object.next()) {
                if (!rMIPerfExplorerModel.getDimensionReduction().equals(TransformationType.OVER_X_PERCENT) || object.getDouble(7) > rMIPerfExplorerModel.getXPercent()) {
                    if (n6 != object.getInt(n10)) {
                        ++n7;
                    }
                    n6 = object.getInt(n10);
                    n9 = object.getInt(2);
                    rawDataInterface.addValue(n9, n7, object.getDouble(4));
                    if (d < object.getDouble(4)) {
                        d = object.getDouble(4);
                    }
                }
                if (object.getDouble(6) == 100.0) {
                    rawDataInterface.addMainValue(n9, n7, object.getDouble(5));
                }
                ++n8;
            }
            object.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            String string3 = "ERROR: Couldn't the raw data from the database!";
            System.err.println(string3);
            System.err.println(sQLException.getMessage());
            sQLException.printStackTrace();
            throw new PerfExplorerException(string3, sQLException);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println(arrayIndexOutOfBoundsException.getMessage());
            arrayIndexOutOfBoundsException.printStackTrace();
            PerfExplorerOutput.println("\ncurrentFunction: " + n6);
            PerfExplorerOutput.println("functionIndex: " + n7);
            PerfExplorerOutput.println("rowIndex: " + n8);
            PerfExplorerOutput.println("threadIndex: " + n9);
            System.exit(1);
        }
        PerfExplorerOutput.println(" Done!");
        return rawDataInterface;
    }

    public static String shortName(String string) {
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "[");
        try {
            string2 = stringTokenizer.nextToken();
            if (string2.length() < string.length()) {
                string2 = string2.trim() + "()";
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            string2 = string;
        }
        stringTokenizer = new StringTokenizer(string, "(");
        try {
            string2 = stringTokenizer.nextToken();
            if (string2.length() < string.length()) {
                string2 = string2.trim() + "()";
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            string2 = string;
        }
        return string2;
    }
}

