/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.server;

import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.DBDataSource;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Database;
import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.DatabaseException;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.View;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfdmf.taudb.TAUdbDataSource;
import edu.uoregon.tau.perfdmf.taudb.TAUdbDatabaseAPI;
import edu.uoregon.tau.perfexplorer.common.AnalysisType;
import edu.uoregon.tau.perfexplorer.common.ChartDataType;
import edu.uoregon.tau.perfexplorer.common.ChartType;
import edu.uoregon.tau.perfexplorer.common.Configure;
import edu.uoregon.tau.perfexplorer.common.ConfigureFiles;
import edu.uoregon.tau.perfexplorer.common.PerfExplorerException;
import edu.uoregon.tau.perfexplorer.common.PerfExplorerOutput;
import edu.uoregon.tau.perfexplorer.common.RMIChartData;
import edu.uoregon.tau.perfexplorer.common.RMICubeData;
import edu.uoregon.tau.perfexplorer.common.RMIGeneralChartData;
import edu.uoregon.tau.perfexplorer.common.RMIPerfExplorer;
import edu.uoregon.tau.perfexplorer.common.RMIPerfExplorerModel;
import edu.uoregon.tau.perfexplorer.common.RMIPerformanceResults;
import edu.uoregon.tau.perfexplorer.common.RMISortableIntervalEvent;
import edu.uoregon.tau.perfexplorer.common.RMIVarianceData;
import edu.uoregon.tau.perfexplorer.constants.Constants;
import edu.uoregon.tau.perfexplorer.server.ChartData;
import edu.uoregon.tau.perfexplorer.server.GeneralChartData;
import edu.uoregon.tau.perfexplorer.server.PerfDMFGeneralChartData;
import edu.uoregon.tau.perfexplorer.server.QueryManager;
import edu.uoregon.tau.perfexplorer.server.TimerThread;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerfExplorerServer
extends UnicastRemoteObject
implements RMIPerfExplorer {
    private static final long serialVersionUID = 6257362740066518307L;
    private static String USAGE = "Usage: PerfExplorerClient [{-h,--help}] {-c,--configfile}=<config_file> [{-p,--port}=<port_number>]\n ";
    private DatabaseAPI session = null;
    private List<DatabaseAPI> sessions = new ArrayList<DatabaseAPI>();
    private List<String> configNames = new ArrayList<String>();
    private List<String> sessionStrings = new ArrayList<String>();
    private List<Integer> schemaVersions = new ArrayList<Integer>();
    private List<Boolean> connected = new ArrayList<Boolean>();
    private List<String> actualConfigFiles = new ArrayList<String>();
    private List<Queue<RMIPerfExplorerModel>> requestQueues = new ArrayList<Queue<RMIPerfExplorerModel>>();
    private List<Thread> timerThreads = new ArrayList<Thread>();
    private List<TimerThread> timers = new ArrayList<TimerThread>();
    private static PerfExplorerServer theServer = null;
    private String configFile;
    private String tauHome = "";
    private String tauArch = "";

    public static PerfExplorerServer getServer() {
        return theServer;
    }

    public DatabaseAPI getSession() {
        return this.session;
    }

    public DatabaseAPI getSession(Database database) {
        if (database == null) {
            return null;
        }
        for (DatabaseAPI databaseAPI : this.sessions) {
            if (databaseAPI == null || databaseAPI.getDb().getDatabase().getID() != database.getID()) continue;
            return databaseAPI;
        }
        return null;
    }

    public static PerfExplorerServer getServer(String string, String string2, String string3) {
        try {
            File file;
            if (theServer == null) {
                theServer = new PerfExplorerServer(string, 0, false, string2, string3);
            }
            if (!(file = new File(Constants.TMPDIR)).exists()) {
                System.out.println("Temporary directory not found, creating " + Constants.TMPDIR);
                boolean bl = file.mkdirs();
                if (bl) {
                    System.out.println("Created " + Constants.TMPDIR);
                } else {
                    System.err.println("Failed to create " + Constants.TMPDIR);
                }
            }
        }
        catch (Exception exception) {
            System.err.println("getServer exception: " + exception.getMessage());
            exception.printStackTrace();
        }
        return theServer;
    }

    @Override
    public void resetServer() {
        String string = PerfExplorerServer.theServer.configFile;
        String string2 = PerfExplorerServer.theServer.tauHome;
        String string3 = PerfExplorerServer.theServer.tauArch;
        theServer = null;
        PerfExplorerServer.getServer(string, string2, string3);
    }

    public static void hardResetServer() {
        theServer = null;
    }

    private PerfExplorerServer(String string, int n, boolean bl, String string2, String string3) throws RemoteException {
        super(n);
        this.configFile = string;
        this.tauHome = string2;
        this.tauArch = string3;
        PerfExplorerOutput.setQuiet(bl);
        theServer = this;
        boolean bl2 = false;
        List<String> list = ConfigureFiles.getConfigurationNames();
        if (string != null && string.equals("NONE")) {
            list = new ArrayList<String>();
            bl2 = true;
        } else if (string != null && string.length() > 0) {
            list = new ArrayList<String>();
            list.add(string);
            this.addWorkingDatabase(list);
        } else {
            this.addWorkingDatabase(list);
        }
        for (String string4 : list) {
            if (string4.contains("NO_DATABASE")) break;
            this.connectToDatabase(string4, bl2, -1);
        }
    }

    private void connectToDatabase(String string, boolean bl, int n) {
        String string2 = System.getProperty("user.home");
        String string3 = System.getProperty("file.separator");
        String string4 = string2 + string3 + ".ParaProf" + string3 + "perfdmf.cfg.";
        string4 = string4.replaceAll("\\\\", "\\\\\\\\");
        try {
            DatabaseAPI databaseAPI = new DatabaseAPI();
            String string5 = string.replaceAll(string4, "");
            if (!new File(string).exists()) {
                string = string4 + string;
            }
            if (bl) {
                PerfExplorerOutput.print("Connecting...");
                databaseAPI.initialize(string, false);
                if (databaseAPI.db().getSchemaVersion() > 0) {
                    databaseAPI = new TAUdbDatabaseAPI(databaseAPI);
                }
                PerfExplorerOutput.println(" Connected to " + databaseAPI.db().getConnectString() + ".");
                LinkedList linkedList = new LinkedList();
                TimerThread timerThread = new TimerThread(this, databaseAPI, n < 0 ? this.sessions.size() : n);
                Thread thread = new Thread(timerThread);
                if (n < 0) {
                    this.sessions.add(databaseAPI);
                    this.connected.add(true);
                    this.configNames.add(string5);
                    this.sessionStrings.add(databaseAPI.db().getConnectString());
                    this.schemaVersions.add(databaseAPI.db().getSchemaVersion());
                    this.session = databaseAPI;
                    this.actualConfigFiles.add(string);
                    this.requestQueues.add(linkedList);
                    this.timers.add(timerThread);
                    this.timerThreads.add(thread);
                } else {
                    this.sessions.set(n, databaseAPI);
                    this.connected.set(n, true);
                    this.configNames.set(n, string5);
                    this.sessionStrings.set(n, databaseAPI.db().getConnectString());
                    this.schemaVersions.set(n, databaseAPI.db().getSchemaVersion());
                    this.session = databaseAPI;
                    this.requestQueues.set(n, linkedList);
                    this.timers.set(n, timerThread);
                    this.timerThreads.set(n, thread);
                }
                thread.start();
            } else {
                this.sessions.add(null);
                this.connected.add(false);
                this.configNames.add(string5);
                this.sessionStrings.add("jdbc:" + string5);
                this.schemaVersions.add(0);
                this.actualConfigFiles.add(string);
                this.requestQueues.add(null);
                this.timers.add(null);
                this.timerThreads.add(null);
            }
        }
        catch (Exception exception) {
            if (exception instanceof FileNotFoundException) {
                System.err.println(exception.getMessage());
            }
            System.err.println("Error connecting to " + string + "!");
            System.err.println(exception.getMessage());
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\nPlease make sure that your DBMS is ");
            stringBuilder.append("configured correctly, and the database ");
            stringBuilder.append("has been created.");
            stringBuilder.append("\nSee the PerfExplorer and/or PerfDMF");
            stringBuilder.append("configuration utilities for details.\n");
            System.err.println(stringBuilder.toString());
            exception.printStackTrace();
        }
    }

    private void addWorkingDatabase(List<String> list) {
        String string = System.getProperty("user.home") + File.separator + ".ParaProf" + File.separator + "perfdmf.cfg." + "perfexplorer_working";
        list.remove(string);
        File file = new File(string);
        if (!file.exists() && this.tauHome != null && this.tauArch != null && this.tauHome.length() > 0 && this.tauArch.length() > 0) {
            try {
                System.out.println("Default working database does not exist, creating...");
                String string2 = System.getProperty("user.home") + File.separator + ".ParaProf" + File.separator + "perfexplorer_working";
                edu.uoregon.tau.perfdmf.loader.Configure.createDefault((String)string, (String)this.tauHome, (String)this.tauArch, (String)string2);
                System.out.println("Configuration file " + string + " created.");
                Configure.loadDefaultSchema(string, this.tauHome, this.tauArch);
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        }
        list.add(string);
    }

    @Override
    public String sayHello() {
        PerfExplorerOutput.println("sayHello()...");
        String string = new String("Hello, client - this is server!");
        return string;
    }

    @Override
    public List<Application> getApplicationList() {
        List list = this.session.getApplicationList();
        return list;
    }

    @Override
    public List<Experiment> getExperimentList(int n) {
        this.session.setApplication(n);
        List list = null;
        try {
            list = this.session.getExperimentList();
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
        return list;
    }

    @Override
    public List<Trial> getTrialList(int n, boolean bl) {
        try {
            this.session.setExperiment(n);
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
        List list = this.session.getTrialList(bl);
        return list;
    }

    @Override
    public void stopServer() {
        PerfExplorerOutput.println("stopServer()...");
        for (int i = 0; i < this.timers.size(); ++i) {
            TimerThread timerThread = this.timers.get(i);
            timerThread.cancel();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
    }

    @Override
    public String requestAnalysis(RMIPerfExplorerModel rMIPerfExplorerModel, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            if (!bl && this.checkForRequest(rMIPerfExplorerModel) != 0) {
                throw new PerfExplorerException("Request already exists");
            }
            int n = this.insertRequest(rMIPerfExplorerModel);
            stringBuilder.append("Request " + n + " queued.");
            rMIPerfExplorerModel.setAnalysisID(n);
            stringBuilder.append("\nRequest accepted.");
            Queue<RMIPerfExplorerModel> queue = this.requestQueues.get(rMIPerfExplorerModel.getConnectionIndex());
            queue.offer(rMIPerfExplorerModel);
        }
        catch (PerfExplorerException perfExplorerException) {
            String string = perfExplorerException.getMessage();
            Throwable throwable = perfExplorerException.getCause();
            if (throwable != null) {
                string = string + "\n" + throwable.getMessage();
            }
            return string;
        }
        return stringBuilder.toString();
    }

    @Override
    public RMIPerformanceResults getCorrelationResults(RMIPerfExplorerModel rMIPerfExplorerModel) {
        RMIPerformanceResults rMIPerformanceResults = new RMIPerformanceResults();
        try {
            DB dB = this.getDB();
            PreparedStatement preparedStatement = null;
            if (rMIPerfExplorerModel.getCurrentSelection() instanceof Metric) {
                if (dB.getSchemaVersion() == 0) {
                    preparedStatement = dB.prepareStatement("select id from analysis_settings where application = ? and experiment = ? and trial = ? and metric = ? and method = ? order by id desc");
                    preparedStatement.setInt(1, rMIPerfExplorerModel.getApplication().getID());
                    preparedStatement.setInt(2, rMIPerfExplorerModel.getExperiment().getID());
                    preparedStatement.setInt(3, rMIPerfExplorerModel.getTrial().getID());
                    preparedStatement.setInt(4, ((Metric)rMIPerfExplorerModel.getCurrentSelection()).getID());
                    preparedStatement.setString(5, AnalysisType.CORRELATION_ANALYSIS.toString());
                } else {
                    preparedStatement = dB.prepareStatement("select id from analysis_settings where trial = ? and metric = ? and method = ? order by id desc");
                    preparedStatement.setInt(1, rMIPerfExplorerModel.getTrial().getID());
                    preparedStatement.setInt(2, ((Metric)rMIPerfExplorerModel.getCurrentSelection()).getID());
                    preparedStatement.setString(3, AnalysisType.CORRELATION_ANALYSIS.toString());
                }
            } else if (dB.getSchemaVersion() == 0) {
                preparedStatement = dB.prepareStatement("select id from analysis_settings where application = ? and experiment = ? and trial = ? and metric is null and method = ? order by id desc");
                preparedStatement.setInt(1, rMIPerfExplorerModel.getApplication().getID());
                preparedStatement.setInt(2, rMIPerfExplorerModel.getExperiment().getID());
                preparedStatement.setInt(3, rMIPerfExplorerModel.getTrial().getID());
                preparedStatement.setString(4, AnalysisType.CORRELATION_ANALYSIS.toString());
            } else {
                preparedStatement = dB.prepareStatement("select id from analysis_settings where trial = ? and metric is null and method = ? order by id desc");
                preparedStatement.setInt(1, rMIPerfExplorerModel.getTrial().getID());
                preparedStatement.setString(2, AnalysisType.CORRELATION_ANALYSIS.toString());
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            int n = 0;
            if (!resultSet.next()) {
                preparedStatement.close();
                return rMIPerformanceResults;
            }
            n = resultSet.getInt(1);
            preparedStatement.close();
            preparedStatement = dB.prepareStatement("select id, description, thumbnail_size, thumbnail, image_size, image, result_type from analysis_result where analysis_settings = ? and result_type = ? order by id asc");
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, Integer.valueOf(ChartType.CORRELATION_SCATTERPLOT.toString()));
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                int n2 = resultSet.getInt(3);
                InputStream inputStream = resultSet.getBinaryStream(4);
                byte[] byArray = new byte[n2];
                inputStream.read(byArray);
                int n3 = resultSet.getInt(5);
                InputStream inputStream2 = resultSet.getBinaryStream(6);
                byte[] byArray2 = new byte[n3];
                inputStream2.read(byArray2);
                rMIPerformanceResults.getDescriptions().add(string2);
                rMIPerformanceResults.getIDs().add(string);
                rMIPerformanceResults.getThumbnails().add(byArray);
                rMIPerformanceResults.getImages().add(byArray2);
            }
        }
        catch (Exception exception) {
            String string = "\nERROR: Couldn't select the analysis settings from the database!";
            System.err.println(string);
            exception.printStackTrace();
        }
        return rMIPerformanceResults;
    }

    @Override
    public RMIPerformanceResults getPerformanceResults(RMIPerfExplorerModel rMIPerfExplorerModel) {
        RMIPerformanceResults rMIPerformanceResults = new RMIPerformanceResults();
        try {
            int n;
            DB dB = this.getDB();
            PreparedStatement preparedStatement = null;
            Object[] objectArray = AnalysisType.getClusterMethods();
            StringBuilder stringBuilder = new StringBuilder();
            for (n = 0; n < objectArray.length; ++n) {
                if (n > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append("?");
            }
            if (rMIPerfExplorerModel.getCurrentSelection() instanceof Metric) {
                if (dB.getSchemaVersion() == 0) {
                    preparedStatement = dB.prepareStatement("select id from analysis_settings where application = ? and experiment = ? and trial = ? and metric = ? and method in (" + stringBuilder.toString() + ") order by id desc");
                    preparedStatement.setInt(1, rMIPerfExplorerModel.getApplication().getID());
                    preparedStatement.setInt(2, rMIPerfExplorerModel.getExperiment().getID());
                    preparedStatement.setInt(3, rMIPerfExplorerModel.getTrial().getID());
                    preparedStatement.setInt(4, ((Metric)rMIPerfExplorerModel.getCurrentSelection()).getID());
                    for (n = 0; n < objectArray.length; ++n) {
                        preparedStatement.setString(5 + n, objectArray[n].toString());
                    }
                } else {
                    preparedStatement = dB.prepareStatement("select id from analysis_settings where trial = ? and metric = ? and method in (" + stringBuilder.toString() + ") order by id desc");
                    preparedStatement.setInt(1, rMIPerfExplorerModel.getTrial().getID());
                    preparedStatement.setInt(2, ((Metric)rMIPerfExplorerModel.getCurrentSelection()).getID());
                    for (n = 0; n < objectArray.length; ++n) {
                        preparedStatement.setString(3 + n, objectArray[n].toString());
                    }
                }
            } else if (dB.getSchemaVersion() == 0) {
                preparedStatement = dB.prepareStatement("select id from analysis_settings where application = ? and experiment = ? and trial = ? and metric is null and method in (" + stringBuilder.toString() + ") order by id desc");
                preparedStatement.setInt(1, rMIPerfExplorerModel.getApplication().getID());
                preparedStatement.setInt(2, rMIPerfExplorerModel.getExperiment().getID());
                preparedStatement.setInt(3, rMIPerfExplorerModel.getTrial().getID());
                for (n = 0; n < objectArray.length; ++n) {
                    preparedStatement.setString(4 + n, objectArray[n].toString());
                }
            } else {
                preparedStatement = dB.prepareStatement("select id from analysis_settings where trial = ? and metric is null and method in (" + stringBuilder.toString() + ") order by id desc");
                preparedStatement.setInt(1, rMIPerfExplorerModel.getTrial().getID());
                for (n = 0; n < objectArray.length; ++n) {
                    preparedStatement.setString(2 + n, objectArray[n].toString());
                }
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            int n2 = 0;
            if (!resultSet.next()) {
                preparedStatement.close();
                return rMIPerformanceResults;
            }
            n2 = resultSet.getInt(1);
            preparedStatement.close();
            preparedStatement = dB.prepareStatement("select id, description, thumbnail_size, thumbnail, image_size, image, result_type from analysis_result where analysis_settings = ? order by id asc");
            preparedStatement.setInt(1, n2);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                int n3 = resultSet.getInt(3);
                InputStream inputStream = resultSet.getBinaryStream(4);
                byte[] byArray = new byte[n3];
                inputStream.read(byArray);
                int n4 = resultSet.getInt(5);
                InputStream inputStream2 = resultSet.getBinaryStream(6);
                byte[] byArray2 = new byte[n4];
                inputStream2.read(byArray2);
                rMIPerformanceResults.getDescriptions().add(string2);
                rMIPerformanceResults.getIDs().add(string);
                rMIPerformanceResults.getThumbnails().add(byArray);
                rMIPerformanceResults.getImages().add(byArray2);
            }
            preparedStatement.close();
        }
        catch (Exception exception) {
            String string = "\nERROR: Couldn't select the analysis settings from the database!";
            System.err.println(string);
            exception.printStackTrace();
        }
        return rMIPerformanceResults;
    }

    public void taskFinished(int n) {
        Queue<RMIPerfExplorerModel> queue = this.requestQueues.get(n);
        queue.poll();
    }

    public RMIPerfExplorerModel getNextRequest(int n) {
        Queue<RMIPerfExplorerModel> queue = this.requestQueues.get(n);
        RMIPerfExplorerModel rMIPerfExplorerModel = queue.peek();
        return rMIPerfExplorerModel;
    }

    public DB getDB() {
        if (this.session != null) {
            return this.session.db();
        }
        return null;
    }

    public int checkForRequest(RMIPerfExplorerModel rMIPerfExplorerModel) throws PerfExplorerException {
        int n = 0;
        try {
            DB dB = this.getDB();
            PreparedStatement preparedStatement = null;
            int n2 = 1;
            if (dB.getSchemaVersion() == 0) {
                preparedStatement = dB.prepareStatement("select id from analysis_settings where application = ? and experiment = ? and trial = ? and metric = ? and method = ? and dimension_reduction = ? and normalization = ?");
                preparedStatement.setInt(n2++, rMIPerfExplorerModel.getApplication().getID());
                preparedStatement.setInt(n2++, rMIPerfExplorerModel.getExperiment().getID());
            } else {
                preparedStatement = dB.prepareStatement("select id from analysis_settings where trial = ? and metric = ? and method = ? and dimension_reduction = ? and normalization = ?");
            }
            preparedStatement.setInt(n2++, rMIPerfExplorerModel.getTrial().getID());
            preparedStatement.setInt(n2++, ((Metric)rMIPerfExplorerModel.getCurrentSelection()).getID());
            preparedStatement.setString(n2++, rMIPerfExplorerModel.getClusterMethod().toString());
            preparedStatement.setString(n2++, rMIPerfExplorerModel.getDimensionReduction().toString());
            preparedStatement.setString(n2++, rMIPerfExplorerModel.getNormalization().toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            String string = "ERROR: Couldn't select the analysis settings from the database!";
            System.err.println(string);
            sQLException.printStackTrace();
            throw new PerfExplorerException(string, sQLException);
        }
        return n;
    }

    public int insertRequest(RMIPerfExplorerModel rMIPerfExplorerModel) throws PerfExplorerException {
        int n = 0;
        try {
            DB dB = this.getDB();
            PreparedStatement preparedStatement = null;
            int n2 = 1;
            if (dB.getSchemaVersion() == 0) {
                preparedStatement = dB.prepareStatement("insert into analysis_settings (application, experiment, trial, metric, method, dimension_reduction, normalization) values (?, ?, ?, ?, ?, ?, ?)");
                preparedStatement.setInt(n2++, rMIPerfExplorerModel.getApplication().getID());
                preparedStatement.setInt(n2++, rMIPerfExplorerModel.getExperiment().getID());
            } else {
                preparedStatement = dB.prepareStatement("insert into analysis_settings (application, experiment, trial, metric, method, dimension_reduction, normalization) values (null, null, ?, ?, ?, ?, ?)");
            }
            preparedStatement.setInt(n2++, rMIPerfExplorerModel.getTrial().getID());
            if (rMIPerfExplorerModel.getCurrentSelection() instanceof Metric) {
                preparedStatement.setInt(n2++, ((Metric)rMIPerfExplorerModel.getCurrentSelection()).getID());
            } else {
                preparedStatement.setNull(n2++, 4);
            }
            preparedStatement.setString(n2++, rMIPerfExplorerModel.getClusterMethod().toString());
            preparedStatement.setString(n2++, rMIPerfExplorerModel.getDimensionReduction().toString());
            preparedStatement.setString(n2++, rMIPerfExplorerModel.getNormalization().toString());
            preparedStatement.execute();
            preparedStatement.close();
            String string = new String();
            string = dB.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (dB.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM analysis_settings" : (dB.getDBType().compareTo("derby") == 0 ? "select IDENTITY_VAL_LOCAL() FROM analysis_settings" : (dB.getDBType().compareTo("h2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM analysis_settings" : (dB.getDBType().compareTo("oracle") == 0 ? "SELECT as_id_seq.currval FROM DUAL" : "select currval('analysis_settings_id_seq');"))));
            n = Integer.parseInt(dB.getDataItem(string));
        }
        catch (SQLException sQLException) {
            String string = "ERROR: Couldn't insert the analysis settings into the database!\nPlease make sure that the analysis_settings and analysis_results tables\nhave been created in the database.";
            System.err.println(string);
            sQLException.printStackTrace();
            throw new PerfExplorerException(string, sQLException);
        }
        return n;
    }

    @Override
    public RMIChartData requestChartData(RMIPerfExplorerModel rMIPerfExplorerModel, ChartDataType chartDataType) {
        ChartData chartData = ChartData.getChartData(rMIPerfExplorerModel, chartDataType);
        return chartData;
    }

    @Override
    public RMIGeneralChartData requestGeneralChartData(RMIPerfExplorerModel rMIPerfExplorerModel, ChartDataType chartDataType) {
        GeneralChartData generalChartData = GeneralChartData.getChartData(rMIPerfExplorerModel, chartDataType);
        return generalChartData;
    }

    @Override
    public List<String> getXMLFields(RMIPerfExplorerModel rMIPerfExplorerModel) {
        List<String> list = null;
        list = this.getDB().getSchemaVersion() == 0 ? PerfDMFGeneralChartData.getXMLFields(rMIPerfExplorerModel) : this.getPotentialPrimaryMetadata(rMIPerfExplorerModel);
        return list;
    }

    @Override
    public List<String> getPotentialGroups(RMIPerfExplorerModel rMIPerfExplorerModel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Object object;
            Object object2;
            StringBuilder stringBuilder;
            DB dB = this.getDB();
            if (dB.getSchemaVersion() == 0) {
                stringBuilder = new StringBuilder("select distinct ie.group_name ");
                stringBuilder.append(" from interval_event ie inner join trial t on ie.trial = t.id ");
            } else {
                stringBuilder = new StringBuilder("select distinct tg.group_name ");
                stringBuilder.append(" from timer_group tg inner join timer on tg.timer = timer.id inner join trial t on timer.trial = t.id ");
            }
            Object object3 = rMIPerfExplorerModel.getCurrentSelection();
            if (object3 instanceof View) {
                stringBuilder.append(rMIPerfExplorerModel.getViewSelectionPath(true, true, dB.getDBType(), dB.getSchemaVersion()));
            } else {
                stringBuilder.append(" inner join experiment e on t.experiment = e.id ");
                object2 = rMIPerfExplorerModel.getMultiSelection();
                if (object2 == null) {
                    object = rMIPerfExplorerModel.getCurrentSelection();
                    if (object instanceof Application) {
                        stringBuilder.append(" where e.application = ");
                        stringBuilder.append(rMIPerfExplorerModel.getApplication().getID());
                    } else if (object instanceof Experiment) {
                        stringBuilder.append(" where t.experiment = ");
                        stringBuilder.append(rMIPerfExplorerModel.getExperiment().getID());
                    } else if (object instanceof Trial) {
                        stringBuilder.append(" where t.id = ");
                        stringBuilder.append(rMIPerfExplorerModel.getTrial().getID());
                    }
                } else {
                    Application application;
                    int n;
                    object = rMIPerfExplorerModel.getCurrentSelection();
                    if (object instanceof Application) {
                        stringBuilder.append(" where e.application in (");
                        for (n = 0; n < object2.size(); ++n) {
                            application = (Application)object2.get(n);
                            if (n > 0) {
                                stringBuilder.append(",");
                            }
                            stringBuilder.append(application.getID());
                        }
                        stringBuilder.append(")");
                    } else if (object instanceof Experiment) {
                        stringBuilder.append(" where t.experiment in (");
                        for (n = 0; n < object2.size(); ++n) {
                            application = (Experiment)object2.get(n);
                            if (n > 0) {
                                stringBuilder.append(",");
                            }
                            stringBuilder.append(application.getID());
                        }
                        stringBuilder.append(")");
                    } else if (object instanceof Trial) {
                        stringBuilder.append(" where t.id in (");
                        for (n = 0; n < object2.size(); ++n) {
                            application = (Trial)object2.get(n);
                            if (n > 0) {
                                stringBuilder.append(",");
                            }
                            stringBuilder.append(application.getID());
                        }
                        stringBuilder.append(")");
                    }
                }
            }
            object2 = dB.prepareStatement(stringBuilder.toString());
            object = object2.executeQuery();
            while (object.next()) {
                arrayList.add(object.getString(1));
            }
            object2.close();
        }
        catch (Exception exception) {
            String string = "ERROR: Couldn't select the groups from the database!";
            System.err.println(string);
            exception.printStackTrace();
        }
        return arrayList;
    }

    @Override
    public List<String> getPotentialMetrics(RMIPerfExplorerModel rMIPerfExplorerModel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Object object;
            Object object2;
            DB dB = this.getDB();
            if (dB.getSchemaVersion() > 0) {
                dB.getDatabase().setTAUdb(true);
            } else {
                dB.getDatabase().setTAUdb(false);
            }
            if (dB.getDatabase().isTAUdb()) {
                return this.getPotentialMetricsTAUdb(rMIPerfExplorerModel);
            }
            if (dB.getDBType().compareTo("db2") == 0) {
                stringBuilder.append("select distinct count(cast (m.name as VARCHAR(256))), cast (m.name as VARCHAR(256)) ");
            } else {
                stringBuilder.append("select distinct count(m.name), m.name ");
            }
            stringBuilder.append(" from metric m inner join trial t on m.trial = t.id ");
            Object object3 = rMIPerfExplorerModel.getCurrentSelection();
            if (object3 instanceof View) {
                stringBuilder.append(rMIPerfExplorerModel.getViewSelectionPath(true, true, dB.getDBType(), dB.getSchemaVersion()));
            } else {
                if (dB.getSchemaVersion() == 0) {
                    stringBuilder.append(" inner join experiment e on t.experiment = e.id ");
                }
                if ((object2 = rMIPerfExplorerModel.getMultiSelection()) == null) {
                    object = rMIPerfExplorerModel.getCurrentSelection();
                    if (object instanceof Application) {
                        stringBuilder.append(" where e.application = ");
                        stringBuilder.append(rMIPerfExplorerModel.getApplication().getID());
                    } else if (object instanceof Experiment) {
                        stringBuilder.append(" where t.experiment = ");
                        stringBuilder.append(rMIPerfExplorerModel.getExperiment().getID());
                    } else if (object instanceof Trial) {
                        stringBuilder.append(" where t.id = ");
                        stringBuilder.append(rMIPerfExplorerModel.getTrial().getID());
                    }
                } else {
                    Application application;
                    int n;
                    object = rMIPerfExplorerModel.getCurrentSelection();
                    if (object instanceof Application) {
                        stringBuilder.append(" where e.application in (");
                        for (n = 0; n < object2.size(); ++n) {
                            application = (Application)object2.get(n);
                            if (n > 0) {
                                stringBuilder.append(",");
                            }
                            stringBuilder.append(application.getID());
                        }
                        stringBuilder.append(")");
                    } else if (object instanceof Experiment) {
                        stringBuilder.append(" where t.experiment in (");
                        for (n = 0; n < object2.size(); ++n) {
                            application = (Experiment)object2.get(n);
                            if (n > 0) {
                                stringBuilder.append(",");
                            }
                            stringBuilder.append(application.getID());
                        }
                        stringBuilder.append(")");
                    } else if (object instanceof Trial) {
                        stringBuilder.append(" where t.id in (");
                        for (n = 0; n < object2.size(); ++n) {
                            application = (Trial)object2.get(n);
                            if (n > 0) {
                                stringBuilder.append(",");
                            }
                            stringBuilder.append(application.getID());
                        }
                        stringBuilder.append(")");
                    }
                }
            }
            if (dB.getDBType().compareTo("db2") == 0) {
                stringBuilder.append(" group by cast (m.name as VARCHAR(256)) order by 1 desc");
            } else if (dB.getDBType().compareTo("mysql") == 0) {
                stringBuilder.append(" group by 2 order by 1 desc");
            } else {
                stringBuilder.append(" group by m.name order by count(m.name) desc");
            }
            object2 = dB.prepareStatement(stringBuilder.toString());
            object = object2.executeQuery();
            while (object.next()) {
                arrayList.add(object.getString(2));
            }
            object.close();
            object2.close();
        }
        catch (Exception exception) {
            String string = "ERROR: Couldn't select the metrics from the database!";
            System.err.println(string);
            System.err.println(stringBuilder.toString());
            exception.printStackTrace();
        }
        return arrayList;
    }

    private List<String> getPotentialMetricsTAUdb(RMIPerfExplorerModel rMIPerfExplorerModel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Object object;
            List<Object> list;
            DB dB = this.getDB();
            if (dB.getDBType().compareTo("db2") == 0) {
                stringBuilder.append("select distinct count(cast (m.name as VARCHAR(256))), cast (m.name as VARCHAR(256)) ");
            } else {
                stringBuilder.append("select distinct count(m.name), m.name ");
            }
            stringBuilder.append(" from metric m inner join trial t on m.trial = t.id ");
            Object object2 = rMIPerfExplorerModel.getCurrentSelection();
            if (object2 instanceof View) {
                stringBuilder.append(rMIPerfExplorerModel.getViewSelectionPath(false, false, dB.getDBType(), dB.getSchemaVersion()));
            } else {
                list = rMIPerfExplorerModel.getMultiSelection();
                if (list == null) {
                    object = rMIPerfExplorerModel.getCurrentSelection();
                    if (object instanceof Trial) {
                        stringBuilder.append(" where t.id = ");
                        stringBuilder.append(rMIPerfExplorerModel.getTrial().getID());
                    }
                } else {
                    object = rMIPerfExplorerModel.getCurrentSelection();
                    if (object instanceof Trial) {
                        stringBuilder.append(" where t.id in (");
                        for (int i = 0; i < list.size(); ++i) {
                            Trial trial = (Trial)list.get(i);
                            if (i > 0) {
                                stringBuilder.append(",");
                            }
                            stringBuilder.append(trial.getID());
                        }
                        stringBuilder.append(")");
                    }
                }
            }
            if (dB.getDBType().compareTo("db2") == 0) {
                stringBuilder.append(" group by cast (m.name as VARCHAR(256)) order by 1 desc");
            } else if (dB.getDBType().compareTo("mysql") == 0) {
                stringBuilder.append(" group by 2 order by 1 desc");
            } else {
                stringBuilder.append(" group by m.name order by count(m.name) desc");
            }
            list = dB.prepareStatement(stringBuilder.toString());
            object = list.executeQuery();
            while (object.next()) {
                arrayList.add(object.getString(2));
            }
            object.close();
            list.close();
        }
        catch (Exception exception) {
            String string = "ERROR: Couldn't select the metrics from the database!";
            System.err.println(string);
            System.err.println(stringBuilder.toString());
            exception.printStackTrace();
        }
        return arrayList;
    }

    @Override
    public List<String> getPotentialCallPathEvents(RMIPerfExplorerModel rMIPerfExplorerModel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Object object;
            Object object2;
            DB dB = this.getDB();
            if (dB.getSchemaVersion() > 0) {
                return this.getPotentialCallPathEventsTAUdb(rMIPerfExplorerModel);
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (dB.getDBType().compareTo("db2") == 0) {
                stringBuilder.append("select distinct cast (m.name as VARCHAR(256))");
            } else {
                stringBuilder.append("select distinct ie.name ");
            }
            if (dB.getSchemaVersion() == 0) {
                stringBuilder.append(" from interval_event ie inner join trial t on ie.trial = t.id ");
            } else {
                stringBuilder.append(" from timer ie inner join trial t on ie.trial = t.id ");
                stringBuilder.append("inner join timer_callpath tcp on tcp.timer = ie.id and tcp.parent is not null ");
            }
            Object object3 = rMIPerfExplorerModel.getCurrentSelection();
            if (object3 instanceof View) {
                stringBuilder.append(rMIPerfExplorerModel.getViewSelectionPath(true, true, dB.getDBType(), dB.getSchemaVersion()));
            } else {
                if (dB.getSchemaVersion() == 0) {
                    stringBuilder.append(" inner join experiment e on t.experiment = e.id ");
                }
                if ((object2 = rMIPerfExplorerModel.getMultiSelection()) == null) {
                    object = rMIPerfExplorerModel.getCurrentSelection();
                    if (object instanceof Application) {
                        stringBuilder.append(" where e.application = ");
                        stringBuilder.append(rMIPerfExplorerModel.getApplication().getID());
                    } else if (object instanceof Experiment) {
                        stringBuilder.append(" where t.experiment = ");
                        stringBuilder.append(rMIPerfExplorerModel.getExperiment().getID());
                    } else if (object instanceof Trial) {
                        stringBuilder.append(" where t.id = ");
                        stringBuilder.append(rMIPerfExplorerModel.getTrial().getID());
                    }
                } else {
                    Application application;
                    int n;
                    object = rMIPerfExplorerModel.getCurrentSelection();
                    if (object instanceof Application) {
                        stringBuilder.append(" where e.application in (");
                        for (n = 0; n < object2.size(); ++n) {
                            application = (Application)object2.get(n);
                            if (n > 0) {
                                stringBuilder.append(",");
                            }
                            stringBuilder.append(application.getID());
                        }
                        stringBuilder.append(")");
                    } else if (object instanceof Experiment) {
                        stringBuilder.append(" where t.experiment in (");
                        for (n = 0; n < object2.size(); ++n) {
                            application = (Experiment)object2.get(n);
                            if (n > 0) {
                                stringBuilder.append(",");
                            }
                            stringBuilder.append(application.getID());
                        }
                        stringBuilder.append(")");
                    } else if (object instanceof Trial) {
                        stringBuilder.append(" where t.id in (");
                        for (n = 0; n < object2.size(); ++n) {
                            application = (Trial)object2.get(n);
                            if (n > 0) {
                                stringBuilder.append(",");
                            }
                            stringBuilder.append(application.getID());
                        }
                        stringBuilder.append(")");
                    }
                }
            }
            if (dB.getSchemaVersion() == 0) {
                stringBuilder.append(" and (group_name is null or group_name like '%TAU_CALLPATH%') ");
            }
            object2 = dB.prepareStatement(stringBuilder.toString());
            object = object2.executeQuery();
            while (object.next()) {
                arrayList.add(object.getString(1));
            }
            object2.close();
        }
        catch (Exception exception) {
            String string = "ERROR: Couldn't select the events from the database!";
            System.err.println(string);
            exception.printStackTrace();
        }
        return arrayList;
    }

    public List<String> getPotentialCallPathEventsTAUdb(RMIPerfExplorerModel rMIPerfExplorerModel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Object object;
            DB dB = this.getDB();
            Set set = null;
            List<Object> list = rMIPerfExplorerModel.getMultiSelection();
            if (list == null) {
                object = rMIPerfExplorerModel.getCurrentSelection();
                if (object instanceof Trial) {
                    set = TAUdbDatabaseAPI.getCallDataMap((int)rMIPerfExplorerModel.getTrial().getID(), (DB)dB).keySet();
                }
            } else {
                object = rMIPerfExplorerModel.getCurrentSelection();
                if (object instanceof Trial) {
                    Object object2 = new ArrayList();
                    for (int i = 0; i < list.size(); ++i) {
                        ((ArrayList)object2).add(((Trial)list.get(i)).getID());
                    }
                    set = TAUdbDatabaseAPI.getCallDataMap((List)object2, (DB)dB).keySet();
                }
            }
            for (Object object2 : set) {
                arrayList.add((String)object2);
            }
        }
        catch (Exception exception) {
            String string = "ERROR: Couldn't select the events from the database!";
            System.err.println(string);
            exception.printStackTrace();
        }
        return arrayList;
    }

    @Override
    public List<String> getPotentialEvents(RMIPerfExplorerModel rMIPerfExplorerModel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Object object;
            Object object2;
            DB dB = this.getDB();
            StringBuilder stringBuilder = new StringBuilder();
            if (dB.getDBType().compareTo("db2") == 0) {
                stringBuilder.append("select distinct cast (m.name as VARCHAR(256))");
            } else {
                stringBuilder.append("select distinct ie.name ");
            }
            if (dB.getSchemaVersion() == 0) {
                stringBuilder.append(" from interval_event ie inner join trial t on ie.trial = t.id ");
            } else {
                stringBuilder.append(" from timer ie inner join trial t on ie.trial = t.id ");
                stringBuilder.append("inner join timer_callpath tcp on tcp.timer = ie.id and tcp.parent is null ");
            }
            Object object3 = rMIPerfExplorerModel.getCurrentSelection();
            if (object3 instanceof View) {
                stringBuilder.append(rMIPerfExplorerModel.getViewSelectionPath(true, true, dB.getDBType(), dB.getSchemaVersion()));
            } else {
                if (dB.getSchemaVersion() == 0) {
                    stringBuilder.append(" inner join experiment e on t.experiment = e.id ");
                }
                if ((object2 = rMIPerfExplorerModel.getMultiSelection()) == null) {
                    object = rMIPerfExplorerModel.getCurrentSelection();
                    if (object instanceof Application) {
                        stringBuilder.append(" where e.application = ");
                        stringBuilder.append(rMIPerfExplorerModel.getApplication().getID());
                    } else if (object instanceof Experiment) {
                        stringBuilder.append(" where t.experiment = ");
                        stringBuilder.append(rMIPerfExplorerModel.getExperiment().getID());
                    } else if (object instanceof Trial) {
                        stringBuilder.append(" where t.id = ");
                        stringBuilder.append(rMIPerfExplorerModel.getTrial().getID());
                    }
                } else {
                    Application application;
                    int n;
                    object = rMIPerfExplorerModel.getCurrentSelection();
                    if (object instanceof Application) {
                        stringBuilder.append(" where e.application in (");
                        for (n = 0; n < object2.size(); ++n) {
                            application = (Application)object2.get(n);
                            if (n > 0) {
                                stringBuilder.append(",");
                            }
                            stringBuilder.append(application.getID());
                        }
                        stringBuilder.append(")");
                    } else if (object instanceof Experiment) {
                        stringBuilder.append(" where t.experiment in (");
                        for (n = 0; n < object2.size(); ++n) {
                            application = (Experiment)object2.get(n);
                            if (n > 0) {
                                stringBuilder.append(",");
                            }
                            stringBuilder.append(application.getID());
                        }
                        stringBuilder.append(")");
                    } else if (object instanceof Trial) {
                        stringBuilder.append(" where t.id in (");
                        for (n = 0; n < object2.size(); ++n) {
                            application = (Trial)object2.get(n);
                            if (n > 0) {
                                stringBuilder.append(",");
                            }
                            stringBuilder.append(application.getID());
                        }
                        stringBuilder.append(")");
                    }
                }
            }
            if (dB.getSchemaVersion() == 0) {
                stringBuilder.append(" and (group_name is null or group_name not like '%TAU_CALLPATH%') ");
            }
            object2 = dB.prepareStatement(stringBuilder.toString());
            object = object2.executeQuery();
            while (object.next()) {
                arrayList.add(object.getString(1));
            }
            object2.close();
        }
        catch (Exception exception) {
            String string = "ERROR: Couldn't select the events from the database!";
            System.err.println(string);
            exception.printStackTrace();
        }
        return arrayList;
    }

    @Override
    public List<String> getPotentialAtomicEvents(RMIPerfExplorerModel rMIPerfExplorerModel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Object object;
            Object object2;
            DB dB = this.getDB();
            StringBuilder stringBuilder = new StringBuilder();
            if (dB.getDBType().compareTo("db2") == 0) {
                stringBuilder.append("select distinct cast (m.name as VARCHAR(256))");
            } else {
                stringBuilder.append("select distinct ae.name ");
            }
            if (dB.getSchemaVersion() == 0) {
                stringBuilder.append(" from atomic_event ae inner join trial t on ae.trial = t.id ");
            } else {
                stringBuilder.append(" from counter ae inner join trial t on ae.trial = t.id ");
            }
            Object object3 = rMIPerfExplorerModel.getCurrentSelection();
            if (object3 instanceof View) {
                stringBuilder.append(rMIPerfExplorerModel.getViewSelectionPath(true, true, dB.getDBType(), dB.getSchemaVersion()));
            } else {
                if (dB.getSchemaVersion() == 0) {
                    stringBuilder.append(" inner join experiment e on t.experiment = e.id ");
                }
                if ((object2 = rMIPerfExplorerModel.getMultiSelection()) == null) {
                    object = rMIPerfExplorerModel.getCurrentSelection();
                    if (object instanceof Application) {
                        stringBuilder.append(" where e.application = ");
                        stringBuilder.append(rMIPerfExplorerModel.getApplication().getID());
                    } else if (object instanceof Experiment) {
                        stringBuilder.append(" where t.experiment = ");
                        stringBuilder.append(rMIPerfExplorerModel.getExperiment().getID());
                    } else if (object instanceof Trial) {
                        stringBuilder.append(" where t.id = ");
                        stringBuilder.append(rMIPerfExplorerModel.getTrial().getID());
                    }
                } else {
                    Application application;
                    int n;
                    object = rMIPerfExplorerModel.getCurrentSelection();
                    if (object instanceof Application) {
                        stringBuilder.append(" where e.application in (");
                        for (n = 0; n < object2.size(); ++n) {
                            application = (Application)object2.get(n);
                            if (n > 0) {
                                stringBuilder.append(",");
                            }
                            stringBuilder.append(application.getID());
                        }
                        stringBuilder.append(")");
                    } else if (object instanceof Experiment) {
                        stringBuilder.append(" where t.experiment in (");
                        for (n = 0; n < object2.size(); ++n) {
                            application = (Experiment)object2.get(n);
                            if (n > 0) {
                                stringBuilder.append(",");
                            }
                            stringBuilder.append(application.getID());
                        }
                        stringBuilder.append(")");
                    } else if (object instanceof Trial) {
                        stringBuilder.append(" where t.id in (");
                        for (n = 0; n < object2.size(); ++n) {
                            application = (Trial)object2.get(n);
                            if (n > 0) {
                                stringBuilder.append(",");
                            }
                            stringBuilder.append(application.getID());
                        }
                        stringBuilder.append(")");
                    }
                }
            }
            object2 = dB.prepareStatement(stringBuilder.toString());
            object = object2.executeQuery();
            while (object.next()) {
                arrayList.add(object.getString(1));
            }
            object2.close();
        }
        catch (Exception exception) {
            String string = "ERROR: Couldn't select the events from the database!";
            System.err.println(string);
            exception.printStackTrace();
        }
        return arrayList;
    }

    public List<String> getPotentialPrimaryMetadata(RMIPerfExplorerModel rMIPerfExplorerModel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Object object;
            List<Object> list;
            DB dB = this.getDB();
            StringBuilder stringBuilder = new StringBuilder();
            if (dB.getDBType().compareTo("db2") == 0) {
                stringBuilder.append("select distinct cast (name as VARCHAR(256))");
            } else {
                stringBuilder.append("select distinct pm.name ");
            }
            stringBuilder.append(" from primary_metadata pm left outer join trial t on pm.trial = t.id ");
            Object object2 = rMIPerfExplorerModel.getCurrentSelection();
            if (object2 instanceof View) {
                stringBuilder.append(rMIPerfExplorerModel.getViewSelectionPath(true, true, dB.getDBType(), dB.getSchemaVersion()));
            } else {
                list = rMIPerfExplorerModel.getMultiSelection();
                if (list == null) {
                    object = rMIPerfExplorerModel.getCurrentSelection();
                    if (object instanceof Trial) {
                        stringBuilder.append(" where t.id = ");
                        stringBuilder.append(rMIPerfExplorerModel.getTrial().getID());
                    }
                } else {
                    object = rMIPerfExplorerModel.getCurrentSelection();
                    if (object instanceof Trial) {
                        stringBuilder.append(" where t.id in (");
                        for (int i = 0; i < list.size(); ++i) {
                            Trial trial = (Trial)list.get(i);
                            if (i > 0) {
                                stringBuilder.append(",");
                            }
                            stringBuilder.append(trial.getID());
                        }
                        stringBuilder.append(")");
                    }
                }
            }
            stringBuilder.append(" order by name asc ");
            list = dB.prepareStatement(stringBuilder.toString());
            object = list.executeQuery();
            while (object.next()) {
                arrayList.add(object.getString(1));
            }
            list.close();
        }
        catch (Exception exception) {
            String string = "ERROR: Couldn't select the events from the database!";
            System.err.println(string);
            exception.printStackTrace();
        }
        return arrayList;
    }

    @Override
    public String[] getMetaData(String string) {
        String[] stringArray = null;
        try {
            if (string.equalsIgnoreCase("application")) {
                stringArray = Application.getFieldNames((DB)this.getDB());
            } else if (string.equalsIgnoreCase("experiment")) {
                stringArray = Experiment.getFieldNames((DB)this.getDB());
            } else if (string.equalsIgnoreCase("trial")) {
                stringArray = Trial.getFieldNames((DB)this.getDB());
            }
        }
        catch (Exception exception) {
            String string2 = "ERROR: Couldn't select the columns from the database!";
            System.err.println(string2);
            exception.printStackTrace();
        }
        return stringArray;
    }

    @Override
    public List<String> getPossibleValues(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            DB dB = this.getDB();
            StringBuilder stringBuilder = new StringBuilder("select distinct ");
            if (dB.getDBType().compareTo("db2") == 0) {
                stringBuilder.append("cast (");
                stringBuilder.append(string2);
                stringBuilder.append(" as varchar(256))");
            } else {
                stringBuilder.append(string2);
            }
            stringBuilder.append(" from ");
            stringBuilder.append(string.toLowerCase());
            PreparedStatement preparedStatement = dB.prepareStatement(stringBuilder.toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
            preparedStatement.close();
        }
        catch (Exception exception) {
            String string3 = "ERROR: Couldn't select the potential values from the database!";
            System.err.println(string3);
            exception.printStackTrace();
        }
        return arrayList;
    }

    @Override
    public int createNewView(String string, int n, String string2, String string3, String string4, String string5) {
        int n2 = 0;
        try {
            DB dB = this.getDB();
            PreparedStatement preparedStatement = null;
            preparedStatement = n > 0 ? dB.prepareStatement("insert into trial_view (name, table_name, column_name, operator, value, parent) values (?, ?, ?, ?, ?, ?)") : dB.prepareStatement("insert into trial_view (name, table_name, column_name, operator, value) values (?, ?, ?, ?, ?)");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            preparedStatement.setString(3, string3);
            preparedStatement.setString(4, string4);
            preparedStatement.setString(5, string5);
            if (n > 0) {
                preparedStatement.setInt(6, n);
            }
            preparedStatement.execute();
            preparedStatement.close();
            String string6 = new String();
            string6 = dB.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (dB.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM trial_view" : (dB.getDBType().compareTo("derby") == 0 ? "select IDENTITY_VAL_LOCAL() FROM trial_view" : (dB.getDBType().compareTo("h2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM trial_view" : (dB.getDBType().compareTo("oracle") == 0 ? "SELECT " + dB.getSchemaPrefix() + "tv_id_seq.currval FROM DUAL" : "select currval('trial_view_id_seq');"))));
            n2 = Integer.parseInt(dB.getDataItem(string6));
        }
        catch (Exception exception) {
            String string7 = "ERROR: Couldn't select the columns from the database!";
            System.err.println(string7);
            exception.printStackTrace();
        }
        return n2;
    }

    @Override
    public void deleteView(String string) {
        try {
            DB dB = this.getDB();
            PreparedStatement preparedStatement = null;
            preparedStatement = dB.prepareStatement("delete from trial_view where id = ?");
            preparedStatement.setString(1, string);
            preparedStatement.execute();
            preparedStatement.close();
        }
        catch (Exception exception) {
            String string2 = "ERROR: Couldn't delete the view from the database!";
            System.err.println(string2);
            exception.printStackTrace();
        }
    }

    @Override
    public List<View> getViews(int n) {
        DB dB = this.getDB();
        return View.getViews((int)n, (DB)dB);
    }

    public List<View> getAllSubViews(int n) {
        DB dB = this.getDB();
        List list = View.getViews((int)n, (DB)dB);
        ListIterator<View> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            View view = (View)listIterator.next();
            List<View> list2 = this.getAllSubViews(view.getID());
            for (View view2 : list2) {
                view2.setParent(view);
                listIterator.add(view2);
            }
        }
        return list;
    }

    @Override
    public List<Trial> getTrialsForView(List<View> list, boolean bl) {
        DB dB = this.getDB();
        return View.getTrialsForView(list, (boolean)bl, (DB)dB);
    }

    public List<Trial> getTrialsForTAUdbView(List<View> list) {
        return this.getTrialsForTAUdbView(list, false);
    }

    public List<Trial> getTrialsForTAUdbView(List<View> list, boolean bl) {
        DB dB = this.getDB();
        return View.getTrialsForTAUdbView(list, (DB)dB, (boolean)bl);
    }

    @Override
    public RMIVarianceData getVariationAnalysis(RMIPerfExplorerModel rMIPerfExplorerModel) {
        RMIVarianceData rMIVarianceData = new RMIVarianceData();
        try {
            DB dB = this.getDB();
            PreparedStatement preparedStatement = null;
            StringBuilder stringBuilder = new StringBuilder();
            if (dB.getDBType().compareTo("oracle") == 0) {
                stringBuilder.append("select ie.name, ");
                stringBuilder.append("avg(ilp.excl), ");
                stringBuilder.append("avg(ilp.exclusive_percentage), ");
                stringBuilder.append("avg(ilp.call), ");
                stringBuilder.append("avg(ilp.excl / ilp.call), ");
                stringBuilder.append("max(ilp.excl), ");
                stringBuilder.append("min(ilp.excl), ");
                stringBuilder.append("stddev(ilp.excl) ");
            } else if (dB.getDBType().compareTo("derby") == 0) {
                stringBuilder.append("select ie.name, ");
                stringBuilder.append("avg(ilp.exclusive), ");
                stringBuilder.append("avg(ilp.exclusive_percentage), ");
                stringBuilder.append("avg(ilp.num_calls), ");
                stringBuilder.append("avg(ilp.exclusive / ilp.num_calls), ");
                stringBuilder.append("max(ilp.exclusive), ");
                stringBuilder.append("min(ilp.exclusive), ");
                stringBuilder.append("0 ");
            } else if (dB.getDBType().compareTo("db2") == 0) {
                stringBuilder.append("select cast (ie.name as varchar(256)), ");
                stringBuilder.append("avg(ilp.exclusive), ");
                stringBuilder.append("avg(ilp.exclusive_percentage), ");
                stringBuilder.append("avg(ilp.call), ");
                stringBuilder.append("avg(ilp.exclusive / ilp.call), ");
                stringBuilder.append("max(ilp.exclusive), ");
                stringBuilder.append("min(ilp.exclusive), ");
                stringBuilder.append("stddev(ilp.exclusive) ");
            } else if (dB.getDBType().compareTo("mysql") == 0) {
                stringBuilder.append("select ie.name, ");
                stringBuilder.append("avg(ilp.exclusive), ");
                stringBuilder.append("avg(ilp.exclusive_percentage), ");
                stringBuilder.append("avg(ilp.call), ");
                stringBuilder.append("avg(ilp.exclusive / ilp.`call`), ");
                stringBuilder.append("max(ilp.exclusive), ");
                stringBuilder.append("min(ilp.exclusive), ");
                stringBuilder.append("stddev(ilp.exclusive) ");
            } else {
                stringBuilder.append("select ie.name, ");
                stringBuilder.append("avg(ilp.exclusive), ");
                stringBuilder.append("avg(ilp.exclusive_percentage), ");
                stringBuilder.append("avg(ilp.call), ");
                stringBuilder.append("avg(ilp.exclusive / ilp.call), ");
                stringBuilder.append("max(ilp.exclusive), ");
                stringBuilder.append("min(ilp.exclusive), ");
                stringBuilder.append("stddev(ilp.exclusive) ");
            }
            stringBuilder.append("from interval_location_profile ilp ");
            stringBuilder.append("inner join interval_event ie ");
            stringBuilder.append("on ilp.interval_event = ie.id ");
            stringBuilder.append("where ie.trial = ? and ilp.metric = ? ");
            stringBuilder.append("and (ie.group_name is null ");
            stringBuilder.append("or (ie.group_name not like '%TAU_CALLPATH%' ");
            stringBuilder.append("and group_name not like '%TAU_PHASE%')) ");
            if (dB.getDBType().compareTo("db2") == 0) {
                stringBuilder.append("group by ie.id, cast (ie.name as VARCHAR(256)) order by cast (ie.name as VARCHAR(256)) ");
            } else {
                stringBuilder.append("group by ie.id, ie.name order by ie.name");
            }
            preparedStatement = dB.prepareStatement(stringBuilder.toString());
            preparedStatement.setInt(1, rMIPerfExplorerModel.getTrial().getID());
            Metric metric = (Metric)rMIPerfExplorerModel.getCurrentSelection();
            preparedStatement.setInt(2, metric.getID());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                rMIVarianceData.addEventName(resultSet.getString(1));
                double[] dArray = new double[8];
                dArray[0] = resultSet.getDouble(2);
                dArray[1] = resultSet.getDouble(3);
                dArray[2] = resultSet.getDouble(4);
                dArray[3] = resultSet.getDouble(5);
                dArray[4] = resultSet.getDouble(6);
                dArray[5] = resultSet.getDouble(7);
                String string = resultSet.getString(8);
                if (string == null || string.trim().equalsIgnoreCase("nan") || string.trim().equals("0")) {
                    dArray[6] = 0.0;
                    dArray[7] = 0.0;
                } else {
                    dArray[6] = resultSet.getDouble(8);
                    dArray[7] = dArray[6] / (dArray[4] - dArray[5]) * dArray[1];
                }
                rMIVarianceData.addValues(dArray);
            }
            rMIVarianceData.addValueName("name");
            rMIVarianceData.addValueName("excl");
            rMIVarianceData.addValueName("excl %");
            rMIVarianceData.addValueName("calls");
            rMIVarianceData.addValueName("excl/call");
            rMIVarianceData.addValueName("max");
            rMIVarianceData.addValueName("min");
            rMIVarianceData.addValueName("stddev");
            rMIVarianceData.addValueName("(stddev/range)*%");
            resultSet.close();
            preparedStatement.close();
        }
        catch (Exception exception) {
            String string = "ERROR: Couldn't get variation from the database!";
            System.err.println(string);
            exception.printStackTrace();
        }
        return rMIVarianceData;
    }

    @Override
    public RMICubeData getCubeData(RMIPerfExplorerModel rMIPerfExplorerModel, int n) {
        RMICubeData rMICubeData = null;
        try {
            int n2;
            DB dB = this.getDB();
            PreparedStatement preparedStatement = null;
            StringBuilder stringBuilder = new StringBuilder();
            String string = rMIPerfExplorerModel.getClusterValueType();
            String string2 = "inclusive_percentage";
            if (string == null || string.compareTo("inclusive") != 0) {
                string = dB.getDBType().compareTo("oracle") == 0 ? "excl" : "exclusive";
                string2 = "exclusive_percentage";
            }
            if (dB.getDBType().compareTo("derby") == 0) {
                stringBuilder.append("select interval_event.id, avg(" + string + ") ");
            } else {
                stringBuilder.append("select interval_event.id, stddev(" + string + ") ");
            }
            stringBuilder.append("from interval_location_profile ");
            stringBuilder.append("inner join interval_event ");
            stringBuilder.append("on interval_event = interval_event.id ");
            stringBuilder.append("where trial = ? and metric = ? ");
            stringBuilder.append("and (group_name is null or (");
            stringBuilder.append("group_name not like '%TAU_CALLPATH%' ");
            stringBuilder.append("and group_name not like '%TAU_PHASE%')) ");
            stringBuilder.append("group by interval_event.id ");
            preparedStatement = dB.prepareStatement(stringBuilder.toString());
            preparedStatement.setInt(1, rMIPerfExplorerModel.getTrial().getID());
            Metric metric = (Metric)rMIPerfExplorerModel.getCurrentSelection();
            preparedStatement.setInt(2, metric.getID());
            ResultSet resultSet = preparedStatement.executeQuery();
            StringBuilder stringBuilder2 = new StringBuilder();
            boolean bl = false;
            ArrayList<String> arrayList = new ArrayList<String>();
            while (resultSet.next()) {
                if (resultSet.getString(2) == null || resultSet.getString(2).trim().equalsIgnoreCase("NaN") || resultSet.getString(2).trim().equals("") || resultSet.getString(2).trim().equals("0") || resultSet.getDouble(2) == 0.0) continue;
                if (bl) {
                    stringBuilder2.append(",");
                }
                stringBuilder2.append(resultSet.getString(1));
                bl = true;
                arrayList.add(resultSet.getString(1));
            }
            resultSet.close();
            preparedStatement.close();
            stringBuilder = new StringBuilder();
            if (dB.getDBType().compareTo("db2") == 0) {
                preparedStatement = dB.prepareStatement("declare global temporary table working_table (id int) on commit preserve rows not logged ");
                preparedStatement.execute();
                preparedStatement.close();
                preparedStatement = dB.prepareStatement("insert into SESSION.working_table (id) values (?)");
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    int n3 = Integer.parseInt((String)iterator.next());
                    preparedStatement.setInt(1, n3);
                    preparedStatement.execute();
                }
                preparedStatement.close();
                stringBuilder.append("select interval_event.id, cast (name as varchar(256)), (stddev(" + string + ")/ ");
                stringBuilder.append("(max(" + string + ")-min(" + string + ")))* ");
                stringBuilder.append("avg(" + string2 + ") ");
                stringBuilder.append("from interval_location_profile ");
                stringBuilder.append("inner join interval_event ");
                stringBuilder.append("on interval_event = interval_event.id ");
                stringBuilder.append("inner join SESSION.working_table on ");
                stringBuilder.append("interval_event.id = SESSION.working_table.id ");
                stringBuilder.append("group by interval_event.id, cast (name as varchar(256))");
            } else {
                if (dB.getDBType().compareTo("derby") == 0) {
                    stringBuilder.append("select interval_event.id, name, avg(" + string + ") ");
                } else {
                    stringBuilder.append("select interval_event.id, name, (stddev(" + string + ")/ ");
                    stringBuilder.append("(max(" + string + ")-min(" + string + ")))* ");
                    stringBuilder.append("avg(" + string2 + ") ");
                }
                stringBuilder.append("from interval_location_profile ");
                stringBuilder.append("inner join interval_event ");
                stringBuilder.append("on interval_event = interval_event.id ");
                stringBuilder.append("where interval_event.id in (" + stringBuilder2.toString() + ") ");
                stringBuilder.append("group by interval_event.id, name ");
            }
            stringBuilder.append("order by 3 desc");
            preparedStatement = dB.prepareStatement(stringBuilder.toString());
            resultSet = preparedStatement.executeQuery();
            int n4 = 0;
            int[] nArray = new int[n];
            String[] stringArray = new String[n];
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            while (resultSet.next() && n4 < n) {
                nArray[n4] = resultSet.getInt(1);
                stringArray[n4] = resultSet.getString(2);
                hashMap.put(stringArray[n4], new Integer(n4));
                if (resultSet.getString(3) == null || resultSet.getString(3).trim().equalsIgnoreCase("NaN") || resultSet.getString(3).trim().equals("")) continue;
                ++n4;
            }
            resultSet.close();
            preparedStatement.close();
            if (dB.getDBType().compareTo("db2") == 0) {
                preparedStatement = dB.prepareStatement("drop table SESSION.working_table");
                preparedStatement.execute();
                preparedStatement.close();
            }
            rMICubeData = new RMICubeData(n4);
            rMICubeData.setNames(stringArray);
            stringBuilder = new StringBuilder();
            if (dB.getDBType().compareTo("db2") == 0) {
                stringBuilder.append("select node, context, thread, cast (name as varchar(256)), " + string + " ");
            } else {
                stringBuilder.append("select node, context, thread, name, " + string + " ");
            }
            stringBuilder.append("from interval_location_profile ");
            stringBuilder.append("inner join interval_event ");
            stringBuilder.append("on interval_event = interval_event.id ");
            stringBuilder.append("where interval_event in (");
            stringBuilder.append(nArray[0]);
            for (n2 = 1; n2 < n4; ++n2) {
                stringBuilder.append(", ");
                stringBuilder.append(nArray[n2]);
            }
            stringBuilder.append(") and metric = ? ");
            stringBuilder.append("order by 1, 2, 3, 4");
            preparedStatement = dB.prepareStatement(stringBuilder.toString());
            preparedStatement.setInt(1, metric.getID());
            resultSet = preparedStatement.executeQuery();
            n2 = 0;
            int n5 = 0;
            int n6 = 0;
            float[] fArray = new float[n4];
            while (resultSet.next()) {
                if (n2 != resultSet.getInt(1) || n5 != resultSet.getInt(2) || n6 != resultSet.getInt(3)) {
                    rMICubeData.addValues(fArray);
                    fArray = new float[n4];
                    n2 = resultSet.getInt(1);
                    n5 = resultSet.getInt(2);
                    n6 = resultSet.getInt(3);
                }
                fArray[((Integer)hashMap.get((Object)resultSet.getString((int)4))).intValue()] = resultSet.getFloat(5);
            }
            rMICubeData.addValues(fArray);
            resultSet.close();
            preparedStatement.close();
        }
        catch (Exception exception) {
            String string = "ERROR: Couldn't get variation from the database!";
            System.err.println(string);
            exception.printStackTrace();
        }
        return rMICubeData;
    }

    @Override
    public String getConnectionString() {
        return this.session.db().getConnectString();
    }

    @Override
    public List<Integer> getSchemaVersions() {
        return this.schemaVersions;
    }

    @Override
    public List<String> getConnectionStrings() {
        return this.sessionStrings;
    }

    @Override
    public List<String> getConfigNames() {
        return this.configNames;
    }

    @Override
    public List<RMISortableIntervalEvent> getEventList(int n, int n2) {
        try {
            this.session.setTrial(n, false);
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
        Object object = null;
        object = this.session.getDb().getSchemaVersion() > 0 ? new TAUdbDataSource(this.session) : new DBDataSource(this.session);
        Map map = this.session.getIntervalEvents((DataSource)object, n2);
        ArrayList<RMISortableIntervalEvent> arrayList = new ArrayList<RMISortableIntervalEvent>();
        for (Function function : map.values()) {
            arrayList.add(new RMISortableIntervalEvent(function, n, this.session, n2));
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    @Override
    public List<Trial> getTrialList(String string, boolean bl) {
        return QueryManager.getTrialList(string, bl);
    }

    @Override
    public List<String> getChartFieldNames() {
        DB dB = this.getDB();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (dB != null && dB.getSchemaVersion() == 0) {
            int n;
            String[] stringArray;
            arrayList.add("application.id");
            arrayList.add("application.name");
            if (dB != null) {
                stringArray = Application.getFieldNames((DB)dB);
                for (n = 0; n < stringArray.length; ++n) {
                    arrayList.add("application." + stringArray[n]);
                }
            }
            arrayList.add("experiment.id");
            arrayList.add("experiment.name");
            arrayList.add("experiment.applciation");
            if (dB != null) {
                stringArray = Experiment.getFieldNames((DB)dB);
                for (n = 0; n < stringArray.length; ++n) {
                    arrayList.add("experiment." + stringArray[n]);
                }
            }
            arrayList.add("trial.id");
            arrayList.add("trial.name");
            arrayList.add("trial.experiment");
            if (dB != null) {
                stringArray = Trial.getFieldNames((DB)dB);
                for (n = 0; n < stringArray.length; ++n) {
                    if (stringArray[n].equalsIgnoreCase("XML_METADATA_GZ") || stringArray[n].equalsIgnoreCase("node_count") || stringArray[n].equalsIgnoreCase("contexts_per_node")) continue;
                    if (stringArray[n].equalsIgnoreCase("threads_per_context")) {
                        arrayList.add("trial.threads_of_execution");
                        continue;
                    }
                    arrayList.add("trial." + stringArray[n]);
                }
            }
        } else {
            arrayList.add("trial.id");
            arrayList.add("trial.name");
            if (dB != null) {
                String[] stringArray = Trial.getFieldNames((DB)dB);
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].equalsIgnoreCase("node_count") || stringArray[i].equalsIgnoreCase("contexts_per_node") || stringArray[i].equalsIgnoreCase("data_source") || stringArray[i].equalsIgnoreCase("threads_per_context")) continue;
                    if (stringArray[i].equalsIgnoreCase("total_threads")) {
                        arrayList.add("trial.threads_of_execution");
                        continue;
                    }
                    arrayList.add("trial." + stringArray[i]);
                }
            }
            arrayList.add("primary_metadata.name");
        }
        return arrayList;
    }

    @Override
    public void setConnectionIndex(int n) throws RemoteException {
        this.session = this.sessions.get(n);
    }

    public int getSessionCount() {
        return this.sessions.size();
    }

    @Override
    public Map<String, Integer> checkScalabilityChartData(RMIPerfExplorerModel rMIPerfExplorerModel) throws RemoteException {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Object object;
            Object object2;
            Object object3;
            DB dB = this.getDB();
            if (dB.getSchemaVersion() == 0) {
                stringBuilder.append("select t.id, node_count * contexts_per_node * threads_per_context, t.experiment ");
            } else {
                stringBuilder.append("select t.id, t.total_threads, 0 ");
            }
            stringBuilder.append(" from trial t ");
            Object object4 = rMIPerfExplorerModel.getCurrentSelection();
            if (object4 instanceof View) {
                stringBuilder.append(rMIPerfExplorerModel.getViewSelectionPath(true, true, dB.getDBType(), dB.getSchemaVersion()));
            } else {
                stringBuilder.append(" inner join experiment e on t.experiment = e.id ");
                object3 = rMIPerfExplorerModel.getMultiSelection();
                if (object3 == null) {
                    object2 = rMIPerfExplorerModel.getCurrentSelection();
                    if (object2 instanceof Application) {
                        stringBuilder.append(" where e.application = ");
                        stringBuilder.append(rMIPerfExplorerModel.getApplication().getID());
                    } else if (object2 instanceof Experiment) {
                        stringBuilder.append(" where t.experiment = ");
                        stringBuilder.append(rMIPerfExplorerModel.getExperiment().getID());
                    } else if (object2 instanceof Trial) {
                        stringBuilder.append(" where t.id = ");
                        stringBuilder.append(rMIPerfExplorerModel.getTrial().getID());
                    }
                } else {
                    int n;
                    object2 = rMIPerfExplorerModel.getCurrentSelection();
                    if (object2 instanceof Application) {
                        stringBuilder.append(" where e.application in (");
                        for (n = 0; n < object3.size(); ++n) {
                            object = (Application)object3.get(n);
                            if (n > 0) {
                                stringBuilder.append(",");
                            }
                            stringBuilder.append(object.getID());
                        }
                        stringBuilder.append(")");
                    } else if (object2 instanceof Experiment) {
                        stringBuilder.append(" where t.experiment in (");
                        for (n = 0; n < object3.size(); ++n) {
                            object = (Experiment)object3.get(n);
                            if (n > 0) {
                                stringBuilder.append(",");
                            }
                            stringBuilder.append(object.getID());
                        }
                        stringBuilder.append(")");
                    } else if (object2 instanceof Trial) {
                        stringBuilder.append(" where t.id in (");
                        for (n = 0; n < object3.size(); ++n) {
                            object = (Trial)object3.get(n);
                            if (n > 0) {
                                stringBuilder.append(",");
                            }
                            stringBuilder.append(object.getID());
                        }
                        stringBuilder.append(")");
                    }
                }
            }
            object3 = dB.prepareStatement(stringBuilder.toString());
            object2 = object3.executeQuery();
            while (object2.next()) {
                String string = new String(object2.getString(2) + ":" + object2.getString(3));
                object = (Integer)hashMap.get(string);
                object = object == null ? new Integer(1) : Integer.valueOf((Integer)object + 1);
                hashMap.put(string, (Integer)object);
            }
            object2.close();
            object3.close();
        }
        catch (Exception exception) {
            String string = "ERROR: Couldn't select the thread counts from the database!";
            System.err.println(string);
            System.err.println(stringBuilder.toString());
            exception.printStackTrace();
        }
        return hashMap;
    }

    @Override
    public Map<String, double[][]> getUserEventData(RMIPerfExplorerModel rMIPerfExplorerModel) throws RemoteException {
        HashMap<String, double[][]> hashMap = new HashMap<String, double[][]>();
        DB dB = this.getDB();
        PreparedStatement preparedStatement = null;
        StringBuilder stringBuilder = null;
        Trial trial = (Trial)rMIPerfExplorerModel.getCurrentSelection();
        int n = Integer.parseInt(trial.getField("threads_per_context"));
        int n2 = Integer.parseInt(trial.getField("contexts_per_node")) * n;
        int n3 = n2 * Integer.parseInt(trial.getField("node_count"));
        try {
            stringBuilder = new StringBuilder();
            stringBuilder.append("select a.name, ");
            stringBuilder.append("(p.node * " + n2 + ") + ");
            stringBuilder.append("(p.context * " + n + ") + ");
            stringBuilder.append("p.thread as thread, ");
            stringBuilder.append("p.sample_count, ");
            stringBuilder.append("p.maximum_value, ");
            stringBuilder.append("p.minimum_value, ");
            stringBuilder.append("p.mean_value, ");
            stringBuilder.append("p.standard_deviation ");
            stringBuilder.append("from atomic_event a ");
            stringBuilder.append("left outer join atomic_location_profile p ");
            stringBuilder.append("on a.id = p.atomic_event ");
            stringBuilder.append("where a.trial = ? ");
            stringBuilder.append(" order by 2,1 ");
            preparedStatement = dB.prepareStatement(stringBuilder.toString());
            preparedStatement.setInt(1, trial.getID());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                double[][] dArray = (double[][])hashMap.get(string);
                if (dArray == null) {
                    dArray = new double[n3][5];
                }
                Integer n4 = resultSet.getInt(2);
                dArray[n4.intValue()][0] = resultSet.getDouble(3);
                dArray[n4.intValue()][1] = resultSet.getDouble(4);
                dArray[n4.intValue()][2] = resultSet.getDouble(5);
                dArray[n4.intValue()][3] = resultSet.getDouble(6);
                dArray[n4.intValue()][4] = resultSet.getDouble(7);
                hashMap.put(string, dArray);
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException.getMessage());
            sQLException.printStackTrace();
            if (preparedStatement != null) {
                System.err.println(preparedStatement);
            }
            System.err.println(stringBuilder);
        }
        return hashMap;
    }

    @Override
    public int getSchemaVersion(int n) {
        if (!this.connected.get(n).booleanValue()) {
            this.connectToDatabase(this.actualConfigFiles.get(n), true, n);
        }
        return this.schemaVersions.get(n);
    }
}

