/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.PerfExplorerActionListener;
import client.PerfExplorerConnection;
import client.PerfExplorerJTabbedPane;
import client.PerfExplorerJTree;
import client.PerfExplorerMainJMenuBar;
import common.EngineType;
import common.PerfExplorerOutput;
import edu.uoregon.tau.common.ImageExport;
import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.perfdmf.database.DBConnector;
import edu.uoregon.tau.perfdmf.database.PasswordCallback;
import jargs.gnu.CmdLineParser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ToolTipManager;

public class PerfExplorerClient
extends JFrame
implements ImageExport {
    private static String USAGE = "Usage: PerfExplorerClient [{-h,--help}] {-c,--configfile}=<config_file> [{-s,--standalone}] [{-e,--engine}=<analysis_engine>]\n  where analysis_engine = R or Weka";
    private ActionListener listener = null;
    private static PerfExplorerClient mainFrame = null;
    private JComponent mainComponent = null;

    public static PerfExplorerClient getMainFrame() {
        return mainFrame;
    }

    public ActionListener getListener() {
        return this.listener;
    }

    PerfExplorerClient(boolean bl, String string, EngineType engineType, boolean bl2) {
        super("TAU: PerfExplorer Client");
        DBConnector.setPasswordCallback((PasswordCallback)PasswordCallback.guiPasswordCallback);
        PerfExplorerOutput.setQuiet(bl2);
        PerfExplorerConnection.setStandalone(bl);
        PerfExplorerConnection.setConfigFile(string);
        PerfExplorerConnection.setAnalysisEngine(engineType);
        this.listener = new PerfExplorerActionListener(this);
        PerfExplorerJTree perfExplorerJTree = PerfExplorerJTree.getTree();
        JScrollPane jScrollPane = new JScrollPane(perfExplorerJTree);
        JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
        jScrollBar.setUnitIncrement(35);
        jScrollPane.setPreferredSize(new Dimension(300, 400));
        PerfExplorerJTabbedPane perfExplorerJTabbedPane = PerfExplorerJTabbedPane.getPane();
        perfExplorerJTabbedPane.setPreferredSize(new Dimension(890, 570));
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setLeftComponent(jScrollPane);
        jSplitPane.setRightComponent(perfExplorerJTabbedPane);
        this.mainComponent = jSplitPane;
        this.getContentPane().add((Component)jSplitPane, "Center");
        this.setJMenuBar(new PerfExplorerMainJMenuBar(this.listener));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        int n = 1190;
        int n2 = 620;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        int n3 = dimension.height;
        int n4 = dimension.width;
        Point point = null;
        if (point == null || point.x + n > n4 || point.y + n2 > n3) {
            int n5 = (n4 - n) / 2;
            int n6 = (n3 - n2) / 2;
            if (n5 > 50) {
                n5 -= 50;
            }
            if (n6 > 50) {
                n6 -= 50;
            }
            this.setLocation(n5, n6);
        } else {
            this.setLocation(point);
        }
        URL uRL = Utility.getResource((String)"tau32x32.gif");
        if (uRL != null) {
            this.setIconImage(Toolkit.getDefaultToolkit().getImage(uRL));
        }
        mainFrame = this;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string;
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem && (string = actionEvent.getActionCommand()).equals("Quit")) {
                System.exit(0);
            }
        }
        catch (Exception exception) {
            System.err.println("actionPerformed Exception: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        return this.mainComponent.getSize();
    }

    public void export(Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) {
        this.mainComponent.setDoubleBuffered(false);
        this.mainComponent.paintAll(graphics2D);
        this.mainComponent.setDoubleBuffered(true);
    }

    public static void main(String[] stringArray) {
        ToolTipManager.sharedInstance().setDismissDelay(20000);
        CmdLineParser cmdLineParser = new CmdLineParser();
        CmdLineParser.Option option = cmdLineParser.addBooleanOption('h', "help");
        CmdLineParser.Option option2 = cmdLineParser.addBooleanOption('s', "standalone");
        CmdLineParser.Option option3 = cmdLineParser.addStringOption('c', "configfile");
        CmdLineParser.Option option4 = cmdLineParser.addStringOption('e', "engine");
        CmdLineParser.Option option5 = cmdLineParser.addBooleanOption('q', "quiet");
        try {
            cmdLineParser.parse(stringArray);
        }
        catch (CmdLineParser.OptionException optionException) {
            System.err.println(optionException.getMessage());
            System.err.println(USAGE);
            System.exit(-1);
        }
        Boolean bl = (Boolean)cmdLineParser.getOptionValue(option);
        Boolean bl2 = (Boolean)cmdLineParser.getOptionValue(option2);
        String string = (String)cmdLineParser.getOptionValue(option3);
        String string2 = (String)cmdLineParser.getOptionValue(option4);
        Boolean bl3 = (Boolean)cmdLineParser.getOptionValue(option5);
        EngineType engineType = EngineType.WEKA;
        if (bl != null && bl.booleanValue()) {
            System.err.println(USAGE);
            System.exit(-1);
        }
        if (bl3 == null) {
            bl3 = new Boolean(false);
        }
        if (bl2 == null) {
            bl2 = new Boolean(false);
        }
        if (bl2.booleanValue()) {
            if (string == null) {
                System.err.println("Please enter a valid config file.");
                System.err.println(USAGE);
                System.exit(-1);
            }
            try {
                engineType = EngineType.getType(string2);
            }
            catch (Exception exception) {
                System.err.println("Please enter a valid engine type.");
                System.err.println(USAGE);
                System.exit(-1);
            }
        }
        PerfExplorerClient perfExplorerClient = new PerfExplorerClient(bl2, string, engineType, bl3);
        perfExplorerClient.pack();
        perfExplorerClient.setVisible(true);
    }
}

