/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.AnalysisType;
import common.RMIView;
import common.SelectionType;
import common.TransformationType;
import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.IntervalEvent;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Trial;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class RMIPerfExplorerModel
implements Serializable {
    public static final int MAX_CLUSTERS = 10;
    public static final double X_PERCENT = 1.0;
    protected List multiSelections = null;
    protected SelectionType multiSelectionType = SelectionType.NO_MULTI;
    protected List groupNames = null;
    protected List metricNames = null;
    protected List eventNames = null;
    protected String totalTimesteps = null;
    protected Boolean constantProblem = null;
    protected boolean eventNoCallpath = true;
    protected boolean mainEventOnly = true;
    protected boolean eventExclusive100 = false;
    protected String chartSeriesName = null;
    protected String chartMetadataFieldName = null;
    protected String chartMetadataFieldValue = null;
    protected String chartXAxisName = null;
    protected String chartYAxisName = null;
    protected String chartXAxisLabel = null;
    protected String chartYAxisLabel = null;
    protected String chartTitle = null;
    protected boolean chartLogYAxis = false;
    protected boolean chartScalability = false;
    protected boolean chartEfficiency = false;
    protected boolean chartHorizontal = false;
    protected String chartUnits = null;
    protected AnalysisType clusterMethod = null;
    protected TransformationType dimensionReduction = null;
    protected TransformationType normalization = null;
    protected int numberOfClusters = 10;
    protected double xPercent = 1.0;
    protected Object currentSelection = null;
    protected Application application = null;
    protected Experiment experiment = null;
    protected Trial trial = null;
    protected RMIView view = null;
    protected Metric metric = null;
    protected IntervalEvent event = null;
    protected int analysisID = 0;
    protected Object[] fullPath = null;
    protected int connectionIndex = 0;

    public RMIPerfExplorerModel() {
    }

    public RMIPerfExplorerModel(RMIPerfExplorerModel rMIPerfExplorerModel) {
        this.multiSelectionType = rMIPerfExplorerModel.multiSelectionType;
        this.groupNames = rMIPerfExplorerModel.groupNames;
        this.metricNames = rMIPerfExplorerModel.metricNames;
        this.eventNames = rMIPerfExplorerModel.eventNames;
        this.totalTimesteps = rMIPerfExplorerModel.totalTimesteps;
        this.constantProblem = rMIPerfExplorerModel.constantProblem;
        this.eventNoCallpath = rMIPerfExplorerModel.eventNoCallpath;
        this.mainEventOnly = rMIPerfExplorerModel.mainEventOnly;
        this.eventExclusive100 = rMIPerfExplorerModel.eventExclusive100;
        this.chartSeriesName = rMIPerfExplorerModel.chartSeriesName;
        this.chartMetadataFieldName = rMIPerfExplorerModel.chartMetadataFieldName;
        this.chartMetadataFieldValue = rMIPerfExplorerModel.chartMetadataFieldValue;
        this.chartXAxisName = rMIPerfExplorerModel.chartXAxisName;
        this.chartYAxisName = rMIPerfExplorerModel.chartYAxisName;
        this.chartXAxisLabel = rMIPerfExplorerModel.chartXAxisLabel;
        this.chartYAxisLabel = rMIPerfExplorerModel.chartYAxisLabel;
        this.chartTitle = rMIPerfExplorerModel.chartTitle;
        this.chartLogYAxis = rMIPerfExplorerModel.chartLogYAxis;
        this.chartScalability = rMIPerfExplorerModel.chartScalability;
        this.chartEfficiency = rMIPerfExplorerModel.chartEfficiency;
        this.chartHorizontal = rMIPerfExplorerModel.chartHorizontal;
        this.chartUnits = rMIPerfExplorerModel.chartUnits;
        this.clusterMethod = rMIPerfExplorerModel.clusterMethod;
        this.dimensionReduction = rMIPerfExplorerModel.dimensionReduction;
        this.normalization = rMIPerfExplorerModel.normalization;
        this.numberOfClusters = rMIPerfExplorerModel.numberOfClusters;
        this.xPercent = rMIPerfExplorerModel.xPercent;
        this.currentSelection = rMIPerfExplorerModel.currentSelection;
        this.application = rMIPerfExplorerModel.application;
        this.experiment = rMIPerfExplorerModel.experiment;
        this.trial = rMIPerfExplorerModel.trial;
        this.view = rMIPerfExplorerModel.view;
        this.metric = rMIPerfExplorerModel.metric;
        this.event = rMIPerfExplorerModel.event;
        this.analysisID = rMIPerfExplorerModel.analysisID;
        this.fullPath = rMIPerfExplorerModel.fullPath;
        this.connectionIndex = rMIPerfExplorerModel.connectionIndex;
    }

    public Object getCurrentSelection() {
        return this.currentSelection;
    }

    public Application getApplication() {
        return this.application;
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public Trial getTrial() {
        return this.trial;
    }

    public Metric getMetric() {
        return this.metric;
    }

    public IntervalEvent getEvent() {
        return this.event;
    }

    public AnalysisType getClusterMethod() {
        return this.clusterMethod == null ? AnalysisType.K_MEANS : this.clusterMethod;
    }

    public TransformationType getDimensionReduction() {
        return this.dimensionReduction == null ? TransformationType.NONE : this.dimensionReduction;
    }

    public TransformationType getNormalization() {
        return this.normalization == null ? TransformationType.NONE : this.normalization;
    }

    public int getNumberOfClusters() {
        return this.numberOfClusters;
    }

    public double getXPercent() {
        return this.xPercent;
    }

    public void setCurrentSelection(Object object) {
        this.groupNames = null;
        this.metricNames = null;
        this.eventNames = null;
        this.totalTimesteps = null;
        this.multiSelections = null;
        this.constantProblem = null;
        this.multiSelectionType = SelectionType.NO_MULTI;
        if (object instanceof Application) {
            this.application = (Application)object;
        } else if (object instanceof Experiment) {
            this.experiment = (Experiment)object;
        } else if (object instanceof Trial) {
            this.trial = (Trial)object;
        } else if (object instanceof RMIView) {
            this.view = (RMIView)object;
        } else if (object instanceof Metric) {
            this.metric = (Metric)object;
        } else if (object instanceof IntervalEvent) {
            this.event = (IntervalEvent)object;
        }
        this.currentSelection = object;
    }

    public void setCurrentSelection(Object[] objectArray) {
        this.groupNames = null;
        this.metricNames = null;
        this.eventNames = null;
        this.totalTimesteps = null;
        this.multiSelections = null;
        this.constantProblem = null;
        this.multiSelectionType = SelectionType.NO_MULTI;
        this.fullPath = objectArray;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof Application) {
                this.application = (Application)objectArray[i];
            } else if (objectArray[i] instanceof Experiment) {
                this.experiment = (Experiment)objectArray[i];
            } else if (objectArray[i] instanceof Trial) {
                this.trial = (Trial)objectArray[i];
            } else if (objectArray[i] instanceof RMIView) {
                this.view = (RMIView)objectArray[i];
            } else if (objectArray[i] instanceof Metric) {
                this.metric = (Metric)objectArray[i];
            } else if (objectArray[i] instanceof IntervalEvent) {
                this.event = (IntervalEvent)objectArray[i];
            }
            this.currentSelection = objectArray[i];
        }
    }

    public void setClusterMethod(String string) {
        this.clusterMethod = AnalysisType.fromString(string);
    }

    public void setClusterMethod(AnalysisType analysisType) {
        this.clusterMethod = analysisType;
    }

    public void setDimensionReduction(TransformationType transformationType) {
        this.dimensionReduction = transformationType;
    }

    public void setNormalization(TransformationType transformationType) {
        this.normalization = transformationType;
    }

    public void setNumberOfClusters(String string) {
        this.numberOfClusters = Integer.parseInt(string);
    }

    public void setXPercent(String string) {
        this.xPercent = Double.parseDouble(string);
    }

    public String toString() {
        if (this.multiSelectionType == SelectionType.APPLICATION) {
            return "Applications";
        }
        if (this.multiSelectionType == SelectionType.EXPERIMENT) {
            String string = this.application == null ? "" : this.application.getName();
            return string;
        }
        if (this.multiSelectionType == SelectionType.TRIAL) {
            String string = this.application == null ? "" : this.application.getName();
            String string2 = this.experiment.getName();
            String string3 = string + ":" + string2;
            return string3;
        }
        if (this.multiSelectionType == SelectionType.METRIC) {
            String string = this.application == null ? "" : this.application.getName();
            String string4 = this.experiment == null ? "" : this.experiment.getName();
            String string5 = this.trial.getName();
            String string6 = string + ":" + string4 + ":" + string5;
            return string6;
        }
        if (this.multiSelectionType == SelectionType.EVENT) {
            String string = this.application == null ? "" : this.application.getName();
            String string7 = this.experiment == null ? "" : this.experiment.getName();
            String string8 = this.trial.getName();
            String string9 = string + ":" + string7 + ":" + string8;
            return string9;
        }
        if (this.multiSelectionType == SelectionType.VIEW) {
            return "Custom View";
        }
        if (this.currentSelection instanceof IntervalEvent) {
            IntervalEvent intervalEvent = (IntervalEvent)this.currentSelection;
            String string = this.application == null ? "" : this.application.getName();
            String string10 = this.experiment == null ? "" : this.experiment.getName();
            String string11 = this.trial == null ? "" : this.trial.getName();
            String string12 = this.metric == null ? "" : this.metric.getName();
            String string13 = intervalEvent.getName();
            String string14 = string + ":" + string10 + ":" + string11 + ":" + string12 + ":" + string13;
            return string14;
        }
        if (this.currentSelection instanceof Metric) {
            Metric metric = (Metric)this.currentSelection;
            String string = this.application == null ? "" : this.application.getName();
            String string15 = this.experiment == null ? "" : this.experiment.getName();
            String string16 = this.trial == null ? "" : this.trial.getName();
            String string17 = metric.getName();
            String string18 = string + ":" + string15 + ":" + string16 + ":" + string17;
            return string18;
        }
        if (this.currentSelection instanceof Trial) {
            Trial trial = (Trial)this.currentSelection;
            String string = this.application == null ? "" : this.application.getName();
            String string19 = this.experiment == null ? "" : this.experiment.getName();
            String string20 = trial.getName();
            String string21 = string + ":" + string19 + ":" + string20;
            return string21;
        }
        if (this.currentSelection instanceof Experiment) {
            Experiment experiment = (Experiment)this.currentSelection;
            String string = this.application == null ? "" : this.application.getName();
            String string22 = experiment.getName();
            String string23 = string + ":" + string22;
            return string23;
        }
        if (this.currentSelection instanceof Application) {
            Application application = (Application)this.currentSelection;
            String string = application.getName();
            return string;
        }
        if (this.currentSelection instanceof RMIView) {
            RMIView rMIView = (RMIView)this.currentSelection;
            String string = rMIView.getField("NAME");
            return string;
        }
        return new String("");
    }

    public String toShortString() {
        if (this.currentSelection instanceof IntervalEvent) {
            IntervalEvent intervalEvent = (IntervalEvent)this.currentSelection;
            String string = this.application == null ? "" : "" + this.application.getID();
            String string2 = this.experiment == null ? "" : "" + this.experiment.getID();
            String string3 = this.trial == null ? "" : "" + this.trial.getID();
            String string4 = this.metric == null ? "" : "" + this.metric.getID();
            String string5 = "" + intervalEvent.getID();
            String string6 = string + ":" + string2 + ":" + string3 + ":" + string4 + ":" + string5;
            return string6;
        }
        if (this.currentSelection instanceof Metric) {
            Metric metric = (Metric)this.currentSelection;
            String string = this.application == null ? "" : "" + this.application.getID();
            String string7 = this.experiment == null ? "" : "" + this.experiment.getID();
            String string8 = this.trial == null ? "" : "" + this.trial.getID();
            String string9 = "" + metric.getID();
            String string10 = string + "." + string7 + "." + string8 + "." + string9;
            return string10;
        }
        if (this.currentSelection instanceof Trial) {
            Trial trial = (Trial)this.currentSelection;
            String string = this.application == null ? "" : "" + this.application.getID();
            String string11 = this.experiment == null ? "" : "" + this.experiment.getID();
            String string12 = "" + trial.getID();
            String string13 = string + "." + string11 + "." + string12;
            return string13;
        }
        if (this.currentSelection instanceof Experiment) {
            Experiment experiment = (Experiment)this.currentSelection;
            String string = this.application == null ? "" : "" + this.application.getID();
            String string14 = "" + experiment.getID();
            String string15 = string + "." + string14;
            return string15;
        }
        if (this.currentSelection instanceof Application) {
            Application application = (Application)this.currentSelection;
            String string = "" + application.getID();
            return string;
        }
        if (this.currentSelection instanceof RMIView) {
            RMIView rMIView = (RMIView)this.currentSelection;
            String string = rMIView.getField("NAME");
            return string;
        }
        return new String("");
    }

    public int getAnalysisID() {
        return this.analysisID;
    }

    public void setAnalysisID(int n) {
        this.analysisID = n;
    }

    public boolean setMultiSelection(List list) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) instanceof Application) {
                if (this.multiSelectionType != SelectionType.APPLICATION && this.multiSelectionType != SelectionType.NO_MULTI) {
                    return false;
                }
                this.multiSelectionType = SelectionType.APPLICATION;
                continue;
            }
            if (list.get(i) instanceof Experiment) {
                if (this.multiSelectionType != SelectionType.EXPERIMENT && this.multiSelectionType != SelectionType.NO_MULTI) {
                    return false;
                }
                this.multiSelectionType = SelectionType.EXPERIMENT;
                continue;
            }
            if (list.get(i) instanceof Trial) {
                if (this.multiSelectionType != SelectionType.TRIAL && this.multiSelectionType != SelectionType.NO_MULTI) {
                    return false;
                }
                this.multiSelectionType = SelectionType.TRIAL;
                continue;
            }
            if (list.get(i) instanceof Metric) {
                if (this.multiSelectionType != SelectionType.METRIC && this.multiSelectionType != SelectionType.NO_MULTI) {
                    return false;
                }
                this.multiSelectionType = SelectionType.METRIC;
                continue;
            }
            if (list.get(i) instanceof RMIView) {
                if (this.multiSelectionType != SelectionType.VIEW && this.multiSelectionType != SelectionType.NO_MULTI) {
                    return false;
                }
                this.multiSelectionType = SelectionType.VIEW;
                continue;
            }
            if (!(list.get(i) instanceof IntervalEvent)) continue;
            if (this.multiSelectionType != SelectionType.EVENT && this.multiSelectionType != SelectionType.NO_MULTI) {
                return false;
            }
            this.multiSelectionType = SelectionType.EVENT;
        }
        this.groupNames = null;
        this.metricNames = null;
        this.eventNames = null;
        this.totalTimesteps = null;
        this.constantProblem = null;
        this.multiSelections = list;
        return true;
    }

    public boolean addSelection(Object object) {
        this.groupNames = null;
        this.metricNames = null;
        this.eventNames = null;
        this.totalTimesteps = null;
        this.constantProblem = null;
        if (this.multiSelections == null) {
            this.multiSelections = new ArrayList();
            this.multiSelections.add(this.currentSelection);
        }
        this.multiSelections.add(object);
        return true;
    }

    public List getMultiSelection() {
        return this.multiSelections;
    }

    public String getGroupName() {
        String string = null;
        if (this.groupNames != null) {
            string = (String)this.groupNames.get(0);
        }
        return string;
    }

    public List getGroupNames() {
        return this.groupNames;
    }

    public List getEventNames() {
        return this.eventNames;
    }

    public void setGroupName(String string) {
        if (string == null) {
            this.groupNames = null;
        } else {
            this.groupNames = new ArrayList();
            this.groupNames.add(string);
        }
    }

    public String getMetricName() {
        if (this.metricNames != null) {
            return (String)this.metricNames.get(0);
        }
        if (this.currentSelection instanceof Metric) {
            Metric metric = (Metric)this.currentSelection;
            return metric.getName();
        }
        if (this.currentSelection instanceof IntervalEvent && this.metric != null) {
            return this.metric.getName();
        }
        String string = null;
        return string;
    }

    public List getMetricNames() {
        return this.metricNames;
    }

    public String getMetricNameUnits() {
        String string = this.getMetricName();
        if (string != null && string.equalsIgnoreCase("time")) {
            return string + " (seconds)";
        }
        return string;
    }

    public void setMetricName(String string) {
        if (string == null) {
            this.metricNames = null;
        } else {
            this.metricNames = new ArrayList();
            this.metricNames.add(string);
        }
    }

    public void addMetricName(String string) {
        if (this.metricNames == null) {
            this.metricNames = new ArrayList();
        }
        this.metricNames.add(string);
    }

    public void addGroupName(String string) {
        if (this.groupNames == null) {
            this.groupNames = new ArrayList();
        }
        this.groupNames.add(string);
    }

    public void addEventName(String string) {
        if (this.eventNames == null) {
            this.eventNames = new ArrayList();
        }
        this.eventNames.add(string);
    }

    public String getTotalTimesteps() {
        return this.totalTimesteps;
    }

    public void setTotalTimesteps(String string) {
        this.totalTimesteps = string;
    }

    public String getEventName() {
        String string = null;
        if (this.eventNames != null) {
            string = (String)this.eventNames.get(0);
        }
        return string;
    }

    public void setEventName(String string) {
        if (string == null) {
            this.eventNames = null;
        } else {
            this.eventNames = new ArrayList();
            this.eventNames.add(string);
        }
    }

    public String getViewSelectionPath(boolean bl, boolean bl2, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl2) {
            stringBuffer.append(" inner join experiment e on t.experiment = e.id ");
        }
        if (bl) {
            stringBuffer.append(" inner join application a on e.application = a.id ");
        }
        stringBuffer.append(" WHERE ");
        boolean bl3 = false;
        for (int i = 0; i < this.fullPath.length; ++i) {
            if (i > 0 && bl3) {
                stringBuffer.append(" AND ");
            }
            if (!(this.fullPath[i] instanceof RMIView)) continue;
            RMIView rMIView = (RMIView)this.fullPath[i];
            if (string.equalsIgnoreCase("db2")) {
                stringBuffer.append(" cast (");
            }
            if (rMIView.getField("table_name").equalsIgnoreCase("Application")) {
                stringBuffer.append(" a.");
            } else if (rMIView.getField("table_name").equalsIgnoreCase("Experiment")) {
                stringBuffer.append(" e.");
            } else {
                stringBuffer.append(" t.");
            }
            stringBuffer.append(rMIView.getField("column_name"));
            if (string.equalsIgnoreCase("db2")) {
                stringBuffer.append(" as varchar(256)) ");
            }
            stringBuffer.append(" " + rMIView.getField("operator") + " '");
            stringBuffer.append(rMIView.getField("value"));
            stringBuffer.append("' ");
            bl3 = true;
        }
        return stringBuffer.toString();
    }

    public String getViewSelectionString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.fullPath.length - 1;
        RMIView rMIView = (RMIView)this.fullPath[n];
        if (rMIView.getField("operator").equals("=")) {
            if (string.equalsIgnoreCase("db2")) {
                stringBuffer.append(" cast ( ");
            }
            if (rMIView.getField("table_name").equalsIgnoreCase("Application")) {
                stringBuffer.append(" a.");
            } else if (rMIView.getField("table_name").equalsIgnoreCase("Experiment")) {
                stringBuffer.append(" e.");
            } else {
                stringBuffer.append(" t.");
            }
            stringBuffer.append(rMIView.getField("column_name"));
            if (string.equalsIgnoreCase("db2")) {
                stringBuffer.append(" as varchar(256)) ");
            }
        } else {
            stringBuffer.append(" '" + rMIView.getField("name") + "'");
        }
        return stringBuffer.toString();
    }

    public String getViewID() {
        int n = this.fullPath.length - 1;
        RMIView rMIView = (RMIView)this.fullPath[n];
        return rMIView.getField("id");
    }

    public void setConstantProblem(boolean bl) {
        this.constantProblem = new Boolean(bl);
    }

    public void setMainEventOnly(boolean bl) {
        this.mainEventOnly = bl;
    }

    public void setEventNoCallpath(boolean bl) {
        this.eventNoCallpath = bl;
    }

    public void setEventExclusive100(boolean bl) {
        this.eventExclusive100 = bl;
    }

    public Boolean getConstantProblem() {
        return this.constantProblem;
    }

    public boolean getMainEventOnly() {
        return this.mainEventOnly;
    }

    public boolean getEventNoCallpath() {
        return this.eventNoCallpath;
    }

    public boolean getEventExclusive100() {
        return this.eventExclusive100;
    }

    public String getChartSeriesName() {
        return this.chartSeriesName;
    }

    public void setChartSeriesName(String string) {
        this.chartSeriesName = string;
    }

    public String getChartMetadataFieldName() {
        return this.chartMetadataFieldName;
    }

    public void setChartMetadataFieldName(String string) {
        this.chartMetadataFieldName = string;
    }

    public String getChartMetadataFieldValue() {
        return this.chartMetadataFieldValue;
    }

    public void setChartMetadataFieldValue(String string) {
        this.chartMetadataFieldValue = string;
    }

    public String getChartXAxisName() {
        return this.chartXAxisName;
    }

    public String getChartXAxisLabel() {
        return this.chartXAxisLabel;
    }

    public void setChartXAxisName(String string, String string2) {
        this.chartXAxisName = string;
        this.chartXAxisLabel = string2;
    }

    public String getChartYAxisName() {
        return this.chartYAxisName;
    }

    public String getChartYAxisLabel() {
        return this.chartYAxisLabel;
    }

    public void setChartYAxisName(String string, String string2) {
        this.chartYAxisName = string;
        this.chartYAxisLabel = string2;
    }

    public String getChartTitle() {
        return this.chartTitle;
    }

    public String getChartUnits() {
        return this.chartUnits;
    }

    public void setChartTitle(String string) {
        this.chartTitle = string;
    }

    public void setChartUnits(String string) {
        this.chartUnits = string;
    }

    public boolean getChartLogYAxis() {
        return this.chartLogYAxis;
    }

    public boolean getChartScalability() {
        return this.chartScalability;
    }

    public boolean getChartEfficiency() {
        return this.chartEfficiency;
    }

    public void setChartLogYAxis(boolean bl) {
        this.chartLogYAxis = bl;
    }

    public void setChartScalability(boolean bl) {
        this.chartScalability = bl;
    }

    public void setChartEfficiency(boolean bl) {
        this.chartEfficiency = bl;
    }

    public void setChartHorizontal(boolean bl) {
        this.chartHorizontal = bl;
    }

    public boolean getChartHorizontal() {
        return this.chartHorizontal;
    }

    public int getConnectionIndex() {
        return this.connectionIndex;
    }

    public void setConnectionIndex(int n) {
        this.connectionIndex = n;
    }
}

