/*
 * Decompiled with CFR 0.152.
 */
package server;

import common.EngineType;
import common.PerfExplorerOutput;
import common.RMIPerfExplorerModel;
import common.TransformationType;
import edu.uoregon.tau.common.TauScripter;
import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Trial;
import java.util.ListIterator;
import java.util.Vector;
import server.PerfExplorerServer;

public class TestServer {
    PerfExplorerServer server = null;

    public TestServer(String string, EngineType engineType) {
        this.server = PerfExplorerServer.getServer(string, engineType);
        PerfExplorerOutput.println(this.server.sayHello());
    }

    public void testScripting() throws Exception {
        TauScripter.execfile((String)"etc/test.py");
    }

    public void testClustering() throws Exception {
        Object object;
        Object[] objectArray = new Object[4];
        ListIterator listIterator = this.server.getApplicationList().listIterator();
        Application application = null;
        while (listIterator.hasNext()) {
            application = (Application)listIterator.next();
            if (application.getID() != 12) continue;
            objectArray[0] = application;
            break;
        }
        ListIterator listIterator2 = this.server.getExperimentList(application.getID()).listIterator();
        Experiment experiment = null;
        while (listIterator2.hasNext()) {
            experiment = (Experiment)listIterator2.next();
            if (experiment.getID() != 66) continue;
            objectArray[1] = experiment;
            break;
        }
        ListIterator listIterator3 = this.server.getTrialList(experiment.getID()).listIterator();
        Trial trial = null;
        while (listIterator3.hasNext()) {
            trial = (Trial)listIterator3.next();
            if (trial.getID() != 430) continue;
            objectArray[2] = trial;
            break;
        }
        Vector vector = trial.getMetrics();
        for (int i = 0; i < vector.size(); ++i) {
            object = (Metric)vector.elementAt(i);
            if (object.getID() != 1272) continue;
            objectArray[3] = object;
            break;
        }
        RMIPerfExplorerModel rMIPerfExplorerModel = new RMIPerfExplorerModel();
        rMIPerfExplorerModel.setDimensionReduction(TransformationType.OVER_X_PERCENT);
        rMIPerfExplorerModel.setNumberOfClusters("10");
        rMIPerfExplorerModel.setXPercent("2");
        rMIPerfExplorerModel.setCurrentSelection(objectArray);
        object = this.server.requestAnalysis(rMIPerfExplorerModel, true);
        PerfExplorerOutput.println((String)object);
        if (((String)object).equals("Request already exists")) {
            PerfExplorerOutput.println(this.server.requestAnalysis(rMIPerfExplorerModel, true));
        }
    }

    public static void main(String[] stringArray) {
        PerfExplorerOutput.println("LIBRARY PATH: " + System.getProperty("java.library.path"));
        try {
            EngineType engineType = EngineType.WEKA;
            TestServer testServer = new TestServer(stringArray[0], engineType);
            testServer.testScripting();
        }
        catch (Exception exception) {
            System.err.println("TestServer exception: " + exception.getMessage());
            exception.printStackTrace();
        }
        try {
            Thread.sleep(300000L);
        }
        catch (InterruptedException interruptedException) {
            System.err.println(interruptedException.getMessage());
            interruptedException.printStackTrace();
        }
        System.exit(0);
    }
}

