/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.barchart;

import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.FunctionBarChartWindow;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.PPThread;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.barchart.AbstractBarChartModel;
import edu.uoregon.tau.paraprof.enums.ValueType;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;

public class ThreadBarChartModel
extends AbstractBarChartModel {
    private List<PPFunctionProfile> list;
    private FunctionBarChartWindow window;
    private DataSorter dataSorter;
    private ParaProfTrial ppTrial;
    private PPThread ppThread;

    public ThreadBarChartModel(FunctionBarChartWindow functionBarChartWindow, DataSorter dataSorter, PPThread pPThread) {
        this.window = functionBarChartWindow;
        this.dataSorter = dataSorter;
        this.ppThread = pPThread;
        this.ppTrial = functionBarChartWindow.getPpTrial();
        this.reloadData();
    }

    @Override
    public int getNumRows() {
        return this.list.size();
    }

    @Override
    public String getRowLabel(int n) {
        PPFunctionProfile pPFunctionProfile = this.list.get(n);
        if (this.window.getPhase() != null) {
            return UtilFncs.getRightSide((String)pPFunctionProfile.getFunction().getName());
        }
        return pPFunctionProfile.getDisplayName();
    }

    @Override
    public double getValue(int n, int n2) {
        PPFunctionProfile pPFunctionProfile = this.list.get(n);
        return pPFunctionProfile.getValue();
    }

    @Override
    public String getValueLabel(int n, int n2) {
        PPFunctionProfile pPFunctionProfile = this.list.get(n);
        double d = pPFunctionProfile.getValue();
        if (this.window.getDataSorter().getValueType() == ValueType.EXCLUSIVE_PERCENT || this.window.getDataSorter().getValueType() == ValueType.INCLUSIVE_PERCENT) {
            return UtilFncs.getOutputString((int)0, (double)d, (int)6, (boolean)pPFunctionProfile.getDataSorter().getSelectedMetric().isTimeDenominator()) + "%";
        }
        return UtilFncs.getOutputString((int)this.window.units(), (double)d, (int)6, (boolean)pPFunctionProfile.getDataSorter().getSelectedMetric().isTimeDenominator());
    }

    @Override
    public Color getValueColor(int n, int n2) {
        PPFunctionProfile pPFunctionProfile = this.list.get(n);
        return pPFunctionProfile.getColor();
    }

    @Override
    public Color getValueHighlightColor(int n, int n2) {
        PPFunctionProfile pPFunctionProfile = this.list.get(n);
        Function function = pPFunctionProfile.getFunction();
        if (function == this.ppTrial.getHighlightedFunction()) {
            return this.ppTrial.getColorChooser().getHighlightColor();
        }
        if (function.isGroupMember(this.ppTrial.getHighlightedGroup())) {
            return this.ppTrial.getColorChooser().getGroupHighlightColor();
        }
        return null;
    }

    @Override
    public void reloadData() {
        if (this.ppThread.getThread().getDataSource().isDerivedProvided()) {
            if (this.ppThread.getName().equals("mean")) {
                this.ppThread = new PPThread(this.ppThread.getThread().getDataSource().getMeanData(), this.ppTrial);
            } else if (this.ppThread.getName().equals("std. dev.")) {
                this.ppThread = new PPThread(this.ppThread.getThread().getDataSource().getStdDevData(), this.ppTrial);
            }
        }
        this.list = this.ppThread.getSortedFunctionProfiles(this.dataSorter, false);
        this.fireModelChanged();
    }

    @Override
    public void fireRowLabelClick(int n, MouseEvent mouseEvent, JComponent jComponent) {
        PPFunctionProfile pPFunctionProfile = this.list.get(n);
        if (ParaProfUtils.rightClick(mouseEvent)) {
            JPopupMenu jPopupMenu = ParaProfUtils.createFunctionClickPopUp(this.ppTrial, pPFunctionProfile.getFunction(), pPFunctionProfile.getThread(), jComponent);
            jPopupMenu.show(jComponent, mouseEvent.getX(), mouseEvent.getY());
        } else {
            this.ppTrial.toggleHighlightedFunction(pPFunctionProfile.getFunction());
        }
    }

    @Override
    public void fireValueClick(int n, int n2, MouseEvent mouseEvent, JComponent jComponent) {
        PPFunctionProfile pPFunctionProfile = this.list.get(n);
        Function function = pPFunctionProfile.getFunction();
        if (ParaProfUtils.rightClick(mouseEvent)) {
            JPopupMenu jPopupMenu = ParaProfUtils.createFunctionClickPopUp(this.window.getPpTrial(), function, pPFunctionProfile.getThread(), jComponent);
            jPopupMenu.show(jComponent, mouseEvent.getX(), mouseEvent.getY());
        } else {
            this.window.getPpTrial().toggleHighlightedFunction(function);
        }
    }

    @Override
    public String getValueToolTipText(int n, int n2) {
        return null;
    }

    @Override
    public String getRowLabelToolTipText(int n) {
        return null;
    }

    @Override
    public String getOtherToolTopText(int n) {
        return null;
    }

    @Override
    public DataSorter getDataSorter() {
        return this.dataSorter;
    }
}

