/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.barchart;

import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.FunctionBarChartWindow;
import edu.uoregon.tau.paraprof.PPUserEventProfile;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.UserEventWindow;
import edu.uoregon.tau.paraprof.barchart.AbstractBarChartModel;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;

public class UserEventThreadBarChartModel
extends AbstractBarChartModel {
    private UserEventWindow window;
    private DataSorter dataSorter;
    private Thread thread;
    private List<PPUserEventProfile> list;

    public UserEventThreadBarChartModel(UserEventWindow userEventWindow, DataSorter dataSorter, Thread thread) {
        this.window = userEventWindow;
        this.dataSorter = dataSorter;
        this.thread = thread;
        this.reloadData();
    }

    @Override
    public int getNumRows() {
        return this.list.size();
    }

    @Override
    public String getRowLabel(int n) {
        PPUserEventProfile pPUserEventProfile = this.list.get(n);
        return pPUserEventProfile.getUserEventDisplayName();
    }

    @Override
    public String getValueLabel(int n, int n2) {
        PPUserEventProfile pPUserEventProfile = this.list.get(n);
        double d = this.window.getValueType().getValue(pPUserEventProfile.getUserEventProfile(), this.dataSorter.getSelectedSnapshot());
        return UtilFncs.getOutputString((int)0, (double)d, (int)ParaProf.defaultNumberPrecision, (boolean)false);
    }

    @Override
    public double getValue(int n, int n2) {
        PPUserEventProfile pPUserEventProfile = this.list.get(n);
        return this.window.getValueType().getValue(pPUserEventProfile.getUserEventProfile(), this.dataSorter.getSelectedSnapshot());
    }

    @Override
    public Color getValueColor(int n, int n2) {
        PPUserEventProfile pPUserEventProfile = this.list.get(n);
        return pPUserEventProfile.getColor();
    }

    @Override
    public Color getValueHighlightColor(int n, int n2) {
        PPUserEventProfile pPUserEventProfile = this.list.get(n);
        if (pPUserEventProfile.getUserEvent() == this.window.getPpTrial().getHighlightedUserEvent()) {
            return this.window.getPpTrial().getColorChooser().getUserEventHighlightColor();
        }
        return null;
    }

    @Override
    public void fireValueClick(int n, int n2, MouseEvent mouseEvent, JComponent jComponent) {
    }

    @Override
    public void fireRowLabelClick(int n, MouseEvent mouseEvent, JComponent jComponent) {
        PPUserEventProfile pPUserEventProfile = this.list.get(n);
        UserEvent userEvent = pPUserEventProfile.getUserEvent();
        if (ParaProfUtils.rightClick(mouseEvent)) {
            ParaProfUtils.handleUserEventClick(this.window.getPpTrial(), userEvent, this.thread, jComponent, mouseEvent);
        } else {
            FunctionBarChartWindow functionBarChartWindow = new FunctionBarChartWindow(this.window.getPpTrial(), pPUserEventProfile.getThread(), null, jComponent);
            functionBarChartWindow.setVisible(true);
        }
    }

    @Override
    public String getValueToolTipText(int n, int n2) {
        return null;
    }

    @Override
    public String getRowLabelToolTipText(int n) {
        return null;
    }

    @Override
    public String getOtherToolTopText(int n) {
        return null;
    }

    @Override
    public void reloadData() {
        this.list = this.dataSorter.getUserEventProfiles(this.thread);
        this.fireModelChanged();
    }

    @Override
    public DataSorter getDataSorter() {
        return this.dataSorter;
    }
}

