/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.graph;

import edu.uoregon.tau.paraprof.graph.Vertex;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Layout {
    private static final int HORIZONTAL_SPACING = 10;
    private static final int MARGIN = 20;

    public static void runSugiyama(List<List<Vertex>> list) {
        Layout.runPhaseOne(list);
    }

    private static void runPhaseOne(List<List<Vertex>> list) {
        for (int i = 100; i > 0; --i) {
            int n;
            for (n = 0; n < list.size() - 1; ++n) {
                Layout.assignBaryCenters(list.get(n), list.get(n + 1), true);
                Collections.sort(list.get(n));
            }
            for (n = list.size() - 1; n > 0; --n) {
                Layout.assignBaryCenters(list.get(n), list.get(n - 1), false);
                Collections.sort(list.get(n));
            }
        }
    }

    private static void assignBaryCenters(List<Vertex> list, List<Vertex> list2, boolean bl) {
        Vertex vertex;
        int n;
        for (n = 0; n < list2.size(); ++n) {
            vertex = list2.get(n);
            vertex.setLevelIndex(n);
        }
        for (n = 0; n < list.size(); ++n) {
            int n2;
            int n3;
            vertex = list.get(n);
            if (bl) {
                n3 = 0;
                for (n2 = 0; n2 < vertex.getChildren().size(); ++n2) {
                    n3 += vertex.getChildren().get(n2).getLevelIndex();
                }
                if (vertex.getChildren().size() == 0) continue;
                vertex.setBaryCenter(n3 / vertex.getChildren().size());
                continue;
            }
            n3 = 0;
            for (n2 = 0; n2 < vertex.getParents().size(); ++n2) {
                n3 += vertex.getParents().get(n2).getLevelIndex();
            }
            if (vertex.getParents().size() == 0) continue;
            vertex.setBaryCenter(n3 / vertex.getParents().size());
        }
    }

    private static void assignGridBaryCenters(List<Vertex> list, boolean bl, boolean bl2) {
        for (int i = 0; i < list.size(); ++i) {
            int n;
            float f;
            Vertex vertex = list.get(i);
            if (bl) {
                if (vertex.getChildren().size() == 0) continue;
                f = 0.0f;
                for (n = 0; n < vertex.getChildren().size(); ++n) {
                    f += (float)vertex.getChildren().get(n).getPosition();
                }
                vertex.setGridBaryCenter(f / (float)vertex.getChildren().size());
                continue;
            }
            if (vertex.getParents().size() == 0) continue;
            f = 0.0f;
            for (n = 0; n < vertex.getParents().size(); ++n) {
                f += (float)vertex.getParents().get(n).getPosition();
            }
            vertex.setGridBaryCenter(f / (float)vertex.getParents().size());
        }
    }

    private static void improvePositions(List<List<Vertex>> list, int n, boolean bl, boolean bl2) {
        List<Vertex> list2 = list.get(n);
        Layout.assignGridBaryCenters(list2, bl, bl2);
        for (int i = 0; i < list2.size(); ++i) {
            int n2;
            int n3;
            Vertex vertex = list2.get(i);
            int n4 = (int)vertex.getGridBaryCenter();
            if (bl && vertex.getChildren().size() == 0) continue;
            if (n4 > vertex.getPosition()) {
                n3 = Layout.moveRight(list2, i, n4 - vertex.getPosition(), bl, vertex.getPriority(bl));
                for (n2 = i - 1; n2 >= 0 && bl2; --n2) {
                    Layout.moveRight(list2, n2, n3, bl, vertex.getPriority(bl));
                }
                continue;
            }
            n3 = Layout.moveLeft(list2, i, vertex.getPosition() - n4, bl, vertex.getPriority(bl));
            for (n2 = i + 1; n2 < list2.size() && bl2; ++n2) {
                Layout.moveLeft(list2, n2, n3, bl, vertex.getPriority(bl));
            }
        }
    }

    private static int moveRight(List<Vertex> list, int n, int n2, boolean bl, int n3) {
        int n4;
        Vertex vertex = list.get(n);
        int n5 = n + 1;
        if (n5 >= list.size()) {
            vertex.setPosition(vertex.getPosition() + n2);
            return n2;
        }
        Vertex vertex2 = list.get(n5);
        int n6 = vertex.getPosition() + vertex.getWidth() / 2;
        if (n6 + n2 + 10 < (n4 = vertex2.getPosition() - vertex2.getWidth() / 2)) {
            vertex.setPosition(vertex.getPosition() + n2);
            return n2;
        }
        if (vertex2.getPriority(bl) > n3) {
            int n7 = vertex2.getPosition() - (vertex.getWidth() + vertex2.getWidth()) / 2 - 10;
            int n8 = n7 - vertex.getPosition();
            vertex.setPosition(vertex.getPosition() + n8);
            return n8;
        }
        int n9 = vertex.getPosition() + n2 + (vertex2.getWidth() + vertex.getWidth()) / 2 + 10;
        Layout.moveRight(list, n5, n9 - vertex2.getPosition(), bl, n3);
        int n10 = vertex2.getPosition() - (vertex.getWidth() + vertex2.getWidth()) / 2 - 10;
        int n11 = n10 - vertex.getPosition();
        vertex.setPosition(vertex.getPosition() + n11);
        return n11;
    }

    private static int moveLeft(List<Vertex> list, int n, int n2, boolean bl, int n3) {
        int n4;
        Vertex vertex = list.get(n);
        int n5 = n - 1;
        if (n5 < 0) {
            vertex.setPosition(vertex.getPosition() - n2);
            return n2;
        }
        Vertex vertex2 = list.get(n5);
        int n6 = vertex.getPosition() - vertex.getWidth() / 2;
        if (n6 - n2 - 10 > (n4 = vertex2.getPosition() + vertex2.getWidth() / 2)) {
            vertex.setPosition(vertex.getPosition() - n2);
            return n2;
        }
        if (vertex2.getPriority(bl) > n3) {
            int n7 = vertex2.getPosition() + (vertex2.getWidth() + vertex.getWidth()) / 2 + 10;
            int n8 = vertex.getPosition() - n7;
            vertex.setPosition(vertex.getPosition() - n8);
            return n8;
        }
        int n9 = vertex.getPosition() - n2 - vertex.getWidth() / 2 - 10 - vertex2.getWidth() / 2;
        Layout.moveLeft(list, n5, vertex2.getPosition() - n9, bl, n3);
        int n10 = vertex2.getPosition() + (vertex2.getWidth() + vertex.getWidth()) / 2 + 10;
        int n11 = vertex.getPosition() - n10;
        vertex.setPosition(vertex.getPosition() - n11);
        return n11;
    }

    public static void assignPositions(List<List<Vertex>> list) {
        int n;
        int n2;
        int n3;
        for (n3 = 0; n3 < list.size(); ++n3) {
            List<Vertex> list2 = list.get(n3);
            int n4 = 0;
            list2.get(0).setPosition(0);
            for (n2 = 1; n2 < list2.size(); ++n2) {
                Vertex vertex = list2.get(n2);
                vertex.setPosition(n4 + 10 + (list2.get(n2 - 1).getWidth() + vertex.getWidth()) / 2);
                n4 = vertex.getPosition();
                vertex.setDownPriority(vertex.getChildren().size());
                if (vertex.getUserObject() == null) {
                    vertex.setDownPriority(2);
                }
                vertex.setUpPriority(vertex.getParents().size());
                if (vertex.getUserObject() != null) continue;
                vertex.setUpPriority(2);
            }
            if (list2.size() % 2 == 0) {
                int n5 = list2.get((list2.size() - 2) / 2).getPosition();
                int n6 = list2.get(list2.size() / 2).getPosition();
                n2 = (n5 + n6) / 2;
            } else {
                n2 = list2.get((list2.size() - 1) / 2).getPosition();
            }
            for (int i = 0; i < list2.size(); ++i) {
                Vertex vertex = list2.get(i);
                vertex.setPosition(vertex.getPosition() - n2);
            }
        }
        for (n3 = 1; n3 < list.size(); ++n3) {
            Layout.improvePositions(list, n3, false, false);
        }
        for (n3 = list.size() - 2; n3 >= 0; --n3) {
            Layout.improvePositions(list, n3, true, false);
        }
        for (n3 = 1; n3 < list.size(); ++n3) {
            Layout.improvePositions(list, n3, false, false);
        }
        for (n3 = list.size() - 2; n3 >= 0; --n3) {
            Layout.improvePositions(list, n3, true, true);
        }
        for (n3 = list.size() - 2; n3 >= 0; --n3) {
            Layout.improvePositions(list, n3, true, false);
        }
        n3 = 0;
        for (n = 0; n < list.size(); ++n) {
            List<Vertex> list3 = list.get(n);
            for (n2 = 0; n2 < list3.size(); ++n2) {
                Vertex vertex = list3.get(n2);
                if (vertex.getPosition() - vertex.getWidth() / 2 >= n3) continue;
                n3 = vertex.getPosition() - vertex.getWidth() / 2;
            }
        }
        for (n = 0; n < list.size(); ++n) {
            List<Vertex> list4 = list.get(n);
            for (n2 = 0; n2 < list4.size(); ++n2) {
                Vertex vertex = list4.get(n2);
                vertex.setPosition(vertex.getPosition() + (-n3 + 20));
            }
        }
    }

    public static void assignLevel(Vertex vertex) {
        int n = 0;
        for (int i = 0; i < vertex.getParents().size(); ++i) {
            Vertex vertex2 = vertex.getParents().get(i);
            if (vertex2.getLevel() == -1) {
                Layout.assignLevel(vertex2);
            }
            if (vertex2.getLevel() <= n) continue;
            n = vertex2.getLevel();
        }
        vertex.setLevel(n + 1);
    }

    public static void fillLevels(Vertex vertex, List<List<Vertex>> list, int n) {
        if (vertex.getVisited()) {
            return;
        }
        vertex.setVisited(true);
        if (list.size() == n) {
            list.add(new ArrayList());
        }
        vertex.setLevel(n);
        List<Vertex> list2 = list.get(n);
        list2.add(vertex);
        for (int i = 0; i < vertex.getChildren().size(); ++i) {
            Vertex vertex2 = vertex.getChildren().get(i);
            Layout.fillLevels(vertex2, list, n + 1);
        }
    }

    public static void insertDummies(Vertex vertex) {
        for (int i = 0; i < vertex.getChildren().size(); ++i) {
            Vertex vertex2 = vertex.getChildren().get(i);
            if (vertex2.getLevel() - vertex.getLevel() <= 1) continue;
            vertex.getChildren().remove(i);
            vertex2.getParents().remove(vertex);
            Vertex vertex3 = new Vertex(null, 1, 1);
            vertex3.setLevel(vertex.getLevel() + 1);
            vertex3.getChildren().add(vertex2);
            vertex2.getParents().add(vertex3);
            vertex.getChildren().add(i, vertex3);
            vertex3.getParents().add(vertex);
            Layout.insertDummies(vertex3);
        }
    }

    public static List<Vertex> findRoots(Map<FunctionProfile, Vertex> map) {
        ArrayList<Vertex> arrayList = new ArrayList<Vertex>();
        for (Vertex vertex : map.values()) {
            vertex.setVisited(false);
        }
        for (Vertex vertex : map.values()) {
            for (int i = 0; i < vertex.getChildren().size(); ++i) {
                Vertex vertex2 = vertex.getChildren().get(i);
                vertex2.setVisited(true);
            }
        }
        for (Vertex vertex : map.values()) {
            if (vertex.getVisited()) continue;
            arrayList.add(vertex);
        }
        return arrayList;
    }
}

