/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.treetable;

import edu.uoregon.tau.common.ImageExport;
import edu.uoregon.tau.common.treetable.AbstractTreeTableModel;
import edu.uoregon.tau.common.treetable.JTreeTable;
import edu.uoregon.tau.paraprof.ColorBar;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfException;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.SearchPanel;
import edu.uoregon.tau.paraprof.WindowPlacer;
import edu.uoregon.tau.paraprof.interfaces.ParaProfWindow;
import edu.uoregon.tau.paraprof.interfaces.Searchable;
import edu.uoregon.tau.paraprof.interfaces.SearchableOwner;
import edu.uoregon.tau.paraprof.interfaces.UnitListener;
import edu.uoregon.tau.paraprof.treetable.CallPathModel;
import edu.uoregon.tau.paraprof.treetable.ColumnChooser;
import edu.uoregon.tau.paraprof.treetable.TreePortionCellRenderer;
import edu.uoregon.tau.paraprof.treetable.TreeTableColumn;
import edu.uoregon.tau.paraprof.treetable.TreeTableNode;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Thread;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeTableWindow
extends JFrame
implements TreeExpansionListener,
Observer,
ParaProfWindow,
Printable,
UnitListener,
ImageExport,
SearchableOwner,
ActionListener,
KeyListener,
Searchable {
    private static final long serialVersionUID = 4726597182083786681L;
    private ParaProfTrial ppTrial;
    private Thread thread;
    private CallPathModel model;
    private JTreeTable treeTable;
    private int colorMetricID;
    private int units = ParaProf.preferences.getUnits();
    private int decimals = -1;
    private List<TreeTableColumn> columns;
    private ColumnChooser columnChooser;
    private JCheckBoxMenuItem showFindPanelBox = new JCheckBoxMenuItem("Show Find Panel", false);
    private SearchPanel searchPanel;
    private final JMenuItem showAsTreeMenuItem = new JCheckBoxMenuItem("Show as Call Tree");
    private final JMenuItem reverseTreeMenuItem = new JCheckBoxMenuItem("Reverse Call Tree", false);
    private final JMenuItem showInclExclMenuItem = new JCheckBoxMenuItem("Show Inclusive/Exclusive", true);
    private JScrollPane scrollPane;
    boolean searchMatchCase = true;
    SearchNode sn = new SearchNode();
    TreeTableNode lastNode = null;
    boolean nexting = false;
    List<TreeTableNode> prevNodes = new ArrayList<TreeTableNode>();
    String searchString = "";

    public TreeTableWindow(ParaProfTrial paraProfTrial, Thread thread) {
        this(paraProfTrial, thread, null);
    }

    public TreeTableWindow(ParaProfTrial paraProfTrial, Thread thread, Component component) {
        this.ppTrial = paraProfTrial;
        this.thread = thread;
        paraProfTrial.addObserver(this);
        if (!paraProfTrial.getDataSource().getReverseDataAvailable()) {
            this.reverseTreeMenuItem.setEnabled(false);
        }
        this.columnChooser = new ColumnChooser(this, paraProfTrial);
        this.setSize(ParaProfUtils.checkSize(new Dimension(1000, 600)));
        this.setLocation(WindowPlacer.getNewLocation(this, component));
        if (thread.getNodeID() == -1 || thread.getNodeID() == -6) {
            this.setTitle("TAU: ParaProf: Mean Statistics - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        } else if (thread.getNodeID() == -2) {
            this.setTitle("TAU: ParaProf: Total Statistics - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        } else if (thread.getNodeID() == -3 || thread.getNodeID() == -7) {
            this.setTitle("TAU: ParaProf: Std. Dev. Statistics - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        } else {
            this.setTitle("TAU: ParaProf: Statistics for: " + ParaProfUtils.getThreadLabel(thread) + " - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        }
        ParaProfUtils.setFrameIcon(this);
        if (ParaProf.getHelpWindow().isVisible()) {
            this.help(false);
        }
        this.setupMenus();
        this.setupData();
        ParaProf.incrementNumWindows();
    }

    public void updateColumns() {
        this.setColumns();
        AbstractTableModel abstractTableModel = (AbstractTableModel)this.treeTable.getModel();
        abstractTableModel.fireTableChanged(new TableModelEvent(abstractTableModel, -1));
        for (int i = 0; i < this.columns.size(); ++i) {
            this.treeTable.setDefaultRenderer(this.columns.get(i).getClass(), this.columns.get(i).getCellRenderer());
        }
    }

    private void setColumns() {
        ColumnChooser.CheckBoxListItem checkBoxListItem;
        this.columns = new ArrayList<TreeTableColumn>();
        ListModel listModel = this.columnChooser.getMetricModel();
        ListModel listModel2 = this.columnChooser.getValueModel();
        for (int i = 0; i < listModel.getSize() - 2; ++i) {
            checkBoxListItem = (ColumnChooser.CheckBoxListItem)listModel.getElementAt(i);
            if (!checkBoxListItem.getSelected()) continue;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            for (int j = 0; j < listModel2.getSize(); ++j) {
                ColumnChooser.CheckBoxListItem checkBoxListItem2 = (ColumnChooser.CheckBoxListItem)listModel2.getElementAt(j);
                if (!checkBoxListItem2.getSelected()) continue;
                String string = (String)checkBoxListItem2.getUserObject();
                if (string.equals("Exclusive Value") || string.equals("Inclusive Value")) {
                    if (this.showInclExclMenuItem.isSelected()) {
                        if (string.equals("Inclusive Value")) {
                            this.columns.add(new TreeTableColumn.InclusiveColumn(this, i));
                        }
                        if (!string.equals("Exclusive Value")) continue;
                        this.columns.add(new TreeTableColumn.ExclusiveColumn(this, i));
                        continue;
                    }
                    if (bl) continue;
                    this.columns.add(new TreeTableColumn.RegularMetricColumn(this, i));
                    bl = true;
                    continue;
                }
                if (string.equals("Inclusive Percent Value") || string.equals("Exclusive Percent Value")) {
                    if (this.showInclExclMenuItem.isSelected()) {
                        if (string.equals("Inclusive Percent Value")) {
                            this.columns.add(new TreeTableColumn.InclusivePercentColumn(this, i));
                        }
                        if (!string.equals("Exclusive Percent Value")) continue;
                        this.columns.add(new TreeTableColumn.ExclusivePercentColumn(this, i));
                        continue;
                    }
                    if (bl2) continue;
                    this.columns.add(new TreeTableColumn.RegularPercentMetricColumn(this, i));
                    bl2 = true;
                    continue;
                }
                if (!string.equals("Inclusive Value Per Call") && !string.equals("Exclusive Value Per Call")) continue;
                if (this.showInclExclMenuItem.isSelected()) {
                    if (string.equals("Inclusive Value Per Call")) {
                        this.columns.add(new TreeTableColumn.InclusivePerCallColumn(this, i));
                    }
                    if (!string.equals("Exclusive Value Per Call")) continue;
                    this.columns.add(new TreeTableColumn.ExclusivePerCallColumn(this, i));
                    continue;
                }
                if (bl3) continue;
                this.columns.add(new TreeTableColumn.RegularPerCallMetricColumn(this, i));
                bl3 = true;
            }
        }
        ColumnChooser.CheckBoxListItem checkBoxListItem3 = (ColumnChooser.CheckBoxListItem)listModel.getElementAt(listModel.getSize() - 2);
        checkBoxListItem = (ColumnChooser.CheckBoxListItem)listModel.getElementAt(listModel.getSize() - 1);
        if (checkBoxListItem3.getSelected()) {
            this.columns.add(new TreeTableColumn.NumCallsColumn(this));
        }
        if (checkBoxListItem.getSelected()) {
            this.columns.add(new TreeTableColumn.NumSubrColumn(this));
        }
    }

    private void addComponents() {
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (!this.showAsTreeMenuItem.isSelected()) {
            this.showInclExclMenuItem.setEnabled(false);
            this.showInclExclMenuItem.setSelected(true);
        } else {
            this.showInclExclMenuItem.setEnabled(true);
            gridBagConstraints.anchor = 11;
            gridBagConstraints.weighty = 0.0;
            if (this.ppTrial.getNumberOfMetrics() > 1) {
                final JComboBox<Metric> jComboBox = new JComboBox<Metric>(this.ppTrial.getMetricArray());
                jComboBox.setSelectedItem(this.ppTrial.getDefaultMetric());
                jComboBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TreeTableWindow.this.model.setColorMetric(jComboBox.getSelectedIndex());
                        TreeTableWindow.this.repaint();
                    }
                });
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                this.addCompItem(jComboBox, gridBagConstraints, 0, 0, 1, 1);
            }
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            this.addCompItem(new ColorBar(), gridBagConstraints, 1, 0, 1, 1);
        }
        if (this.scrollPane != null) {
            this.getContentPane().remove(this.scrollPane);
        }
        this.scrollPane = new JScrollPane((Component)this.treeTable);
        for (int i = 0; i < this.columns.size(); ++i) {
            this.treeTable.setDefaultRenderer(this.columns.get(i).getClass(), this.columns.get(i).getCellRenderer());
        }
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(this.scrollPane, gridBagConstraints, 0, 1, 0, 1);
        this.validate();
    }

    private void setupData() {
        this.setColumns();
        this.model = new CallPathModel(this, this.ppTrial, this.thread, this.reverseTreeMenuItem.isSelected());
        this.createTreeTable(this.model);
        this.addComponents();
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    private void helperAddButton(JMenu jMenu, ActionListener actionListener, ButtonGroup buttonGroup, String string, boolean bl) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string, bl);
        jRadioButtonMenuItem.addActionListener(actionListener);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
    }

    private JMenu createDecimalMenu() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string = actionEvent.getActionCommand();
                    if (string.equals("auto")) {
                        TreeTableWindow.this.decimals = -1;
                    } else if (string.equals("display full numbers")) {
                        TreeTableWindow.this.decimals = -2;
                    } else if (string.equals("0 decimal places")) {
                        TreeTableWindow.this.decimals = 0;
                    } else if (string.equals("1 decimal places")) {
                        TreeTableWindow.this.decimals = 1;
                    } else if (string.equals("2 decimal places")) {
                        TreeTableWindow.this.decimals = 2;
                    } else if (string.equals("3 decimal places")) {
                        TreeTableWindow.this.decimals = 3;
                    } else if (string.equals("4 decimal places")) {
                        TreeTableWindow.this.decimals = 4;
                    }
                    TreeTableWindow.this.treeTable.forceRedraw();
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        JMenu jMenu = new JMenu("Select Precision...");
        ButtonGroup buttonGroup = new ButtonGroup();
        this.helperAddButton(jMenu, actionListener, buttonGroup, "auto", true);
        this.helperAddButton(jMenu, actionListener, buttonGroup, "0 decimal places", false);
        this.helperAddButton(jMenu, actionListener, buttonGroup, "1 decimal places", false);
        this.helperAddButton(jMenu, actionListener, buttonGroup, "2 decimal places", false);
        this.helperAddButton(jMenu, actionListener, buttonGroup, "3 decimal places", false);
        this.helperAddButton(jMenu, actionListener, buttonGroup, "4 decimal places", false);
        this.helperAddButton(jMenu, actionListener, buttonGroup, "display full numbers", false);
        return jMenu;
    }

    private void setupMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Options");
        this.showFindPanelBox.addActionListener(this);
        jMenu.add(this.showFindPanelBox);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object = actionEvent.getSource();
                    if (object instanceof JMenuItem) {
                        String string = actionEvent.getActionCommand();
                        if (string.equals("Show as Call Tree")) {
                            TreeTableWindow.this.showSearchPanel(false);
                            if (TreeTableWindow.this.showAsTreeMenuItem.isSelected()) {
                                TreeTableWindow.this.showInclExclMenuItem.setSelected(false);
                            }
                            TreeTableWindow.this.setupData();
                        } else if (string.equals("Reverse Call Tree")) {
                            TreeTableWindow.this.showSearchPanel(false);
                            TreeTableWindow.this.setupData();
                        } else if (string.equals("Show Inclusive/Exclusive")) {
                            TreeTableWindow.this.showSearchPanel(false);
                            TreeTableWindow.this.setupData();
                        }
                    }
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        this.showAsTreeMenuItem.addActionListener(actionListener);
        jMenu.add(this.showAsTreeMenuItem);
        this.showAsTreeMenuItem.setSelected(true);
        this.reverseTreeMenuItem.addActionListener(actionListener);
        jMenu.add(this.reverseTreeMenuItem);
        this.showInclExclMenuItem.addActionListener(actionListener);
        jMenu.add(this.showInclExclMenuItem);
        JMenu jMenu2 = ParaProfUtils.createUnitsMenu(this, this.units, false);
        jMenu.add(jMenu2);
        jMenu.add(this.createDecimalMenu());
        JMenuItem jMenuItem = new JMenuItem("Choose Columns...");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreeTableWindow.this.columnChooser.showDialog(TreeTableWindow.this, true);
            }
        });
        jMenu.add(jMenuItem);
        if (!this.ppTrial.callPathDataPresent()) {
            this.showAsTreeMenuItem.setSelected(false);
            this.showAsTreeMenuItem.setEnabled(false);
            this.showInclExclMenuItem.setSelected(true);
            this.showInclExclMenuItem.setEnabled(false);
        }
        jMenuBar.add(ParaProfUtils.createFileMenu(this, this, this));
        jMenuBar.add(jMenu);
        jMenuBar.add(ParaProfUtils.createWindowsMenu(this.ppTrial, this));
        jMenuBar.add(ParaProfUtils.createHelpMenu(this, this));
        this.setJMenuBar(jMenuBar);
    }

    private void createTreeTable(AbstractTreeTableModel abstractTreeTableModel) {
        this.treeTable = new JTreeTable(abstractTreeTableModel, true, true);
        final JTree jTree = this.treeTable.getTree();
        FontMetrics fontMetrics = jTree.getFontMetrics(ParaProf.preferences.getFont());
        jTree.setRowHeight(fontMetrics.getHeight());
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                try {
                    TreePath treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (treePath != null) {
                        TreeTableNode treeTableNode = (TreeTableNode)treePath.getLastPathComponent();
                        if (ParaProfUtils.rightClick(mouseEvent) && treeTableNode.getFunctionProfile() != null) {
                            JPopupMenu jPopupMenu = ParaProfUtils.createFunctionClickPopUp(treeTableNode.getModel().getPPTrial(), treeTableNode.getFunctionProfile().getFunction(), TreeTableWindow.this.getThread(), (Component)TreeTableWindow.this.treeTable);
                            jPopupMenu.show((Component)TreeTableWindow.this.treeTable, mouseEvent.getX(), mouseEvent.getY());
                        }
                    }
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        this.treeTable.addMouseListener((MouseListener)mouseAdapter);
        this.treeTable.getTree().addTreeExpansionListener(this);
        TreePortionCellRenderer treePortionCellRenderer = new TreePortionCellRenderer();
        this.treeTable.getTree().setCellRenderer(treePortionCellRenderer);
        Font font = ParaProf.preferencesWindow.getFont();
        this.treeTable.setFont(font);
        treePortionCellRenderer.setFont(font);
        FontMetrics fontMetrics2 = this.getFontMetrics(font);
        this.treeTable.setRowHeight(fontMetrics2.getMaxAscent() + fontMetrics2.getMaxDescent() + 3);
        this.treeTable.setAutoResizeMode(0);
        this.treeTable.setAutoResizeMode(2);
        TableColumn tableColumn = this.treeTable.getColumnModel().getColumn(0);
        int n = 500;
        if (this.ppTrial.getNumberOfMetrics() > 1) {
            n = 350;
        }
        if (ParaProf.demoMode) {
            n = 200;
        }
        tableColumn.setPreferredWidth(n);
        int n2 = this.treeTable.getColumnCount();
        tableColumn = this.treeTable.getColumnModel().getColumn(n2 - 2);
        tableColumn.setPreferredWidth(10);
        tableColumn = this.treeTable.getColumnModel().getColumn(n2 - 1);
        tableColumn.setPreferredWidth(10);
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        TreeTableNode treeTableNode = (TreeTableNode)treeExpansionEvent.getPath().getLastPathComponent();
        treeTableNode.setExpanded(false);
    }

    @Override
    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        TreeTableNode treeTableNode = (TreeTableNode)treeExpansionEvent.getPath().getLastPathComponent();
        treeTableNode.setExpanded(true);
    }

    @Override
    public void update(Observable observable, Object object) {
        if (this.thread.getNodeID() >= 0) {
            this.setTitle("TAU: ParaProf: Statistics for: " + ParaProfUtils.getThreadLabel(this.thread) + " - " + this.ppTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        }
        this.setupData();
    }

    @Override
    public void help(boolean bl) {
        ParaProf.getHelpWindow().clearText();
        if (bl) {
            ParaProf.getHelpWindow().setVisible(true);
        }
        ParaProf.getHelpWindow().writeText("This is the Statistics Table.\n");
        ParaProf.getHelpWindow().writeText("This window shows you function data across a given thread (or mean/std.dev.)\n");
        ParaProf.getHelpWindow().writeText("If callpath data is present, it will be shown as a tree on the left.");
        ParaProf.getHelpWindow().writeText("In this mode, the metric values will show Inclusive when the node is collapsed, and exclusive when the node is expanded.\n");
    }

    @Override
    public void closeThisWindow() {
        this.setVisible(false);
        this.ppTrial.deleteObserver(this);
        ParaProf.decrementNumWindows();
        this.dispose();
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        try {
            if (n >= 1) {
                return 1;
            }
            ParaProfUtils.scaleForPrint(graphics, pageFormat, (int)this.treeTable.getSize().getWidth(), (int)this.treeTable.getSize().getHeight());
            this.export((Graphics2D)graphics, false, true, false);
            return 0;
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
            return 1;
        }
    }

    public boolean getExclusiveInclusiveMode() {
        return this.showInclExclMenuItem.isSelected();
    }

    public boolean getTreeMode() {
        return this.showAsTreeMenuItem.isSelected();
    }

    public int getColorMetricID() {
        return this.colorMetricID;
    }

    @Override
    public void setUnits(int n) {
        this.units = n;
        this.treeTable.forceRedraw();
    }

    public int getUnits() {
        return this.units;
    }

    public List<TreeTableColumn> getColumns() {
        return this.columns;
    }

    public ParaProfTrial getPPTrial() {
        return this.ppTrial;
    }

    public void export(Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            this.scrollPane.getColumnHeader().paintAll(graphics2D);
            graphics2D.translate(0, this.scrollPane.getColumnHeader().getHeight());
            this.treeTable.paintAll((Graphics)graphics2D);
        } else {
            this.scrollPane.paintAll(graphics2D);
        }
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        if (bl) {
            Dimension dimension = this.treeTable.getSize();
            dimension.setSize(dimension.getWidth(), dimension.getHeight() + (double)this.scrollPane.getColumnHeader().getHeight());
            return dimension;
        }
        return this.scrollPane.getSize();
    }

    public Thread getThread() {
        return this.thread;
    }

    @Override
    public JFrame getFrame() {
        return this;
    }

    public int getDecimals() {
        return this.decimals;
    }

    public void setDecimals(int n) {
        this.decimals = n;
    }

    public void select(Function function) {
        String[] stringArray = function.getName().split("=>");
        this.selectStrings(stringArray);
    }

    public void collapseTree() {
        JTree jTree = this.treeTable.getTree();
        for (int i = 0; i < jTree.getRowCount(); ++i) {
            jTree.collapseRow(i);
        }
    }

    public boolean selectStrings(String[] stringArray) {
        int n;
        JTree jTree = this.treeTable.getTree();
        TreeModel treeModel = jTree.getModel();
        TreeTableNode treeTableNode = (TreeTableNode)treeModel.getRoot();
        int n2 = treeModel.getChildCount(treeTableNode);
        int n3 = 0;
        this.collapseTree();
        block0: for (n = 0; n < stringArray.length; ++n) {
            for (int i = 0; i < n2; ++i) {
                TreeTableNode treeTableNode2 = (TreeTableNode)treeModel.getChild(treeTableNode, i);
                if (!stringArray[n].trim().equals(treeTableNode2.toString().trim())) continue;
                treeTableNode = treeTableNode2;
                n2 = treeModel.getChildCount(treeTableNode);
                TreePath treePath = jTree.getPathForRow(n3 += i);
                if (!treePath.getLastPathComponent().toString().equals(treeTableNode2.toString())) {
                    while (!jTree.getPathForRow(n3).getLastPathComponent().toString().equals(treeTableNode2.toString())) {
                        if (++n3 < jTree.getRowCount()) continue;
                        System.out.println("Tree Search Pathing Error.");
                        return false;
                    }
                }
                jTree.expandRow(n3);
                ++n3;
                continue block0;
            }
        }
        if (n3 <= 0) {
            return false;
        }
        jTree.setSelectionRow(--n3);
        n = this.treeTable.getRowHeight() + this.treeTable.getRowMargin();
        this.treeTable.scrollRectToVisible(new Rectangle(0, n * n3, 5, 50));
        this.validate();
        return true;
    }

    public SearchNode recSearch(String string, int n, TreeTableNode treeTableNode, TreeModel treeModel) {
        int n2 = treeModel.getChildCount(treeTableNode);
        for (int i = 0; i < n2; ++i) {
            SearchNode searchNode;
            TreeTableNode treeTableNode2 = (TreeTableNode)treeModel.getChild(treeTableNode, i);
            String string2 = treeTableNode2.toString().trim();
            if (!this.searchMatchCase) {
                string2 = string2.toUpperCase();
            }
            if (string2.contains(string) && !this.prevNodes.contains(treeTableNode2)) {
                searchNode = new SearchNode(n + i, treeTableNode2);
                searchNode.addNode(treeTableNode2);
                this.lastNode = treeTableNode2;
                return searchNode;
            }
            searchNode = this.recSearch(string, i + n, treeTableNode2, treeModel);
            if (searchNode == null) continue;
            searchNode.addNode(treeTableNode2);
            return searchNode;
        }
        return null;
    }

    public static TreePath getPath(TreeNode treeNode) {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        if (treeNode != null) {
            arrayList.add(treeNode);
            for (treeNode = treeNode.getParent(); treeNode != null; treeNode = treeNode.getParent()) {
                arrayList.add(0, treeNode);
            }
        }
        return arrayList.isEmpty() ? null : new TreePath(arrayList.toArray());
    }

    public boolean search(String string) {
        SearchNode searchNode;
        boolean bl = false;
        JTree jTree = this.treeTable.getTree();
        TreeModel treeModel = jTree.getModel();
        string = string.trim();
        TreeTableNode treeTableNode = this.sn.getTtn();
        if (treeTableNode == null) {
            treeTableNode = (TreeTableNode)treeModel.getRoot();
        }
        if ((searchNode = this.recSearch(string, 0, treeTableNode, treeModel)) == null) {
            if (!this.prevNodes.isEmpty()) {
                this.lastNode = null;
                this.prevNodes.clear();
                return this.search(string);
            }
            this.lastNode = null;
            this.prevNodes.clear();
            return false;
        }
        String[] stringArray = searchNode.getPathStrings();
        bl = this.selectStrings(stringArray);
        return bl;
    }

    @Override
    public void showSearchPanel(boolean bl) {
        if (bl) {
            if (this.searchPanel == null) {
                this.searchPanel = new SearchPanel(this, this, false, false);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.insets = new Insets(5, 5, 5, 5);
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 10;
                gridBagConstraints.weightx = 0.1;
                gridBagConstraints.weighty = 0.01;
                this.addCompItem(this.searchPanel, gridBagConstraints, 0, 2, 2, 1);
                this.searchPanel.setFocus();
            }
        } else {
            if (this.searchPanel != null) {
                this.getContentPane().remove(this.searchPanel);
            }
            this.searchPanel = null;
        }
        this.showFindPanelBox.setSelected(bl);
        this.validate();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block5: {
            try {
                Object object = actionEvent.getSource();
                if (!(object instanceof JMenuItem)) break block5;
                String string = actionEvent.getActionCommand();
                if (string.equals("Show Find Panel")) {
                    if (this.showFindPanelBox.isSelected()) {
                        this.showSearchPanel(true);
                    } else {
                        this.showSearchPanel(false);
                    }
                    break block5;
                }
                throw new ParaProfException("Menu system not implemented properly: " + string);
            }
            catch (Exception exception) {
                ParaProfUtils.handleException(exception);
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 70) {
            this.showSearchPanel(true);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public boolean setSearchString(String string) {
        if (!this.nexting) {
            this.prevNodes.clear();
        } else {
            this.nexting = false;
        }
        this.searchString = string;
        if (string.length() == 0) {
            this.sn.setSearchRow(0);
            this.sn.setTtn(null);
            this.repaint();
            return true;
        }
        if (!this.searchMatchCase) {
            string = string.toUpperCase();
        }
        boolean bl = false;
        bl = this.search(string);
        if (!bl) {
            this.repaint();
            return false;
        }
        this.repaint();
        return true;
    }

    @Override
    public void setSearchHighlight(boolean bl) {
    }

    @Override
    public void setSearchMatchCase(boolean bl) {
        this.searchMatchCase = bl;
        this.repaint();
    }

    @Override
    public boolean searchNext() {
        this.nexting = true;
        if (this.lastNode != null) {
            this.prevNodes.add(this.lastNode);
        }
        int n = this.sn.getSearchRow();
        this.sn.setSearchRow(n++);
        this.setSearchString(this.searchString);
        return false;
    }

    @Override
    public boolean searchPrevious() {
        return false;
    }

    private class SearchNode {
        private int searchRow = 0;
        private TreeTableNode ttn = null;
        List<Object> nodes = new ArrayList<Object>();

        public SearchNode() {
            this.searchRow = 0;
            this.ttn = null;
        }

        public SearchNode(int n, TreeTableNode treeTableNode) {
            this.searchRow = n;
            this.ttn = treeTableNode;
        }

        public int getSearchRow() {
            return this.searchRow;
        }

        public void setSearchRow(int n) {
            this.searchRow = n;
        }

        public TreeTableNode getTtn() {
            return this.ttn;
        }

        public void setTtn(TreeTableNode treeTableNode) {
            this.ttn = treeTableNode;
        }

        public void addNode(TreeNode treeNode) {
            this.nodes.add(0, treeNode);
        }

        public String[] getPathStrings() {
            String[] stringArray = new String[this.nodes.size()];
            for (int i = 0; i < this.nodes.size(); ++i) {
                stringArray[i] = this.nodes.get(i).toString();
            }
            return stringArray;
        }
    }
}

