/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.util;

import edu.uoregon.tau.common.MetaDataMap;
import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class MapViewer
extends JFrame {
    private static final long serialVersionUID = -3534612098086026146L;
    String[][] items = null;

    public MapViewer(String string, MetaDataMap metaDataMap, Font font) {
        Object object2;
        int n = metaDataMap.size();
        this.items = new String[n][2];
        int n2 = 0;
        for (Object object2 : metaDataMap.keySet()) {
            MetaDataMap.MetaDataValue metaDataValue = metaDataMap.get(object2);
            this.items[n2][0] = object2.name;
            this.items[n2][1] = metaDataValue.value.toString();
            ++n2;
        }
        Object[] objectArray = new String[]{"Name", "Value"};
        JTable jTable = new JTable(this.items, objectArray);
        Utility.setTableFontHeight((JTable)jTable, (Font)font);
        object2 = new JScrollPane(jTable);
        this.getContentPane().add((Component)object2);
        this.setTitle(string);
        this.pack();
        ParaProfUtils.setFrameIcon(this);
        jTable.addMouseListener(this.getMouseListener(jTable));
    }

    public MouseListener getMouseListener(final JTable jTable) {
        return new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (ParaProfUtils.rightClick(mouseEvent)) {
                    JPopupMenu jPopupMenu;
                    int n = jTable.rowAtPoint(mouseEvent.getPoint());
                    int n2 = jTable.columnAtPoint(mouseEvent.getPoint());
                    String string = MapViewer.this.items[n][0];
                    if (string.startsWith("BACKTRACE") && (jPopupMenu = ParaProfUtils.createMetadataClickPopUp(MapViewer.this.items[n][n2].toString(), jTable)) != null) {
                        jPopupMenu.show(jTable, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }
        };
    }
}

