/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.x11;

import com.sun.opengl.impl.x11.GLX;
import com.sun.opengl.impl.x11.GLXFBConfig;
import com.sun.opengl.impl.x11.X11GLDrawable;
import com.sun.opengl.impl.x11.X11GLDrawableFactory;
import com.sun.opengl.impl.x11.X11PbufferGLContext;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;

public class X11PbufferGLDrawable
extends X11GLDrawable {
    private int initWidth;
    private int initHeight;
    private GLXFBConfig fbConfig;
    private int width;
    private int height;
    protected static final int MAX_PFORMATS = 256;
    protected static final int MAX_ATTRIBS = 256;

    public X11PbufferGLDrawable(GLCapabilities gLCapabilities, int n, int n2) {
        super(gLCapabilities, null);
        this.initWidth = n;
        this.initHeight = n2;
        if (this.initWidth <= 0 || this.initHeight <= 0) {
            throw new GLException("Initial width and height of pbuffer must be positive (were (" + this.initWidth + ", " + this.initHeight + "))");
        }
        if (DEBUG) {
            System.out.println("Pbuffer caps on init: " + gLCapabilities + (gLCapabilities.getPbufferRenderToTexture() ? " [rtt]" : "") + (gLCapabilities.getPbufferRenderToTextureRectangle() ? " [rect]" : "") + (gLCapabilities.getPbufferFloatingPointBuffers() ? " [float]" : ""));
        }
        this.createPbuffer(X11GLDrawableFactory.getDisplayConnection());
    }

    public GLContext createContext(GLContext gLContext) {
        return new X11PbufferGLContext(this, gLContext);
    }

    public void destroy() {
        this.lockToolkit();
        if (this.drawable != 0L) {
            GLX.glXDestroyPbuffer(this.display, this.drawable);
            this.drawable = 0L;
        }
        this.unlockToolkit();
        this.display = 0L;
    }

    public void setSize(int n, int n2) {
        throw new GLException("Not yet implemented");
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPbuffer(long l) {
        this.lockToolkit();
        try {
            int[] nArray;
            if (l == 0L) {
                throw new GLException("Null display");
            }
            if (this.capabilities.getPbufferRenderToTexture()) {
                throw new GLException("Render-to-texture pbuffers not supported yet on X11");
            }
            if (this.capabilities.getPbufferRenderToTextureRectangle()) {
                throw new GLException("Render-to-texture-rectangle pbuffers not supported yet on X11");
            }
            int n = 0;
            int[] nArray2 = X11GLDrawableFactory.glCapabilities2AttribList(this.capabilities, X11GLDrawableFactory.isMultisampleAvailable(), true, l, n);
            GLXFBConfig[] gLXFBConfigArray = GLX.glXChooseFBConfig(l, n, nArray2, 0, nArray = new int[1], 0);
            if (gLXFBConfigArray == null || gLXFBConfigArray.length == 0 || gLXFBConfigArray[0] == null) {
                throw new GLException("pbuffer creation error: glXChooseFBConfig() failed");
            }
            int n2 = nArray[0];
            if (n2 <= 0) {
                throw new GLException("pbuffer creation error: couldn't find a suitable frame buffer configuration");
            }
            GLXFBConfig gLXFBConfig = gLXFBConfigArray[0];
            if (DEBUG) {
                System.err.println("Found " + gLXFBConfigArray.length + " matching GLXFBConfigs");
                System.err.println("Parameters of default one:");
                System.err.println("render type: 0x" + Integer.toHexString(this.queryFBConfig(l, gLXFBConfig, 32785)));
                System.err.println("rgba: " + ((this.queryFBConfig(l, gLXFBConfig, 32785) & 1) != 0));
                System.err.println("r: " + this.queryFBConfig(l, gLXFBConfig, 8));
                System.err.println("g: " + this.queryFBConfig(l, gLXFBConfig, 9));
                System.err.println("b: " + this.queryFBConfig(l, gLXFBConfig, 10));
                System.err.println("a: " + this.queryFBConfig(l, gLXFBConfig, 11));
                System.err.println("depth: " + this.queryFBConfig(l, gLXFBConfig, 12));
                System.err.println("double buffered: " + this.queryFBConfig(l, gLXFBConfig, 5));
            }
            int n3 = 0;
            nArray2[n3++] = 32833;
            nArray2[n3++] = this.initWidth;
            nArray2[n3++] = 32832;
            nArray2[n3++] = this.initHeight;
            nArray2[n3++] = 0;
            long l2 = GLX.glXCreatePbuffer(l, gLXFBConfig, nArray2, 0);
            if (l2 == 0L) {
                throw new GLException("pbuffer creation error: glXCreatePbuffer() failed");
            }
            this.display = l;
            this.drawable = l2;
            this.fbConfig = gLXFBConfig;
            int[] nArray3 = new int[1];
            GLX.glXQueryDrawable(l, this.drawable, 32797, nArray3, 0);
            this.width = nArray3[0];
            GLX.glXQueryDrawable(l, this.drawable, 32798, nArray3, 0);
            this.height = nArray3[0];
            if (DEBUG) {
                System.err.println("Created pbuffer " + this.width + " x " + this.height);
            }
        }
        finally {
            this.unlockToolkit();
        }
    }

    public int getFloatingPointMode() {
        return 3;
    }

    public GLXFBConfig getFBConfig() {
        return this.fbConfig;
    }

    private int queryFBConfig(long l, GLXFBConfig gLXFBConfig, int n) {
        int[] nArray = new int[1];
        if (GLX.glXGetFBConfigAttrib(l, gLXFBConfig, n, nArray, 0) != 0) {
            throw new GLException("glXGetFBConfigAttrib failed");
        }
        return nArray[0];
    }
}

