/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube.datalayout.data.value;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import scalasca.cubex.cube.datalayout.data.value.Value;
import scalasca.cubex.cube.errors.WrongNumberOfValueParametersException;
import scalasca.cubex.cube.services.transformation.Endianess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CubeUint32
extends Value {
    protected long value;

    public CubeUint32() {
    }

    public CubeUint32(int n) {
        this.value = n;
    }

    @Override
    public String getName() {
        return "UINT32";
    }

    @Override
    public String toString() {
        return Long.valueOf(this.value).toString();
    }

    @Override
    public int size() {
        return 4;
    }

    @Override
    public void correctEndianess(Endianess endianess, DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
        int n = dataInputStream.readInt();
        int n2 = endianess.applyOn(n);
        dataOutputStream.writeInt(n2);
    }

    @Override
    public Value clone() {
        return new CubeUint32();
    }

    @Override
    public Value copy() {
        return new CubeUint32((int)this.value);
    }

    @Override
    public Value clone(DataInputStream dataInputStream) throws IOException {
        return new CubeUint32(dataInputStream.readInt());
    }

    @Override
    public void setValue(String string) {
        this.value = Long.parseLong(string);
    }

    @Override
    public void setValue(byte by) {
        this.value = by;
    }

    @Override
    public void setValue(short s) {
        this.value = s;
    }

    @Override
    public void setValue(int n) {
        this.value = n;
    }

    @Override
    public void setValue(long l) {
        this.value = l;
    }

    @Override
    public void setValue(double d) {
        this.value = (long)d;
    }

    @Override
    public double getDouble() {
        return Long.valueOf(this.value).doubleValue();
    }

    @Override
    public void addValue(Value value) {
        CubeUint32 cubeUint32 = (CubeUint32)value;
        this.value += cubeUint32.value;
    }

    @Override
    public void subtractValue(Value value) {
        CubeUint32 cubeUint32 = (CubeUint32)value;
        this.value -= cubeUint32.value;
    }

    @Override
    public void setValueParameters(Vector<Double> vector) throws WrongNumberOfValueParametersException {
    }
}

