/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cubexlayout;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import scalasca.cubex.cube.errors.MissingMetricInCubeReport;
import scalasca.cubex.cube.errors.MissingMiscInCubeReport;
import scalasca.cubex.cubexlayout.Cube3GZIPLayout;
import scalasca.cubex.cubexlayout.CubeTarLayout;

public class CubeLayout {
    protected String filename;
    protected long AnchorShift = -1L;
    protected long AnchorSize = -1L;
    protected Map<Long, Map<String, Long>> metricDataPlaces = new HashMap<Long, Map<String, Long>>();
    protected Map<Long, Map<String, Long>> metricIndexPlaces = new HashMap<Long, Map<String, Long>>();
    protected Map<Long, Map<String, Long>> ghostMetricDataPlaces = new HashMap<Long, Map<String, Long>>();
    protected Map<Long, Map<String, Long>> ghostMetricIndexPlaces = new HashMap<Long, Map<String, Long>>();
    protected Map<String, Map<String, Long>> miscDataPlaces = new HashMap<String, Map<String, Long>>();

    public CubeLayout(String string) {
        this.filename = string;
        File file = new File(this.filename);
        this.AnchorSize = file.length();
        this.AnchorShift = 0L;
    }

    public long getAnchorSize() {
        return this.AnchorSize;
    }

    public long getAnchorShift() {
        return this.AnchorShift;
    }

    public long getMetricDataSize(int n) throws MissingMetricInCubeReport {
        return 0L;
    }

    public long getMetricDataShift(int n) throws MissingMetricInCubeReport {
        return 0L;
    }

    public long getMetricIndexSize(int n) throws MissingMetricInCubeReport {
        return 0L;
    }

    public long getMetricIndexShift(int n) throws MissingMetricInCubeReport {
        return 0L;
    }

    public long getMiscDataSize(String string) throws MissingMiscInCubeReport {
        return 0L;
    }

    public long getMiscDataShift(String string) throws MissingMiscInCubeReport {
        return 0L;
    }

    public void print() {
        System.out.println(" ====== Simply Cube 3 layout ========");
        System.out.println("Anchor size:      " + this.AnchorSize);
        System.out.println("Anchor offset:   " + this.AnchorShift);
    }

    public static CubeLayout getCubeLayout(String string) {
        if (CubeTarLayout.testLayout(string)) {
            return new CubeTarLayout(string);
        }
        if (Cube3GZIPLayout.testLayout(string)) {
            return new Cube3GZIPLayout(string);
        }
        return new CubeLayout(string);
    }

    static boolean testLayout(String string) {
        return true;
    }

    public byte[] getAnchorBytes() throws IOException {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.filename);
            fileInputStream.skip(this.AnchorShift);
            byte[] byArray = new byte[(int)this.AnchorSize];
            fileInputStream.read(byArray);
            fileInputStream.close();
            return byArray;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File " + this.filename + " not found.");
            return new byte[0];
        }
    }

    public byte[] getMetricDataBytes(int n) throws IOException, MissingMetricInCubeReport {
        return new byte[0];
    }

    public byte[] getMetricIndexBytes(int n) throws IOException, MissingMetricInCubeReport {
        return new byte[0];
    }

    public byte[] getMiscDataBytes(String string) throws IOException, MissingMiscInCubeReport {
        return new byte[0];
    }
}

