/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.common;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;

public class Wget {
    public static void wget(String string, String string2) throws IOException {
        Wget.wget(string, string2, false);
    }

    public static void wget(String string, String string2, boolean bl) throws IOException {
        Wget.wget(string, string2, bl, new Progress(){
            int size;

            @Override
            public void reportFininshed(int n) {
                System.out.println("\r" + n / 1000 + "k bytes... done.");
            }

            @Override
            public void reportProgress(int n) {
                System.out.print("\r" + n / 1000 + "k bytes... of " + this.size / 1000 + "k bytes");
            }

            @Override
            public void reportSize(int n) {
                this.size = n;
            }
        });
    }

    public static void wget(String string, String string2, boolean bl, Progress progress) throws IOException {
        URLConnection uRLConnection = new URL(string).openConnection();
        DataInputStream dataInputStream = new DataInputStream(uRLConnection.getInputStream());
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        int n = 0;
        progress.reportSize(uRLConnection.getContentLength());
        try {
            while (true) {
                ((OutputStream)fileOutputStream).write(dataInputStream.readUnsignedByte());
                if (!bl || ++n % 100000 != 0) continue;
                progress.reportProgress(n);
            }
        }
        catch (EOFException eOFException) {
            ((OutputStream)fileOutputStream).close();
            if (bl) {
                progress.reportFininshed(n);
            }
            return;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 2) {
            try {
                Wget.wget(stringArray[0], stringArray[1], false);
            }
            catch (IOException iOException) {
                System.out.println("Failed getting " + stringArray[0]);
            }
        } else if (stringArray.length == 3) {
            try {
                Wget.wget(stringArray[0], stringArray[1], stringArray[2].equalsIgnoreCase("true"));
            }
            catch (IOException iOException) {
                System.out.println("Failed getting " + stringArray[0]);
            }
        } else {
            System.out.println("Usage: Wget <url> <local filename>");
            System.out.println("Failed getting " + stringArray[0]);
        }
    }

    public static interface Progress {
        public void reportProgress(int var1);

        public void reportFininshed(int var1);

        public void reportSize(int var1);
    }
}

